/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;

public class XSDIdentity
extends XSDNode {
    String refer;
    String selector;
    String expandedName;
    String[] fields;
    int nfields;
    XSLExprBase[] fieldExprs;
    XSLExprBase selectorExpr;

    XSDIdentity() {
        this.init();
    }

    private void init() {
        this.nodeType = 22;
        this.fields = new String[10];
        this.nfields = 0;
    }

    void setExpandedName(String string) {
        this.expandedName = string;
    }

    String getExpandedName() {
        if (this.expandedName == null) {
            this.expandedName = this.getTargetNS() + ":" + this.name;
        }
        return this.expandedName;
    }

    XSLExprBase getFieldExpr(int n) {
        return this.fieldExprs[n];
    }

    XSLExprBase getSelectorExpr() {
        return this.selectorExpr;
    }

    boolean compileExpr(XMLElement xMLElement) {
        try {
            this.selectorExpr = XSLExprBase.createExpression(this.selector, xMLElement, null);
            this.fieldExprs = new XSLExprBase[this.nfields];
            for (int i = 0; i < this.nfields; ++i) {
                this.fieldExprs[i] = XSLExprBase.createExpression(this.fields[i], xMLElement, null);
            }
        }
        catch (XSLException xSLException) {
            return false;
        }
        catch (XQException xQException) {
            return false;
        }
        return true;
    }

    void setNodeType(int n) {
        this.nodeType = n;
    }

    void setRefer(String string) {
        this.refer = string.intern();
    }

    void setSelector(String string) {
        this.selector = string.intern();
    }

    void addField(String string) {
        if (this.nfields >= this.fields.length) {
            String[] stringArray = new String[this.fields.length + 10];
            System.arraycopy(this.fields, 0, stringArray, 0, this.fields.length);
            this.fields = stringArray;
        }
        this.fields[this.nfields++] = string.intern();
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public String getRefer() {
        return this.refer;
    }

    public String getSelector() {
        return this.selector;
    }

    public String[] getFields() {
        return this.fields;
    }

    int getnFields() {
        return this.nfields;
    }

    void print(int n) {
        this.printSTag(n);
        if (this.refer != null) {
            System.out.println(XSDIdentity.indent(n) + "refer =" + this.refer);
        }
        if (this.selector != null) {
            System.out.println(XSDIdentity.indent(n) + "selector =" + this.selector);
        }
        for (int i = 0; i < this.nfields; ++i) {
            System.out.println(XSDIdentity.indent(n) + "field  =" + this.fields[i]);
        }
        this.printSTagEnd(n);
        this.printETag(n);
    }
}

