/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import oracle.xml.parser.v2.CMChoice;
import oracle.xml.parser.v2.CMLeaf;
import oracle.xml.parser.v2.CMNode;
import oracle.xml.parser.v2.CMNodeSeq;
import oracle.xml.parser.v2.CMPlus;
import oracle.xml.parser.v2.CMQuestionMark;
import oracle.xml.parser.v2.CMStar;
import oracle.xml.parser.v2.CMXMLNode;
import oracle.xml.parser.v2.ContentModelType;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTD2SchemaConstants;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.XMLCharReader;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ContentModel
implements XMLConstants,
DTD2SchemaConstants {
    CMNode content;
    Vector leafnodes;
    Hashtable symboltable;
    Vector symbols;
    Vector dTrans;
    byte type;
    public static final byte EMPTY = 1;
    public static final byte ANY = 2;
    public static final byte MIXED = 3;
    public static final byte ELEMENTS = 4;

    ContentModel() {
    }

    final void parseContentModel(XMLError xMLError, XMLReader xMLReader) throws SAXException, IOException {
        int n;
        Object object;
        Cloneable cloneable;
        this.leafnodes = new Vector();
        this.symboltable = new Hashtable(20);
        this.symbols = new Vector();
        this.content = this.parseRootNode(xMLError, xMLReader);
        CMLeaf cMLeaf = new CMLeaf(this, null);
        this.content = new CMNodeSeq(this.content, cMLeaf);
        int n2 = this.leafnodes.size();
        BitSet[] bitSetArray = new BitSet[n2];
        for (int i = 0; i < n2; ++i) {
            bitSetArray[i] = new BitSet(n2);
        }
        this.content.calcfollowpos(bitSetArray);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < n2; ++i) {
            cloneable = bitSetArray[i];
            hashSet.clear();
            int n3 = ((BitSet)cloneable).nextSetBit(0);
            while (n3 >= 0) {
                object = ((CMLeaf)this.leafnodes.get((int)n3)).name;
                if (hashSet.contains(object)) {
                    xMLError.error0(68, 0);
                } else {
                    hashSet.add(object);
                }
                n3 = ((BitSet)cloneable).nextSetBit(n3 + 1);
            }
        }
        Vector<BitSet> vector = new Vector<BitSet>();
        this.dTrans = new Vector();
        cloneable = new Vector();
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(20);
        object = new BitSet(n2);
        hashtable.put(object, new Integer(-1));
        int n4 = 0;
        BitSet bitSet = this.content.firstpos(n2);
        hashtable.put(bitSet, new Integer(vector.size()));
        ((Vector)cloneable).addElement(bitSet);
        vector.addElement(bitSet);
        int[] nArray = new int[this.symbols.size() + 1];
        this.dTrans.addElement(nArray);
        if (bitSet.get(cMLeaf.pos)) {
            nArray[this.symbols.size()] = 1;
        }
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = ((CMLeaf)this.leafnodes.elementAt((int)n)).name;
        }
        n = this.symbols.size();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n5 = 1;
            String string = (String)this.symbols.elementAt(i);
            nArrayArray[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                if (stringArray[j] != string) continue;
                nArrayArray[i][n5++] = j;
            }
            nArrayArray[i][0] = n5;
        }
        while (((Vector)cloneable).size() > 0) {
            int[] nArray2 = (int[])this.dTrans.elementAt(n4);
            bitSet = (BitSet)((Vector)cloneable).elementAt(0);
            ((Vector)cloneable).removeElementAt(0);
            for (int i = 0; i < n; ++i) {
                int n6;
                String string = (String)this.symbols.elementAt(i);
                BitSet bitSet2 = new BitSet(n2);
                int n7 = nArrayArray[i][0];
                for (int j = 1; j < n7; ++j) {
                    n6 = nArrayArray[i][j];
                    if (!bitSet.get(n6)) continue;
                    bitSet2.or(bitSetArray[n6]);
                }
                Integer n8 = (Integer)hashtable.get(bitSet2);
                if (n8 == null) {
                    n6 = vector.size();
                    hashtable.put(bitSet2, new Integer(n6));
                    ((Vector)cloneable).addElement(bitSet2);
                    vector.addElement(bitSet2);
                    nArray = new int[this.symbols.size() + 1];
                    this.dTrans.addElement(nArray);
                    if (bitSet2.get(cMLeaf.pos)) {
                        nArray[this.symbols.size()] = 1;
                    }
                } else {
                    n6 = n8;
                }
                nArray2[i] = n6;
            }
            ++n4;
        }
    }

    final void parseContentModel(String string) {
        try {
            XMLError xMLError = new XMLError();
            XMLCharReader xMLCharReader = new XMLCharReader(string, null, null);
            XMLReader xMLReader = new XMLReader(null, xMLError, null, true);
            xMLReader.pushXMLReader(xMLCharReader);
            this.parseContentModel(xMLError, xMLReader);
        }
        catch (Exception exception) {
            return;
        }
    }

    boolean validateContent(XMLElement xMLElement, DTD dTD) {
        int n = this.getState(xMLElement, dTD);
        return n != -1 && ((int[])this.dTrans.elementAt(n))[this.symbols.size()] > 0;
    }

    boolean checkContent(ParserState parserState, String string) throws XMLParseException {
        if (this.type == 2) {
            return true;
        }
        if (this.type == 1) {
            return false;
        }
        Integer n = (Integer)this.symboltable.get(string);
        if (n != null) {
            int n2 = n;
            int n3 = ((int[])this.dTrans.elementAt(parserState.state))[n2];
            if (n3 != -1) {
                parserState.state = n3;
                return true;
            }
        }
        return false;
    }

    boolean checkAcceptState(ParserState parserState) throws XMLParseException {
        if (this.type == 2 || this.type == 1) {
            return true;
        }
        return ((int[])this.dTrans.elementAt(parserState.state))[this.symbols.size()] > 0;
    }

    final Vector getContentElements() {
        if (this.type == 2 || this.type == 1) {
            return null;
        }
        return this.symbols;
    }

    Vector expectedElements(XMLElement xMLElement, DTD dTD) {
        int n = this.getState(xMLElement, dTD);
        if (n != -1) {
            return this.expectedElements(n);
        }
        return null;
    }

    final Vector expectedElements(int n) {
        int[] nArray = (int[])this.dTrans.elementAt(n);
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.leafnodes.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            String string = ((CMLeaf)enumeration.nextElement()).name;
            if (string == null || vector.contains(string) || (n2 = (Integer)this.symboltable.get(string)) == null || nArray[n2] == -1) continue;
            vector.addElement(string);
        }
        return vector;
    }

    String getStringValue() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
        try {
            this.print(xMLOutputStream);
            xMLOutputStream.flush();
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    void print(XMLOutputStream xMLOutputStream) throws IOException {
        switch (this.type) {
            case 1: {
                xMLOutputStream.writeChars("EMPTY");
                break;
            }
            case 2: {
                xMLOutputStream.writeChars("ANY");
                break;
            }
            case 3: 
            case 4: {
                CMNode cMNode = ((CMNodeSeq)this.content).left;
                cMNode.print(xMLOutputStream, 0);
            }
        }
    }

    final XMLElement d2sdom(XMLDocument xMLDocument, ElementDecl elementDecl) {
        Vector vector = new Vector();
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        String string = elementDecl.getNodeName();
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
        xMLElement.setAttributeNS("", "name", string);
        if (this.content != null) {
            this.d2sdom(xMLDocument, this.content.getChild(0), xMLElement, vector);
            this.normalizeStream(vector);
            boolean bl = this.process(vector, stack, stack2, xMLDocument, xMLElement);
            Object e = stack2.pop();
            if (e instanceof XMLElement) {
                XMLElement xMLElement2 = (XMLElement)e;
                XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                if (bl) {
                    xMLElement3.setAttributeNS("", "mixed", "true");
                }
                xMLElement3.appendChild(xMLElement2);
                xMLElement.appendChild(xMLElement3);
            } else if (e instanceof String) {
                String string2 = (String)e;
                this.handleSingleChildElement(string2, 1001, xMLDocument, xMLElement);
            } else if (e instanceof ContentModelType) {
                ContentModelType contentModelType = (ContentModelType)e;
                String string3 = contentModelType.name;
                int n = contentModelType.type;
                if (string3.equals("PCDATA") && n == 1005) {
                    xMLElement.setAttributeNS("", "type", "xs:string");
                } else {
                    this.handleSingleChildElement(string3, n, xMLDocument, xMLElement);
                }
            }
        } else {
            int n = elementDecl.getContentType();
            switch (n) {
                case 2: {
                    this.handleAnyDecl(xMLDocument, xMLElement);
                    break;
                }
                case 3: {
                    this.handleAnyDecl(xMLDocument, xMLElement);
                    break;
                }
                case 1: {
                    this.handleEmptyDecl(xMLDocument, xMLElement);
                    break;
                }
            }
        }
        return xMLElement;
    }

    final Node getRoot() {
        return this.buildTree(this.content.getChild(0));
    }

    private CMNode parseRootNode(XMLError xMLError, XMLReader xMLReader) throws SAXException, IOException {
        this.type = (byte)4;
        if (xMLReader.isCMGroupStart()) {
            xMLReader.skipWhiteSpace();
            CMNode cMNode = xMLReader.tryRead(35) ? this.parseMixed(xMLError, xMLReader) : this.parseList(xMLError, xMLReader);
            return this.finishNode(cMNode, xMLError, xMLReader);
        }
        return null;
    }

    private CMNode parseMixed(XMLError xMLError, XMLReader xMLReader) throws SAXException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(20);
        this.type = (byte)3;
        xMLReader.skipWhiteSpace();
        String string = xMLReader.scanQName();
        if (string != "PCDATA") {
            xMLError.error0(110, 0);
        }
        CMNode cMNode = new CMLeaf(this, string);
        hashtable.put(string, string);
        xMLReader.skipWhiteSpace();
        if (xMLReader.isCMGroupEnd()) {
            xMLReader.skipWhiteSpace();
            if (xMLReader.tryRead(63) || xMLReader.tryRead(43)) {
                xMLError.error0(285, 0);
            }
            if (!xMLReader.tryRead(42)) {
                cMNode.isStarPresent = false;
            }
            cMNode = new CMStar(cMNode);
            return cMNode;
        }
        while (!xMLReader.isEOF()) {
            xMLReader.skipWhiteSpace();
            if (xMLReader.tryRead(124)) {
                xMLReader.skipWhiteSpace();
                if (xMLReader.isCMGroupStart()) {
                    xMLError.error0(286, 0);
                }
                xMLReader.skipWhiteSpace();
                String string2 = xMLReader.scanQName();
                CMLeaf cMLeaf = new CMLeaf(this, string2);
                if (string2 == null) {
                    cMLeaf = null;
                    xMLError.error0(103, 0);
                }
                xMLReader.skipWhiteSpace();
                if (xMLReader.tryRead(42) || xMLReader.tryRead(43) || xMLReader.tryRead(43)) {
                    xMLError.error0(287, 0);
                }
                if (cMLeaf instanceof CMLeaf) {
                    if (hashtable.contains(cMLeaf.name)) {
                        if (xMLReader.valMode == 2) {
                            xMLError.error1(111, 1, cMLeaf.name);
                        }
                    } else {
                        hashtable.put(cMLeaf.name, cMLeaf.name);
                    }
                }
                cMNode = new CMChoice(cMNode, cMLeaf);
                continue;
            }
            if (xMLReader.isCMGroupEnd()) {
                if (!xMLReader.tryRead(42)) {
                    xMLError.error1(100, 0, "*");
                }
                cMNode = new CMStar(cMNode);
                break;
            }
            xMLError.error1(100, 0, "(");
            break;
        }
        return cMNode;
    }

    private CMNode parseList(XMLError xMLError, XMLReader xMLReader) throws SAXException, IOException {
        CMNode cMNode;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(20);
        int n = 44;
        CMNode cMNode2 = this.parseNode(xMLError, xMLReader);
        xMLReader.skipWhiteSpace();
        if (xMLReader.tryRead(44)) {
            n = 44;
            cMNode2 = new CMNodeSeq(cMNode2, this.parseNode(xMLError, xMLReader));
        } else if (xMLReader.tryRead(124)) {
            n = 124;
            cMNode = this.parseNode(xMLError, xMLReader);
            if (cMNode instanceof CMLeaf && !hashtable.contains(((CMLeaf)cMNode).name)) {
                hashtable.put(((CMLeaf)cMNode).name, ((CMLeaf)cMNode).name);
            }
            cMNode2 = new CMChoice(cMNode2, cMNode);
        } else if (xMLReader.isCMGroupEnd()) {
            return cMNode2;
        }
        while (true) {
            xMLReader.skipWhiteSpace();
            if (xMLReader.isCMGroupEnd()) {
                return cMNode2;
            }
            if (n == 44 && xMLReader.tryRead(44)) {
                cMNode2 = new CMNodeSeq(cMNode2, this.parseNode(xMLError, xMLReader));
                continue;
            }
            if (n != 124 || !xMLReader.tryRead(124)) break;
            cMNode = this.parseNode(xMLError, xMLReader);
            if (cMNode instanceof CMLeaf && !hashtable.contains(((CMLeaf)cMNode).name)) {
                hashtable.put(((CMLeaf)cMNode).name, ((CMLeaf)cMNode).name);
            }
            cMNode2 = new CMChoice(cMNode2, cMNode);
        }
        return cMNode2;
    }

    private CMNode parseNode(XMLError xMLError, XMLReader xMLReader) throws SAXException, IOException {
        CMNode cMNode;
        xMLReader.skipWhiteSpace();
        if (xMLReader.isCMGroupStart()) {
            cMNode = this.parseList(xMLError, xMLReader);
        } else {
            String string = xMLReader.scanQName();
            cMNode = new CMLeaf(this, string);
            if (string == null) {
                cMNode = null;
                xMLError.error0(103, 0);
            }
        }
        return this.finishNode(cMNode, xMLError, xMLReader);
    }

    private CMNode finishNode(CMNode cMNode, XMLError xMLError, XMLReader xMLReader) throws SAXException, IOException {
        boolean bl = xMLReader.skipWhiteSpace();
        if (xMLReader.tryRead(42)) {
            if (bl) {
                xMLError.error0(284, 0);
            }
            xMLReader.skipWhiteSpace();
            if (cMNode instanceof CMStar) {
                return cMNode;
            }
            return new CMStar(cMNode);
        }
        if (xMLReader.tryRead(43)) {
            if (bl) {
                xMLError.error0(284, 0);
            }
            xMLReader.skipWhiteSpace();
            return new CMPlus(cMNode);
        }
        if (xMLReader.tryRead(63)) {
            if (bl) {
                xMLError.error0(284, 0);
            }
            xMLReader.skipWhiteSpace();
            return new CMQuestionMark(cMNode);
        }
        return cMNode;
    }

    private int getState(XMLElement xMLElement, DTD dTD) {
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && n2 != -1) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n3++);
            n2 = this.checkState(xMLNode, n2, dTD);
        }
        return n2;
    }

    private int checkState(XMLNode xMLNode, int n, DTD dTD) {
        String string;
        int n2 = -1;
        if (xMLNode.getNodeType() == 3) {
            string = "PCDATA";
        } else if (xMLNode.getNodeType() == 1) {
            string = xMLNode.getNodeName();
        } else {
            if (xMLNode.getNodeType() == 5) {
                NodeList nodeList = xMLNode.getChildNodes();
                int n3 = nodeList.getLength();
                int n4 = 0;
                while (n4 < n3 && n != -1) {
                    XMLNode xMLNode2 = (XMLNode)nodeList.item(n4++);
                    n = this.checkState(xMLNode2, n, dTD);
                }
                return n;
            }
            return n;
        }
        Integer n5 = (Integer)this.symboltable.get(string);
        if (n5 != null) {
            int n6 = n5;
            n2 = ((int[])this.dTrans.elementAt(n))[n6];
        }
        if (n2 != -1 && xMLNode.getNodeType() == 1 && !((XMLElement)xMLNode).validateContent(dTD)) {
            n2 = -1;
        }
        return n2;
    }

    private void handleSingleChildElement(String string, int n, XMLDocument xMLDocument, XMLElement xMLElement) {
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
        xMLElement2.setAttributeNS("", "name", string);
        XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
        XMLElement xMLElement4 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
        xMLElement3.appendChild(xMLElement4);
        xMLElement4.appendChild(xMLElement2);
        xMLElement.appendChild(xMLElement3);
        switch (n) {
            case 1001: {
                break;
            }
            case 1005: {
                xMLElement2.setAttributeNS("", "minOccurs", "0");
                xMLElement2.setAttributeNS("", "maxOccurs", "unbounded");
                break;
            }
            case 1006: {
                xMLElement2.setAttributeNS("", "maxOccurs", "unbounded");
                break;
            }
            case 1004: {
                xMLElement2.setAttributeNS("", "minOccurs", "0");
            }
        }
    }

    private void handleAnyDecl(XMLDocument xMLDocument, XMLElement xMLElement) {
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
        xMLElement2.setAttributeNS("", "mixed", "true");
        XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
        XMLElement xMLElement4 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:any");
        xMLElement3.setAttributeNS("", "minOccurs", "0");
        xMLElement3.setAttributeNS("", "maxOccurs", "unbounded");
        xMLElement3.appendChild(xMLElement4);
        xMLElement2.appendChild(xMLElement3);
        xMLElement.appendChild(xMLElement2);
    }

    private void handleEmptyDecl(XMLDocument xMLDocument, XMLElement xMLElement) {
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
        xMLElement.appendChild(xMLElement2);
    }

    private void mixedpcdata(Stack stack, XMLDocument xMLDocument) {
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:choice");
        xMLElement.setAttributeNS("", "minOccurs", "0");
        xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
        for (int i = 1; i < stack.size(); ++i) {
            XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
            xMLElement2.setAttributeNS("", "name", stack.elementAt(i).toString());
            xMLElement.appendChild(xMLElement2);
        }
        stack.removeAllElements();
        stack.push(xMLElement);
    }

    private XMLElement constructSingle(XMLDocument xMLDocument, Object object) {
        XMLElement xMLElement = null;
        if (object instanceof String) {
            String string = (String)object;
            xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
            xMLElement.setAttributeNS("", "name", string);
        } else if (object instanceof ContentModelType) {
            ContentModelType contentModelType = (ContentModelType)object;
            String string = contentModelType.name;
            int n = contentModelType.type;
            xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
            xMLElement.setAttributeNS("", "name", string);
            switch (n) {
                case 1005: {
                    xMLElement.setAttributeNS("", "minOccurs", "0");
                    xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
                    break;
                }
                case 1006: {
                    xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
                    break;
                }
                case 1004: {
                    xMLElement.setAttributeNS("", "minOccurs", "0");
                }
            }
        } else {
            return (XMLElement)object;
        }
        return xMLElement;
    }

    private XMLElement constructGroup(XMLDocument xMLDocument, Object object) {
        Integer n = (Integer)object;
        XMLElement xMLElement = null;
        switch (n) {
            case 1: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:choice");
                break;
            }
            case 2: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:choice");
                xMLElement.setAttributeNS("", "minOccurs", "0");
                xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
                break;
            }
            case 3: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:choice");
                xMLElement.setAttributeNS("", "minOccurs", "0");
                break;
            }
            case 4: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:choice");
                xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
                break;
            }
            case 11: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                break;
            }
            case 12: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                xMLElement.setAttributeNS("", "minOccurs", "0");
                xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
                break;
            }
            case 13: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                xMLElement.setAttributeNS("", "minOccurs", "0");
                break;
            }
            case 14: {
                xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                xMLElement.setAttributeNS("", "maxOccurs", "unbounded");
            }
        }
        return xMLElement;
    }

    private boolean process(Vector vector, Stack stack, Stack stack2, XMLDocument xMLDocument, XMLElement xMLElement) {
        int n = 0;
        int n2 = 0;
        Object var11_8 = null;
        Object var12_9 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Integer n3;
            Object e;
            Object e2 = vector.elementAt(i);
            while (e2 instanceof Integer) {
                stack.push(e2);
                if (++i == vector.size()) break;
                e2 = vector.elementAt(i);
            }
            n = this.countSameTypeOps(stack);
            for (n2 = 0; (e2 instanceof String || e2 instanceof ContentModelType) && n2 < n + 1; ++n2) {
                stack2.push(e2);
                if (++i == vector.size()) break;
                e2 = vector.elementAt(i);
            }
            if (stack.size() > 0 && stack2.size() > 0 && (e = stack.elementAt(0)) instanceof Integer && (n3 = (Integer)e) == 2 && (object = stack2.elementAt(0)) instanceof String && object.toString().equals("PCDATA")) {
                this.mixedpcdata(stack2, xMLDocument);
                return true;
            }
            boolean bl = true;
            while (stack2.size() > 1 && (bl || n <= 1)) {
                int n4;
                bl = false;
                if (stack2.size() <= n) {
                    n = stack2.size() - 1;
                }
                for (int j = 0; j < n; ++j) {
                    var11_8 = stack.pop();
                }
                XMLElement xMLElement2 = this.constructGroup(xMLDocument, var11_8);
                if (xMLElement2 == null) continue;
                n2 = n + 1;
                Vector<XMLElement> vector2 = new Vector<XMLElement>(n2);
                for (n4 = 0; n4 < n2; ++n4) {
                    var12_9 = stack2.pop();
                    XMLElement xMLElement3 = this.constructSingle(xMLDocument, var12_9);
                    vector2.addElement(xMLElement3);
                }
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    object = (XMLElement)vector2.elementAt(n4);
                    xMLElement2.appendChild((Node)object);
                }
                stack2.push(xMLElement2);
                n = this.countSameTypeOps(stack);
            }
            --i;
        }
        return false;
    }

    private int countSameTypeOps(Stack stack) {
        if (stack.size() == 1 || stack.size() == 0) {
            return stack.size();
        }
        int n = stack.size() - 1;
        Integer n2 = (Integer)stack.elementAt(n);
        int n3 = n2;
        int n4 = 1;
        --n;
        while (n >= 0) {
            Integer n5 = (Integer)stack.elementAt(n);
            int n6 = n5;
            if (n6 == n3) {
                ++n4;
            } else {
                if (n6 - n6 % 10 != n3 - 1) break;
                ++n4;
                break;
            }
            n3 = n6;
            --n;
        }
        return n4;
    }

    private void printNormalizeStream(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object e = vector.elementAt(i);
            if (e instanceof ContentModelType) {
                object = (ContentModelType)e;
                System.out.println("element: " + ((ContentModelType)object).name + " " + ((ContentModelType)object).type);
                continue;
            }
            if (e instanceof Integer) {
                object = (Integer)e;
                System.out.println("operator: " + (Integer)object);
                continue;
            }
            if (!(e instanceof String)) continue;
            System.out.println("element: " + e.toString());
        }
    }

    private void normalizeStream(Vector vector) {
        Object object = null;
        Object var3_3 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Integer n;
            Integer n2;
            int n3;
            object = vector.elementAt(i);
            if (object instanceof String) {
                if (i == 0 || !((var3_3 = vector.elementAt(i - 1)) instanceof Integer) || (n3 = (n2 = (Integer)var3_3).intValue()) != 1005 && n3 != 1006 && n3 != 1004) continue;
                ContentModelType contentModelType = new ContentModelType();
                contentModelType.type = n3;
                contentModelType.name = object.toString();
                vector.removeElementAt(i - 1);
                vector.setElementAt(contentModelType, i - 1);
                --i;
                continue;
            }
            if (!(object instanceof Integer) || i == 0 || !((var3_3 = vector.elementAt(i - 1)) instanceof Integer)) continue;
            Integer n4 = (Integer)object;
            int n5 = n4;
            n2 = var3_3;
            n3 = n2;
            if (n3 == 1005 && n5 == 1) {
                n = new Integer(2);
                vector.removeElementAt(i - 1);
                vector.setElementAt(n, i - 1);
                continue;
            }
            if (n3 == 1006 && n5 == 1) {
                n = new Integer(4);
                vector.removeElementAt(i - 1);
                vector.setElementAt(n, i - 1);
                continue;
            }
            if (n3 == 1004 && n5 == 1) {
                n = new Integer(3);
                vector.removeElementAt(i - 1);
                vector.setElementAt(n, i - 1);
                continue;
            }
            if (n3 == 1005 && n5 == 11) {
                n = new Integer(12);
                vector.removeElementAt(i - 1);
                vector.setElementAt(n, i - 1);
                continue;
            }
            if (n3 == 1006 && n5 == 11) {
                n = new Integer(14);
                vector.removeElementAt(i - 1);
                vector.setElementAt(n, i - 1);
                continue;
            }
            if (n3 != 1004 || n5 != 11) continue;
            n = new Integer(13);
            vector.removeElementAt(i - 1);
            vector.setElementAt(n, i - 1);
        }
    }

    private void d2sdom(XMLDocument xMLDocument, CMNode cMNode, XMLElement xMLElement, Vector vector) {
        if (cMNode == null) {
            return;
        }
        switch (cMNode.tag) {
            case 1001: {
                vector.addElement(cMNode.name);
                break;
            }
            case 1002: {
                vector.addElement(new Integer(1));
                CMNode cMNode2 = cMNode.getChild(0);
                this.d2sdom(xMLDocument, cMNode2, xMLElement, vector);
                this.d2sdom(xMLDocument, cMNode.getChild(1), xMLElement, vector);
                break;
            }
            case 1003: {
                vector.addElement(new Integer(11));
                CMNode cMNode3 = cMNode.getChild(0);
                this.d2sdom(xMLDocument, cMNode3, xMLElement, vector);
                this.d2sdom(xMLDocument, cMNode.getChild(1), xMLElement, vector);
                break;
            }
            case 1005: {
                vector.addElement(new Integer(1005));
                CMNode cMNode4 = cMNode.getChild(0);
                this.d2sdom(xMLDocument, cMNode4, xMLElement, vector);
                break;
            }
            case 1004: {
                vector.addElement(new Integer(1004));
                CMNode cMNode5 = cMNode.getChild(0);
                this.d2sdom(xMLDocument, cMNode5, xMLElement, vector);
                break;
            }
            case 1006: {
                vector.addElement(new Integer(1006));
                CMNode cMNode6 = cMNode.getChild(0);
                this.d2sdom(xMLDocument, cMNode6, xMLElement, vector);
                break;
            }
        }
    }

    private XMLNode buildTree(CMNode cMNode) {
        if (cMNode == null) {
            return null;
        }
        CMXMLNode cMXMLNode = cMNode.name != null ? new CMXMLNode(new String(cMNode.name), cMNode.tag) : new CMXMLNode(new String(" "), cMNode.tag);
        switch (cMNode.tag) {
            case 1001: {
                break;
            }
            case 1002: {
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(0)));
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(1)));
                break;
            }
            case 1003: {
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(0)));
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(1)));
                break;
            }
            case 1005: {
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(0)));
                break;
            }
            case 1004: {
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(0)));
                break;
            }
            case 1006: {
                cMXMLNode.appendChild(this.buildTree(cMNode.getChild(0)));
                break;
            }
        }
        return cMXMLNode;
    }
}

