/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.QxName;

public class ScalableDOMPrintDriver
extends XMLPrintDriver {
    public ScalableDOMPrintDriver(Writer writer) {
        super(writer);
    }

    public ScalableDOMPrintDriver(PrintWriter printWriter) {
        super(printWriter);
    }

    public ScalableDOMPrintDriver(OutputStream outputStream) {
        super(outputStream);
    }

    public void printElement(XMLElement xMLElement, boolean bl) throws IOException {
        if (!xMLElement.isNodeFlag(2048) || xMLElement.isNodeFlag(64)) {
            super.printElement(xMLElement, bl);
        } else {
            InfosetReader infosetReader = xMLElement.xdkGetReader();
            InfosetReader.Offset offset = xMLElement.xdkGetOffset();
            infosetReader.seek(offset);
            this.printElement(infosetReader);
        }
    }

    private void printElement(InfosetReader infosetReader) throws IOException {
        boolean bl = true;
        boolean bl2 = this.out.mixed;
        int n = this.out.getOutputStyle();
        int n2 = this.nsVector.size();
        int n3 = this.prefixCount;
        this.prevSize = n2;
        this.nsDeclToPrint.clear();
        this.out.writeIndent();
        this.out.writeChars("<");
        SAXAttrList sAXAttrList = (SAXAttrList)infosetReader.getAttributes();
        this.scanNSDecls(sAXAttrList);
        QName qName = infosetReader.getQName();
        String string = ((QxName)qName).getQName();
        String string2 = qName.getPrefix();
        String string3 = qName.getLocalPart();
        String string4 = qName.getNamespaceURI();
        string2 = this.checkConflicts(string2, string4, true);
        if (string2 == null) {
            this.out.writeChars(string);
        } else {
            if (!string2.equals("")) {
                this.out.writeChars(string2);
                this.out.write(58);
            }
            this.out.writeChars(string3);
        }
        this.printAttributes(sAXAttrList);
        this.printNsDecls();
        infosetReader.next();
        int n4 = infosetReader.getEventType();
        if (n4 != 2) {
            this.out.writeChars(">");
            bl = false;
            this.out.mixed = true;
            this.out.writeNewLine();
            this.out.addIndent(1);
        }
        while (true) {
            switch (n4) {
                case 1: {
                    this.printElement(infosetReader);
                    break;
                }
                case 2: {
                    this.out.addIndent(-1);
                    this.out.writeIndent();
                    this.out.mixed = bl2;
                    this.out.addIndent(-1);
                    this.out.writeIndent();
                    this.out.mixed = bl2;
                    if (bl) {
                        this.out.writeChars("/>");
                    } else {
                        this.out.writeChars("</");
                        if (string2 == null) {
                            this.out.writeChars(string);
                        } else {
                            if (!string2.equals("")) {
                                this.out.writeChars(string2);
                                this.out.write(58);
                            }
                            this.out.writeChars(string3);
                        }
                        this.out.writeChars(">");
                    }
                    this.out.writeNewLine();
                    this.out.setOutputStyle(n);
                    this.out.flush();
                    this.prefixCount = n3;
                    this.nsVector.setSize(n2);
                    this.prefixVector.setSize(n2);
                    return;
                }
                case 5: {
                    this.printComment(infosetReader);
                    break;
                }
                case 6: {
                    this.printSpace(infosetReader);
                    break;
                }
                case 12: {
                    this.printCDATA(infosetReader);
                    break;
                }
                case 4: {
                    this.printText(infosetReader);
                    break;
                }
                case 9: {
                    this.printEntityReference(infosetReader);
                    break;
                }
                case 3: {
                    this.printPI(infosetReader);
                }
            }
            infosetReader.next();
            n4 = infosetReader.getEventType();
        }
    }

    private void scanNSDecls(SAXAttrList sAXAttrList) throws IOException {
        int n = sAXAttrList.count;
        for (int i = 0; i < n; ++i) {
            String string = sAXAttrList.name[i];
            String string2 = sAXAttrList.prefix[i];
            String string3 = sAXAttrList.values[i];
            if ("xmlns".equals(string2)) {
                this.addNsDeclPrinted(string, string3);
                continue;
            }
            if (!"xmlns".equals(string)) continue;
            this.addNsDeclPrinted("", string3);
        }
    }

    private void printAttributes(SAXAttrList sAXAttrList) throws IOException {
        int n = sAXAttrList.count;
        for (int i = 0; i < n; ++i) {
            String string = sAXAttrList.namespace[i];
            String string2 = sAXAttrList.name[i];
            String string3 = sAXAttrList.prefix[i];
            String string4 = sAXAttrList.qname[i];
            if ("xmlns".equals(string3)) {
                this.nsDeclToPrint.remove(string2);
            } else if ("xmlns".equals(string2)) {
                this.nsDeclToPrint.remove("");
            } else {
                string3 = string == null || string.equals("") ? null : this.checkConflicts(string3, string, false);
            }
            if (!sAXAttrList.specified[i] && !this.printAllAttrs) continue;
            this.out.write(32);
            if (string3 == null) {
                this.out.writeChars(string4);
            } else {
                if (!string3.equals("")) {
                    this.out.writeChars(string3);
                    this.out.write(58);
                }
                this.out.writeChars(string2);
            }
            this.out.write(61);
            this.out.write(34);
            String string5 = sAXAttrList.values[i];
            if (string5 != null) {
                int n2 = string5.length();
                char[] cArray = new char[n2];
                string5.getChars(0, n2, cArray, 0);
                for (int j = 0; j < n2; ++j) {
                    if (cArray[j] == '&') {
                        this.out.writeChars("&amp;");
                        continue;
                    }
                    if (cArray[j] == '<') {
                        this.out.writeChars("&lt;");
                        continue;
                    }
                    if (cArray[j] == '\"') {
                        this.out.writeChars("&quot;");
                        continue;
                    }
                    if (cArray[j] == '\r') {
                        this.out.writeChars("&#xD;");
                        continue;
                    }
                    if (cArray[j] == '\n') {
                        this.out.writeChars("&#xA;");
                        continue;
                    }
                    if (cArray[j] == '\t') {
                        this.out.writeChars("&#x9;");
                        continue;
                    }
                    this.out.write(cArray[j]);
                }
            }
            this.out.write(34);
            this.out.flush();
        }
    }

    private void printNsDecls() throws IOException {
        Enumeration enumeration = this.nsDeclToPrint.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (this.lookupNsDecl(string2, string = (String)this.nsDeclToPrint.get(string2), this.prevSize) == 1) continue;
            this.out.write(32);
            this.out.writeChars("xmlns");
            if (string2 != null && !string2.equals("")) {
                this.out.write(58);
            }
            this.out.writeChars(string2);
            this.out.write(61);
            this.out.write(34);
            if (string != null) {
                this.out.writeChars(string);
            }
            this.out.write(34);
            this.out.flush();
        }
    }

    private void printText(InfosetReader infosetReader) throws IOException {
        char[] cArray = infosetReader.getData();
        int n = infosetReader.getDataLength();
        for (int i = infosetReader.getDataStart(); i < n; ++i) {
            if (cArray[i] == '&') {
                this.out.writeChars("&amp;");
                continue;
            }
            if (cArray[i] == '<') {
                this.out.writeChars("&lt;");
                continue;
            }
            if (i > 1 && cArray[i] == '>') {
                if (cArray[i - 1] == ']' && cArray[i - 2] == ']') {
                    this.out.writeChars("&gt;");
                    continue;
                }
                this.out.write(62);
                continue;
            }
            this.out.write(cArray[i]);
        }
        this.out.flush();
    }

    private void printSpace(InfosetReader infosetReader) throws IOException {
        this.printText(infosetReader);
    }

    private void printComment(InfosetReader infosetReader) throws IOException {
        this.out.writeIndent();
        this.out.writeChars("<!--");
        char[] cArray = infosetReader.getData();
        int n = infosetReader.getDataLength();
        this.printText(infosetReader);
        this.out.writeChars("-->");
        this.out.writeNewLine();
        this.out.flush();
    }

    private void printCDATA(InfosetReader infosetReader) throws IOException {
        this.out.writeIndent();
        this.out.writeChars("<![CDATA[");
        char[] cArray = infosetReader.getData();
        int n = infosetReader.getDataLength();
        for (int i = infosetReader.getDataStart(); i < n; ++i) {
            this.out.write(cArray[i]);
        }
        this.out.writeChars("]]>");
        this.out.writeNewLine();
        this.out.flush();
    }

    private void printPI(InfosetReader infosetReader) {
    }

    private void printEntityReference(InfosetReader infosetReader) {
    }
}

