/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.util.Vector;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMStringList;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLTypeInfo;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class XMLAttr
extends XMLNSNode
implements Attr,
NSName,
Externalizable {
    public static final int SPECIFIED_ATTR = 65536;
    static final int ATTR_IN_USE = 131072;
    public static final int NS_ATTR = 262144;
    static final int IS_ID = 524288;
    private static final int ATTR_PARENT = 0;
    private static final int ATTR_QXNAME = 1;
    private static final int ATTR_VALUE = 2;
    private static final int ATTR_NEXTNODE = 3;
    private static final int ATTR_FIRSTCHILD = 4;
    private static final int ATTR_LASTCHILD = 5;
    private static final int ATTR_DATASZ = 6;

    protected XMLAttr(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    protected XMLAttr(XMLDocument xMLDocument, String string, String string2) {
        super(xMLDocument);
        XMLUtil.validateQualifiedName(string, string2);
        switch (this.flags & 3) {
            case 1: {
                QxName qxName = QxNameHash.create(string, string2);
                this.xdkSetQxName(qxName);
                this.setNodeFlag(65536);
                String string3 = qxName.getLocalPart();
                String string4 = qxName.getPrefix();
                if (!"xmlns".equals(string3) && !"xmlns".equals(string4)) break;
                this.setNodeFlag(262144);
                break;
            }
            case 2: {
                long l = xMLDocument.xdbCreateAttribute(this.xdbGetCtx(), xMLDocument.nodeId, string, string2, "");
                this.setNodeId(l);
            }
        }
        this.checkNamespace();
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeName() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getQName();
            }
            case 2: {
                return this.xdbGetNodeName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getName() {
        return this.getNodeName();
    }

    public String getLocalName() {
        if (!XMLParser.is902compatible && this.isNodeFlag(256)) {
            return null;
        }
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getLocalPart();
            }
            case 2: {
                return this.xdbGetLocalName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getNamespaceURI() {
        if (!XMLParser.is902compatible && this.isNodeFlag(256)) {
            return null;
        }
        switch (this.flags & 3) {
            case 1: {
                String string = this.xdkGetQxName().getNamespaceURI();
                if (string != "" || XMLParser.is902compatible) {
                    return string;
                }
                return null;
            }
            case 2: {
                return this.xdbGetNamespaceURI(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getPrefix() {
        if (!XMLParser.is902compatible && this.isNodeFlag(256)) {
            return null;
        }
        switch (this.flags & 3) {
            case 1: {
                String string = this.xdkGetQxName().getPrefix();
                if (string != "" || XMLParser.is902compatible) {
                    return string;
                }
                return null;
            }
            case 2: {
                return this.xdbGetPrefix(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isNodeFlag(256)) {
            super.setPrefix(string);
            return;
        }
        switch (this.flags & 3) {
            case 1: {
                if (string == null) {
                    string = "";
                }
                if (string.startsWith("!") || string.startsWith("#") || string.startsWith("@") || string.startsWith(",") || string.startsWith("<") || string.startsWith(">")) {
                    throw new XMLDOMException(5, 21007, this.getXMLError(), string.substring(0, 1));
                }
                QxName qxName = this.xdkGetQxName();
                String string2 = qxName.getNamespaceURI();
                String string3 = qxName.getQName();
                if ("xmlns".equals(string3)) {
                    throw new XMLDOMException(14, 21016, this.getXMLError(), string2, string);
                }
                if (string.equals("xmlns")) {
                    if (!"http://www.w3.org/2000/xmlns/".equals(this.getNamespaceURI())) {
                        throw new XMLDOMException(14, 21016, this.getXMLError(), string2, string);
                    }
                    this.setNodeFlag(262144);
                }
                if (!string2.equals("http://www.w3.org/XML/1998/namespace") && string.equals("xml")) {
                    throw new XMLDOMException(14, 21016, this.getXMLError(), string2, string);
                }
                if (string2.equals("")) {
                    throw new XMLDOMException(14, 21016, this.getXMLError(), string2, string);
                }
                this.xdkSetQxName(qxName.setPrefix(string));
                XMLUtil.validateQualifiedName(string2, this.getNodeName());
                break;
            }
            case 2: {
                this.xdbSetPrefix(this.xdbGetCtx(), this.nodeId, string);
            }
        }
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public String getNodeValue() throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                String string = "";
                string = this.xdkGetFirstChild() != null ? this.getText() : this.xdkGetNodeValue();
                return string;
            }
            case 2: {
                return this.xdbGetNodeValue(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public void setValue(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public void setNodeValue(String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.checkReadOnly();
                if (this.isDocumentFlag(65536)) {
                    XMLNode xMLNode = this.xdkGetParentNode();
                    String string2 = this.xdkGetNodeValue();
                    if (string2 == null) {
                        string2 = this.getText();
                        for (Node node = this.xdkGetFirstChild(); node != null; node = node.getNextSibling()) {
                            this.removeChild(node);
                        }
                    }
                    this.xdkSetNodeValue(string);
                    if (xMLNode != null) {
                        this.fireDOMMutationEvent("DOMAttrModified", xMLNode, this, string2, string, this.getNodeName(), true, false, (short)1);
                        this.fireDOMMutationEvent("DOMSubtreeModified", xMLNode, null, null, null, null, true, false, (short)0);
                    }
                } else {
                    String string3 = this.xdkGetNodeValue();
                    if (string3 == null) {
                        string3 = this.getText();
                        for (Node node = this.xdkGetFirstChild(); node != null; node = node.getNextSibling()) {
                            this.removeChild(node);
                        }
                    }
                    this.xdkSetNodeValue(string);
                }
                this.setNodeFlag(65536);
                break;
            }
            case 2: {
                this.xdbSetNodeValue(this.xdbGetCtx(), this.nodeId, string);
            }
        }
    }

    public Node getParentNode() {
        return null;
    }

    public Element getOwnerElement() {
        switch (this.flags & 3) {
            case 1: {
                return (Element)((Object)this.xdkGetParentNode());
            }
            case 2: {
                long l = this.xdbGetOwnerElement(this.xdbGetCtx(), this.nodeId);
                if (l == 0L) break;
                return (Element)((Object)this.xdbGetNodeFromId(l, (short)1));
            }
        }
        return null;
    }

    public boolean isId() {
        switch (this.flags & 3) {
            case 1: {
                return this.isNodeFlag(524288);
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    public boolean getSpecified() {
        switch (this.flags & 3) {
            case 1: {
                return this.isNodeFlag(65536);
            }
            case 2: {
                return this.xdbIsSpecified(this.xdbGetCtx(), this.nodeId);
            }
        }
        return false;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public TypeInfo getSchemaTypeInfo() {
        switch (this.flags & 3) {
            case 1: {
                XMLElement xMLElement = (XMLElement)this.getOwnerElement();
                XSDElement xSDElement = xMLElement.getElementDeclaration();
                if (xSDElement != null) {
                    XSDAttribute xSDAttribute = xSDElement.getAttributeDeclaration(this.getNamespaceURI(), this.getLocalName());
                    if (xSDAttribute != null) {
                        return new XMLTypeInfo(xSDAttribute);
                    }
                    return new XMLTypeInfo();
                }
                return new XMLTypeInfo(this.getNodeName());
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public short canRemoveChild(Node node) {
        switch (this.flags & 3) {
            case 1: {
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public DOMStringList getEnumeratedValues() {
        switch (this.flags & 3) {
            case 1: {
                XMLElement xMLElement = (XMLElement)this.getOwnerElement();
                XSDElement xSDElement = xMLElement.getElementDeclaration();
                if (xSDElement == null) {
                    return null;
                }
                XSDAttribute xSDAttribute = xSDElement.getAttributeDeclaration(this.getNamespaceURI(), this.getLocalName());
                if (xSDAttribute == null) {
                    return null;
                }
                XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
                Vector vector = xSDSimpleType.getEnumeration();
                if (vector != null) {
                    int n = vector.size();
                    XMLDOMStringList xMLDOMStringList = new XMLDOMStringList(n);
                    for (int i = 0; i < n; ++i) {
                        xMLDOMStringList.addString((String)vector.elementAt(i));
                    }
                    return xMLDOMStringList;
                }
                return null;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public String getQualifiedName() {
        return this.getNodeName();
    }

    public String getNamespace() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getNamespaceURI();
            }
            case 2: {
                String string = this.xdbGetNamespaceURI(this.xdbGetCtx(), this.nodeId);
                if (string == null) {
                    string = "";
                }
                return string;
            }
        }
        return null;
    }

    public String getExpandedName() {
        String string = this.getNamespaceURI();
        if (string != null) {
            return string + ":" + this.getLocalName();
        }
        return this.getLocalName();
    }

    public XMLAttr getNextAttribute() {
        switch (this.flags & 3) {
            case 1: {
                return (XMLAttr)this.xdkGetNextNode();
            }
            case 2: {
                XMLElement xMLElement = (XMLElement)this.getOwnerElement();
                if (xMLElement == null) break;
                XMLAttrList xMLAttrList = (XMLAttrList)xMLElement.getAttributes();
                return xMLAttrList.xdbGetNextAttr(this);
            }
        }
        return null;
    }

    public XMLNode addText(String string) {
        switch (this.flags & 3) {
            case 1: {
                String string2 = this.xdkGetNodeValue();
                if (string2 != null) {
                    this.xdkSetNodeValue(this.xdkGetNodeValue().concat(string));
                    break;
                }
                XMLText xMLText = (XMLText)this.getDocument().createTextNode(string);
                this.appendChild(xMLText);
                break;
            }
            case 2: {
                String string3 = this.xdbGetNodeValue(this.xdbGetCtx(), this.nodeId).concat(string);
                this.xdbSetNodeValue(this.xdbGetCtx(), this.nodeId, string3);
            }
        }
        return this;
    }

    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl, boolean bl2) {
        infosetWriter.createEvent(10);
        infosetWriter.setQName(this.xdkGetQxName());
        if (this.isNodeFlag(16384)) {
            infosetWriter.setTypeName(this.xdkGetTypeQxName());
        }
        infosetWriter.setPrimitiveTypeId(this.getPrimitiveTypeId());
        infosetWriter.setValue(this.getNodeValue());
        if (this.isNodeFlag(65536)) {
            infosetWriter.setEventFlags(65536);
        }
        infosetWriter.save();
    }

    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        int n;
        QxName qxName = (QxName)infosetReader.getQName();
        this.xdkSetQxName(qxName);
        QxName qxName2 = (QxName)infosetReader.getTypeName();
        if (qxName2 != null) {
            this.setNodeFlag(0x1000000);
            if (this.isNodeFlag(16384)) {
                this.xdkSetTypeQxName(qxName2);
            }
        }
        if ((n = infosetReader.getPrimitiveTypeId()) != -1) {
            this.setPrimitiveTypeId(n);
        }
        this.xdkSetNodeValue(infosetReader.getValue());
        this.flags |= infosetReader.getEventFlags();
        String string = qxName.getLocalPart();
        String string2 = qxName.getPrefix();
        if ("xmlns".equals(string) || "xmlns".equals(string2)) {
            this.setNodeFlag(262144);
        }
    }

    public Node getFirstChild() {
        switch (this.flags & 3) {
            case 1: {
                String string = this.xdkGetNodeValue();
                if (string != null) {
                    XMLText xMLText = (XMLText)this.getDocument().createTextNode(string);
                    this.xdkSetFirstChild(xMLText);
                    this.xdkSetLastChild(xMLText);
                    xMLText.xdkSetParentNode(this);
                    this.xdkSetNodeValue(null);
                    return xMLText;
                }
                return this.xdkGetFirstChild();
            }
            case 2: {
                long l = this.xdbGetFirstChild(this.xdbGetCtx(), this.nodeId);
                if (l == 0L) break;
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node getLastChild() {
        switch (this.flags & 3) {
            case 1: {
                String string = this.xdkGetNodeValue();
                if (string != null) {
                    XMLText xMLText = (XMLText)this.getDocument().createTextNode(string);
                    this.xdkSetFirstChild(xMLText);
                    this.xdkSetLastChild(xMLText);
                    xMLText.xdkSetParentNode(this);
                    this.xdkSetNodeValue(null);
                    return xMLText;
                }
                return this.xdkGetLastChild();
            }
            case 2: {
                long l = this.xdbGetLastChild(this.xdbGetCtx(), this.nodeId);
                if (l == 0L) break;
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    XMLNode xdkGetParentNode() {
        return (XMLNode)this.data[(int)this.nodeId + 0];
    }

    void xdkSetParentNode(XMLNode xMLNode) {
        this.data[(int)this.nodeId + 0] = xMLNode;
    }

    QxName xdkGetQxName() {
        return (QxName)this.data[(int)this.nodeId + 1];
    }

    void xdkSetQxName(QxName qxName) {
        this.data[(int)this.nodeId + 1] = qxName;
    }

    QxName xdkGetTypeQxName() {
        if (this.isNodeFlag(16384)) {
            return (QxName)this.data[(int)this.nodeId + this.getTypeOffset()];
        }
        return null;
    }

    void xdkSetTypeQxName(QxName qxName) {
        this.data[(int)this.nodeId + this.getTypeOffset()] = qxName;
    }

    String xdkGetNodeValue() {
        return (String)this.data[(int)this.nodeId + 2];
    }

    void xdkSetNodeValue(String string) {
        this.data[(int)this.nodeId + 2] = string;
    }

    XMLNode xdkGetNextNode() {
        return (XMLNode)this.data[(int)this.nodeId + 3];
    }

    void xdkSetNextNode(Object object) {
        this.data[(int)this.nodeId + 3] = object;
    }

    XMLNode xdkGetFirstChild() {
        return (XMLNode)this.data[(int)this.nodeId + 4];
    }

    void xdkSetFirstChild(Object object) {
        this.data[(int)this.nodeId + 4] = object;
    }

    XMLNode xdkGetLastChild() {
        return (XMLNode)this.data[(int)this.nodeId + 5];
    }

    void xdkSetLastChild(Object object) {
        this.data[(int)this.nodeId + 5] = object;
    }

    int xdkGetNodeArraySize() {
        if (this.isNodeFlag(16384)) {
            return 7;
        }
        return 6;
    }

    int getTypeOffset() {
        return 6;
    }

    InfosetReader.Offset xdkGetOffset() {
        return ((XMLElement)this.xdkGetParentNode()).xdkGetOffset();
    }

    public XMLElement getSrcRoot() {
        XMLElement xMLElement = (XMLElement)this.getOwnerElement();
        if (xMLElement != null) {
            return xMLElement.getSrcRoot();
        }
        return null;
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        String string;
        boolean bl = (n & 0x10) == 16;
        QxName qxName = null;
        if (bl && (qxName = (QxName)this.getSchemaTypeName()) != null) {
            xMLDocument.setNodeFlag(16384);
        }
        XMLAttr xMLAttr = this.isNodeFlag(256) ? (XMLAttr)xMLDocument.createAttribute(this.getNodeName()) : (XMLAttr)xMLDocument.createAttributeNS(this.getNamespaceURI(), this.getNodeName());
        xMLDocument.resetNodeFlag(16384);
        if (qxName != null) {
            xMLAttr.xdkSetTypeQxName(qxName);
        }
        if (bl && this.isNodeFlag(0x1000000)) {
            xMLAttr.setPrimitiveTypeId(this.getPrimitiveTypeId());
            xMLAttr.setNodeFlag(0x1000000);
        }
        if ((string = this.xdkGetNodeValue()) != null) {
            xMLAttr.xdkSetNodeValue(string);
        } else if (string == null && (n & 8) == 8) {
            xMLAttr.xdkSetNodeValue("");
        }
        xMLAttr.setNodeFlag(65536, this.isNodeFlag(65536));
        xMLAttr.setNodeFlag(262144, this.isNodeFlag(262144));
        xMLAttr.setNodeFlag(524288, this.isNodeFlag(524288));
        xMLAttr.setNodeFlag(256, this.isNodeFlag(256));
        short s = this.getUserDataHandlerOpcode(n);
        this.callUserDataHandlers(s, xMLAttr);
        if ((n & 8) == 8) {
            return xMLAttr;
        }
        if (string == null) {
            for (XMLNode xMLNode = (XMLNode)this.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                xMLAttr.appendChild(xMLNode.xdkCopyNode(xMLDocument, n));
            }
        }
        return xMLAttr;
    }

    public boolean checkTypeNSName(int n, String string, String string2) {
        return !(n != 2 || string != null && !string.equals(this.getNamespace()) || string2 != null && !string2.equals(this.getNodeLocalName()));
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new XMLDOMException(3, 21003, this.getXMLError(), XMLUtil.nodeTypeToString(n), XMLUtil.nodeTypeToString(this.getNodeType()));
    }

    void checkNamespace() {
        String string = this.getLocalName();
        String string2 = this.getPrefix();
        String string3 = this.getNamespaceURI();
        if (string3 == null && string2 != null) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string3, string2);
        }
        if (!"http://www.w3.org/XML/1998/namespace".equals(string3) && "xml".equals(string2)) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string3, string2);
        }
        if (!"http://www.w3.org/2000/xmlns/".equals(string3) && "xmlns".equals(string)) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string3, string2);
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        this.print(xMLOutputStream, bl, false);
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl, boolean bl2) throws IOException {
        switch (this.flags & 3) {
            case 1: {
                if (bl2 || this.isNodeFlag(65536)) break;
                return;
            }
            case 2: {
                if (this.xdbIsSpecified(this.xdbGetCtx(), this.nodeId)) break;
                return;
            }
        }
        xMLOutputStream.writeChars(" ");
        xMLOutputStream.writeChars(this.getNodeName());
        xMLOutputStream.writeChars("=");
        xMLOutputStream.write(34);
        String string = this.getText();
        if (string != null) {
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == '&') {
                    xMLOutputStream.writeChars("&amp;");
                    continue;
                }
                if (cArray[i] == '<') {
                    xMLOutputStream.writeChars("&lt;");
                    continue;
                }
                if (cArray[i] == '\"') {
                    xMLOutputStream.writeChars("&quot;");
                    continue;
                }
                if (cArray[i] == '\r') {
                    xMLOutputStream.writeChars("&#xD;");
                    continue;
                }
                if (cArray[i] == '\n') {
                    xMLOutputStream.writeChars("&#xA;");
                    continue;
                }
                if (cArray[i] == '\t') {
                    xMLOutputStream.writeChars("&#x9;");
                    continue;
                }
                xMLOutputStream.write(cArray[i]);
            }
        }
        xMLOutputStream.write(34);
        xMLOutputStream.flush();
    }

    Node traverseUp(XMLNode xMLNode, boolean bl) {
        if (this == xMLNode) {
            return null;
        }
        XMLNode xMLNode2 = (XMLNode)((Object)this.getOwnerElement());
        XMLNode xMLNode3 = (XMLNode)xMLNode2.getFirstChild();
        if (xMLNode3 != null) {
            return xMLNode3;
        }
        if (xMLNode2 == xMLNode) {
            return null;
        }
        xMLNode3 = (XMLNode)xMLNode2.getNextSibling();
        if (xMLNode3 != null) {
            return xMLNode3;
        }
        return xMLNode2.traverseUp(xMLNode, bl);
    }

    Node getSuccessor(XMLNode xMLNode, boolean bl) {
        return this.getNextAttribute();
    }

    Node getPredecessor(XMLNode xMLNode, boolean bl) {
        return this.getPrevAttribute();
    }

    native boolean xdbIsSpecified(long var1, long var3);

    native long xdbGetOwnerElement(long var1, long var3);

    public XMLAttr() {
    }

    public XMLAttr(String string, String string2) {
        this(string, "", "", string2);
    }

    public XMLAttr(String string, String string2, String string3, String string4) {
        String string5 = string;
        if (string2 != null && string2 != "") {
            string5 = string2 + ":" + string;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        QxName qxName = QxNameHash.create(string3, string, string2, string5);
        this.xdkSetQxName(qxName);
        if (string == "xmlns" || string2.equals("xmlns")) {
            this.setNodeFlag(262144);
        }
        this.xdkSetNodeValue(string4);
        this.checkNamespace();
    }

    public XMLAttr(String string, String string2, String string3, String string4, String string5) {
        QxName qxName = QxNameHash.create(string4, string, string2, string3);
        this.xdkSetQxName(qxName);
        this.xdkSetNodeValue(string5);
        if (string == "xmlns" || string2.equals("xmlns")) {
            this.setNodeFlag(262144);
        }
    }

    public XMLAttr getPrevAttribute() {
        switch (this.flags & 3) {
            case 1: {
                XMLElement xMLElement = (XMLElement)this.xdkGetParentNode();
                if (xMLElement != null) {
                    XMLAttr xMLAttr = null;
                    for (XMLAttr xMLAttr2 = (XMLAttr)xMLElement.xdkGetFirstAttr(); xMLAttr2 != this; xMLAttr2 = (XMLAttr)xMLAttr2.xdkGetNextNode()) {
                        xMLAttr = xMLAttr2;
                    }
                    return xMLAttr;
                }
                return null;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }
}

