/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import oracle.xml.comp.CXMLHandlerBase;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.NonValidatingParser;
import oracle.xml.parser.v2.ValidatingParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.util.XMLProperties;
import oracle.xml.util.XMLUtil;
import oracle.xml.xslt.XMLStreamFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XMLParser
implements XMLConstants,
XMLProperties {
    NonValidatingParser parser;
    XSDBuilder xsdBuilder;
    Object schemaSource;
    public static final String DTD_OBJECT = "oracle.xml.parser.XMLParser.DTDObject";
    public static final String PARSER_DTD = "oracle.xml.parser.XMLParser.ParserDTD";
    public static final String PARSER_CDATA = "oracle.xml.parser.XMLParser.ParserCData";
    public static final String PARSER = "oracle.xml.parser.DOMParser.Parser";
    public static final String USE_DTD_ONLY_FOR_VALIDATION = "oracle.xml.parser.XMLParser.UseDTDForValidation";
    public static final String SCHEMA_OBJECT = "oracle.xml.parser.XMLParser.SchemaObject";
    public static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String BASE_URL = "oracle.xml.parser.XMLParser.BaseURL";
    public static final String STANDALONE = "oracle.xml.parser.XMLParser.Standalone";
    public static final String EXPAND_ENTITYREF = "oracle.xml.parser.XMLParser.ExpandEntityRef";
    public static final String RESOLVE_ENTITY_DEFAULT = "oracle.xdkjava.security.resolveEntityDefault";
    protected Hashtable attributes;
    boolean validating;
    boolean useDTDForValidation;
    boolean xsdValidatorSet;
    int validating_mode;
    static final String releaseVersion = "Oracle XML Developers Kit 11.2.0.1.0 - Production";
    static boolean is902compatible;
    static boolean is1010compatible;
    static boolean noShowForInvalidURLError;
    static String[] reportedCHClasses;
    static final boolean extValue;
    private static final boolean replaceIllegalCharsProperty;
    private boolean replaceIllegalChars = replaceIllegalCharsProperty;

    XMLParser() {
        this.parser = new NonValidatingParser();
    }

    public void reset() {
        this.parser.reset();
    }

    void init() throws SAXException, IOException {
        this.parser.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws XMLParseException, SAXException, IOException {
        try {
            this.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.setReplaceIllegalChars(this.replaceIllegalChars);
            this.parser.reader.pushXMLReader(inputSource);
            this.setProperties();
            this.parser.parseDocument();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parser.reader.close();
            throw throwable;
        }
        this.parser.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string) throws XMLParseException, SAXException, IOException {
        try {
            InputSource inputSource = new InputSource(string);
            this.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.setReplaceIllegalChars(this.replaceIllegalChars);
            this.parser.reader.pushXMLReader(inputSource);
            this.setProperties();
            this.parser.parseDocument();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.parser.reader.close();
            throw throwable;
        }
        this.parser.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(URL uRL) throws XMLParseException, SAXException, IOException {
        try {
            this.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.setReplaceIllegalChars(this.replaceIllegalChars);
            this.parser.reader.pushXMLReader(uRL, uRL.toString(), null);
            this.setProperties();
            this.parser.parseDocument();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parser.reader.close();
            throw throwable;
        }
        this.parser.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(InputStream inputStream) throws XMLParseException, SAXException, IOException {
        try {
            this.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.setReplaceIllegalChars(this.replaceIllegalChars);
            this.parser.reader.pushXMLReader(inputStream, null, null);
            this.setProperties();
            this.parser.parseDocument();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parser.reader.close();
            throw throwable;
        }
        this.parser.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(Reader reader) throws XMLParseException, SAXException, IOException {
        try {
            this.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.setReplaceIllegalChars(this.replaceIllegalChars);
            this.parser.reader.pushXMLReader(reader, null, null);
            this.setProperties();
            this.parser.parseDocument();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parser.reader.close();
            throw throwable;
        }
        this.parser.reader.close();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.entResolver = entityResolver;
        if (this.parser.reader != null) {
            this.parser.reader.entResolver = entityResolver;
        }
        if (this.xsdValidatorSet && this.parser.cntHandler instanceof XSDValidator) {
            XSDValidator xSDValidator = (XSDValidator)this.parser.cntHandler;
            xSDValidator.setXMLProperty("entityResolver", entityResolver);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.parser.entResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.err.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.err.getErrorHandler();
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.err.setLocale(locale);
    }

    public void setDoctype(DTD dTD) {
        this.parser.dtd = dTD;
        this.parser.fixedDTD = true;
    }

    public void setSchemaValidationMode(boolean bl) {
        if (bl) {
            this.setValidationMode(3);
        } else {
            this.setValidationMode(0);
        }
    }

    public void setValidationMode(boolean bl) {
        if (bl != this.validating) {
            if (bl) {
                this.parser = new ValidatingParser(this.parser);
                this.validating_mode = 2;
            } else {
                this.parser = new NonValidatingParser(this.parser);
                this.validating_mode = 0;
            }
            this.validating = bl;
        }
    }

    public void setValidationMode(int n) {
        if (n == 0) {
            this.validating = false;
            if (this.xsdValidatorSet) {
                this.removeXSDValidator();
            }
            this.parser = new NonValidatingParser(this.parser);
        } else if (n == 3) {
            this.initializeSchemaValidation("ORACLE_XSD_AutoValidation");
        } else if (n == 5) {
            this.initializeSchemaValidation("ORACLE_XSD_LaxValidation");
        } else if (n == 6) {
            this.initializeSchemaValidation("ORACLE_XSD_StrictValidation");
        } else {
            this.parser = new ValidatingParser(this.parser);
            this.validating = true;
        }
        this.validating_mode = n == 4 ? 1 : n;
    }

    public Object setSchemaValidatorProperty(String string, Object object) {
        XSDValidator xSDValidator = this.getSchemaValidator();
        if (xSDValidator == null) {
            return null;
        }
        return xSDValidator.setXMLProperty(string, object);
    }

    private void initializeSchemaValidation(String string) {
        this.parser = new NonValidatingParser(this.parser);
        XSDValidator xSDValidator = this.addXSDValidator();
        try {
            xSDValidator.setError(this.parser.err);
            xSDValidator.setDocumentLocator(this.parser.reader);
            if (this.parser.entResolver != null) {
                xSDValidator.setXMLProperty("entityResolver", this.parser.entResolver);
            }
            if (xSDValidator.setXMLProperty("validationMode", string) == null) {
                this.parser.err.error0(1900, 0);
            }
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
        this.validating = true;
    }

    public void setBaseURL(URL uRL) {
        this.parser.baseURL = uRL;
    }

    public URL getBaseURL() {
        return this.parser.baseURL;
    }

    public void setPreserveWhitespace(boolean bl) {
        this.parser.preserveWS = bl ? 0 : 1;
    }

    public void resetPreserveWhitespace() {
        this.parser.preserveWS = -1;
    }

    public boolean getValidationMode() {
        return this.validating;
    }

    public int getValidationModeValue() {
        return this.validating_mode;
    }

    public static String getReleaseVersion() {
        return releaseVersion;
    }

    public void setXMLSchema(Object object) {
        XSDValidator xSDValidator = this.addXSDValidator();
        try {
            xSDValidator.setError(this.parser.err);
            xSDValidator.setDocumentLocator(this.parser.reader);
            xSDValidator.setXMLProperty("fixedSchema", (XMLSchema)object);
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }

    public XMLSchema getXMLSchema() {
        XSDValidator xSDValidator = null;
        if (this.parser.cntHandler instanceof XSDValidator) {
            xSDValidator = (XSDValidator)this.parser.cntHandler;
        }
        if (xSDValidator != null) {
            return xSDValidator.getXMLSchema();
        }
        return null;
    }

    public XSDValidator getSchemaValidator() {
        if (this.parser.cntHandler instanceof XSDValidator) {
            return (XSDValidator)this.parser.cntHandler;
        }
        return null;
    }

    XSDValidator addXSDValidator() {
        try {
            if (!this.xsdValidatorSet) {
                XSDValidator xSDValidator = new XSDValidator();
                xSDValidator.setXMLProperties(this);
                ContentHandler contentHandler = this.parser.cntHandler;
                xSDValidator.addContentHandler(contentHandler);
                if (contentHandler instanceof DocumentBuilder) {
                    ((DocumentBuilder)contentHandler).setXSDValidator(xSDValidator);
                }
                if (contentHandler instanceof CXMLHandlerBase) {
                    ((CXMLHandlerBase)contentHandler).setXSDValidator(xSDValidator);
                }
                this.parser.cntHandler = xSDValidator;
                this.xsdValidatorSet = true;
                return xSDValidator;
            }
            return (XSDValidator)this.parser.cntHandler;
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
            return null;
        }
    }

    void removeXSDValidator() {
        if (this.parser.cntHandler instanceof XSDValidator) {
            ContentHandler contentHandler;
            XSDValidator xSDValidator = (XSDValidator)this.parser.cntHandler;
            ContentHandler[] contentHandlerArray = xSDValidator.getContentHandlers();
            if (contentHandlerArray != null && contentHandlerArray.length > 0) {
                this.parser.cntHandler = contentHandlerArray[0];
            }
            if ((contentHandler = this.parser.cntHandler) instanceof DocumentBuilder) {
                ((DocumentBuilder)contentHandler).setXSDValidator(null);
            }
        }
        this.xsdValidatorSet = false;
    }

    public void addFilter(XMLStreamFilter xMLStreamFilter) {
        xMLStreamFilter.addContentHandler(this.parser.cntHandler);
        this.parser.cntHandler = xMLStreamFilter;
    }

    void setContentHandler(ContentHandler contentHandler, ContentHandler contentHandler2) {
        if (this.xsdValidatorSet) {
            XMLMultiHandler xMLMultiHandler = (XMLMultiHandler)this.parser.cntHandler;
            xMLMultiHandler.removeContentHandler(contentHandler2);
            xMLMultiHandler.addContentHandler(contentHandler);
        } else {
            this.parser.cntHandler = contentHandler;
        }
    }

    void setLexHandler(LexicalHandler lexicalHandler) {
        this.parser.lexHandler = lexicalHandler;
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if ((string = string.intern()) == DTD_OBJECT && object instanceof DTD) {
            this.setDoctype((DTD)object);
        } else if (string == SCHEMA_OBJECT) {
            this.setXMLSchema(object);
        } else if (string == SCHEMA_SOURCE) {
            this.schemaSource = object;
        } else if (string == SCHEMA_LANGUAGE) {
            if (((String)object).equals("http://www.w3.org/2001/XMLSchema")) {
                this.setValidationMode(3);
            }
            this.getSchemaValidator().setJAXP(true);
        } else if (string == BASE_URL && object instanceof URL) {
            this.setBaseURL((URL)object);
        } else if (string == USE_DTD_ONLY_FOR_VALIDATION && object instanceof Boolean) {
            this.useDTDForValidation = (Boolean)object;
        } else if (string == STANDALONE && object instanceof Boolean) {
            this.parser.standalone = (Boolean)object;
        } else if (string == EXPAND_ENTITYREF && object instanceof Boolean) {
            this.parser.expanderef = (Boolean)object;
        } else if (string == RESOLVE_ENTITY_DEFAULT && object instanceof Boolean) {
            this.parser.entResolution = (Boolean)object;
        } else {
            throw new IllegalArgumentException();
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable(5);
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if ((string = string.intern()) == PARSER_DTD) {
            return this.parser.dtd;
        }
        if (string == DTD_OBJECT || string == SCHEMA_OBJECT || string == BASE_URL || string == USE_DTD_ONLY_FOR_VALIDATION || string == STANDALONE || string == EXPAND_ENTITYREF) {
            return this.attributes.get(string);
        }
        throw new IllegalArgumentException();
    }

    public void setError(XMLError xMLError) {
        this.parser.err = xMLError;
    }

    public Object setXMLProperty(String string, Object object) {
        if (string == null) {
            return null;
        }
        if (string.equals("oracle.xml.parser.replaceIllegalChars")) {
            Boolean bl;
            if (object == null) {
                this.replaceIllegalChars = false;
                return object;
            }
            if (object instanceof String) {
                bl = new Boolean((String)object);
                object = bl;
            }
            bl = null;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
                this.replaceIllegalChars = bl;
                return object;
            }
            return null;
        }
        return null;
    }

    public Object getXMLProperty(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("oracle.xml.parser.DocumentBuilder")) {
            return this.parser.getDocumentBuilder();
        }
        if (string.equals("oracle.xml.parser.doc.XmlDeclStandalone")) {
            return this.parser.reader.xmlDeclStandalone;
        }
        if (string.equals("oracle.xml.parser.doc.xmlDeclEncoding")) {
            return this.parser.reader.xmlDeclEncoding;
        }
        if (string.equals("oracle.xml.parser.replaceIllegalChars")) {
            return this.replaceIllegalChars;
        }
        return null;
    }

    public boolean isXMLPropertySupported(String string) {
        return string.equals("oracle.xml.parser.DocumentBuilder");
    }

    public boolean isXMLPropertyReadOnly(String string) {
        return true;
    }

    private void setSchemaSource() {
        if (this.schemaSource == null) {
            return;
        }
        try {
            this.setXMLSchema(this.buildSchema(this.schemaSource));
        }
        catch (XSDException xSDException) {
            this.parser.err.setException(xSDException);
            this.parser.err.error0(1900, 0);
        }
        this.getSchemaValidator().setJAXP(true);
        this.schemaSource = null;
    }

    private XMLSchema buildSchema(Object object) throws XSDException, IllegalArgumentException {
        XMLSchema xMLSchema = null;
        if (this.xsdBuilder == null) {
            this.xsdBuilder = new XSDBuilder();
        }
        if (object instanceof InputStream) {
            xMLSchema = this.xsdBuilder.build((InputStream)object, null);
        } else if (object instanceof String) {
            String string = (String)object;
            EntityResolver entityResolver = this.parser.entResolver;
            if (entityResolver != null) {
                InputSource inputSource = null;
                try {
                    inputSource = entityResolver.resolveEntity(null, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                xMLSchema = inputSource != null ? this.xsdBuilder.build(inputSource) : this.xsdBuilder.build(string);
            } else {
                xMLSchema = this.xsdBuilder.build(string);
            }
        } else if (object instanceof InputSource) {
            xMLSchema = this.xsdBuilder.build((InputSource)object);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                xMLSchema = this.buildSchema(objectArray[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return xMLSchema;
    }

    private void setProperties() throws XMLParseException {
        this.setSchemaSource();
        if (this.parser.cntHandler instanceof CXMLHandlerBase) {
            CXMLHandlerBase cXMLHandlerBase = (CXMLHandlerBase)this.parser.cntHandler;
            if (this.parser.reader.xmlDecl) {
                cXMLHandlerBase.setProperty("oracle.xml.version", this.parser.reader.xmlDeclVersion);
                cXMLHandlerBase.setProperty("oracle.xml.comp.standalone", this.parser.reader.xmlDeclStandalone);
                cXMLHandlerBase.setProperty("oracle.xml.comp.encoding", this.parser.reader.xmlDeclEncoding);
            }
        } else if (this.parser.cntHandler instanceof XMLMultiHandler) {
            XMLMultiHandler xMLMultiHandler = (XMLMultiHandler)this.parser.cntHandler;
            if (this.parser.reader.xmlDecl) {
                xMLMultiHandler.setProperty("oracle.xml.version", this.parser.reader.xmlDeclVersion);
                xMLMultiHandler.setProperty("oracle.xml.comp.standalone", this.parser.reader.xmlDeclStandalone);
                xMLMultiHandler.setProperty("oracle.xml.comp.encoding", this.parser.reader.xmlDeclEncoding);
            }
        }
    }

    public static boolean getIs1010Compatible() {
        return is1010compatible;
    }

    public static String[] getReportedCHClasses() {
        return reportedCHClasses;
    }

    public static boolean getNoShowForInvalidURLError() {
        return noShowForInvalidURLError;
    }

    static {
        String string;
        String string2;
        is902compatible = false;
        is1010compatible = false;
        noShowForInvalidURLError = false;
        reportedCHClasses = null;
        String string3 = XMLUtil.getProperty("oracle.xdkjava.compatibility.version", "10.2.0");
        if (string3.equals("9.0.2")) {
            is902compatible = true;
        } else if (string3.equals("10.1.0")) {
            is1010compatible = true;
        }
        String string4 = XMLUtil.getProperty("oracle.xml.jaxp.NoShowForInvalidURLError", "false");
        if (string4.equals("true")) {
            noShowForInvalidURLError = true;
        }
        if (!(string2 = XMLUtil.getProperty("oracle.xml.reportdocevents", "none")).equals("none")) {
            reportedCHClasses = XMLUtil.stringTokens(string2, ",");
        }
        extValue = !(string = XMLUtil.getProperty(RESOLVE_ENTITY_DEFAULT, "true")).equals("false");
        String string5 = "oracle.xml.parser.replaceIllegalChars";
        String string6 = XMLUtil.getProperty(string5);
        Boolean bl = new Boolean(string6);
        replaceIllegalCharsProperty = bl;
    }
}

