/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.xml.parser.v2.DTD;
import oracle.xml.scalable.PageManager;

public class BinaryStream {
    protected PagedIO pagedio;
    private byte[][] bufArray;
    private int[] bufCount;
    private byte[] wriBuf = new byte[BUFSIZE];
    private int[][] reversePageIds;
    private int[] pageIds;
    private int[] pageTicks;
    private int pageTickCnt;
    private int pageOrderIdx;
    private DTD dtd;
    private String version;
    private String encoding;
    private String standalone;
    private String systemId;
    private Vector typelist;
    protected Vector readers;
    protected boolean writer;
    protected boolean updated;
    private boolean pgmSet;
    public static int NBUFFERS = 16;
    public static int BUFSIZE = 4096;
    public static final String BINARY_FORMAT = "oracle.xml.scalable.binary_format";
    public static final String XDK_CXML = "XDK_CXML_BINARY";
    public static final String XDB_BINXML = "XDB_BINXML_BINARY";

    public BinaryStream() {
        int n;
        this.bufArray = new byte[NBUFFERS][];
        this.bufCount = new int[NBUFFERS];
        this.pageIds = new int[NBUFFERS];
        this.reversePageIds = new int[512][];
        this.reversePageIds[0] = new int[1024];
        for (n = 0; n < 1024; ++n) {
            this.reversePageIds[0][n] = -1;
        }
        this.pageTicks = new int[NBUFFERS];
        this.pageTickCnt = 0;
        this.pageOrderIdx = 0;
        for (n = 0; n < NBUFFERS; ++n) {
            this.bufArray[n] = new byte[BUFSIZE];
            this.pageIds[n] = -1;
            this.pageTicks[n] = -1;
        }
        this.pagedio = new MemoryPagedIO();
        this.typelist = new Vector();
        this.readers = new Vector();
        this.writer = false;
        this.pgmSet = false;
        this.dtd = new DTD();
    }

    public void setDTD(DTD dTD) {
        this.dtd = dTD;
    }

    public DTD getDTD() {
        return this.dtd;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStandalone(String string) {
        this.standalone = string;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public Vector getTypeList() {
        return this.typelist;
    }

    public boolean isSeekSupported() {
        return this.pgmSet || !(this.pagedio instanceof StreamPagedIO) && !(this.pagedio instanceof ObjectPagedIO);
    }

    public void setObjectOutput(ObjectOutput objectOutput) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof ObjectPagedIO)) {
            this.pagedio = new ObjectPagedIO();
        }
        ((ObjectPagedIO)this.pagedio).setObjectOutput(objectOutput);
    }

    public void setObjectInput(ObjectInput objectInput) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof ObjectPagedIO)) {
            this.pagedio = new ObjectPagedIO();
        }
        ((ObjectPagedIO)this.pagedio).setObjectInput(objectInput);
    }

    public ObjectOutput getObjectOutput() {
        if (this.pagedio instanceof ObjectPagedIO) {
            return ((ObjectPagedIO)this.pagedio).getObjectOutput();
        }
        return null;
    }

    public ObjectInput getObjectInput() {
        if (this.pagedio instanceof ObjectPagedIO) {
            return ((ObjectPagedIO)this.pagedio).getObjectInput();
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof StreamPagedIO)) {
            this.pagedio = new StreamPagedIO();
        }
        ((StreamPagedIO)this.pagedio).setOutputStream(outputStream);
    }

    public void setBlob(Blob blob) throws IOException {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        this.pagedio = new BlobPagedIO(blob);
    }

    public void setFile(File file) throws IOException {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        this.pagedio = new FilePagedIO(file);
    }

    public void setInputStream(InputStream inputStream) {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        if (!(this.pagedio instanceof StreamPagedIO)) {
            this.pagedio = new StreamPagedIO();
        }
        ((StreamPagedIO)this.pagedio).setInputStream(inputStream);
    }

    public void setByteArray(byte[] byArray) {
        this.pagedio = new ArrayPagedIO(byArray);
    }

    public void setPageManager(PageManager pageManager) {
        if (this.pagedio instanceof MemoryPagedIO) {
            this.pagedio = new StreamPagedIO();
        }
        if (!this.pgmSet && (this.pagedio instanceof StreamPagedIO || this.pagedio instanceof ObjectPagedIO)) {
            ((StreamPagedIO)this.pagedio).setPageManager(pageManager);
            this.pgmSet = true;
        }
    }

    int getReplacementBuf1() {
        int n = this.pageOrderIdx;
        do {
            int n2 = this.pageOrderIdx;
            this.pageOrderIdx = this.pageOrderIdx + 1 & NBUFFERS - 1;
            if (this.bufCount[n2] != 0) continue;
            return n2;
        } while (this.pageOrderIdx != n);
        return this.getReplacementBuf2();
    }

    int getReplacementBuf2() {
        int n = this.pageTickCnt;
        int n2 = -1;
        for (int i = 0; i < NBUFFERS; ++i) {
            if (this.pageTicks[i] >= n) continue;
            n2 = i;
            n = this.pageTicks[i];
        }
        return n2;
    }

    int getBufferId(int n) {
        int n2 = n / 1024;
        if (this.reversePageIds[n2] == null) {
            this.reversePageIds[n2] = new int[1024];
            for (int i = 0; i < 1024; ++i) {
                this.reversePageIds[n2][i] = -1;
            }
        }
        return this.reversePageIds[n2][n & 0x3FF];
    }

    void setBufferId(int n, int n2) {
        int n3 = n / 1024;
        if (this.reversePageIds[n3] == null) {
            this.reversePageIds[n3] = new int[1024];
            for (int i = 0; i < 1024; ++i) {
                this.reversePageIds[n3][i] = -1;
            }
        }
        this.reversePageIds[n3][n & 0x3FF] = n2;
    }

    public byte[] load(int n, boolean bl) {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            try {
                int n2 = this.getBufferId(n);
                if (n2 != -1) {
                    this.pageTicks[n2] = ++this.pageTickCnt;
                    int n3 = n2;
                    this.bufCount[n3] = this.bufCount[n3] + 1;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this.bufArray[n2];
                }
                n2 = this.getReplacementBuf1();
                if (this.bufCount[n2] > 0) {
                    this.bufArray[n2] = new byte[BUFSIZE];
                }
                byte[] byArray2 = this.bufArray[n2];
                int n4 = this.pageIds[n2];
                if (n4 != -1) {
                    this.reversePageIds[n4 >> 10][n4 & 0x3FF] = -1;
                }
                this.reversePageIds[n >> 10][n & 0x3FF] = n2;
                this.pageIds[n2] = n;
                this.pageTicks[n2] = ++this.pageTickCnt;
                this.bufCount[n2] = 1;
                if (n < this.pagedio.size()) {
                    this.pagedio.seek(n);
                    this.pagedio.read(byArray2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return byArray2;
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(iOException);
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(int n, boolean bl) {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            int n2;
            int n3 = n2 = this.getBufferId(n);
            this.bufCount[n3] = this.bufCount[n3] - 1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public byte[] getWriteBuffer() {
        this.updated = true;
        return this.wriBuf;
    }

    public void flushWriBuffer() throws IOException {
        this.pagedio.write(this.wriBuf);
    }

    public void flushWriBuffer(int n) throws IOException {
        this.pagedio.write(this.wriBuf, n);
        this.updated = false;
    }

    public void flush() throws IOException {
        if (this.updated) {
            this.pagedio.write(this.wriBuf);
        }
        this.updated = false;
        this.pagedio.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            this.pagedio.seek(0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            try {
                this.pagedio.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws IOException {
        byte[][] byArray = this.bufArray;
        synchronized (this.bufArray) {
            this.pagedio.closeAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static class StreamPagedIO
    implements PagedIO {
        OutputStream oos;
        InputStream ois;
        PageManager pageMgr;
        ArrayList pageIdList;
        int streamPos;
        int seekPos;

        StreamPagedIO() {
        }

        public void setOutputStream(OutputStream outputStream) {
            this.oos = outputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.ois = inputStream;
        }

        public void setPageManager(PageManager pageManager) {
            this.pageMgr = pageManager;
            this.pageIdList = new ArrayList();
        }

        public int read(byte[] byArray) throws IOException {
            while (this.seekPos >= this.streamPos && this.ois != null) {
                int n;
                int n2 = 0;
                for (int i = BUFSIZE; i != 0 && (n = this.ois.read(byArray, n2, i)) != -1; i -= n) {
                    n2 += n;
                }
                ++this.streamPos;
                if (this.pageMgr != null) {
                    PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n2);
                    this.pageIdList.add(pageId);
                }
                if (this.seekPos != this.streamPos - 1) continue;
                ++this.seekPos;
                return n2;
            }
            PageManager.PageId pageId = (PageManager.PageId)this.pageIdList.get(this.seekPos);
            this.pageMgr.readPage(pageId, byArray, 0);
            ++this.seekPos;
            return BUFSIZE;
        }

        public void write(byte[] byArray) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, BUFSIZE);
                this.pageIdList.add(pageId);
            }
        }

        public void write(byte[] byArray, int n) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray, 0, n);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n);
                this.pageIdList.add(pageId);
            }
        }

        public void seek(int n) {
            if (this.pageMgr == null && n < this.streamPos) {
                throw new RuntimeException("Seek not supported");
            }
            this.seekPos = n;
        }

        public int size() {
            if (this.ois != null) {
                return Integer.MAX_VALUE;
            }
            if (this.pageMgr != null) {
                return this.pageIdList.size();
            }
            return 0;
        }

        public void flush() {
            try {
                if (this.oos != null) {
                    this.oos.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void close() throws IOException {
            if (this.pageMgr != null) {
                int n = this.pageIdList.size();
                for (int i = n - 1; i >= 0; --i) {
                    this.pageMgr.deletePage((PageManager.PageId)this.pageIdList.remove(i));
                }
            }
        }

        public void closeAll() throws IOException {
            this.close();
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
        }
    }

    static class ObjectPagedIO
    implements PagedIO {
        ObjectOutput oos;
        ObjectInput ois;
        PageManager pageMgr;
        ArrayList pageIdList;
        int streamPos;
        int seekPos;

        ObjectPagedIO() {
        }

        public void setObjectOutput(ObjectOutput objectOutput) {
            this.oos = objectOutput;
        }

        public void setObjectInput(ObjectInput objectInput) {
            this.ois = objectInput;
        }

        public ObjectOutput getObjectOutput() {
            return this.oos;
        }

        public ObjectInput getObjectInput() {
            return this.ois;
        }

        public void setPageManager(PageManager pageManager) {
            this.pageMgr = pageManager;
            this.pageIdList = new ArrayList();
        }

        public int read(byte[] byArray) throws IOException {
            while (this.seekPos >= this.streamPos && this.ois != null) {
                int n;
                int n2 = 0;
                for (int i = BUFSIZE; i != 0 && (n = this.ois.read(byArray, n2, i)) != -1; i -= n) {
                    n2 += n;
                }
                ++this.streamPos;
                if (this.pageMgr != null) {
                    PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n2);
                    this.pageIdList.add(pageId);
                }
                if (this.seekPos != this.streamPos - 1) continue;
                ++this.seekPos;
                return n2;
            }
            PageManager.PageId pageId = (PageManager.PageId)this.pageIdList.get(this.seekPos);
            this.pageMgr.readPage(pageId, byArray, 0);
            ++this.seekPos;
            return BUFSIZE;
        }

        public void write(byte[] byArray) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, BUFSIZE);
                this.pageIdList.add(pageId);
            }
        }

        public void write(byte[] byArray, int n) throws IOException {
            if (this.oos != null) {
                this.oos.write(byArray, 0, n);
            }
            if (this.pageMgr != null) {
                PageManager.PageId pageId = this.pageMgr.writePage(byArray, 0, n);
                this.pageIdList.add(pageId);
            }
        }

        public void seek(int n) {
            if (this.pageMgr == null && n < this.streamPos) {
                throw new RuntimeException("Seek not supported");
            }
            this.seekPos = n;
        }

        public int size() {
            if (this.ois != null) {
                return Integer.MAX_VALUE;
            }
            if (this.pageMgr != null) {
                return this.pageIdList.size();
            }
            return 0;
        }

        public void flush() {
            try {
                if (this.oos != null) {
                    this.oos.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void close() throws IOException {
            if (this.pageMgr != null) {
                int n = this.pageIdList.size();
                for (int i = n - 1; i >= 0; --i) {
                    this.pageMgr.deletePage((PageManager.PageId)this.pageIdList.remove(i));
                }
            }
        }

        public void closeAll() throws IOException {
            this.close();
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
        }
    }

    static class ArrayPagedIO
    implements PagedIO {
        byte[] data;
        int readPos = 0;
        int wriPos = 0;
        int size;

        ArrayPagedIO(byte[] byArray) {
            this.data = byArray;
            this.size = this.data.length / BUFSIZE;
            if (this.data.length % BUFSIZE != 0) {
                ++this.size;
            }
        }

        public void close() throws IOException {
        }

        public void closeAll() throws IOException {
        }

        public void seek(int n) {
            this.readPos = n * BUFSIZE;
        }

        public int size() {
            return this.size;
        }

        public int read(byte[] byArray) throws IOException {
            if (this.data == null || this.readPos >= this.data.length) {
                return -1;
            }
            int n = BUFSIZE;
            if (this.readPos + BUFSIZE > this.data.length) {
                n = this.data.length - this.readPos;
            }
            System.arraycopy(this.data, this.readPos, byArray, 0, n);
            this.readPos += n;
            return n;
        }

        public void write(byte[] byArray) throws IOException {
            System.arraycopy(byArray, 0, this.data, this.wriPos, BUFSIZE);
            this.wriPos += BUFSIZE;
        }

        public void write(byte[] byArray, int n) throws IOException {
            System.arraycopy(byArray, 0, this.data, this.wriPos, n);
            this.wriPos += n;
        }

        public void flush() {
        }
    }

    static class MemoryPagedIO
    implements PagedIO {
        ArrayList buffers = new ArrayList();
        int seekBuf;

        MemoryPagedIO() {
        }

        public void close() throws IOException {
        }

        public void closeAll() throws IOException {
        }

        public void seek(int n) {
            this.seekBuf = n;
        }

        public int size() {
            return this.buffers.size();
        }

        public int read(byte[] byArray) throws IOException {
            if (this.buffers == null) {
                return -1;
            }
            byte[] byArray2 = (byte[])this.buffers.get(this.seekBuf);
            System.arraycopy(byArray2, 0, byArray, 0, BUFSIZE);
            ++this.seekBuf;
            return BUFSIZE;
        }

        public void write(byte[] byArray) throws IOException {
            byte[] byArray2 = new byte[BUFSIZE];
            System.arraycopy(byArray, 0, byArray2, 0, BUFSIZE);
            this.buffers.add(byArray2);
        }

        public void write(byte[] byArray, int n) throws IOException {
            byte[] byArray2 = new byte[BUFSIZE];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.buffers.add(byArray2);
        }

        public void flush() {
        }
    }

    static class BlobPagedIO
    implements PagedIO {
        Blob blob;
        OutputStream os;
        int offset;
        int sz;

        BlobPagedIO(Blob blob) throws IOException {
            try {
                this.blob = blob;
                long l = blob.length();
                this.sz = (int)(l / (long)BUFSIZE);
                if (l % (long)BUFSIZE != 0L) {
                    ++this.sz;
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = new IOException(sQLException.getMessage());
                iOException.initCause(sQLException);
                throw iOException;
            }
        }

        public void close() throws IOException {
            if (this.os != null) {
                this.os.close();
            }
            this.os = null;
        }

        public void closeAll() throws IOException {
            this.close();
        }

        public void seek(int n) {
            this.offset = n;
        }

        public int size() {
            return this.sz;
        }

        public int read(byte[] byArray) throws IOException {
            try {
                int n;
                int n2 = this.offset * BUFSIZE;
                int n3 = BUFSIZE;
                if (this.offset == this.sz - 1 && n2 + n3 > (n = (int)this.blob.length())) {
                    n3 = n - n2;
                }
                byte[] byArray2 = this.blob.getBytes(n2 + 1, n3);
                System.arraycopy(byArray2, 0, byArray, 0, n3);
                ++this.offset;
                return n3;
            }
            catch (SQLException sQLException) {
                IOException iOException = new IOException(sQLException.getMessage());
                iOException.initCause(sQLException);
                throw iOException;
            }
        }

        public void write(byte[] byArray) throws IOException {
            if (this.os == null) {
                try {
                    this.os = this.blob.setBinaryStream(0L);
                }
                catch (SQLException sQLException) {
                    IOException iOException = new IOException(sQLException.getMessage());
                    iOException.initCause(sQLException);
                    throw iOException;
                }
            }
            for (int i = 0; i < BUFSIZE; ++i) {
                this.os.write(byArray[i]);
            }
            ++this.sz;
        }

        public void write(byte[] byArray, int n) throws IOException {
            if (this.os == null) {
                try {
                    this.os = this.blob.setBinaryStream(0L);
                }
                catch (SQLException sQLException) {
                    IOException iOException = new IOException(sQLException.getMessage());
                    iOException.initCause(sQLException);
                    throw iOException;
                }
            }
            for (int i = 0; i < n; ++i) {
                this.os.write(byArray[i]);
            }
            ++this.sz;
        }

        public void flush() {
            try {
                if (this.os != null) {
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class FilePagedIO
    implements PagedIO {
        RandomAccessFile file;
        int sz;
        int offset;

        FilePagedIO(File file) throws IOException {
            this.file = new RandomAccessFile(file, "rw");
            long l = this.file.length();
            this.sz = (int)(l / (long)BUFSIZE);
            if ((l & (long)(BUFSIZE - 1)) != 0L) {
                ++this.sz;
            }
        }

        public void close() throws IOException {
        }

        public void closeAll() throws IOException {
        }

        public void seek(int n) {
            try {
                this.offset = n;
                this.file.seek(n * BUFSIZE);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(iOException);
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }

        public int size() {
            return this.sz;
        }

        public int read(byte[] byArray) throws IOException {
            int n = 0;
            int n2 = BUFSIZE;
            while (n2 != 0) {
                int n3 = this.file.read(byArray, n, n2);
                if (n3 == -1) {
                    return n;
                }
                n2 -= n3;
                n += n3;
            }
            return n;
        }

        public void write(byte[] byArray) throws IOException {
            this.file.write(byArray);
            if (this.offset == this.sz) {
                ++this.offset;
                ++this.sz;
            }
        }

        public void write(byte[] byArray, int n) throws IOException {
            this.file.write(byArray, 0, n);
            if (this.offset == this.sz) {
                ++this.offset;
                ++this.sz;
            }
        }

        public void flush() {
        }
    }

    static interface PagedIO {
        public int read(byte[] var1) throws IOException;

        public void write(byte[] var1) throws IOException;

        public void write(byte[] var1, int var2) throws IOException;

        public void seek(int var1);

        public int size();

        public void flush();

        public void close() throws IOException;

        public void closeAll() throws IOException;
    }
}

