/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.xpath.JXPathContext;
import oracle.xml.xpath.JXPathExpression;
import oracle.xml.xpath.XSLExprBase;
import org.xml.sax.InputSource;

class JXPath
implements XPath {
    NamespaceContext nsContext;
    XPathVariableResolver varResolver;
    XPathFunctionResolver funcResolver;
    boolean secure;

    JXPath(XPathVariableResolver xPathVariableResolver, XPathFunctionResolver xPathFunctionResolver, boolean bl) {
        this.varResolver = xPathVariableResolver;
        this.funcResolver = xPathFunctionResolver;
        this.secure = bl;
    }

    public void reset() {
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            throw new NullPointerException();
        }
        this.varResolver = xPathVariableResolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.varResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            throw new NullPointerException();
        }
        this.funcResolver = xPathFunctionResolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.funcResolver;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            throw new NullPointerException();
        }
        this.nsContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    public XPathExpression compile(String string) throws XPathExpressionException {
        if (string == null) {
            throw new NullPointerException();
        }
        XSLExprBase xSLExprBase = null;
        try {
            JXPathContext jXPathContext = null;
            jXPathContext = new JXPathContext(this.nsContext, this.secure ? null : this.funcResolver);
            xSLExprBase = XSLExprBase.createExpression(string, jXPathContext, null);
        }
        catch (Exception exception) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(exception.getMessage());
            xPathExpressionException.initCause(exception);
            throw xPathExpressionException;
        }
        return new JXPathExpression(xSLExprBase, this.varResolver, string);
    }

    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object, qName);
    }

    public String evaluate(String string, Object object) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object);
    }

    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource, qName);
    }

    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource);
    }
}

