/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.StreamingSequence;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathFilterExpr;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class PathExpr
extends XSLExprBase {
    private XSLExprBase filter;
    private boolean root = false;
    private boolean matchroot = false;
    private FastVector stepVector = new FastVector();
    private String[] anchorName = new String[2];
    int anchorType = -1;

    PathExpr(XSLParseString xSLParseString, XSLExprBase xSLExprBase) throws XSLException, XQException {
        int n = xSLParseString.peekToken();
        int n2 = 5;
        boolean bl = false;
        super.setExprType(0x2200000);
        this.filter = xSLExprBase;
        if (this.filter != null) {
            n2 = n;
            xSLParseString.nextToken();
        } else if (n == 5) {
            this.root = true;
            this.matchroot = true;
            n2 = 5;
            xSLParseString.nextToken();
            this.anchorType = 1;
            bl = true;
        } else if (n == 6) {
            this.root = true;
            n2 = 6;
            xSLParseString.nextToken();
        }
        XPathStep xPathStep = new XPathStep(xSLParseString, n2);
        if (!xPathStep.found) {
            if (!bl) {
                throw new XPathException(1013, new String(xSLParseString.getExprString()));
            }
            return;
        }
        this.stepVector.addElement(xPathStep);
        this.priority = this.filter != null || this.root ? 0.5f : xPathStep.priority;
        n = xSLParseString.peekToken();
        while (n == 5 || n == 6) {
            n2 = n;
            xSLParseString.nextToken();
            xPathStep = new XPathStep(xSLParseString, n2);
            if (!xPathStep.found) {
                throw new XPathException(1013, new String(xSLParseString.getExprString()));
            }
            this.stepVector.addElement(xPathStep);
            this.priority = 0.5f;
            n = xSLParseString.peekToken();
        }
        this.anchorType = xPathStep.getAnchorType();
        xPathStep.getAnchorName(this.anchorName);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = XPathFilterExpr.parse(xSLParseString);
        PathExpr pathExpr = null;
        if (xSLExprBase != null) {
            if (!xSLExprBase.isExprType(0xA00000)) {
                xSLExprBase.setPriority(0.5f);
                return xSLExprBase;
            }
            int n = xSLParseString.peekToken();
            if (n != 5 && n != 6) {
                return xSLExprBase;
            }
        }
        pathExpr = new PathExpr(xSLParseString, xSLExprBase);
        pathExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        return pathExpr;
    }

    public boolean isStreamable() {
        if (this.filter != null) {
            return false;
        }
        int n = this.stepVector.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i);
            if (xPathStep.prevSeparator == 6) {
                if (bl) {
                    return false;
                }
                bl = true;
            }
            if (xPathStep.axisClass.getAxisType() == 11 && i == 0 && xPathStep.predicates == null) continue;
            if (xPathStep.axisClass.getAxisType() != 3 || xPathStep.getAnchorType() != 1) {
                return false;
            }
            XPathPredicate xPathPredicate = xPathStep.predicates;
            if (xPathPredicate == null || xPathPredicate.isSimpleContext()) continue;
            return false;
        }
        return true;
    }

    public ArrayList getStepList() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.stepVector.size());
        for (int i = 0; i < this.stepVector.size(); ++i) {
            arrayList.add(this.stepVector.elementAt(i));
        }
        return arrayList;
    }

    public int getAnchorType() {
        return this.anchorType;
    }

    public void getAnchorName(String[] stringArray) {
        stringArray[0] = this.anchorName[0];
        stringArray[1] = this.anchorName[1];
    }

    public void setEvaluationHints(String string, Object object) {
        int n = this.stepVector.size();
        if (n != 0) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(n - 1);
            xPathStep.setEvaluationHints(string, object);
        }
    }

    boolean checkPosLastFN() {
        if (this.filter != null) {
            return this.filter.checkPosLastFN();
        }
        return false;
    }

    void cacheSubExpr() throws XQException {
        if (this.filter != null && this.filter.canCacheExpr()) {
            this.filter = this.filter.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.filter == null || this.filter.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filter != null) {
            stringBuffer.append(this.filter.getNormalizedExpr());
        }
        int n = this.stepVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.stepVector.elementAt(i);
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        OXMLSequence oXMLSequence = null;
        if (this.filter != null) {
            this.filter.evaluate(xPathRuntimeContext);
        } else {
            XMLNode xMLNode = xPathRuntimeContext.getContextNode();
            oXMLSequence = xPathRuntimeContext.pushExprValue();
            if (this.root) {
                XPathSequence.addNode(oXMLSequence, xPathRuntimeContext.getSrcRoot(xMLNode));
            } else {
                XPathSequence.addNode(oXMLSequence, xMLNode);
            }
        }
        int n = this.stepVector.size();
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i);
            xPathStep.evaluate(xPathRuntimeContext);
        }
        oXMLSequence = xPathRuntimeContext.peekExprValue();
        XPathSequence.makeDocOrder(oXMLSequence);
    }

    public void streamingEvaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        int n = this.stepVector.size();
        XMLNode xMLNode = xPathRuntimeContext.getContextNode();
        if (this.root) {
            xMLNode = xPathRuntimeContext.getSrcRoot(xMLNode);
        }
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.pushExprValue();
        StreamingSequence streamingSequence = null;
        StreamingSequence streamingSequence2 = null;
        streamingSequence2 = streamingSequence = new StreamingSequence(null, xPathRuntimeContext, null, xMLNode);
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i);
            if (xPathStep.axisClass.getAxisType() == 11) continue;
            streamingSequence2 = streamingSequence = new StreamingSequence(xPathStep, xPathRuntimeContext, streamingSequence2, null);
        }
        xPathSequence.streamResult = streamingSequence;
        xPathSequence.started = true;
    }

    public void setPriority(float f) throws XSLException {
        this.priority = f;
    }

    public XSLExprBase matchPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence = xSLTContext.getCurNodeList();
        OXMLSequence oXMLSequence2 = xSLTContext.getAltNodeList();
        XMLNode xMLNode2 = xMLNode;
        int n = this.stepVector.size();
        if (n > 0 && xMLNode == xSLTContext.getSrcRoot(xMLNode)) {
            return null;
        }
        oXMLSequence.reset();
        for (int i = n - 1; i >= 0; --i) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i);
            oXMLSequence2.reset();
            if (xMLNode2 != null) {
                xMLNode2 = xPathStep.matchPattern(xSLTContext, xMLNode2, oXMLSequence2);
            } else if (oXMLSequence.getItemOccurrence() != 0) {
                xMLNode2 = xPathStep.matchPattern(xSLTContext, oXMLSequence, oXMLSequence2);
            } else {
                return null;
            }
            if (xMLNode2 != null) continue;
            OXMLSequence oXMLSequence3 = oXMLSequence;
            oXMLSequence = oXMLSequence2;
            oXMLSequence2 = oXMLSequence3;
        }
        if (this.matchroot) {
            XMLElement xMLElement = xSLTContext.getSrcRoot(xMLNode);
            if (xMLNode2 != null) {
                if (xMLNode2 == xMLElement) {
                    return this;
                }
                return null;
            }
            if (XPathSequence.contains(oXMLSequence, xMLElement)) {
                return this;
            }
        } else {
            if (this.filter != null) {
                if (xMLNode2 != null) {
                    XPathSequence.addNode(oXMLSequence, xMLNode2);
                }
                if (this.filter.matchNodeList(xMLNode, oXMLSequence, xSLTContext)) {
                    return this;
                }
                return null;
            }
            if (xMLNode2 != null || oXMLSequence.getItemOccurrence() != 0) {
                return this;
            }
        }
        return null;
    }
}

