/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.net.URL;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.scalable.PageManagerPool;
import oracle.xml.xpath.XPathContext;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNamespace;
import oracle.xml.xslt.XSLSourceContext;

public class XPathRuntimeContext
extends XSLTContext
implements OXMLFunctionContext,
XSLConstants {
    protected boolean debug = false;
    private boolean isDebugMode = false;
    private boolean streaming = true;
    private XPathItem firstFreeItem;
    private XPathItem lastFreeItem;
    protected XMLNode contextNode;
    protected XMLNode currentNode;
    protected int contextSize;
    protected int contextPos;
    protected GregorianCalendar contextDateTime;
    protected static TimeZone contextTimeZone = TimeZone.getDefault();
    protected XPathContext jxContext;
    protected XPathSequence[] varValues;
    protected int varValuesIndex;
    private URL baseUrl;
    private Hashtable sourceContext = new Hashtable(20);
    private int numSourceContext;
    private XSLSourceContext onlySourceContext;
    private XMLElement onlySrcRoot;
    private int stacksize = 128;
    protected OXMLSequence[] valueStack = new XPathSequence[this.stacksize];
    protected int valueStackIndex;
    private XPathVariableResolver varResolver;
    private URIResolver uriResolver;
    protected int version;
    protected boolean bkwdCompFlag;
    protected boolean fwdCompFlag;
    protected String defaultcollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Hashtable nsTable;
    private OXMLSequence curNodeList;
    private OXMLSequence altNodeList;

    public XPathRuntimeContext() {
        for (int i = 0; i < this.stacksize; ++i) {
            this.valueStack[i] = new XPathSequence(this);
        }
        this.valueStackIndex = -1;
        this.varValuesIndex = 0;
        this.baseUrl = null;
        this.firstFreeItem = this.lastFreeItem = new XPathItem();
    }

    public XMLNode getContextNode() throws XSLException {
        return this.contextNode;
    }

    public XMLNode getJDWPContextNode() throws XSLException {
        return this.contextNode;
    }

    XPathContext getXPathContext() {
        return this.jxContext;
    }

    void setXPathContext(XPathContext xPathContext) {
        this.jxContext = xPathContext;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public int getContextPosition() {
        return this.contextPos;
    }

    public void setVarResolver(XPathVariableResolver xPathVariableResolver) {
        this.varResolver = xPathVariableResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    Object getVariable(NSName nSName) {
        if (this.varResolver != null) {
            return this.varResolver.resolveVariable(new QName(nSName.getNamespace(), nSName.getLocalName()));
        }
        return null;
    }

    public OXMLSequence getVariable(NSName nSName, int n) {
        if (n >= 0) {
            return this.varValues[this.varValuesIndex - n];
        }
        return null;
    }

    public OXMLSequence getCurNodeList() {
        if (this.curNodeList == null) {
            this.curNodeList = new XPathSequence(this);
        }
        return this.curNodeList;
    }

    public OXMLSequence getAltNodeList() {
        if (this.altNodeList == null) {
            this.altNodeList = new XPathSequence(this);
        }
        return this.altNodeList;
    }

    public OXMLSequence createSequence() {
        return new XPathSequence(this);
    }

    public OXMLItem createItem() {
        return this.allocItem();
    }

    public String getDBCharSet() {
        return null;
    }

    public String getBaseURI() {
        if (this.baseUrl == null) {
            return null;
        }
        return this.baseUrl.toString();
    }

    public String getDefaultCollation() {
        return this.defaultcollation;
    }

    public void setDefaultCollation(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            this.defaultcollation = string;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f");
        if (stringTokenizer.hasMoreTokens()) {
            String string2;
            this.defaultcollation = string2 = stringTokenizer.nextToken();
            return;
        }
    }

    public String getInScopeNamespace(String string) {
        return null;
    }

    public GregorianCalendar getDateTime() {
        if (this.contextDateTime == null) {
            this.contextDateTime = new GregorianCalendar(contextTimeZone);
        }
        return this.contextDateTime;
    }

    public TimeZone getImplicitTimezone() {
        return contextTimeZone;
    }

    public OXMLItem getContextItem() {
        if (this.contextNode == null) {
            return null;
        }
        XPathItem xPathItem = this.allocItem();
        xPathItem.setNode(this.contextNode);
        return xPathItem;
    }

    public void attachExternalObject(Object object) {
    }

    public Object retrieveExternalObject() {
        return null;
    }

    public void init() {
        this.sourceContext.clear();
        this.varValuesIndex = 0;
        this.valueStackIndex = -1;
        this.nsTable = null;
    }

    public void reset() {
        try {
            for (int i = 0; i < this.stacksize; ++i) {
                this.valueStack[i].reset();
            }
        }
        catch (XQException xQException) {
            // empty catch block
        }
        XPathItem xPathItem = this.firstFreeItem;
        while (xPathItem != null && xPathItem != this.lastFreeItem) {
            xPathItem.reset();
            xPathItem = xPathItem.nextItem;
        }
        this.currentNode = null;
        this.contextNode = null;
        this.streaming = true;
        this.onlySourceContext = null;
        this.onlySrcRoot = null;
        this.curNodeList = null;
        this.altNodeList = null;
        this.numSourceContext = 0;
        this.init();
    }

    public OXMLSequence peekExprValue() {
        return this.valueStack[this.valueStackIndex];
    }

    public OXMLSequence peekExprValue(int n) {
        return this.valueStack[this.valueStackIndex - n];
    }

    public OXMLSequence popExprValue() {
        return this.valueStack[this.valueStackIndex--];
    }

    public void popExprValue(int n) {
        this.valueStackIndex -= n;
    }

    public OXMLSequence pushExprValue() {
        if (this.stacksize == ++this.valueStackIndex) {
            this.enlargevalueStackSize();
        }
        OXMLSequence oXMLSequence = this.valueStack[this.valueStackIndex];
        try {
            oXMLSequence.reset();
        }
        catch (XQException xQException) {
            // empty catch block
        }
        return oXMLSequence;
    }

    public void pushExprValue(OXMLSequence oXMLSequence) {
        ++this.valueStackIndex;
        if (this.stacksize == this.valueStackIndex) {
            this.enlargevalueStackSize();
        }
        try {
            this.valueStack[this.valueStackIndex].reset();
        }
        catch (XQException xQException) {
            // empty catch block
        }
        this.valueStack[this.valueStackIndex] = oXMLSequence;
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(URL uRL) {
        this.baseUrl = uRL;
    }

    protected XMLElement getSrcRoot(XMLNode xMLNode) throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySrcRoot;
        }
        return xMLNode.getSrcRoot();
    }

    protected XMLElement getSrcRoot() throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySrcRoot;
        }
        return this.contextNode.getSrcRoot();
    }

    public XSLSourceContext getSrcContext(XMLNode xMLNode) throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySourceContext;
        }
        XMLElement xMLElement = xMLNode.getSrcRoot();
        if (xMLElement == null) {
            return null;
        }
        XSLSourceContext xSLSourceContext = (XSLSourceContext)this.sourceContext.get(xMLElement);
        if (xSLSourceContext != null) {
            return xSLSourceContext;
        }
        XMLDocument xMLDocument = xMLElement.getNodeType() == 9 ? (XMLDocument)xMLElement : (XMLDocument)xMLElement.getOwnerDocument();
        this.addSourceContext(xMLElement, xMLDocument);
        return (XSLSourceContext)this.sourceContext.get(xMLElement);
    }

    public void addSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) throws XSLException {
        XSLSourceContext xSLSourceContext = new XSLSourceContext(xMLElement, xMLDocument);
        if (this.numSourceContext == 0) {
            this.onlySourceContext = xSLSourceContext;
            this.onlySrcRoot = xMLElement;
        }
        ++this.numSourceContext;
        this.sourceContext.put(xMLElement, xSLSourceContext);
    }

    public void setContextNode(XMLNode xMLNode) {
        this.contextNode = xMLNode;
    }

    public int setContextSize(int n) {
        int n2 = this.contextSize;
        this.contextSize = n;
        return n2;
    }

    public void setContextPosition(int n) {
        this.contextPos = n;
    }

    public void setCurrentNode(XMLNode xMLNode) {
        this.currentNode = xMLNode;
    }

    public XMLNode getCurrentNode() {
        return this.currentNode;
    }

    public void pushVariable(OXMLSequence oXMLSequence) {
        if (this.varValues == null) {
            this.varValues = new XPathSequence[256];
        }
        if (this.varValuesIndex == this.varValues.length) {
            XPathSequence[] xPathSequenceArray = new XPathSequence[this.varValues.length * 2];
            System.arraycopy(this.varValues, 0, xPathSequenceArray, 0, this.varValues.length);
            this.varValues = xPathSequenceArray;
        }
        this.varValues[this.varValuesIndex++] = (XPathSequence)oXMLSequence;
    }

    public void popVariable(int n) {
        this.varValuesIndex -= n;
    }

    public XMLNode[] getNSNodes(XMLElement xMLElement) {
        XSLNamespace xSLNamespace;
        XMLNode[] xMLNodeArray;
        if (this.nsTable == null) {
            this.nsTable = new Hashtable(20);
        }
        if ((xMLNodeArray = (XSLNamespace[])this.nsTable.get(xMLElement)) != null) {
            return xMLNodeArray;
        }
        String string = xMLElement.resolveNamespacePrefix("#default");
        Hashtable hashtable = xMLElement.getAllNamespaceAttrs();
        XMLDocument xMLDocument = xMLElement.getDocument();
        int n = hashtable.size() + 1;
        long l = xMLElement.getDocOrderId() + 1 << 32;
        int n2 = 0;
        if (string != null) {
            xMLNodeArray = new XSLNamespace[n + 1];
            xSLNamespace = new XSLNamespace(xMLDocument);
            xSLNamespace.init("", string, xMLElement);
            xSLNamespace.setNodeId(l);
            xMLNodeArray[n2++] = xSLNamespace;
        } else {
            xMLNodeArray = new XSLNamespace[n];
        }
        xSLNamespace = new XSLNamespace(xMLDocument);
        xSLNamespace.init("xml", "http://www.w3.org/XML/1998/namespace", xMLElement);
        xSLNamespace.setNodeId(l);
        xMLNodeArray[n2++] = xSLNamespace;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                xSLNamespace = new XSLNamespace(xMLDocument);
                xSLNamespace.init(string2, string3, xMLElement);
                xSLNamespace.setNodeId(l);
                xMLNodeArray[n2++] = xSLNamespace;
            }
        }
        this.nsTable.put(xMLElement, xMLNodeArray);
        return xMLNodeArray;
    }

    public XPathItem allocItem() {
        if (this.firstFreeItem == this.lastFreeItem) {
            XPathItem xPathItem = new XPathItem();
            xPathItem.setContext(this);
            xPathItem.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
            return xPathItem;
        }
        XPathItem xPathItem = this.firstFreeItem;
        xPathItem.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
        this.firstFreeItem = this.firstFreeItem.nextItem;
        xPathItem.nextItem = null;
        xPathItem.prevItem = null;
        return xPathItem;
    }

    public void freeItem(XPathItem xPathItem) {
        this.lastFreeItem.nextItem = xPathItem;
        this.lastFreeItem = xPathItem;
    }

    public void freeItem(XPathItem xPathItem, XPathItem xPathItem2) {
        this.lastFreeItem.nextItem = xPathItem;
        this.lastFreeItem = xPathItem2;
    }

    private void enlargevalueStackSize() {
        int n = this.stacksize * 2;
        XPathSequence[] xPathSequenceArray = new XPathSequence[n];
        for (int i = 0; i < n; ++i) {
            xPathSequenceArray[i] = new XPathSequence(this);
        }
        System.arraycopy(this.valueStack, 0, xPathSequenceArray, 0, this.stacksize);
        this.valueStack = xPathSequenceArray;
        this.stacksize = n;
    }

    public void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    public void setStreaming(boolean bl) {
        this.streaming = this.isDebugMode ? false : bl;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public PageManagerPool getPageManagerPool() {
        return null;
    }

    public boolean isInDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean bl) {
        this.isDebugMode = bl;
        if (bl) {
            this.streaming = false;
        }
    }
}

