/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import org.apache.commons.math.linear.RealMatrixImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadraticFitter
implements CurveFitter {
    private static QuadraticFitter a;

    private QuadraticFitter() {
    }

    public static QuadraticFitter getInstance() {
        QuadraticFitter quadraticFitter = a;
        if (Polynomial.b == 0) {
            if (quadraticFitter == null) {
                a = new QuadraticFitter();
            }
            quadraticFitter = a;
        }
        return quadraticFitter;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        int n2;
        int n3;
        block6: {
            int n4;
            block5: {
                n3 = Polynomial.b;
                n2 = chartModel.getPointCount();
                n4 = b;
                if (n3 != 0) break block5;
                if (n4 != 0) break block6;
                n4 = n2;
            }
            if (n4 <= 0) {
                throw new AssertionError((Object)"Can't perform a regression on a model containing no points!");
            }
        }
        double d2 = this.a(chartModel, 1, 0);
        double d3 = this.a(chartModel, 2, 0);
        double d4 = this.a(chartModel, 3, 0);
        double d5 = this.a(chartModel, 4, 0);
        double d6 = this.a(chartModel, 0, 1);
        double d7 = this.a(chartModel, 1, 1);
        double d8 = this.a(chartModel, 2, 1);
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl((double[][])new double[][]{{n2, d2, d3}, {d2, d3, d4}, {d3, d4, d5}});
        double[] dArray = new double[]{d6, d7, d8};
        double[] dArray2 = realMatrixImpl.solve(dArray);
        Polynomial polynomial = new Polynomial(dArray2);
        if (n3 != 0) {
            int n5 = Chart.Ib;
            Chart.Ib = ++n5;
        }
        return polynomial;
    }

    @Override
    public DefaultChartModel createModel(Polynomial polynomial, Range<?> range, int n2) {
        return this.createModel((String)null, polynomial, (Range)range, n2);
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n2 = Polynomial.b;
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            for (int i2 = 0; i2 < doubleArray.length; ++i2) {
                double d2 = doubleArray[i2];
                double d3 = polynomial.eval(d2);
                defaultChartModel = defaultChartModel2.addPoint(d2, d3);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    @Override
    public DefaultChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n2) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n3 = Polynomial.b;
            double d2 = range.minimum();
            double d3 = range.maximum();
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            double d4 = (d3 - d2) / (double)(n2 - 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d5 = d2 + (double)i2 * d4;
                double d6 = polynomial.eval(d5);
                defaultChartModel = defaultChartModel2.addPoint(d5, d6);
                if (n3 == 0) {
                    if (n3 == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n2) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, (Range)range, n2);
    }

    private double a(ChartModel chartModel, int n2, int n3) {
        double d2;
        block2: {
            int n4 = Polynomial.b;
            double d3 = 0.0;
            for (Chartable chartable : chartModel) {
                d2 = d3 + Math.pow(chartable.getX().position(), n2) * Math.pow(chartable.getY().position(), n3);
                if (n4 == 0) {
                    d3 = d2;
                    if (n4 == 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }
}

