/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphanumComparator
implements Comparator<CharSequence> {
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("Alphanum");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("Alphanum_Ignorecase");

    public AlphanumComparator() {
        this(true);
    }

    public AlphanumComparator(boolean bl) {
        this._caseSensitive = bl;
    }

    private boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private String getChunk(CharSequence charSequence, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = charSequence.charAt(n3);
        stringBuilder.append(c2);
        ++n3;
        if (this.isDigit(c2)) {
            while (n3 < n2 && this.isDigit(c2 = charSequence.charAt(n3))) {
                stringBuilder.append(c2);
                ++n3;
            }
        } else {
            while (n3 < n2 && !this.isDigit(c2 = charSequence.charAt(n3))) {
                stringBuilder.append(c2);
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int compare(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        while (n2 < n4 && n3 < n5) {
            int n6;
            String string = this.getChunk(charSequence, n4, n2);
            n2 += string.length();
            String string2 = this.getChunk(charSequence2, n5, n3);
            n3 += string2.length();
            if (this.isDigit(string.charAt(0)) && this.isDigit(string2.charAt(0))) {
                int n7 = string.length();
                n6 = n7 - string2.length();
                if (n6 == 0) {
                    for (int i2 = 0; i2 < n7; ++i2) {
                        n6 = string.charAt(i2) - string2.charAt(i2);
                        if (n6 == 0) continue;
                        return n6;
                    }
                }
            } else {
                int n8 = n6 = this.isCaseSensitive() ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
            }
            if (n6 == 0) continue;
            return n6;
        }
        return n4 - n5;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }
}

