/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.DialogPageListCellRenderer;
import com.jidesoft.dialog.DialogPageTreeCellRenderer;
import com.jidesoft.dialog.MutableTreeNodeEx;
import com.jidesoft.dialog.PageList;
import com.jidesoft.dialog.ScrollableButtonPanel;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MultiplePageDialogPane
extends StandardDialogPane {
    private static final long serialVersionUID = -8968638943947885121L;
    public static final int TAB_STYLE = 0;
    public static final int TREE_STYLE = 1;
    public static final int LIST_STYLE = 2;
    public static final int ICON_STYLE = 3;
    private int _style;
    private PageList _pageList;
    private JComponent _indexPanel;
    private JComponent _pagesPanel;
    private CardLayout _cardLayout;
    private Map<String, MutableTreeNode> _titleNodeMap;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _applyButton;
    private AbstractAction _okAction;
    private AbstractAction _cancelAction;
    private TreeCellRenderer _treeCellRenderer;
    private ListCellRenderer _listCellRenderer;
    private JTabbedPane _tabbedPane;
    private String _initialPageTitle;
    public JTree _tree;

    public MultiplePageDialogPane() throws HeadlessException {
        this(0);
    }

    public MultiplePageDialogPane(int n2) {
        this.setStyle(n2);
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public JComponent createContentPanel() {
        this._indexPanel = this.createIndexPanel();
        this._pagesPanel = this.createPagesPanel();
        if (this._pageList.getPageCount() > 0) {
            if (this.getInitialPageTitle() != null) {
                this.setCurrentPage(this.getInitialPageTitle());
            } else {
                this.setCurrentPage(this._pageList.getPage(0));
            }
        }
        return this.setupContentPanel(this._indexPanel, this._pagesPanel);
    }

    protected JComponent setupContentPanel(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (jComponent != null) {
            jPanel.add((Component)jComponent, "Before");
        }
        if (jComponent2 != null) {
            jPanel.add((Component)jComponent2, "Center");
        }
        return jPanel;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        Locale locale = this.getLocale();
        this._okButton = new JButton(JideSwingUtilities.getOKString(locale));
        this._cancelButton = new JButton(JideSwingUtilities.getCancelString(locale));
        this._applyButton = new JButton();
        this._okButton.setName("OK");
        this._cancelButton.setName("CANCEL");
        this._applyButton.setName("APPLY");
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        buttonPanel.addButton((AbstractButton)this._applyButton, "ALTERNATIVE");
        this._okButton.setAction(this.getOKAction());
        this._cancelButton.setAction(this.getCancelAction());
        this._applyButton.setAction(new AbstractAction(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply")){
            private static final long serialVersionUID = 3413994234663396927L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (MultiplePageDialogPane.this.getCurrentPage() != null) {
                    MultiplePageDialogPane.this.getCurrentPage().fireButtonEvent(3302, "APPLY");
                }
            }
        });
        this._applyButton.setMnemonic(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply.mnemonic").charAt(0));
        this._applyButton.setEnabled(false);
        this.setDefaultCancelAction(this._cancelButton.getAction());
        this.setDefaultAction(this._okButton.getAction());
        return buttonPanel;
    }

    public JButton getOkButton() {
        return this._okButton;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JButton getApplyButton() {
        return this._applyButton;
    }

    public void setCancelAction(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._cancelAction = abstractAction;
        this.setDefaultCancelAction(abstractAction);
        if (this._cancelButton != null) {
            this._cancelButton.setAction(abstractAction);
        }
    }

    public AbstractAction getCancelAction() {
        return this._cancelAction;
    }

    public void setOKAction(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._okAction = abstractAction;
        this.setDefaultAction(abstractAction);
        if (this._okAction != null) {
            this._okButton.setAction(abstractAction);
        }
    }

    public AbstractAction getOKAction() {
        return this._okAction;
    }

    protected JComponent createPagesPanel() {
        if (this._style == 0) {
            this._tabbedPane = this.createTabbedPane();
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Component component = MultiplePageDialogPane.this._tabbedPane.getSelectedComponent();
                    if (component instanceof AbstractDialogPage) {
                        MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)component, MultiplePageDialogPane.this._tabbedPane);
                    }
                }
            });
            int n2 = 0;
            while (n2 < this._pageList.getPageCount()) {
                AbstractDialogPage abstractDialogPage = this._pageList.getPage(n2);
                abstractDialogPage.addButtonListener(this.getButtonPanel());
                this._tabbedPane.addTab(abstractDialogPage.getTitle(), abstractDialogPage.getIcon(), abstractDialogPage, abstractDialogPage.getDescription());
                this._tabbedPane.setEnabledAt(n2, abstractDialogPage.isPageEnabled());
                final int n3 = n2++;
                abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setEnabledAt(n3, Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setIconAt(n3, (Icon)propertyChangeEvent.getNewValue());
                        } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setTitleAt(n3, (String)propertyChangeEvent.getNewValue());
                        } else if ("description".equals(propertyChangeEvent.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setToolTipTextAt(n3, (String)propertyChangeEvent.getNewValue());
                        }
                    }
                });
            }
            this._pageList.addListDataListener(new ListDataListener(){

                public void intervalAdded(ListDataEvent listDataEvent) {
                    for (int i2 = listDataEvent.getIndex0(); i2 <= listDataEvent.getIndex1(); ++i2) {
                        AbstractDialogPage abstractDialogPage = MultiplePageDialogPane.this._pageList.getPage(i2);
                        MultiplePageDialogPane.this._tabbedPane.insertTab(abstractDialogPage.getTitle(), abstractDialogPage.getIcon(), abstractDialogPage, abstractDialogPage.getDescription(), i2);
                    }
                }

                public void intervalRemoved(ListDataEvent listDataEvent) {
                    for (int i2 = listDataEvent.getIndex1(); i2 >= listDataEvent.getIndex0(); --i2) {
                        MultiplePageDialogPane.this._tabbedPane.removeTabAt(i2);
                    }
                }

                public void contentsChanged(ListDataEvent listDataEvent) {
                }
            });
            return this._tabbedPane;
        }
        final JPanel jPanel = new JPanel();
        this._cardLayout = new CardLayout();
        jPanel.setLayout(this._cardLayout);
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            AbstractDialogPage abstractDialogPage = this._pageList.getPage(i2);
            abstractDialogPage.addButtonListener(this.getButtonPanel());
            abstractDialogPage.setName(abstractDialogPage.getFullTitle());
            abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("title".equals(propertyChangeEvent.getPropertyName())) {
                        for (int i2 = 0; i2 < jPanel.getComponentCount(); ++i2) {
                            Component component = jPanel.getComponent(i2);
                            Object object = propertyChangeEvent.getSource();
                            if (!(object instanceof AbstractDialogPage) || component != object) continue;
                            jPanel.remove(i2);
                            String string = ((AbstractDialogPage)object).getFullTitle();
                            jPanel.add((AbstractDialogPage)object, string, i2);
                            ((AbstractDialogPage)object).setName(string);
                            MultiplePageDialogPane.this.getIndexPanel().repaint();
                            break;
                        }
                    }
                }
            });
            jPanel.add((Component)abstractDialogPage, abstractDialogPage.getFullTitle());
        }
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex0(); i2 <= listDataEvent.getIndex1(); ++i2) {
                    AbstractDialogPage abstractDialogPage = MultiplePageDialogPane.this._pageList.getPage(i2);
                    abstractDialogPage.setName(abstractDialogPage.getFullTitle());
                    jPanel.add(abstractDialogPage, abstractDialogPage.getFullTitle(), i2);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex1(); i2 >= listDataEvent.getIndex0(); --i2) {
                    jPanel.remove(i2);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                Object object;
                if (listDataEvent.getSource() instanceof PageList && (object = ((PageList)listDataEvent.getSource()).getSelectedItem()) instanceof AbstractDialogPage && ((AbstractDialogPage)object).isPageEnabled()) {
                    MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)object);
                }
            }
        });
        return jPanel;
    }

    protected JTabbedPane createTabbedPane() {
        return new JTabbedPane(1);
    }

    public JComponent createIndexPanel() {
        switch (this._style) {
            case 3: {
                return this.createIconPanel();
            }
            case 2: {
                return this.createListPanel();
            }
            case 1: {
                return this.createTreePanel();
            }
        }
        return null;
    }

    public void setPageList(PageList pageList) {
        this._pageList = pageList;
    }

    public PageList getPageList() {
        return this._pageList;
    }

    public AbstractDialogPage getCurrentPage() {
        return this._pageList.getCurrentPage();
    }

    protected void setCurrentPage(String string) {
        if (this._pageList != null) {
            this.setCurrentPage(this._pageList.getPageByFullTitle(string));
        }
    }

    protected void setCurrentPage(AbstractDialogPage abstractDialogPage) {
        this.setCurrentPage(abstractDialogPage, null);
    }

    protected void setCurrentPage(AbstractDialogPage abstractDialogPage, Object object) {
        if (!this._pageList.setCurrentPage(abstractDialogPage, object)) {
            return;
        }
        if (abstractDialogPage != null) {
            this.showCurrentPage(abstractDialogPage);
        }
    }

    protected void showCurrentPage(AbstractDialogPage abstractDialogPage) {
        if (abstractDialogPage != null) {
            if (this.getStyle() == 0) {
                this._tabbedPane.setSelectedComponent(abstractDialogPage);
            } else {
                this._cardLayout.show(this._pagesPanel, abstractDialogPage.getFullTitle());
            }
            abstractDialogPage.focusDefaultFocusComponent();
        }
    }

    protected MutableTreeNode createTreeNode(AbstractDialogPage abstractDialogPage) {
        return new MutableTreeNodeEx(abstractDialogPage);
    }

    private JComponent createTreePanel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("", true);
        this._titleNodeMap = new HashMap<String, MutableTreeNode>((int)((double)this._pageList.getPageCount() * 0.75));
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            AbstractDialogPage abstractDialogPage = this._pageList.getPage(i2);
            this.addPage(abstractDialogPage, defaultMutableTreeNode, false);
        }
        this._tree = this.createTree(defaultMutableTreeNode);
        this.configureTree(this._tree);
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex0(); i2 <= listDataEvent.getIndex1(); ++i2) {
                    AbstractDialogPage abstractDialogPage = MultiplePageDialogPane.this._pageList.getPage(i2);
                    MultiplePageDialogPane.this.addPage(abstractDialogPage, (DefaultMutableTreeNode)MultiplePageDialogPane.this._tree.getModel().getRoot(), true);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                Set set = MultiplePageDialogPane.this._titleNodeMap.keySet();
                Vector<String> vector = new Vector<String>();
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    String string;
                    String string2 = string = (String)iterator.next();
                    if (MultiplePageDialogPane.this._pageList.getPageByFullTitle(string2) != null || (defaultMutableTreeNode = (DefaultMutableTreeNode)MultiplePageDialogPane.this._titleNodeMap.get(string2)) == null) continue;
                    vector.add(string2);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2 == null) continue;
                    int n2 = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    ((DefaultTreeModel)MultiplePageDialogPane.this._tree.getModel()).nodesWereRemoved(defaultMutableTreeNode2, new int[]{n2}, new Object[]{defaultMutableTreeNode});
                }
                for (String string : vector) {
                    MultiplePageDialogPane.this._titleNodeMap.remove(string);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                TreeNode treeNode;
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1 && listDataEvent.getType() == 0 && MultiplePageDialogPane.this._titleNodeMap != null && MultiplePageDialogPane.this._pageList.getCurrentPage() != null && (treeNode = (TreeNode)MultiplePageDialogPane.this._titleNodeMap.get(MultiplePageDialogPane.this._pageList.getCurrentPage().getFullTitle())) != null) {
                    ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
                    while (treeNode != null) {
                        arrayList.add(0, treeNode);
                        treeNode = treeNode.getParent();
                    }
                    TreePath treePath = new TreePath(arrayList.toArray(new TreeNode[arrayList.size()]));
                    MultiplePageDialogPane.this._tree.getSelectionModel().setSelectionPath(treePath);
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this._tree), "Center");
        return jPanel;
    }

    protected JTree createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        UIManager.put("Tree.hash", Color.white);
        return new JTree(defaultMutableTreeNode);
    }

    protected void configureTree(final JTree jTree) {
        jTree.setToggleClickCount(1);
        jTree.setCellRenderer(this.createTreeCellRenderer());
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(false);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                if (jTree.getSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getSelectionPath().getLastPathComponent();
                while (!defaultMutableTreeNode.isLeaf()) {
                    object = defaultMutableTreeNode;
                    Runnable runnable = new Runnable((DefaultMutableTreeNode)object){
                        final /* synthetic */ DefaultMutableTreeNode val$tn;
                        {
                            this.val$tn = defaultMutableTreeNode;
                        }

                        public void run() {
                            jTree.expandPath(new TreePath(this.val$tn.getPath()));
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                }
                object = defaultMutableTreeNode.getUserObject();
                if (object instanceof AbstractDialogPage && !object.equals(MultiplePageDialogPane.this.getCurrentPage()) && ((AbstractDialogPage)object).isPageEnabled()) {
                    MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)object, jTree);
                    if (MultiplePageDialogPane.this.getCurrentPage() != object) {
                        // empty if block
                    }
                }
            }
        });
    }

    private void addPage(final AbstractDialogPage abstractDialogPage, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (abstractDialogPage == null) {
            return;
        }
        final MutableTreeNode mutableTreeNode = this.createTreeNode(abstractDialogPage);
        if (mutableTreeNode instanceof MutableTreeNodeEx) {
            ((MutableTreeNodeEx)mutableTreeNode).setEnabled(abstractDialogPage.isPageEnabled());
        }
        if (abstractDialogPage.getParentPage() == null) {
            this._titleNodeMap.put(abstractDialogPage.getFullTitle(), mutableTreeNode);
            defaultMutableTreeNode.add(mutableTreeNode);
            if (bl) {
                ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getIndex(mutableTreeNode)});
            }
        } else {
            this._titleNodeMap.put(abstractDialogPage.getFullTitle(), mutableTreeNode);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this._titleNodeMap.get(abstractDialogPage.getParentPage().getFullTitle());
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode2.add(mutableTreeNode);
                if (bl) {
                    ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(defaultMutableTreeNode2, new int[]{defaultMutableTreeNode2.getIndex(mutableTreeNode)});
                }
            }
        }
        abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("icon".equals(propertyChangeEvent.getPropertyName()) && mutableTreeNode instanceof MutableTreeNodeEx) {
                    ((MutableTreeNodeEx)mutableTreeNode).setEnabled(abstractDialogPage.isPageEnabled());
                }
            }
        });
    }

    private JComponent createListPanel() {
        JPanel jPanel;
        final DefaultListModel<AbstractDialogPage> defaultListModel = new DefaultListModel<AbstractDialogPage>();
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            jPanel = this._pageList.getPage(i2);
            defaultListModel.addElement((AbstractDialogPage)jPanel);
        }
        final JList jList = this.createList(defaultListModel);
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(0);
        }
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList.getSelectedValue() == MultiplePageDialogPane.this.getCurrentPage()) {
                    return;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AbstractDialogPage abstractDialogPage = (AbstractDialogPage)jList.getSelectedValue();
                    if (abstractDialogPage != null) {
                        MultiplePageDialogPane.this.setCurrentPage(abstractDialogPage, jList);
                        if (MultiplePageDialogPane.this.getCurrentPage() != abstractDialogPage) {
                            jList.setSelectedValue(MultiplePageDialogPane.this.getCurrentPage(), true);
                        }
                    } else {
                        jList.setSelectedIndex(listSelectionEvent.getLastIndex());
                    }
                }
            }
        });
        jList.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 10));
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex0(); i2 <= listDataEvent.getIndex1(); ++i2) {
                    AbstractDialogPage abstractDialogPage = MultiplePageDialogPane.this._pageList.getPage(i2);
                    defaultListModel.add(i2, abstractDialogPage);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex1(); i2 >= listDataEvent.getIndex0(); --i2) {
                    defaultListModel.remove(i2);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1 && listDataEvent.getType() == 0) {
                    int n2 = MultiplePageDialogPane.this._pageList.getPageIndexByFullTitle(MultiplePageDialogPane.this._pageList.getCurrentPage().getFullTitle());
                    jList.setSelectedIndex(n2);
                }
            }
        });
        jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)new JideScrollPane(jList), "Center");
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected JList createList(DefaultListModel defaultListModel) {
        JList jList = new JList(defaultListModel);
        jList.setCellRenderer(this.createListCellRenderer());
        return jList;
    }

    protected JComponent createIconPanel() {
        final ButtonPanel buttonPanel = this.createIconButtonPanel();
        buttonPanel.setGroupGap(0);
        buttonPanel.setButtonGap(0);
        final ButtonGroup buttonGroup = new ButtonGroup();
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            final AbstractDialogPage abstractDialogPage = this._pageList.getPage(i2);
            final JideButton jideButton = this.createIconButton(abstractDialogPage.getTitle(), abstractDialogPage.getIcon());
            jideButton.setToolTipText(abstractDialogPage.getDescription());
            jideButton.setEnabled(abstractDialogPage.isPageEnabled());
            jideButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8913013217983540816L;

                public void actionPerformed(ActionEvent actionEvent) {
                    MultiplePageDialogPane.this.setCurrentPage(abstractDialogPage, buttonPanel);
                    if (MultiplePageDialogPane.this.getCurrentPage() == abstractDialogPage) {
                        buttonGroup.setSelected(jideButton.getModel(), true);
                    }
                }
            });
            abstractDialogPage.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setEnabled(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                    } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setIcon((Icon)propertyChangeEvent.getNewValue());
                    } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setText((String)propertyChangeEvent.getNewValue());
                    } else if ("description".equals(propertyChangeEvent.getPropertyName())) {
                        jideButton.setToolTipText((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
            buttonPanel.addButton(jideButton);
            buttonGroup.add(jideButton);
            if (i2 != 0) continue;
            buttonGroup.setSelected(jideButton.getModel(), true);
        }
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(buttonPanel){
            private static final long serialVersionUID = 7258489670834946958L;

            public Dimension getPreferredSize() {
                if (buttonPanel.getAlignment() == 1 || buttonPanel.getAlignment() == 3) {
                    return new Dimension(buttonPanel.getPreferredSize().width + this.getVerticalScrollBar().getPreferredSize().width, 5);
                }
                return new Dimension(5, buttonPanel.getPreferredSize().height + this.getHorizontalScrollBar().getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jScrollPane.setHorizontalScrollBarPolicy(31);
        buttonPanel.setOpaque(false);
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex0(); i2 <= listDataEvent.getIndex1(); ++i2) {
                    MultiplePageDialogPane.this.addPage(i2, buttonGroup, buttonPanel);
                }
                buttonPanel.invalidate();
                buttonPanel.doLayout();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                for (int i2 = listDataEvent.getIndex1(); i2 >= listDataEvent.getIndex0(); --i2) {
                    AbstractButton abstractButton = (AbstractButton)buttonPanel.getComponent(i2);
                    buttonPanel.remove(abstractButton);
                    buttonGroup.remove(abstractButton);
                }
                buttonPanel.invalidate();
                buttonPanel.doLayout();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                AbstractButton abstractButton;
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1 && listDataEvent.getType() == 0 && (abstractButton = (AbstractButton)buttonPanel.getButtonByName(MultiplePageDialogPane.this._pageList.getCurrentPage().getTitle())) != null) {
                    buttonGroup.setSelected(abstractButton.getModel(), true);
                }
            }
        });
        jScrollPane.getViewport().setOpaque(false);
        return jScrollPane;
    }

    protected ButtonPanel createIconButtonPanel() {
        return new ScrollableButtonPanel(1, 0);
    }

    private JideButton addPage(int n2, final ButtonGroup buttonGroup, final ButtonPanel buttonPanel) {
        AbstractDialogPage abstractDialogPage = this._pageList.getPage(n2);
        final JideButton jideButton = this.createIconButton(abstractDialogPage.getTitle(), abstractDialogPage.getIcon());
        jideButton.addActionListener(new AbstractAction(abstractDialogPage.getTitle(), abstractDialogPage.getIcon()){
            private static final long serialVersionUID = -2375074433514421417L;

            public void actionPerformed(ActionEvent actionEvent) {
                buttonGroup.setSelected(jideButton.getModel(), true);
                MultiplePageDialogPane.this.setCurrentPage(MultiplePageDialogPane.this._pageList.getPageByFullTitle(actionEvent.getActionCommand()), buttonPanel);
            }
        });
        buttonPanel.addButton((AbstractButton)jideButton, n2);
        buttonGroup.add(jideButton);
        return jideButton;
    }

    protected JideButton createIconButton(String string, Icon icon) {
        JideButton jideButton = new JideButton(string, icon);
        jideButton.setName(string);
        jideButton.setHorizontalAlignment(0);
        jideButton.setVerticalTextPosition(3);
        jideButton.setHorizontalTextPosition(0);
        jideButton.setRequestFocusEnabled(false);
        jideButton.setFocusable(false);
        return jideButton;
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int n2) {
        if (n2 != 0 && n2 != 2 && n2 != 3 && n2 != 1) {
            throw new IllegalArgumentException("The value of style must be one of the following - TAB_STYLE, ICON_STYLE, LIST_STYLE or TREE_STYLE");
        }
        this._style = n2;
    }

    public JComponent getIndexPanel() {
        return this._indexPanel;
    }

    public JComponent getPagesPanel() {
        return this._pagesPanel;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        return this._treeCellRenderer;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this._treeCellRenderer = treeCellRenderer;
    }

    protected ListCellRenderer getListCellRenderer() {
        return this._listCellRenderer;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this._listCellRenderer = listCellRenderer;
    }

    protected ListCellRenderer createListCellRenderer() {
        if (this.getListCellRenderer() == null) {
            this.setListCellRenderer(new DialogPageListCellRenderer());
        }
        return this.getListCellRenderer();
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        if (this.getTreeCellRenderer() == null) {
            this.setTreeCellRenderer(new DialogPageTreeCellRenderer());
        }
        return this.getTreeCellRenderer();
    }

    public String getInitialPageTitle() {
        return this._initialPageTitle;
    }

    public void setInitialPageTitle(String string) {
        this._initialPageTitle = string;
    }
}

