/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarginSupport;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.editor.margin.DefaultCodeFoldingPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class CodeFoldingMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseInputListener {
    private transient FoldingSpan b;
    protected CodeFoldingPainter _codeFoldingPainter;

    public CodeFoldingMargin() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public CodeFoldingMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    public void paintMargin(Graphics graphics) {
        FoldingSpan[] foldingSpanArray;
        int n2 = AbstractMargin.a;
        CodeEditor codeEditor = this.getCodeEditor();
        if (n2 == 0) {
            if (codeEditor == null) {
                return;
            }
            codeEditor = this.getCodeEditor();
        }
        int n3 = codeEditor.getPainter().getFontMetrics().getHeight();
        for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
            this.paintFolding(graphics, foldingSpan, n3);
            if (n2 == 0) continue;
        }
    }

    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public CodeFoldingPainter getCodeFoldingPainter() {
        CodeFoldingPainter codeFoldingPainter = this._codeFoldingPainter;
        if (AbstractMargin.a == 0) {
            if (codeFoldingPainter == null) {
                this._codeFoldingPainter = new DefaultCodeFoldingPainter();
            }
            codeFoldingPainter = this._codeFoldingPainter;
        }
        return codeFoldingPainter;
    }

    public void setCodeFoldingPainter(CodeFoldingPainter codeFoldingPainter) {
        this._codeFoldingPainter = codeFoldingPainter;
        this.repaint();
    }

    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.getCodeFoldingPainter().paintBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public int getPreferredWidth() {
        return this.getCodeFoldingPainter().getPreferredWidth();
    }

    protected void paintFolding(Graphics graphics, FoldingSpan foldingSpan, int n2) {
        block13: {
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block9: {
                    int n7;
                    block12: {
                        int n8;
                        int n9;
                        block10: {
                            block11: {
                                n7 = AbstractMargin.a;
                                CodeEditor codeEditor = this.getCodeEditor();
                                if (n7 == 0) {
                                    if (codeEditor == null) {
                                        return;
                                    }
                                    codeEditor = this.getCodeEditor();
                                }
                                n6 = codeEditor.getFirstLine();
                                n5 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                n4 = this.b == foldingSpan ? 2 : 0;
                                n3 = foldingSpan.isExpanded();
                                if (n7 != 0) break block8;
                                if (n3 == 0) break block9;
                                int n10 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                n9 = n5;
                                n8 = n10;
                                if (n7 != 0) break block10;
                                if (n9 == n8) break block11;
                                n5 = this.getCodeEditor().modelToViewLine(n5) + 1;
                                n10 = this.getCodeEditor().modelToViewLine(n10) + 1;
                                int n11 = this.getCodeFoldingPainter().paintFoldingStart(this, graphics, foldingSpan, new Rectangle(0, (n5 - n6 - 1) * n2 + 1, this.getWidth(), n2), n4);
                                int n12 = this.getCodeFoldingPainter().paintFoldingEnd(this, graphics, foldingSpan, new Rectangle(0, (n10 - n6 - 1) * n2 + 1, this.getWidth(), n2), n4);
                                this.getCodeFoldingPainter().paintFoldingLine(this, graphics, foldingSpan, new Rectangle(0, n11, this.getWidth(), n12 - n11), n4);
                                if (n7 == 0) break block12;
                            }
                            n9 = this.getCodeEditor().modelToViewLine(n5);
                            n8 = 1;
                        }
                        n5 = n9 + n8;
                        this.getCodeFoldingPainter().paintExpandedFolding(this, graphics, foldingSpan, new Rectangle(0, (n5 - n6 - 1) * n2 + 1, this.getWidth(), n2), n4);
                    }
                    if (n7 == 0) break block13;
                }
                n3 = this.getCodeEditor().modelToViewLine(n5) + 1;
            }
            n5 = n3;
            this.getCodeFoldingPainter().paintCollapsedFolding(this, graphics, foldingSpan, new Rectangle(0, (n5 - n6 - 1) * n2 + 1, this.getWidth(), n2), n4);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block6: {
            HitInfo hitInfo;
            block13: {
                int n2;
                block12: {
                    int n3;
                    block11: {
                        block7: {
                            block8: {
                                block10: {
                                    block9: {
                                        HitInfo hitInfo2;
                                        block5: {
                                            n3 = AbstractMargin.a;
                                            CodeFoldingMargin codeFoldingMargin = this;
                                            if (n3 == 0) {
                                                if (codeFoldingMargin.getCodeEditor() == null) {
                                                    return;
                                                }
                                                codeFoldingMargin = this;
                                            }
                                            hitInfo2 = hitInfo = codeFoldingMargin.getSpanInfo(mouseEvent.getPoint());
                                            if (n3 != 0) break block5;
                                            if (hitInfo2 == null) break block6;
                                            hitInfo2 = hitInfo;
                                        }
                                        n2 = hitInfo2.a.isExpanded();
                                        if (n3 != 0) break block7;
                                        if (n2 == 0) break block8;
                                        n2 = hitInfo.b;
                                        if (n3 != 0) break block9;
                                        if (n2 == 0) break block10;
                                        n2 = hitInfo.b;
                                    }
                                    if (n3 != 0) break block7;
                                    if (n2 != 1) break block8;
                                }
                                this.getCodeEditor().getFoldingModel().collapseFoldingSpan(hitInfo.a);
                                if (n3 == 0) break block6;
                            }
                            n2 = hitInfo.a.isExpanded() ? 1 : 0;
                        }
                        if (n3 != 0) break block11;
                        if (n2 != 0) break block6;
                        n2 = hitInfo.b;
                    }
                    if (n3 != 0) break block12;
                    if (n2 == 0) break block13;
                    n2 = hitInfo.b;
                }
                if (n2 != 1) break block6;
            }
            this.getCodeEditor().getFoldingModel().expandFoldingSpan(hitInfo.a);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        block3: {
            CodeFoldingMargin codeFoldingMargin;
            block2: {
                codeFoldingMargin = this;
                if (AbstractMargin.a != 0) break block2;
                if (codeFoldingMargin.b == null) break block3;
                this.b = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block5: {
            CodeFoldingMargin codeFoldingMargin;
            block6: {
                HitInfo hitInfo;
                int n2;
                block2: {
                    HitInfo hitInfo2;
                    block3: {
                        CodeFoldingMargin codeFoldingMargin2;
                        block4: {
                            n2 = AbstractMargin.a;
                            hitInfo = hitInfo2 = this.getSpanInfo(mouseEvent.getPoint());
                            if (n2 != 0) break block2;
                            if (hitInfo == null) break block3;
                            codeFoldingMargin2 = this;
                            if (n2 != 0) break block4;
                            if (codeFoldingMargin2.b == hitInfo2.a) break block3;
                            this.b = hitInfo2.a;
                            codeFoldingMargin2 = this;
                        }
                        codeFoldingMargin2.repaint();
                        if (n2 == 0) break block5;
                    }
                    hitInfo = hitInfo2;
                }
                if (hitInfo != null) break block5;
                codeFoldingMargin = this;
                if (n2 != 0) break block6;
                if (codeFoldingMargin.b == null) break block5;
                this.b = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    protected HitInfo getSpanInfo(Point point) {
        int n2 = AbstractMargin.a;
        CodeEditor codeEditor = this.getCodeEditor();
        if (n2 == 0) {
            if (codeEditor == null) {
                return null;
            }
            codeEditor = this.getCodeEditor();
        }
        int n3 = codeEditor.getFirstLine();
        int n4 = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
        int n5 = point.y;
        int n6 = n5 / n4;
        FoldingSpan[] foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n7 = n3 + n6;
        for (FoldingSpan foldingSpan : foldingSpanArray) {
            int n8;
            int n9;
            int n10;
            int n11;
            block14: {
                block11: {
                    int n12;
                    block12: {
                        block13: {
                            block9: {
                                block10: {
                                    int n13 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                    int n14 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                    n11 = this.getCodeEditor().modelToViewLine(n13);
                                    n10 = this.getCodeEditor().modelToViewLine(n14);
                                    n12 = n11;
                                    if (n2 != 0) break block9;
                                    if (n12 >= 0) break block10;
                                    n11 = n10;
                                    if (n2 == 0) break block11;
                                }
                                n12 = n10;
                            }
                            if (n2 != 0) break block12;
                            if (n12 < 0) break block13;
                            n9 = n10;
                            n8 = n11;
                            if (n2 != 0) break block14;
                            if (n9 >= n8) break block11;
                        }
                        n12 = n11;
                    }
                    n10 = n12;
                }
                n9 = n7;
                n8 = n11;
            }
            if (n2 == 0) {
                if (n9 < n8) continue;
                n9 = n7;
                n8 = n10;
            }
            if (n9 > n8) continue;
            HitInfo hitInfo = new HitInfo();
            hitInfo.a = foldingSpan;
            int n15 = n7;
            int n16 = n11;
            if (n2 == 0) {
                if (n15 == n16) {
                    hitInfo.b = 0;
                    return hitInfo;
                }
                n15 = n7;
                n16 = n10;
            }
            if (n15 != n16) continue;
            hitInfo.b = 0;
            return hitInfo;
        }
        return null;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this.setMarginSupport(new CodeEditorMarginSupport(codeEditor));
        super.setCodeEditor(codeEditor);
    }

    protected static class HitInfo {
        FoldingSpan a;
        int b;

        protected HitInfo() {
        }
    }
}

