/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.Span;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.icons.IconsFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.Icon;

public class DefaultCodeFoldingPainter
implements CodeFoldingPainter {
    private static final Icon a = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom.png");
    private static final Icon b = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top.png");
    private static final Icon c = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed.png");
    private static final Icon d = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened.png");
    private static final Icon e = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom_r.png");
    private static final Icon f = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top_r.png");
    private static final Icon g = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed_r.png");
    private static final Icon h = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened_r.png");
    private static final BasicStroke i = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    public int paintFoldingStart(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? f : b;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 + icon.getIconHeight() / 2;
    }

    public int paintFoldingEnd(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? e : a;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2;
    }

    public void paintCollapsedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? g : c;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    public void paintExpandedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? h : d;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    public void paintFoldingLine(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        block3: {
            int n3;
            int n4;
            block2: {
                n4 = n2;
                n3 = 2;
                if (AbstractMargin.a != 0) break block2;
                if (n4 != n3) break block3;
                graphics.setColor(Color.BLACK);
                n4 = rectangle.x;
                n3 = rectangle.width / 2;
            }
            int n5 = n4 + n3;
            graphics.drawLine(n5, rectangle.y, n5, rectangle.y + rectangle.height);
        }
    }

    public void paintBackground(Component component, Graphics graphics, Rectangle rectangle) {
        Stroke stroke;
        Color color;
        int n2;
        int n3;
        block5: {
            Graphics graphics2;
            block2: {
                block3: {
                    CodeEditor codeEditor;
                    int n4;
                    block4: {
                        n4 = AbstractMargin.a;
                        n3 = rectangle.x + rectangle.width / 2;
                        n2 = rectangle.height;
                        color = graphics.getColor();
                        stroke = ((Graphics2D)graphics).getStroke();
                        graphics.setColor(component.getBackground());
                        graphics2 = graphics;
                        if (n4 != 0) break block2;
                        graphics2.fillRect(rectangle.x, rectangle.y, n3, n2);
                        if (!(component instanceof AbstractMargin)) break block3;
                        codeEditor = ((AbstractMargin)component).getCodeEditor();
                        if (n4 != 0) break block4;
                        if (codeEditor == null) break block3;
                        codeEditor = ((AbstractMargin)component).getCodeEditor();
                    }
                    CodeEditor codeEditor2 = codeEditor;
                    graphics.setColor(codeEditor2.getPainter().getBackground());
                    if (n4 == 0) break block5;
                    int n5 = CodeEditor.V;
                    CodeEditor.V = ++n5;
                }
                graphics2 = graphics;
            }
            graphics2.setColor(Color.WHITE);
        }
        graphics.fillRect(rectangle.x + n3 + 1, rectangle.y, n3, n2);
        graphics.setColor(Color.GRAY);
        ((Graphics2D)graphics).setStroke(i);
        graphics.drawLine(n3, 0, n3, n2);
        graphics.setColor(color);
        ((Graphics2D)graphics).setStroke(stroke);
    }

    public int getPreferredWidth() {
        return a.getIconWidth() + 4;
    }
}

