/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.icons.RolloverIcon;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationTreeTable
extends TreeTable
implements NavigationComponent,
RolloverIcon.IconRolloverSupport {
    private NavigationComponentHelper Uc;
    private float Vc = 0.0f;
    private Animator Wc;
    private Animator Xc;
    private boolean Yc = true;
    public static final String PROPERTY_FADE_ICON = "fadeIcon";

    public NavigationTreeTable() {
        this.E();
    }

    public NavigationTreeTable(int n2, int n3) {
        super(n2, n3);
        this.E();
    }

    public NavigationTreeTable(TableModel tableModel) {
        super(tableModel);
        this.E();
    }

    public NavigationTreeTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.E();
    }

    public NavigationTreeTable(Vector<?> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.E();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.E();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.E();
    }

    private void E() {
        this.setAutoResizeMode(256);
        this.setFillsSelection(false);
        this.setShowGrid(false);
        this.setFillsGrids(false);
        this.setShowTreeLines(false);
        this.setShowLeafNodeTreeLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setExpandedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 0));
        this.setCollapsedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 1));
        this.Wc = new Animator(this, 100, 30, 30);
        this.Wc.addAnimatorListener(new AnimatorListener(){

            public void animationStarts(Component component) {
            }

            public void animationFrame(Component component, int n2, int n3) {
                float f2 = 1.0f * (float)(n2 - n3) / (float)n2;
                if (!JideTable.jb) {
                    if (f2 <= NavigationTreeTable.this.getIconAlpha()) {
                        NavigationTreeTable.this.setIconAlpha(f2);
                    }
                    NavigationTreeTable.this.repaint();
                }
            }

            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(0.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this.Xc = new Animator(this, 100, 5, 10);
        this.Xc.addAnimatorListener(new AnimatorListener(){

            public void animationStarts(Component component) {
            }

            public void animationFrame(Component component, int n2, int n3) {
                float f2 = 1.0f * (float)n3 / (float)n2;
                if (!JideTable.jb) {
                    if (f2 >= NavigationTreeTable.this.getIconAlpha()) {
                        NavigationTreeTable.this.setIconAlpha(f2);
                    }
                    NavigationTreeTable.this.repaint();
                }
            }

            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(1.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this.Uc = this.createNavigationHelper();
        this.Uc.setup(this);
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTreeTableHelper();
    }

    private Rectangle j(int n2) {
        return this.getCellRect(n2, 0, false).union(this.getCellRect(n2, this.getColumnCount() - 1, false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isIconRollover(int n2, int n3, int n4, int n5) {
        Point point;
        boolean bl = JideTable.jb;
        Point point2 = point = this.Uc.getMousePosition();
        if (!bl) {
            if (point2 == null) return 0 != 0;
            point2 = point;
        }
        int n6 = point2.x;
        if (bl) return n6 != 0;
        if (n6 < n2) return 0 != 0;
        n6 = point.x;
        if (bl) return n6 != 0;
        if (n6 > n2 + n4) return 0 != 0;
        n6 = point.y;
        if (bl) return n6 != 0;
        if (n6 < n3) return 0 != 0;
        n6 = point.y;
        if (bl) return n6 != 0;
        if (n6 > n3 + n5) return 0 != 0;
        return true;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.Uc.paint(graphics, this);
    }

    @Override
    public float getIconAlpha() {
        return this.Vc;
    }

    public void setIconAlpha(float f2) {
        this.Vc = f2;
    }

    @Override
    public boolean isIconFade() {
        return this.Yc;
    }

    public void setFadeIcon(boolean bl) {
        block3: {
            block2: {
                boolean bl2 = this.Yc;
                if (JideTable.jb) break block2;
                if (bl == this.Yc) break block3;
                this.Yc = bl;
                this.firePropertyChange(PROPERTY_FADE_ICON, bl2, this.Yc);
            }
            this.repaint();
        }
    }

    public int getNavigationRolloverRow() {
        return this.Uc.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n2) {
        block5: {
            NavigationTreeTable navigationTreeTable;
            Rectangle rectangle;
            block7: {
                Rectangle rectangle2;
                block6: {
                    int n3;
                    boolean bl;
                    block4: {
                        bl = JideTable.jb;
                        n3 = this.Uc.getRolloverRow();
                        if (bl) break block4;
                        if (n3 == n2) break block5;
                        this.Uc.setRolloverRow(n2);
                    }
                    rectangle2 = rectangle = this.j(n3);
                    if (bl) break block6;
                    if (rectangle2 != null) {
                        this.repaint(rectangle);
                    }
                    navigationTreeTable = this;
                    if (bl) break block7;
                    rectangle2 = rectangle = navigationTreeTable.j(n2);
                }
                if (rectangle2 == null) break block5;
                navigationTreeTable = this;
            }
            navigationTreeTable.repaint(rectangle);
        }
    }

    public class NavigationTreeTableHelper
    extends NavigationComponentHelper {
        public Rectangle getRowBounds(int n2) {
            return NavigationTreeTable.this.j(n2);
        }

        public int rowAtPoint(Point point) {
            return NavigationTreeTable.this.rowAtPoint(point);
        }

        public int[] getSelectedRows() {
            return NavigationTreeTable.this.getSelectedRows();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block4: {
                    boolean bl;
                    block2: {
                        boolean bl2 = JideTable.jb;
                        bl = NavigationTreeTable.this.isIconFade();
                        if (bl2) break block2;
                        if (!bl) break block3;
                        navigationTreeTable = NavigationTreeTable.this;
                        if (bl2) break block4;
                        bl = navigationTreeTable.hasFocus();
                    }
                    if (bl) break block3;
                    NavigationTreeTable.this.Xc.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.Wc.start();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block4: {
                    boolean bl;
                    block2: {
                        boolean bl2 = JideTable.jb;
                        bl = NavigationTreeTable.this.isIconFade();
                        if (bl2) break block2;
                        if (!bl) break block3;
                        navigationTreeTable = NavigationTreeTable.this;
                        if (bl2) break block4;
                        bl = navigationTreeTable.hasFocus();
                    }
                    if (bl) break block3;
                    NavigationTreeTable.this.Wc.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.Xc.start();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block2: {
                    navigationTreeTable = NavigationTreeTable.this;
                    if (JideTable.jb) break block2;
                    if (!navigationTreeTable.isIconFade()) break block3;
                    NavigationTreeTable.this.Wc.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.Xc.start();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block2: {
                    navigationTreeTable = NavigationTreeTable.this;
                    if (JideTable.jb) break block2;
                    if (!navigationTreeTable.isIconFade()) break block3;
                    NavigationTreeTable.this.Xc.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.Wc.start();
            }
        }
    }
}

