/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class RolloverIcon
implements Icon {
    public static Color COLOR_COLLAPSED_FILL_ROLLOVER = new Color(199, 235, 250);
    public static Color COLOR_COLLAPSED_FILL = Color.WHITE;
    public static Color COLOR_COLLAPSED_ROLLOVER = new Color(28, 196, 247);
    public static Color COLOR_COLLAPSED = new Color(165, 165, 165);
    public static Color COLOR_EXPANDED_FILL_ROLLOVER = new Color(130, 223, 251);
    public static Color COLOR_EXPANDED_FILL = new Color(89, 89, 89);
    public static Color COLOR_EXPANDED_ROLLOVER = new Color(28, 196, 247);
    public static Color COLOR_EXPANDED = new Color(35, 35, 35);
    public static final int ICON_EXPANDED = 0;
    public static final int ICON_COLLAPSED = 1;
    private Icon _normalIcon;
    private Icon _rolloverIcon;
    private IconRolloverSupport _rolloverSupport;

    public RolloverIcon(IconRolloverSupport iconRolloverSupport, int n2) {
        this._rolloverSupport = iconRolloverSupport;
        switch (n2) {
            case 0: {
                this._normalIcon = new DefaultExpandedIcon(iconRolloverSupport);
                break;
            }
            case 1: {
                this._normalIcon = new DefaultCollapsedIcon(iconRolloverSupport);
            }
        }
        this._rolloverIcon = null;
    }

    public RolloverIcon(IconRolloverSupport iconRolloverSupport, Icon icon) {
        this._rolloverSupport = iconRolloverSupport;
        this._normalIcon = icon;
        this._rolloverIcon = null;
    }

    public RolloverIcon(IconRolloverSupport iconRolloverSupport, Icon icon, Icon icon2) {
        this._rolloverSupport = iconRolloverSupport;
        this._normalIcon = icon;
        this._rolloverIcon = icon2;
    }

    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        if (this._rolloverSupport.isIconFade()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this._rolloverSupport.getIconAlpha()));
        }
        boolean bl2 = bl = this._rolloverIcon != null && this._rolloverIcon != this._normalIcon && this._rolloverSupport.isIconRollover(n2, n3, this.getIconWidth(), this.getIconHeight());
        if (bl) {
            this._rolloverIcon.paintIcon(component, graphics2D, n2, n3);
        } else {
            this._normalIcon.paintIcon(component, graphics2D, n2, n3);
        }
        graphics2D.setComposite(composite);
    }

    public int getIconWidth() {
        return this._normalIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this._normalIcon.getIconHeight();
    }

    public static class DefaultExpandedIcon
    implements Icon {
        private IconRolloverSupport _rolloverSupport;

        public DefaultExpandedIcon(IconRolloverSupport iconRolloverSupport) {
            this._rolloverSupport = iconRolloverSupport;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            GeneralPath generalPath = new GeneralPath();
            if (component.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                generalPath.moveTo(n2, n3);
                generalPath.lineTo(n2, n3 + 5);
                generalPath.lineTo(n2 + 5, n3 + 5);
            } else {
                generalPath.moveTo(n2 + 5, n3);
                generalPath.lineTo(n2 + 5, n3 + 5);
                generalPath.lineTo(n2, n3 + 5);
            }
            generalPath.closePath();
            boolean bl = this._rolloverSupport.isIconRollover(n2, n3, this.getIconWidth(), this.getIconHeight());
            graphics2D.setColor(bl ? COLOR_EXPANDED_FILL_ROLLOVER : COLOR_EXPANDED_FILL);
            graphics2D.fill(generalPath);
            graphics2D.setColor(bl ? COLOR_EXPANDED_ROLLOVER : COLOR_EXPANDED);
            graphics2D.draw(generalPath);
            graphics2D.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 6;
        }
    }

    public static class DefaultCollapsedIcon
    implements Icon {
        private IconRolloverSupport _rolloverSupport;

        public DefaultCollapsedIcon(IconRolloverSupport iconRolloverSupport) {
            this._rolloverSupport = iconRolloverSupport;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            GeneralPath generalPath = new GeneralPath();
            if (component.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                generalPath.moveTo(n2 + 4, n3);
                generalPath.lineTo(n2, n3 + 4);
                generalPath.lineTo(n2 + 4, n3 + 8);
            } else {
                generalPath.moveTo(n2, n3);
                generalPath.lineTo(n2 + 4, n3 + 4);
                generalPath.lineTo(n2, n3 + 8);
            }
            generalPath.closePath();
            boolean bl = this._rolloverSupport.isIconRollover(n2, n3, this.getIconWidth(), this.getIconHeight());
            graphics2D.setColor(bl ? COLOR_COLLAPSED_FILL_ROLLOVER : COLOR_COLLAPSED_FILL);
            graphics2D.fill(generalPath);
            graphics2D.setColor(bl ? COLOR_COLLAPSED_ROLLOVER : COLOR_COLLAPSED);
            graphics2D.draw(generalPath);
            graphics2D.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    public static interface IconRolloverSupport {
        public boolean isIconRollover(int var1, int var2, int var3, int var4);

        public boolean isIconFade();

        public float getIconAlpha();
    }
}

