/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractMarginSupport;
import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListRowMarginSupport
extends AbstractRowMarginSupport {
    protected JList _list;
    private ListDataListener c;
    private PropertyChangeListener d;

    public ListRowMarginSupport(JList jList, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._list = jList;
    }

    public int getRowCount() {
        return this._list.getModel().getSize();
    }

    public void scrollTo(int n2, int n3, boolean bl) {
        if (bl) {
            this._list.getSelectionModel().setSelectionInterval(Math.min(n2, n3), Math.max(n2, n3));
        }
        this._list.scrollRectToVisible(this._list.getCellBounds(n3, n3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRowHeight(int n2) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this._list.getCellBounds(n2, n2);
        if (!AbstractMarginSupport.b) {
            if (rectangle2 == null) return -1;
            rectangle2 = rectangle;
        }
        int n3 = rectangle2.height;
        return n3;
    }

    public int positionToRow(int n2) {
        int n3 = this.getViewPosition();
        return this._list.locationToIndex(new Point(0, n3 + n2));
    }

    public int rowToPosition(int n2) {
        Point point = this._list.indexToLocation(n2);
        if (point != null) {
            int n3 = this.getViewPosition();
            return point.y - n3;
        }
        return Integer.MIN_VALUE;
    }

    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        block8: {
            ListRowMarginSupport listRowMarginSupport;
            boolean bl;
            block7: {
                bl = AbstractMarginSupport.b;
                listRowMarginSupport = this;
                if (bl) break block7;
                super.installListeners(repaintCallback, modelChangedCallback);
                if (modelChangedCallback == null) break block8;
                listRowMarginSupport = this;
            }
            if (!bl) {
                if (listRowMarginSupport.c == null) {
                    this.c = new ListDataListener(){

                        public void intervalAdded(ListDataEvent listDataEvent) {
                            modelChangedCallback.modelChanged(listDataEvent);
                        }

                        public void intervalRemoved(ListDataEvent listDataEvent) {
                            modelChangedCallback.modelChanged(listDataEvent);
                        }

                        public void contentsChanged(ListDataEvent listDataEvent) {
                            modelChangedCallback.modelChanged(listDataEvent);
                        }
                    };
                }
                listRowMarginSupport = this;
            }
            if (!bl) {
                if (listRowMarginSupport.d == null) {
                    this.d = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            Object object;
                            Object object2;
                            boolean bl = AbstractMarginSupport.b;
                            Object object3 = object2 = propertyChangeEvent.getOldValue();
                            if (!bl) {
                                if (object3 instanceof ListModel) {
                                    ((ListModel)object2).removeListDataListener(ListRowMarginSupport.this.c);
                                }
                                object3 = object = propertyChangeEvent.getNewValue();
                            }
                            if (!bl) {
                                if (object instanceof ListModel) {
                                    ((ListModel)object).addListDataListener(ListRowMarginSupport.this.c);
                                }
                                modelChangedCallback.modelChanged(propertyChangeEvent);
                            }
                        }
                    };
                }
                this._list.addPropertyChangeListener("model", this.d);
                listRowMarginSupport = this;
            }
            listRowMarginSupport._list.getModel().addListDataListener(this.c);
        }
    }

    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        boolean bl = AbstractMarginSupport.b;
        ListRowMarginSupport listRowMarginSupport = this;
        if (!bl) {
            if (listRowMarginSupport.d != null) {
                this._list.removePropertyChangeListener("model", this.d);
            }
            listRowMarginSupport = this;
        }
        if (!bl) {
            if (listRowMarginSupport.c != null) {
                this._list.getModel().removeListDataListener(this.c);
            }
            listRowMarginSupport = this;
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

