/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;

class AnimationThreadFactory {
    static final int DISABLED_TYPE = -1;
    static final int DEFAULT_TYPE = 0;
    static final int HOVER_IN_TYPE = 1;
    static final int HOVER_OUT_TYPE = 2;
    static final int FOCUSED_TYPE = 3;
    static final int DISPOSABLE_TYPE = 4;
    static final int ACTIVE_TYPE = 5;
    static final int INACTIVE_TYPE = 6;
    private static HashMap threads = new HashMap();
    private static AnimationThreadFactory instance = new AnimationThreadFactory();

    private AnimationThreadFactory() {
    }

    public static AnimationThread createThread(int n2) {
        if (threads.containsKey(n2)) {
            return (AnimationThread)threads.get(n2);
        }
        return instance.newThread(n2);
    }

    private AnimationThread newThread(int n2) {
        AnimationThread animationThread = new AnimationThread(n2);
        threads.put(n2, animationThread);
        animationThread.setDaemon(true);
        animationThread.start();
        return animationThread;
    }

    static class AnimationThread
    extends Thread {
        private int delay = 0;
        private HashMap componentAnimations = new HashMap();
        private ReferenceQueue queue = new ReferenceQueue();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    AnimationThread.sleep(this.delay);
                    HashMap hashMap = null;
                    HashMap hashMap2 = this.componentAnimations;
                    synchronized (hashMap2) {
                        void var3_6;
                        Reference reference = this.queue.poll();
                        while (var3_6 != null) {
                            this.componentAnimations.remove(((WeakComponent)var3_6).key);
                            Reference reference2 = this.queue.poll();
                        }
                        hashMap = new HashMap(this.componentAnimations);
                    }
                    block13: for (Map.Entry entry : hashMap.entrySet()) {
                        JComponent jComponent = (JComponent)((ComponentKey)entry.getKey()).wc.get();
                        if (jComponent == null) continue;
                        ComponentAnimation componentAnimation = (ComponentAnimation)entry.getValue();
                        if (jComponent == null || componentAnimation == null) continue;
                        boolean bl = (componentAnimation.state & 2) > 0;
                        boolean bl2 = jComponent.hasFocus();
                        Rectangle rectangle = componentAnimation.repaintRect;
                        switch (componentAnimation.type) {
                            case 4: 
                            case 5: 
                            case 6: {
                                if (!componentAnimation.next()) continue block13;
                                this.repaint(jComponent, rectangle);
                                break;
                            }
                            case 1: {
                                if (componentAnimation.state != -1 && bl && componentAnimation.next()) {
                                    this.repaint(jComponent, rectangle);
                                    break;
                                }
                                if (componentAnimation.state == -1 || bl) continue block13;
                                componentAnimation.reset();
                                break;
                            }
                            case 2: {
                                if (componentAnimation.state != -1 && !bl && componentAnimation.next()) {
                                    this.repaint(jComponent, rectangle);
                                    break;
                                }
                                if (componentAnimation.state == -1 || !bl) continue block13;
                                componentAnimation.reset();
                                break;
                            }
                            case 3: {
                                Component component;
                                if (jComponent instanceof JComboBox && ((JComboBox)jComponent).isEditable() && ((JComboBox)jComponent).getEditor() != null) {
                                    component = ((JComboBox)jComponent).getEditor().getEditorComponent();
                                    if (component != null) {
                                        bl2 = component.hasFocus();
                                    }
                                } else if (jComponent instanceof JSpinner) {
                                    component = SyntheticaLookAndFeel.findComponent((String)"Spinner.formattedTextField", (Container)jComponent);
                                    if (component != null) {
                                        bl2 = component.hasFocus();
                                    }
                                } else if (jComponent instanceof JScrollPane) {
                                    component = (JScrollPane)jComponent;
                                    if (((JScrollPane)component).getViewport().getView() != null) {
                                        bl2 = ((JScrollPane)component).getViewport().getView().hasFocus();
                                    }
                                    int n2 = SyntheticaLookAndFeel.getInt((String)"Synthetica.focus.scrollPane.animation.maxWidth", (Component)component, (int)400);
                                    int n3 = SyntheticaLookAndFeel.getInt((String)"Synthetica.focus.scrollPane.animation.maxHeight", (Component)component, (int)200);
                                    if (((JComponent)component).getWidth() > n2) continue block13;
                                    if (((JComponent)component).getHeight() > n3) break;
                                }
                                if (componentAnimation.next() && bl2 && this.isActive(jComponent)) {
                                    this.repaint(jComponent, rectangle);
                                    break;
                                }
                                if (bl2) continue block13;
                                componentAnimation.reset();
                                break;
                            }
                            default: {
                                if (!componentAnimation.next() || !this.isActive(jComponent)) continue block13;
                                this.repaint(jComponent, rectangle);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }

        private void repaint(JComponent jComponent, Rectangle rectangle) {
            if (rectangle == null) {
                jComponent.repaint();
            } else {
                jComponent.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private boolean isActive(JComponent jComponent) {
            Container container = jComponent.getTopLevelAncestor();
            if (container instanceof Window && !"###focusableSwingPopup###".equals(container.getName())) {
                return ((Window)container).isActive();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(JComponent jComponent, String string, int n2, int n3, String[] stringArray, int n4, Rectangle rectangle) {
            boolean bl = (n2 & 2) > 0;
            ComponentKey componentKey = new ComponentKey(jComponent, string);
            if (this.componentAnimations.containsKey(componentKey)) {
                ComponentAnimation componentAnimation = (ComponentAnimation)this.componentAnimations.get(componentKey);
                componentAnimation.repaintRect = rectangle;
                if (componentAnimation.type != n3 || !Arrays.toString(stringArray).equals(Arrays.toString(componentAnimation.imagePaths))) {
                    componentAnimation.type = n3;
                    ComponentAnimation.access$602(componentAnimation, stringArray);
                    componentAnimation.cyles = n4;
                    componentAnimation.reset();
                }
                if (componentAnimation.state != -1 || bl) {
                    componentAnimation.state = n2;
                }
                return;
            }
            componentKey.setComponent(jComponent);
            ComponentAnimation componentAnimation = new ComponentAnimation(null);
            ComponentAnimation.access$602(componentAnimation, stringArray);
            componentAnimation.cyles = n4;
            componentAnimation.repaintRect = rectangle;
            componentAnimation.type = n3;
            if (bl) {
                componentAnimation.state = n2;
            } else if (n3 == 6) {
                componentAnimation.cylesDone = n4;
            }
            HashMap hashMap = this.componentAnimations;
            synchronized (hashMap) {
                this.componentAnimations.put(componentKey, componentAnimation);
            }
        }

        void rotateRepaintRect(JComponent jComponent, String string) {
            ComponentKey componentKey = new ComponentKey(jComponent, string);
            ComponentAnimation componentAnimation = (ComponentAnimation)this.componentAnimations.get(componentKey);
            if (componentAnimation != null) {
                int n2 = ((ComponentAnimation)componentAnimation).repaintRect.height;
                ((ComponentAnimation)componentAnimation).repaintRect.height = ((ComponentAnimation)componentAnimation).repaintRect.width;
                ((ComponentAnimation)componentAnimation).repaintRect.width = n2;
            }
        }

        public String getImagePath(JComponent jComponent, String string) {
            ComponentAnimation componentAnimation = (ComponentAnimation)this.componentAnimations.get(new ComponentKey(jComponent, string));
            if (componentAnimation.type == 2 && (componentAnimation.state == -1 || componentAnimation.isComplete())) {
                return componentAnimation.imagePaths[componentAnimation.imagePaths.length - 1];
            }
            if (componentAnimation.type == 6 && componentAnimation.isComplete()) {
                return componentAnimation.imagePaths[componentAnimation.imagePaths.length - 1];
            }
            return componentAnimation.imagePaths[componentAnimation.index];
        }

        public AnimationThread(int n2) {
            this.delay = n2;
            this.setPriority(7);
            this.setName("SyntheticaAnimation " + n2);
        }

        private class WeakComponent
        extends WeakReference {
            private ComponentKey key;

            public WeakComponent(JComponent jComponent, ComponentKey componentKey) {
                super(jComponent, AnimationThread.this.queue);
                this.key = componentKey;
            }
        }

        private class ComponentKey {
            private int hashCode;
            private WeakComponent wc;

            void setComponent(JComponent jComponent) {
                this.wc = new WeakComponent(jComponent, this);
            }

            public boolean equals(Object object) {
                ComponentKey componentKey = (ComponentKey)object;
                return componentKey.hashCode == this.hashCode;
            }

            public int hashCode() {
                return this.hashCode;
            }

            ComponentKey(JComponent jComponent, String string) {
                this.hashCode = jComponent.hashCode() * 31 + string.hashCode();
            }
        }

        private static class ComponentAnimation {
            private int state = -1;
            private int type = 0;
            private int index = 0;
            private String[] imagePaths;
            private Rectangle repaintRect;
            private long cyles = 0L;
            private long cylesDone = 0L;

            boolean next() {
                if (this.cyles == 0L || this.cylesDone == this.cyles || this.imagePaths.length == 1) {
                    return false;
                }
                ++this.index;
                if (this.index == this.imagePaths.length - 1) {
                    ++this.cylesDone;
                } else if (this.index == this.imagePaths.length) {
                    this.index = 0;
                }
                return true;
            }

            void reset() {
                this.index = 0;
                this.cylesDone = 0L;
            }

            boolean isComplete() {
                return this.cyles == this.cylesDone;
            }

            private ComponentAnimation() {
            }

            ComponentAnimation(ComponentAnimation componentAnimation) {
                this();
            }

            static /* synthetic */ String[] access$602(ComponentAnimation componentAnimation, String[] stringArray) {
                componentAnimation.imagePaths = stringArray;
                return stringArray;
            }
        }
    }
}

