/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Category;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryRange<T>
extends AbstractRange<T>
implements Iterable<Category<T>> {
    public static final String PROPERTY_VALUES = "values";
    public static final String PROPERTY_COMPARATOR = "comparator";
    public static final String PROPERTY_SORTED = "sorted";
    private List<T> _possibleValues = null;
    private List<Category<T>> _categoryValues = null;
    private Double minimum;
    private Double maximum;
    private Comparator<T> comparator = null;
    private boolean sorted = false;
    private boolean alreadySorted = false;

    public CategoryRange() {
        this._possibleValues = new ArrayList<T>();
        this._categoryValues = new ArrayList<Category<T>>();
        this.alreadySorted = false;
    }

    public CategoryRange(T ... TArray) {
        this._possibleValues = new ArrayList<T>();
        this._possibleValues.addAll(Arrays.asList(TArray));
        this.alreadySorted = false;
    }

    public CategoryRange(Set<T> set) {
        this._possibleValues = new ArrayList<T>(set);
        this.alreadySorted = false;
    }

    public CategoryRange(CategoryRange<T> categoryRange) {
        this._categoryValues = new ArrayList<Category<T>>(categoryRange.getCategoryValues());
        this._possibleValues = new ArrayList<T>(categoryRange.getPossibleValues());
        this.comparator = categoryRange.getComparator();
        this.setMinimum(categoryRange.minimum());
        this.setMaximum(categoryRange.maximum());
        this.alreadySorted = false;
    }

    public List<T> getPossibleValues() {
        if (this.sorted && !this.alreadySorted) {
            if (this.comparator == null) {
                Comparator comparator = new Comparator<T>(){

                    @Override
                    public int compare(T t, T t2) {
                        if (t == null && t2 == null) {
                            return 0;
                        }
                        if (t == null) {
                            return -1;
                        }
                        if (t2 == null) {
                            return 1;
                        }
                        if (t instanceof Comparable) {
                            Comparable comparable = (Comparable)t;
                            return comparable.compareTo(t2);
                        }
                        String string = t.toString();
                        String string2 = t2.toString();
                        return string.compareTo(string2);
                    }
                };
                Collections.sort(this._possibleValues, comparator);
            } else {
                Collections.sort(this._possibleValues, this.comparator);
            }
        }
        return this._possibleValues;
    }

    public Category<T> getCategory(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Supplied category index was " + n2 + " but it should be >= 1");
        }
        return this.getCategoryValues().get(n2 - 1);
    }

    public CategoryRange<T> add(Category<T> category) {
        if (!this.contains(category)) {
            if (this.comparator == null) {
                this._possibleValues.add(category.getValue());
                this._categoryValues.add(category);
            } else {
                this._possibleValues.add(category.getValue());
                this.alreadySorted = false;
                this._categoryValues = null;
            }
            category.setRange(this);
            this.firePropertyChange(PROPERTY_VALUES, null, this._possibleValues);
        }
        return this;
    }

    public void setSorted(boolean bl) {
        boolean bl2 = this.sorted;
        this.sorted = bl;
        if (bl) {
            this._categoryValues = null;
        }
        this.firePropertyChange(PROPERTY_SORTED, bl2, bl);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.comparator;
        this.comparator = comparator;
        this.setSorted(comparator != null);
        this.firePropertyChange(PROPERTY_COMPARATOR, comparator2, comparator);
    }

    @Override
    public Range<T> copy() {
        return new CategoryRange<T>(this);
    }

    @Override
    public T lower() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        return this._possibleValues.get(0);
    }

    @Override
    public T upper() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        int n2 = this._possibleValues.size();
        return this._possibleValues.get(n2 - 1);
    }

    @Override
    public void adjust(T t, T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maximum() {
        if (this.maximum == null) {
            T t = this.upper();
            if (t == null) {
                return 1.0;
            }
            this.maximum = (double)this.position(t) + 1.0;
        }
        return this.maximum;
    }

    @Override
    public double minimum() {
        if (this.minimum == null) {
            T t = this.lower();
            if (t == null) {
                return 0.0;
            }
            this.minimum = (double)this.position(t) - 1.0;
        }
        return this.minimum;
    }

    public void reset() {
        this.maximum = null;
        this.minimum = null;
    }

    public void setMinimum(double d2) {
        Double d3 = this.minimum;
        this.minimum = d2;
        this.firePropertyChange("min", d3, d2);
    }

    public void setMaximum(double d2) {
        Double d3 = this.maximum;
        this.maximum = d2;
        this.firePropertyChange("max", d3, d2);
    }

    @Override
    public double size() {
        if (this._possibleValues == null) {
            return 0.0;
        }
        int n2 = this._possibleValues.size();
        if (n2 == 0) {
            return 0.0;
        }
        return this.maximum() - this.minimum();
    }

    public int position(T t) {
        int n2 = this._possibleValues.indexOf(t);
        if (n2 < 0) {
            throw new IllegalArgumentException("Value " + t + " not known");
        }
        return 1 + n2;
    }

    @Override
    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        for (T t2 : this._possibleValues) {
            if (!t.equals(t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Category<T> category) {
        if (category == null) {
            return false;
        }
        for (Category<T> category2 : this.getCategoryValues()) {
            if (!category.equals(category2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Category<T>> iterator() {
        return this.getCategoryValues().iterator();
    }

    public List<Category<T>> getCategoryValues() {
        if (this._categoryValues == null) {
            this._categoryValues = new ArrayList<Category<T>>();
            for (T t : this.getPossibleValues()) {
                this._categoryValues.add(new Category<T>(t, this));
            }
        }
        return this._categoryValues;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this._categoryValues == null ? 0 : ((Object)this._categoryValues).hashCode());
        n2 = 31 * n2 + (this._possibleValues == null ? 0 : ((Object)this._possibleValues).hashCode());
        n2 = 31 * n2 + (this.maximum == null ? 0 : this.maximum.hashCode());
        n2 = 31 * n2 + (this.minimum == null ? 0 : this.minimum.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CategoryRange categoryRange = (CategoryRange)object;
        if (this._categoryValues == null ? categoryRange._categoryValues != null : !((Object)this._categoryValues).equals(categoryRange._categoryValues)) {
            return false;
        }
        if (this._possibleValues == null ? categoryRange._possibleValues != null : !((Object)this._possibleValues).equals(categoryRange._possibleValues)) {
            return false;
        }
        if (this.maximum == null ? categoryRange.maximum != null : !this.maximum.equals(categoryRange.maximum)) {
            return false;
        }
        return !(this.minimum == null ? categoryRange.minimum != null : !this.minimum.equals(categoryRange.minimum));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<CategoryRange ");
        stringBuilder.append("minimum=");
        stringBuilder.append(this.minimum);
        stringBuilder.append(" maximum=");
        stringBuilder.append(this.maximum);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

