/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCacheEntry;
import com.jidesoft.swing.GradientInfo;
import java.awt.image.BufferedImage;
import java.lang.ref.ReferenceQueue;

class GradientCache {
    private GradientCacheEntry[] gradients;
    private int size;
    private int threshold = 16;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();

    GradientCache() {
        this.loadFactor = 0.75f;
        this.gradients = new GradientCacheEntry[16];
    }

    BufferedImage retrieve(GradientInfo gradientInfo) {
        int n2 = gradientInfo.length;
        GradientCacheEntry[] gradientCacheEntryArray = this.getGradients();
        int n3 = GradientCache.bucket(n2, gradientCacheEntryArray.length);
        GradientCacheEntry gradientCacheEntry = gradientCacheEntryArray[n3];
        while (gradientCacheEntry != null) {
            GradientInfo gradientInfo2 = gradientCacheEntry.getInfo();
            try {
                if (gradientInfo2 != null && gradientCacheEntry.length == n2 && gradientInfo2.isEquivalent(gradientInfo)) {
                    return gradientCacheEntry.gradient;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            gradientCacheEntry = gradientCacheEntry.next;
        }
        return null;
    }

    Object store(GradientInfo gradientInfo, BufferedImage bufferedImage) {
        int n2;
        GradientCacheEntry[] gradientCacheEntryArray = this.getGradients();
        GradientCacheEntry gradientCacheEntry = gradientCacheEntryArray[n2 = GradientCache.bucket(gradientInfo.length, gradientCacheEntryArray.length)];
        if (!this.entryNotInCache(gradientCacheEntry, gradientInfo)) {
            System.err.println("Duplicate entry found!");
        }
        gradientCacheEntryArray[n2] = new GradientCacheEntry(gradientInfo, bufferedImage, this.queue, gradientCacheEntry);
        if (++this.size >= this.threshold) {
            this.resize(gradientCacheEntryArray.length << 1);
        }
        return null;
    }

    void clear() {
        GradientCacheEntry[] gradientCacheEntryArray = this.getGradients();
        for (int i2 = 0; i2 < gradientCacheEntryArray.length; ++i2) {
            gradientCacheEntryArray[i2] = null;
        }
        this.size = 0;
        this.threshold = 16;
        this.gradients = new GradientCacheEntry[16];
    }

    private boolean entryNotInCache(GradientCacheEntry gradientCacheEntry, GradientInfo gradientInfo) {
        while (gradientCacheEntry != null && gradientCacheEntry.getInfo() != null) {
            if (gradientCacheEntry.length == gradientInfo.length && gradientCacheEntry.getInfo().isEquivalent(gradientInfo)) {
                return false;
            }
            gradientCacheEntry = gradientCacheEntry.next;
        }
        return true;
    }

    private void resize(int n2) {
        GradientCacheEntry[] gradientCacheEntryArray = this.getGradients();
        int n3 = gradientCacheEntryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        GradientCacheEntry[] gradientCacheEntryArray2 = new GradientCacheEntry[n2];
        this.moveEntries(gradientCacheEntryArray, gradientCacheEntryArray2);
        this.gradients = gradientCacheEntryArray2;
        if (this.size >= this.threshold >> 1) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.cleanOldCacheEntries();
            this.moveEntries(gradientCacheEntryArray2, gradientCacheEntryArray);
            this.gradients = gradientCacheEntryArray;
        }
    }

    private GradientCacheEntry[] getGradients() {
        this.cleanOldCacheEntries();
        return this.gradients;
    }

    private static int bucket(int n2, int n3) {
        return n2 & n3 - 1;
    }

    private void moveEntries(GradientCacheEntry[] gradientCacheEntryArray, GradientCacheEntry[] gradientCacheEntryArray2) {
        for (int i2 = 0; i2 < gradientCacheEntryArray.length; ++i2) {
            GradientCacheEntry gradientCacheEntry = gradientCacheEntryArray[i2];
            gradientCacheEntryArray[i2] = null;
            while (gradientCacheEntry != null) {
                GradientCacheEntry gradientCacheEntry2 = gradientCacheEntry.next;
                Object t = gradientCacheEntry.get();
                if (t == null) {
                    gradientCacheEntry.next = null;
                    gradientCacheEntry.gradient = null;
                    --this.size;
                } else {
                    int n2 = GradientCache.bucket(gradientCacheEntry.length, gradientCacheEntryArray2.length);
                    gradientCacheEntry.next = gradientCacheEntryArray2[n2];
                    gradientCacheEntryArray2[n2] = gradientCacheEntry;
                }
                gradientCacheEntry = gradientCacheEntry2;
            }
        }
    }

    private void cleanOldCacheEntries() {
        GradientCacheEntry gradientCacheEntry;
        block0: while ((gradientCacheEntry = (GradientCacheEntry)this.queue.poll()) != null) {
            GradientCacheEntry gradientCacheEntry2;
            int n2 = GradientCache.bucket(gradientCacheEntry.length, this.gradients.length);
            GradientCacheEntry gradientCacheEntry3 = gradientCacheEntry2 = this.gradients[n2];
            while (gradientCacheEntry3 != null) {
                GradientCacheEntry gradientCacheEntry4 = gradientCacheEntry3.next;
                if (gradientCacheEntry3 == gradientCacheEntry) {
                    if (gradientCacheEntry2 == gradientCacheEntry) {
                        this.gradients[n2] = gradientCacheEntry4;
                    } else {
                        gradientCacheEntry2.next = gradientCacheEntry4;
                    }
                    gradientCacheEntry.next = null;
                    gradientCacheEntry.gradient = null;
                    --this.size;
                    continue block0;
                }
                gradientCacheEntry2 = gradientCacheEntry3;
                gradientCacheEntry3 = gradientCacheEntry4;
            }
        }
    }
}

