/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.lang.reflect.Method;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class RangeSlider
extends JSlider {
    private static final String uiClassID = "RangeSliderUI";
    private boolean _rangeDraggable = true;
    public static final String CLIENT_PROPERTY_MOUSE_POSITION = "RangeSlider.mousePosition";
    public static final String CLIENT_PROPERTY_ADJUST_ACTION = "RangeSlider.adjustAction";
    public static final String PROPERTY_LOW_VALUE = "lowValue";
    public static final String PROPERTY_HIGH_VALUE = "highValue";

    public RangeSlider() {
    }

    public RangeSlider(int n2) {
        super(n2);
    }

    public RangeSlider(int n2, int n3) {
        super(n2, n3);
    }

    public RangeSlider(int n2, int n3, int n4, int n5) {
        super(new DefaultBoundedRangeModel(n4, n5 - n4, n2, n3));
        this.getModel().removeChangeListener(this.changeListener);
        this.getModel().removeChangeListener(this.changeListener);
        this.getModel().addChangeListener(this.changeListener);
    }

    public String getActualUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(this.getActualUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            Class<?> clazz = Class.forName(UIManager.getString(this.getActualUIClassID()));
            Class<JComponent> clazz2 = JComponent.class;
            Method method = clazz.getMethod("createUI", clazz2);
            if (method != null) {
                Object object = method.invoke(null, this);
                this.setUI((ComponentUI)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getLowValue() {
        return this.getModel().getValue();
    }

    public int getHighValue() {
        return this.getModel().getValue() + this.getModel().getExtent();
    }

    public boolean contains(int n2) {
        return n2 >= this.getLowValue() && n2 <= this.getHighValue();
    }

    public void setValue(int n2) {
        Object object = this.getClientProperty(CLIENT_PROPERTY_MOUSE_POSITION);
        if (object != null) {
            if (Boolean.TRUE.equals(object)) {
                this.setLowValue(n2);
            } else {
                this.setHighValue(n2);
            }
        } else {
            this.setLowValue(n2);
        }
    }

    public void setLowValue(int n2) {
        int n3 = this.getLowValue();
        int n4 = n2 + this.getModel().getExtent() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        int n5 = n4 - n2;
        Object object = this.getClientProperty(CLIENT_PROPERTY_ADJUST_ACTION);
        this.getModel().setRangeProperties(n2, n5, this.getMinimum(), this.getMaximum(), object == null || !object.equals("scrollByBlock") && !object.equals("scrollByUnit"));
        this.firePropertyChange(PROPERTY_LOW_VALUE, n3, this.getLowValue());
    }

    public void setHighValue(int n2) {
        int n3 = this.getHighValue();
        this.getModel().setExtent(n2 - this.getLowValue());
        this.firePropertyChange(PROPERTY_HIGH_VALUE, n3, this.getHighValue());
    }

    public boolean isRangeDraggable() {
        return this._rangeDraggable;
    }

    public void setRangeDraggable(boolean bl) {
        this._rangeDraggable = bl;
    }
}

