/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class TristateCheckBox
extends JCheckBox
implements ActionListener {
    public static final int STATE_UNSELECTED = 0;
    public static final int STATE_SELECTED = 1;
    public static final int STATE_MIXED = 2;

    public TristateCheckBox(String string, Icon icon) {
        super(string, icon);
    }

    public TristateCheckBox(String string) {
        this(string, null);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    protected void init(String string, Icon icon) {
        this.model = this.createButtonModel();
        this.setModel(this.model);
        this.addActionListener(this);
        super.init(string, icon);
    }

    protected ButtonModel createButtonModel() {
        return new TristateButtonModel();
    }

    public void updateUI() {
        super.updateUI();
        if (this.isMixed()) {
            this.adjustMixedIcon();
        } else {
            this.restoreMixedIcon();
        }
    }

    protected void adjustMixedIcon() {
        this.setIcon(UIManager.getIcon("TristateCheckBox.icon"));
    }

    protected void restoreMixedIcon() {
        this.setIcon(null);
    }

    public boolean isMixed() {
        return this.getState() == 2;
    }

    public void setMixed(boolean bl) {
        if (bl) {
            this.setState(2);
        } else {
            this.setState(0);
        }
    }

    public int getState() {
        if (this.model instanceof TristateButtonModel) {
            return ((TristateButtonModel)this.model).getState();
        }
        throw new IllegalStateException("TristateButtonModel is required for TristateCheckBox");
    }

    public void setState(int n2) {
        if (this.model instanceof TristateButtonModel) {
            int n3 = ((TristateButtonModel)this.model).getState();
            if (n3 != n2) {
                ((TristateButtonModel)this.model).setState(n2);
            }
        } else {
            throw new IllegalStateException("TristateButtonModel is required for TristateCheckBox");
        }
        this.stateUpdated(n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.stateUpdated(this.getState());
    }

    protected void stateUpdated(int n2) {
        if (n2 == 2) {
            String string;
            this.adjustMixedIcon();
            Object object = UIDefaultsLookup.get("TristateCheckBox.setMixed.clientProperty");
            if (object != null) {
                this.putClientProperty(((Object[])object)[0], ((Object[])object)[1]);
            }
            if ((string = UIDefaultsLookup.getString("TristateCheckBox.setMixed.componentName")) != null) {
                this.setName(string);
            }
        } else {
            String string;
            this.restoreMixedIcon();
            Object object = UIDefaultsLookup.get("TristateCheckBox.clearMixed.clientProperty");
            if (object != null) {
                this.putClientProperty(((Object[])object)[0], ((Object[])object)[1]);
            }
            if ((string = UIDefaultsLookup.getString("TristateCheckBox.clearMixed.componentName")) != null) {
                this.setName(string);
            }
        }
    }
}

