/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigDecimalMathUtils {
    public static final BigDecimal TWO = BigDecimal.valueOf(2L);

    protected BigDecimalMathUtils() {
    }

    public static BigDecimal sum(List<BigDecimal> list) {
        BigDecimal bigDecimal = new BigDecimal(0);
        for (BigDecimal bigDecimal2 : list) {
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return bigDecimal;
    }

    public static BigDecimal mean(List<BigDecimal> list, MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimalMathUtils.sum(list);
        return bigDecimal.divide(new BigDecimal(list.size()), mathContext);
    }

    public static BigDecimal min(List<BigDecimal> list) {
        return new TreeSet<BigDecimal>(list).first();
    }

    public static BigDecimal max(List<BigDecimal> list) {
        return new TreeSet<BigDecimal>(list).last();
    }

    public static BigDecimal stddev(List<BigDecimal> list, boolean bl, MathContext mathContext) {
        int n2 = list.size();
        BigDecimal bigDecimal = n2 > 0 ? (n2 > 1 ? BigDecimalMathUtils.sqrt(BigDecimalMathUtils.var(list, bl, mathContext)) : BigDecimal.ZERO) : BigDecimal.valueOf(Double.NaN);
        return bigDecimal;
    }

    public static BigDecimal var(List<BigDecimal> list, boolean bl, MathContext mathContext) {
        int n2 = list.size();
        if (n2 == 0) {
            return BigDecimal.valueOf(Double.NaN);
        }
        if (n2 == 1) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = BigDecimalMathUtils.mean(list, mathContext);
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        for (BigDecimal bigDecimal2 : list) {
            BigDecimal bigDecimal3 = bigDecimal2.subtract(bigDecimal);
            arrayList.add(bigDecimal3.pow(2, mathContext));
        }
        BigDecimal bigDecimal4 = BigDecimalMathUtils.sum(arrayList);
        return bigDecimal4.divide(new BigDecimal(bl ? list.size() - 1 : list.size()), mathContext);
    }

    public static BigDecimal sqrt(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = null;
        int n2 = bigDecimal.precision();
        MathContext mathContext = new MathContext(n2, RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = bigDecimal;
        double d2 = bigDecimal6.doubleValue();
        if (mathContext.getPrecision() == 0) {
            throw new IllegalArgumentException("\nRoots need a MathContext precision > 0");
        }
        if (d2 < 0.0) {
            throw new ArithmeticException("\nCannot calculate the square root of a negative number");
        }
        if (d2 == 0.0) {
            return bigDecimal.round(mathContext);
        }
        if (mathContext.getPrecision() < 50) {
            n2 += 10;
        }
        int n3 = 1;
        if (d2 == Double.POSITIVE_INFINITY) {
            BigInteger bigInteger = bigDecimal6.unscaledValue();
            int n4 = bigInteger.bitLength();
            int n5 = n4 / 2;
            bigInteger = bigInteger.shiftRight(n5);
            bigDecimal3 = new BigDecimal(bigInteger);
            MathContext mathContext2 = new MathContext(5, RoundingMode.HALF_DOWN);
            n2 += 10;
            bigDecimal2 = BigDecimal.ONE.divide(TWO.multiply(bigDecimal3, mathContext2), mathContext2);
        } else {
            double d3 = Math.sqrt(d2);
            bigDecimal3 = new BigDecimal(Double.valueOf(d3).toString());
            bigDecimal2 = new BigDecimal(Double.valueOf(0.5 / d3).toString());
            n3 = 64;
        }
        int n6 = mathContext.getPrecision() + n2;
        MathContext mathContext3 = new MathContext(n3, mathContext.getRoundingMode());
        return BigDecimalMathUtils.sqrtProcedure(mathContext3, n6, bigDecimal6, bigDecimal3, bigDecimal2, bigDecimal4, bigDecimal5);
    }

    private static BigDecimal sqrtProcedure(MathContext mathContext, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        bigDecimal4 = BigDecimal.ONE.subtract(TWO.multiply(bigDecimal2, mathContext).multiply(bigDecimal3, mathContext), mathContext);
        bigDecimal3 = bigDecimal3.add(bigDecimal4.multiply(bigDecimal3, mathContext), mathContext);
        bigDecimal5 = bigDecimal.subtract(bigDecimal2.multiply(bigDecimal2, mathContext), mathContext);
        bigDecimal2 = bigDecimal2.add(bigDecimal5.multiply(bigDecimal3, mathContext), mathContext);
        int n3 = mathContext.getPrecision();
        n3 = n3 < 2 ? ++n3 : n3 * 2 - 1;
        if (n3 < 2 * n2) {
            mathContext = new MathContext(n3, mathContext.getRoundingMode());
            BigDecimalMathUtils.sqrtProcedure(mathContext, n2, bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4, bigDecimal5);
        }
        return bigDecimal2;
    }

    public static void main(String[] stringArray) {
        System.out.println(BigDecimalMathUtils.sqrt(new BigDecimal("25029.33333")));
    }
}

