/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 3835017332487313880L;
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;
    private boolean _isDirty = false;

    public CachedArrayList() {
    }

    public CachedArrayList(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedArrayList(int n2) {
        super(n2);
    }

    @Override
    public int indexOf(Object object) {
        Integer n2;
        if (this._indexCache == null || this._isDirty) {
            this.cacheAll();
        }
        if ((n2 = this._indexCache.get(object)) != null) {
            return n2;
        }
        if (this.isLazyCaching()) {
            int n3 = super.indexOf(object);
            if (n3 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n3);
            }
            return n3;
        }
        return -1;
    }

    @Deprecated
    protected synchronized void adjustCache(int n2, int n3) {
        if (this._indexCache != null) {
            Map<Object, Integer> map = this.createCache();
            Set<Object> set = this._indexCache.keySet();
            for (Object object : set) {
                int n4 = this._indexCache.get(object);
                if (n4 >= n2) {
                    map.put(object, n4 + n3);
                    continue;
                }
                map.put(object, n4);
            }
            this._indexCache = map;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public void cacheIt(Object object, int n2) {
        if (this._indexCache != null) {
            Integer n3 = this._indexCache.put(object, n2);
            if (n3 != null && n3 < n2) {
                this._indexCache.put(object, n3);
            }
            this.markDirtyIfNecessary(n2);
            if (!this._isDirty && !this.isLazyCaching()) {
                for (int i2 = this.size() - 1; i2 > n2; --i2) {
                    Integer n4 = this._indexCache.put(this.get(i2), i2);
                    if (n4 == null || n4 >= n2) continue;
                    this._indexCache.put(this.get(i2), n4);
                }
            }
        }
    }

    protected void markDirtyIfNecessary(int n2) {
        if (n2 < this.size() / 2) {
            this._isDirty = true;
        }
    }

    public void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    @Override
    public boolean add(E e2) {
        boolean bl = super.add(e2);
        if (!this.isLazyCaching() && this._indexCache != null && bl) {
            this.cacheIt(e2, this.size() - 1);
        }
        return bl;
    }

    @Override
    public void add(int n2, E e2) {
        if (n2 == this.size()) {
            this.add(e2);
            return;
        }
        super.add(n2, e2);
        if (!this.isLazyCaching()) {
            this.cacheIt(e2, n2);
        } else if (this._indexCache != null) {
            this.cacheIt(e2, n2);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int n2) {
        Object e2 = super.remove(n2);
        if (e2 != null) {
            this.uncacheAll();
        }
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheAll();
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int n2 = this.size();
        boolean bl = super.addAll(collection);
        if (bl && this._indexCache != null) {
            for (E e2 : collection) {
                this.cacheIt(e2, n2++);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 == this.size()) {
            return this.addAll(collection);
        }
        boolean bl = super.addAll(n2, collection);
        if (bl) {
            this.uncacheAll();
        }
        return bl;
    }

    @Override
    public E set(int n2, E e2) {
        if (!this.isLazyCaching()) {
            this.uncacheAll();
            return super.set(n2, e2);
        }
        return super.set(n2, e2);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public void cacheAll() {
        this._indexCache = this.createCache();
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            this._indexCache.put(this.get(i2), i2);
        }
        this._isDirty = false;
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean bl) {
        this._lazyCaching = bl;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        if (n2 == n3) {
            this.remove(n2);
        } else {
            super.removeRange(n2, n3);
            this.uncacheAll();
        }
    }
}

