/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    T4CConnection physicalConn;
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int[] errorNumber;
    private String password;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:43_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CXAResource(T4CConnection t4CConnection, OracleXAConnection oracleXAConnection, boolean bl) throws XAException {
        super(t4CConnection, oracleXAConnection);
        this.physicalConn = t4CConnection;
        this.isTransLoose = bl;
        this.errorNumber = new int[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doStart(Xid xid, int n2) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n3;
            block15: {
                int n4;
                n3 = -1;
                if (this.isTransLoose) {
                    n2 |= 0x10000;
                }
                if ((n4 = n2 & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                    return 0;
                }
                this.applicationValueArr[0] = 0;
                try {
                    try {
                        T4CTTIOtxse t4CTTIOtxse = this.physicalConn.otxse;
                        byte[] byArray = null;
                        byte[] byArray2 = xid.getGlobalTransactionId();
                        byte[] byArray3 = xid.getBranchQualifier();
                        int n5 = 0;
                        int n6 = 0;
                        if (byArray2 != null && byArray3 != null) {
                            n5 = Math.min(byArray2.length, 64);
                            n6 = Math.min(byArray3.length, 64);
                            byArray = new byte[128];
                            System.arraycopy(byArray2, 0, byArray, 0, n5);
                            System.arraycopy(byArray3, 0, byArray, n5, n6);
                        }
                        int n7 = 0;
                        n7 = (n2 & 0x200000) != 0 || (n2 & 0x8000000) != 0 ? (n7 |= 4) : (n7 |= 1);
                        if ((n2 & 0x100) != 0) {
                            n7 |= 0x100;
                        }
                        if ((n2 & 0x200) != 0) {
                            n7 |= 0x200;
                        }
                        if ((n2 & 0x400) != 0) {
                            n7 |= 0x400;
                        }
                        if ((n2 & 0x10000) != 0) {
                            n7 |= 0x10000;
                        }
                        this.physicalConn.needLine();
                        this.physicalConn.sendPiggyBackedMessages();
                        t4CTTIOtxse.marshal(1, null, byArray, xid.getFormatId(), n5, n6, this.timeout, n7, this.applicationValueArr);
                        this.applicationValueArr[0] = 0;
                        byte[] byArray4 = t4CTTIOtxse.receive(this.applicationValueArr);
                        if (byArray4 != null) {
                            this.context = byArray4;
                        }
                        n3 = 0;
                    }
                    catch (IOException iOException) {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    }
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block15;
                    throw new XAException(-6);
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n3;
            block14: {
                n3 = -1;
                try {
                    try {
                        T4CTTIOtxse t4CTTIOtxse = this.physicalConn.otxse;
                        byte[] byArray = null;
                        byte[] byArray2 = xid.getGlobalTransactionId();
                        byte[] byArray3 = xid.getBranchQualifier();
                        int n4 = 0;
                        int n5 = 0;
                        if (byArray2 != null && byArray3 != null) {
                            n4 = Math.min(byArray2.length, 64);
                            n5 = Math.min(byArray3.length, 64);
                            byArray = new byte[128];
                            System.arraycopy(byArray2, 0, byArray, 0, n4);
                            System.arraycopy(byArray3, 0, byArray, n4, n5);
                        }
                        if (this.context == null && (n3 = this.doStart(xid, 0x8000000)) != 0) {
                            return n3;
                        }
                        byte[] byArray4 = this.context;
                        int n6 = 0;
                        if ((n2 & 2) == 2) {
                            n6 = 0x100000;
                        } else if ((n2 & 0x2000000) == 0x2000000 && (n2 & 0x100000) != 0x100000) {
                            n6 = 0x100000;
                            if (!bl) {
                                this.applicationValueArr[0] = 65536;
                            }
                        }
                        this.physicalConn.needLine();
                        this.physicalConn.sendPiggyBackedMessages();
                        t4CTTIOtxse.marshal(2, byArray4, byArray, xid.getFormatId(), n4, n5, this.timeout, n6, this.applicationValueArr);
                        this.applicationValueArr[0] = 0;
                        byte[] byArray5 = t4CTTIOtxse.receive(this.applicationValueArr);
                        if (byArray5 != null) {
                            this.context = byArray5;
                        }
                        n3 = 0;
                    }
                    catch (IOException iOException) {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    }
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block14;
                    throw new XAException(-6);
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doCommit(Xid xid, int n2) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n3 = -1;
            int n4 = n2 == 1 ? 4 : 2;
            n3 = this.doTransaction(xid, 1, n4);
            if (n2 == 1 && (n3 == 2 || n3 == 4)) {
                n3 = 0;
            } else if (n2 != 1 && n3 == 5) {
                n3 = 0;
            } else if (n3 == 8) {
                throw new XAException(106);
            }
            if (n3 == 24756) {
                n3 = this.kputxrec(xid, 1, this.timeout + 120);
            } else if (n3 == 24780) {
                OracleXADataSource oracleXADataSource = null;
                PooledConnection pooledConnection = null;
                try {
                    oracleXADataSource = new OracleXADataSource();
                    oracleXADataSource.setURL(this.physicalConn.url);
                    oracleXADataSource.setUser(this.physicalConn.userName);
                    this.physicalConn.getPasswordInternal(this);
                    oracleXADataSource.setPassword(this.password);
                    pooledConnection = oracleXADataSource.getXAConnection();
                    XAResource xAResource = pooledConnection.getXAResource();
                    xAResource.commit(xid, n2 == 1);
                    n3 = 0;
                }
                catch (SQLException sQLException) {
                    throw new XAException(-6);
                }
                finally {
                    try {
                        if (pooledConnection != null) {
                            pooledConnection.close();
                        }
                        if (oracleXADataSource != null) {
                            oracleXADataSource.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doPrepare(Xid xid) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2 = -1;
            n2 = this.doTransaction(xid, 3, 0);
            if (n2 == 8) {
                throw new XAException(106);
            }
            if (n2 == 4) {
                n2 = 24767;
            } else if (n2 == 1) {
                n2 = 0;
            } else if (n2 == 3) {
                n2 = 24761;
            } else {
                switch (n2) {
                    case 2054: 
                    case 2056: 
                    case 2091: 
                    case 2092: 
                    case 24756: 
                    case 24761: 
                    case 24767: 
                    case 24775: {
                        break;
                    }
                    case 25351: {
                        n2 = 17448;
                        break;
                    }
                    default: {
                        n2 = 24768;
                    }
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doForget(Xid xid) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2 = -1;
            if (OracleXid.isLocalTransaction(xid)) {
                return 24771;
            }
            int n3 = this.doStart(xid, 0x8000000);
            if (n3 == 24756) return this.kputxrec(xid, 4, 1);
            if (n3 == 0) {
                try {
                    this.doEnd(xid, 0, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n3 == 0) return 24769;
            if (n3 == 2079) return 24769;
            if (n3 == 24754) return 24769;
            if (n3 == 24761) return 24769;
            if (n3 == 24774) return 24769;
            if (n3 == 24776) return 24769;
            if (n3 == 25351) {
                return 24769;
            }
            if (n3 != 24752) return n3;
            return 24771;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRollback(Xid xid) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2 = -1;
            n2 = this.doTransaction(xid, 2, 3);
            if (n2 == 8) {
                throw new XAException(106);
            }
            if (n2 == 3 || n2 == 25402) {
                n2 = 0;
            }
            if (n2 == 24756) {
                n2 = this.kputxrec(xid, 2, this.timeout + 120);
            } else if (n2 == 24780) {
                OracleXADataSource oracleXADataSource = null;
                PooledConnection pooledConnection = null;
                try {
                    oracleXADataSource = new OracleXADataSource();
                    oracleXADataSource.setURL(this.physicalConn.url);
                    oracleXADataSource.setUser(this.physicalConn.userName);
                    this.physicalConn.getPasswordInternal(this);
                    oracleXADataSource.setPassword(this.password);
                    pooledConnection = oracleXADataSource.getXAConnection();
                    XAResource xAResource = pooledConnection.getXAResource();
                    xAResource.rollback(xid);
                    n2 = 0;
                }
                catch (SQLException sQLException) {
                    throw new XAException(-6);
                }
                finally {
                    try {
                        if (pooledConnection != null) {
                            pooledConnection.close();
                        }
                        if (oracleXADataSource != null) {
                            oracleXADataSource.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return n2;
        }
    }

    int doTransaction(Xid xid, int n2, int n3) throws XAException {
        int n4 = -1;
        try {
            try {
                T4CTTIOtxen t4CTTIOtxen = this.physicalConn.otxen;
                byte[] byArray = null;
                byte[] byArray2 = xid.getGlobalTransactionId();
                byte[] byArray3 = xid.getBranchQualifier();
                int n5 = 0;
                int n6 = 0;
                if (byArray2 != null && byArray3 != null) {
                    n5 = Math.min(byArray2.length, 64);
                    n6 = Math.min(byArray3.length, 64);
                    byArray = new byte[128];
                    System.arraycopy(byArray2, 0, byArray, 0, n5);
                    System.arraycopy(byArray3, 0, byArray, n5, n6);
                }
                byte[] byArray4 = this.context;
                this.physicalConn.needLine();
                this.physicalConn.sendPiggyBackedMessages();
                t4CTTIOtxen.marshal(n2, byArray4, byArray, xid.getFormatId(), n5, n6, this.timeout, n3, 0);
                n4 = t4CTTIOtxen.receive(this.errorNumber);
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        catch (SQLException sQLException) {
            this.errorNumber[0] = sQLException.getErrorCode();
        }
        if (this.errorNumber[0] == 0) {
            throw new XAException(-6);
        }
        if (n4 == -1) {
            n4 = this.errorNumber[0];
        }
        return n4;
    }

    protected int kputxrec(Xid xid, int n2, int n3) throws XAException {
        Object object;
        int n4;
        int n5;
        int n6 = 0;
        switch (n2) {
            case 1: {
                n5 = 3;
                break;
            }
            case 4: {
                n5 = 2;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        int n7 = 0;
        while (n3-- > 0 && (n7 = this.doTransaction(xid, 5, n5)) == 7) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (n7 == 7) {
            return 24763;
        }
        if (n7 == 24756) {
            return 24756;
        }
        switch (n7) {
            case 3: {
                if (n2 == 1) {
                    n4 = 7;
                    break;
                }
                n4 = 8;
                n6 = -24762;
                break;
            }
            case 0: {
                if (n2 == 4) {
                    n4 = 8;
                    n6 = 24762;
                    break;
                }
                n4 = 7;
                n6 = n2 == 1 ? 24756 : 0;
                break;
            }
            case 2: {
                if (n2 == 4) {
                    n4 = 8;
                    n6 = 24770;
                    break;
                }
            }
            default: {
                object = new int[1];
                n6 = this.kpuho2oc(n7, (int[])object);
                if (n2 == 4 && object[0] == 1) {
                    n4 = 7;
                    n6 = 0;
                    break;
                }
                n4 = 8;
            }
        }
        object = this.physicalConn.k2rpc;
        try {
            ((T4CTTIk2rpc)object).marshal(3, n4);
            ((T4CTTIk2rpc)object).receive();
        }
        catch (IOException iOException) {
            throw new XAException(-7);
        }
        catch (SQLException sQLException) {
            throw new XAException(-6);
        }
        return n6;
    }

    int kpuho2oc(int n2, int[] nArray) {
        int n3 = 0;
        switch (n2) {
            case 5: {
                nArray[0] = 1;
                n3 = 24764;
                break;
            }
            case 4: {
                nArray[0] = 1;
                n3 = 24765;
                break;
            }
            case 6: {
                nArray[0] = 1;
                n3 = 24766;
                break;
            }
            default: {
                n3 = 24762;
            }
        }
        return n3;
    }

    final void setPasswordInternal(String string) {
        this.password = string;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.physicalConn;
    }
}

