/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.xdb.RealInputStream;
import oracle.xdb.SoftHashMap;
import oracle.xdb.XDBError;
import oracle.xdb.XMLTypeFactory;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBResource;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLMetadataProviderFactory;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLProcessorFactory;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.DBBinXMLMetadataProvider;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLSAXSerializer;
import oracle.xml.scalable.InfosetReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLType
extends OPAQUE
implements ORAData {
    public static final int _SQL_TYPECODE = 2007;
    public static final String _SQL_NAME = "SYS.XMLTYPE";
    public static final int CONNTYPE_THIN = 0;
    public static final int CONNTYPE_OCI8 = 1;
    public static final int CONNTYPE_KPRB = 2;
    public static final int DEF_INDENT = 2;
    public static final int MAX_INDENT = 12;
    public static final int MAX_PFLAG = 7;
    public static final int PRINT_DEFAULT_PROPERTY = 1;
    public static final int PRINT_PRETTY = 2;
    public static final int PRINT_NOPRETTY = 4;
    private static final int PRINT_SESSION = 8;
    private static final int PRINT_OPERATION = 16;
    private static final int LOBTYPE_BLOB = 1;
    private static final int NCONN_REUSE_CSX_PROC = 10;
    int m_conntype;
    long m_gpCState = 0L;
    String m_stringval = null;
    ByteArrayOutputStream m_bytesval = null;
    CLOB m_clobval = null;
    BLOB m_blobval = null;
    byte[] m_bytes = null;
    QName m_qname = null;
    long m_cstate = 0L;
    OracleConnection m_local_conn;
    Document m_dom = null;
    CharacterSet m_charSet = CharacterSet.make((int)-1);
    private boolean m_isClosed = false;
    private static boolean m_libLoaded = false;
    private int m_csid = 0;
    private CharacterSet m_blobCS = null;
    String m_kind;
    private boolean m_isCSX = false;
    private boolean m_isXQDM = false;
    Object m_metadataconn = null;
    String m_CSXencoding = null;
    protected boolean m_isReadOnly = false;
    private static final XMLTypeFactory xmlfactory = new XMLTypeFactory();
    private boolean m_scalable = true;
    private boolean m_chunkmode = true;
    private String m_schemaURL = null;
    private static SoftHashMap m_binxmlprocs = null;
    private static boolean m_sharebinproc = true;
    private int m_thinflags;
    private byte[] m_thinsnapshot;
    private byte[] m_thinschoid;
    private byte[] m_thinelemnum;
    private byte[] m_guid;
    private int m_picklepref = 0;
    static final int XMLTYPE_VERSION = 1;
    static final int XMLTYPE_LOB = 1;
    static final int XMLTYPE_STR = 4;
    static final int XMLTYPE_PTR = 8;
    static final int XMLTYPE_CSX = 0x1000000;
    static final int XMLTYPE_XQ_SEQ_DMFMT = 524288;
    static final int XMLTYPE_FLAG_SKIP_NEXT_4 = 0x100000;
    static final int XMLTYPE_FLAG_SNAPSHOT = 4096;
    static final int XMLTYPE_FLAG_SCHMOID = 8;
    static final int XMLTYPE_FLAG_NO_DOC_WRAP = 0x400000;
    static final int XMLTYPE_FLAG_FRAGMENT = 32;
    static final int XMLTYPE_FLAG_NOXMLHDR = 1024;
    static final int XMLTYPE_FLAG_GUID = 0x20000000;
    static final int XMLTYPE_SCHMOIDLEN = 16;
    static final int XMLTYPE_ELEMNUMLEN = 4;
    static final int XMLTYPE_KOSNPLEN = 24;
    static final int XMLTYPE_GUIDLEN = 16;
    public static final int XMLTYPE_PICKLE_AS_TEXT = 0;
    public static final int XMLTYPE_PICKLE_AS_BINXML = 1;
    static final int QMXQDM_SEQ_ITMTFLAG_LEN = 2;
    static final int QMXQDM_SEQ_ITMTYPE_LEN = 1;
    static final int QMXQDM_SEQ_ITM_SIZE = 4;
    static final int QMXQDM_ITM_FLAG_ATOMIC = 2;
    static final int QMXQDM_ITM_FLAG_NODE = 4;
    static final int QMXQDM_ITM_FLAG_ATTR = 8;
    static final int DTYCHR = 1;
    static final int QMTXT_QNAME = 19;

    private native long getXMLTypeNative(long var1, long var3, long var5, byte[] var7, int var8);

    private synchronized native byte[] pickleXMLTypeNative(long var1, long var3, long var5, long var7, int var9);

    private synchronized native byte[] getBinaryBytes(long var1, long var3, long var5, long var7);

    private synchronized native boolean isSchemaBasedNative(long var1, long var3, long var5, long var7);

    private synchronized native String getSchemaURLNative(long var1, long var3, long var5, long var7);

    private synchronized native String getRootElementNative(long var1, long var3, long var5, long var7);

    private synchronized native void schemaValidateNative(long var1, long var3, long var5, long var7);

    private synchronized native void setSchemaValidatedNative(long var1, long var3, long var5, long var7, boolean var9);

    private synchronized native boolean isSchemaValidatedNative(long var1, long var3, long var5, long var7);

    private synchronized native String getNamespaceNative(long var1, long var3, long var5, long var7);

    private synchronized native long createXMLTypeFromLobNative(long var1, long var3, long var5, byte[] var7, int var8, int var9, String var10, boolean var11, boolean var12, boolean var13);

    private synchronized native long createXMLTypeFromStringNative(long var1, long var3, long var5, String var7, String var8, boolean var9, boolean var10);

    private synchronized native long extractNative(long var1, long var3, long var5, long var7, String var9, String var10);

    private synchronized native boolean existsNodeNative(long var1, long var3, long var5, long var7, String var9, String var10);

    private synchronized native long transformNative(long var1, long var3, long var5, long var7, long var9, String var11);

    private synchronized native boolean isFragmentNative(long var1, long var3, long var5, long var7);

    private synchronized native boolean isSchemaValidNative(long var1, long var3, long var5, long var7, String var9, String var10);

    private synchronized native void printToLobNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, int var12);

    private synchronized native long getXobdFromXMLType(long var1, long var3, long var5, long var7);

    private static synchronized native long getXMLTypeFromXobd(long var0, long var2, long var4, long var6);

    private synchronized native long getInputStreamNative(long var1, long var3, long var5, long var7, int var9, int var10);

    private static synchronized native long WriteToSegStreamNative(long var0, long var2, long var4, long var6, byte[] var8, int var9, int var10, long var11);

    private synchronized native long createXMLTypeFromStreamNative(long var1, long var3, long var5, long var7, long var9);

    private synchronized native void closeNative(long var1, long var3, long var5, long var7);

    public static synchronized native long allocHeapNative(long var0, long var2, long var4);

    private synchronized native long setBinaryXMLNative(long var1, long var3, long var5, long var7);

    public static ORADataFactory getORADataFactory() {
        return xmlfactory;
    }

    public Datum toDatum(Connection conn) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        switch (this.m_conntype) {
            case 0: {
                return new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)this.getBytesValue());
            }
            case 1: 
            case 2: {
                OracleConnection iconn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                byte[] bval = this.getBytesPtr(iconn);
                OPAQUE opq = new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)iconn), (Connection)iconn, (Object)bval);
                return opq;
            }
        }
        return null;
    }

    public void setPicklePreference(int pref) {
        this.m_picklepref = pref;
    }

    public void setMetadataConn(Object metaconn) {
        this.m_metadataconn = metaconn;
    }

    public void setBinaryXML() throws SQLException {
        if (this.m_conntype != 0) {
            this.m_cstate = this.setBinaryXMLNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        }
        this.m_isCSX = true;
        this.m_picklepref = 1;
    }

    public void setChunkMode(boolean mode) {
        this.m_chunkmode = mode;
    }

    public void setScalableDOM(boolean mode) {
        this.m_scalable = mode;
    }

    public long toCState() {
        return this.m_cstate;
    }

    public static XMLType createXML(OPAQUE opq) throws SQLException {
        return XMLType.createXML(opq, null);
    }

    public static XMLType createXML(OPAQUE opq, String kind) throws SQLException {
        String opqname = opq.getSQLTypeName();
        String[] schema = new String[1];
        String[] typename = new String[1];
        SQLName.setHandleDoubleQuote((boolean)true);
        SQLName.parse((String)opqname, (String[])schema, (String[])typename);
        if (typename[0].compareTo("XMLTYPE") != 0) {
            return null;
        }
        return new XMLType(opq.getDescriptor(), opq.getJavaSqlConnection(), opq.getBytesValue(), kind);
    }

    public XMLType(Connection conn, String xmlval) throws SQLException {
        this(conn, xmlval, null);
    }

    public XMLType(Connection conn, String xmlval, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (xmlval == null) {
            return;
        }
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.m_stringval = xmlval;
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval, null, false, false);
            }
            catch (UnsatisfiedLinkError e) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_stringval = xmlval;
            }
        }
    }

    public XMLType(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        this(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public XMLType(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (xmlval == null) {
            return;
        }
        this.m_schemaURL = schemaURL;
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.m_stringval = xmlval;
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval, schemaURL, wellformed, valid);
            }
            catch (UnsatisfiedLinkError e) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_stringval = xmlval;
            }
        }
    }

    public static XMLType createXML(Connection conn, String xmlval) throws SQLException {
        return XMLType.createXML(conn, xmlval, null);
    }

    public static XMLType createXML(Connection conn, String xmlval, String kind) throws SQLException {
        return new XMLType(conn, xmlval, kind);
    }

    public static XMLType createXML(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        return XMLType.createXML(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public static XMLType createXML(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        return new XMLType(conn, xmlval, schemaURL, wellformed, valid, kind);
    }

    public XMLType(Connection conn, CLOB xmlval) throws SQLException {
        this(conn, xmlval, null);
    }

    public XMLType(Connection conn, CLOB xmlval, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (xmlval == null) {
            return;
        }
        this.getCStateFromLocator(xmlval, true);
    }

    public XMLType(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        this(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public XMLType(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (xmlval == null) {
            return;
        }
        this.m_schemaURL = schemaURL;
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.m_clobval = xmlval;
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval.getLocator(), 0, 0, schemaURL, wellformed, valid, true);
            }
            catch (UnsatisfiedLinkError e) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_clobval = xmlval;
            }
        }
    }

    public static XMLType createXML(Connection conn, CLOB xmlval) throws SQLException {
        return XMLType.createXML(conn, xmlval, null);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval, String kind) throws SQLException {
        return new XMLType(conn, xmlval, kind);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        return XMLType.createXML(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        return new XMLType(conn, xmlval, schemaURL, wellformed, valid, kind);
    }

    public XMLType(Connection conn, BLOB xmlval, int csid) throws SQLException {
        this(conn, xmlval, csid, null);
    }

    public XMLType(Connection conn, BLOB xmlval, int csid, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        if (csid < 0 || this.m_conntype == 0 && csid == 0) {
            throw new SQLException(XDBError.getMsg("INVALID_CSID"));
        }
        this.m_csid = csid;
        this.m_blobCS = CharacterSet.make((int)this.m_csid);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (xmlval == null) {
            return;
        }
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.m_blobval = xmlval;
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval.getLocator(), csid, 1, null, false, false, true);
            }
            catch (UnsatisfiedLinkError e) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_blobval = xmlval;
            }
        }
    }

    public XMLType(Connection conn, InputStream is) throws SQLException {
        this(conn, is, null);
    }

    public XMLType(Connection conn, InputStream is, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (is == null) {
            return;
        }
        byte[] buf = new byte[1024];
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.m_bytesval = new ByteArrayOutputStream();
            try {
                int nread;
                while ((nread = is.read(buf)) != -1) {
                    this.m_bytesval.write(buf, 0, nread);
                }
            }
            catch (IOException ex) {
                throw new SQLException();
            }
        }
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                long strmHeap = XMLType.allocHeapNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle());
                long segstream = XMLType.inputToSegStream(this.m_gpCState, is, this.getSvcHandle(), this.getErrHandle(), strmHeap);
                this.m_cstate = this.createXMLTypeFromStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), segstream, strmHeap);
            }
            catch (UnsatisfiedLinkError e) {
                this.m_conntype = 0;
                this.m_bytesval = new ByteArrayOutputStream();
                try {
                    int nread;
                    while ((nread = is.read(buf)) != -1) {
                        this.m_bytesval.write(buf, 0, nread);
                    }
                }
                catch (IOException ex) {
                    throw new SQLException();
                }
            }
        }
    }

    public static XMLType createXML(Connection conn, InputStream is) throws SQLException {
        return XMLType.createXML(conn, is, null);
    }

    public static XMLType createXML(Connection conn, InputStream is, String kind) throws SQLException {
        return new XMLType(conn, is, kind);
    }

    public XMLType(OpaqueDescriptor type, Connection conn, Object value) throws SQLException {
        this(type, conn, value, null);
    }

    public XMLType(OpaqueDescriptor type, Connection conn, Object value, String kind) throws SQLException {
        super(type, conn, value == null ? (Object)new byte[1] : value);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (value == null) {
            return;
        }
        byte[] byteVal = (byte[])value;
        int bytepos = 0;
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.processThin(byteVal, bytepos);
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                this.processCState(byteVal, bytepos);
            }
            catch (UnsatisfiedLinkError e) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.processThin(byteVal, 0);
                this.m_cstate = 0L;
            }
        }
    }

    public String getStringVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_stringval != null) {
            return this.m_stringval;
        }
        if (this.m_clobval != null) {
            return this.getClobStr(this.m_clobval);
        }
        if (this.m_blobval != null) {
            String tmpstr = null;
            if (this.m_isCSX) {
                return this.getStringFromBinXMLStream();
            }
            try {
                ByteArrayOutputStream bytestrm = this.getBinaryStream(this.m_blobval);
                tmpstr = this.processString(this.m_blobCS, bytestrm.toByteArray(), 0);
                bytestrm.close();
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            return tmpstr;
        }
        if (this.m_cstate != 0L) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            byte[] locbytes = tmpclob.getLocator();
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0, 0, 2);
            String retval = this.getClobStr(tmpclob);
            CLOB.freeTemporary((CLOB)tmpclob);
            return retval;
        }
        if (this.m_bytesval != null) {
            return this.getStringFromBinaryStream();
        }
        if (this.m_dom != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            switch (this.m_conntype) {
                case 0: {
                    try {
                        Writer xmlwr = tmpclob.getCharacterOutputStream();
                        ((XMLDocument)this.m_dom).print(xmlwr);
                        xmlwr.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new SQLException();
                    }
                }
                case 1: 
                case 2: {
                    this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0, 0, 2);
                }
            }
            String tmpstr = this.getClobStr(tmpclob);
            CLOB.freeTemporary((CLOB)tmpclob);
            return tmpstr;
        }
        return null;
    }

    public String getStringVal(int pflag, int indent) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (pflag < 0 || pflag > 7 || indent < 0 || indent > 12) {
            throw new SQLException(XDBError.getMsg("INVALID_PCFG"));
        }
        if (this.m_cstate != 0L) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            byte[] locbytes = tmpclob.getLocator();
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0, pflag, indent);
            String retval = this.getClobStr(tmpclob);
            CLOB.freeTemporary((CLOB)tmpclob);
            return retval;
        }
        if (this.m_dom != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            switch (this.m_conntype) {
                case 0: {
                    throw new SQLException();
                }
                case 1: 
                case 2: {
                    this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0, pflag, indent);
                }
            }
            String tmpstr = this.getClobStr(tmpclob);
            CLOB.freeTemporary((CLOB)tmpclob);
            return tmpstr;
        }
        return null;
    }

    public CLOB getClobVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_clobval != null) {
            return this.m_clobval;
        }
        if (this.m_stringval != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            tmpclob.putString(1L, this.m_stringval);
            return tmpclob;
        }
        if (this.m_blobval != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            tmpclob.putString(1L, this.getStringVal());
            return tmpclob;
        }
        if (this.m_cstate != 0L) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0, 0, 2);
            return tmpclob;
        }
        if (this.m_bytesval != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            tmpclob.putString(1L, this.getStringFromBinaryStream());
            return tmpclob;
        }
        return null;
    }

    public CLOB getClobVal(int pflag, int indent) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (pflag < 0 || pflag > 7 || indent < 0 || indent > 12) {
            throw new SQLException(XDBError.getMsg("INVALID_PCFG"));
        }
        if (this.m_cstate != 0L) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0, pflag |= 0x10, indent);
            return tmpclob;
        }
        return null;
    }

    public BLOB getBlobVal(int csid) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (csid <= 0) {
            throw new SQLException(XDBError.getMsg("INVALID_CSID"));
        }
        if (this.m_blobval != null && this.m_csid == csid) {
            return this.m_blobval;
        }
        BLOB tmpblob = BLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
        CharacterSet dstcs = CharacterSet.make((int)csid);
        if (this.m_blobval != null) {
            ByteArrayOutputStream bytestrm = this.getBinaryStream(this.m_blobval);
            byte[] bytebuf = dstcs.convert(this.m_blobCS, bytestrm.toByteArray(), 0, bytestrm.size());
            tmpblob.putBytes(1L, bytebuf);
        } else if (this.m_bytesval != null) {
            if (this.m_csid == 0) {
                tmpblob.putBytes(1L, this.m_bytesval.toByteArray());
            } else {
                byte[] bytebuf = dstcs.convert(this.m_blobCS, this.m_bytesval.toByteArray(), 0, this.m_bytesval.size());
                tmpblob.putBytes(1L, bytebuf);
            }
        } else if (this.m_conntype == 0) {
            if (this.m_stringval == null) {
                this.m_stringval = this.getStringVal();
            }
            if (this.m_stringval != null) {
                byte[] bytebuf = dstcs.convert(this.m_stringval);
                tmpblob.putBytes(1L, bytebuf);
            }
        } else if (this.m_cstate != 0L) {
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpblob.getLocator(), csid, 0, 2);
        }
        return tmpblob;
    }

    public BLOB getBlobVal(int csid, int pflag, int indent) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (csid <= 0) {
            throw new SQLException(XDBError.getMsg("INVALID_CSID"));
        }
        if (pflag < 0 || pflag > 7 || indent < 0 || indent > 12) {
            throw new SQLException(XDBError.getMsg("INVALID_PCFG"));
        }
        BLOB tmpblob = BLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
        CharacterSet dstcs = CharacterSet.make((int)csid);
        if (this.m_cstate != 0L) {
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpblob.getLocator(), csid, pflag |= 0x10, indent);
            return tmpblob;
        }
        return null;
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long strm_c_state = this.getInputStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, 0, 2);
        return new RealInputStream(this.getErrHandle(), strm_c_state);
    }

    public InputStream getInputStream(int pflag, int indent) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (pflag < 0 || pflag > 7 || indent < 0 || indent > 12) {
            throw new SQLException(XDBError.getMsg("INVALID_PCFG"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long strm_c_state = this.getInputStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, pflag |= 0x10, indent);
        return new RealInputStream(this.getErrHandle(), strm_c_state);
    }

    public void writeToOutputStream(OutputStream os) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        InputStream is = this.getInputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new SQLException();
        }
    }

    public void writeToOutputStream(OutputStream os, int pflag, int indent) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        InputStream is = this.getInputStream(pflag, indent);
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new SQLException();
        }
    }

    public XMLType(Connection conn, Document domdoc) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (domdoc instanceof XDBDocument) {
            this.m_cstate = XMLType.getCStateFromXobd(conn, domdoc);
        } else if (domdoc instanceof XMLDocument) {
            if (((XMLDocument)domdoc).isNodeFlag(2)) {
                this.m_cstate = XMLType.getCStateFromXobd(conn, domdoc);
            } else {
                CLOB tmpclob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                try {
                    PrintWriter p = new PrintWriter(tmpclob.getCharacterOutputStream());
                    ((XMLDocument)domdoc).print(p);
                }
                catch (IOException e) {
                    throw new SQLException();
                }
                this.getCStateFromLocator(tmpclob, true);
            }
        }
    }

    public XMLType(Connection conn, Node node) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (node == null) {
            return;
        }
        if (node instanceof XDBNode) {
            this.m_cstate = XMLType.getCStateFromXob(conn, node);
        } else if (node instanceof XMLNode) {
            if (((XMLNode)node).isNodeFlag(2)) {
                this.m_cstate = XMLType.getCStateFromXob(conn, node);
            } else {
                CLOB tmpclob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                try {
                    PrintWriter p = new PrintWriter(tmpclob.getCharacterOutputStream());
                    ((XMLNode)node).print(p);
                }
                catch (IOException e) {
                    throw new SQLException();
                }
                this.getCStateFromLocator(tmpclob, false);
            }
        }
        if (this.m_conntype == 0) {
            this.m_thinflags |= 0x400000;
            this.m_thinflags |= 0x20;
            this.m_thinflags |= 0x400;
        }
    }

    public static XMLType createXML(Connection conn, Document domdoc) throws SQLException {
        XMLType xtype = null;
        if (domdoc instanceof XDBDocument) {
            long xmlcstate = XMLType.getCStateFromXobd(conn, domdoc);
            xtype = new XMLType(conn, xmlcstate);
        } else if (domdoc instanceof XMLDocument) {
            if (((XMLDocument)domdoc).isNodeFlag(2)) {
                long xmlcstate = XMLType.getCStateFromXobd(conn, domdoc);
                xtype = new XMLType(conn, xmlcstate, "oracle.xml.parser.XMLDocument.THICK");
            } else {
                CLOB tmpclob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                try {
                    PrintWriter p = new PrintWriter(tmpclob.getCharacterOutputStream());
                    ((XMLDocument)domdoc).print(p);
                }
                catch (IOException e) {
                    throw new SQLException();
                }
                xtype = XMLType.createXML(conn, tmpclob);
            }
        }
        return xtype;
    }

    private static long getCStateFromXobd(Connection conn, Document domdoc) throws SQLException {
        long gpCState = 0L;
        long svchandle = 0L;
        long errhandle = 0L;
        long m_cstate = 0L;
        long cstate = 0L;
        OracleConnection iconn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        if (iconn.getProtocolType().equals("kprb")) {
            gpCState = XDBResource.getServerEnv();
        } else {
            Properties prop = iconn.getOCIHandles();
            svchandle = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
            errhandle = Long.parseLong(prop.getProperty("OCIErrHandle"));
        }
        cstate = domdoc instanceof XDBDocument ? ((XDBDocument)domdoc).toCState() : ((XMLDocument)domdoc).xdbGetNodeId();
        m_cstate = XMLType.getXMLTypeFromXobd(gpCState, svchandle, errhandle, cstate);
        return m_cstate;
    }

    private static long getCStateFromXob(Connection conn, Node node) throws SQLException {
        long gpCState = 0L;
        long svchandle = 0L;
        long errhandle = 0L;
        long m_cstate = 0L;
        long cstate = 0L;
        OracleConnection iconn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        if (iconn.getProtocolType().equals("kprb")) {
            gpCState = XDBResource.getServerEnv();
        } else {
            Properties prop = iconn.getOCIHandles();
            svchandle = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
            errhandle = Long.parseLong(prop.getProperty("OCIErrHandle"));
        }
        cstate = node instanceof XDBNode ? ((XDBNode)node).toCState() : ((XMLNode)node).xdbGetNodeId();
        m_cstate = XMLType.getXMLTypeFromXobd(gpCState, svchandle, errhandle, cstate);
        return m_cstate;
    }

    private void getCStateFromLocator(CLOB xmlclob, boolean isdoc) throws SQLException {
        switch (this.m_conntype) {
            case 0: {
                this.m_clobval = xmlclob;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlclob.getLocator(), 0, 0, null, false, false, isdoc);
                    break;
                }
                catch (UnsatisfiedLinkError e) {
                    this.m_conntype = 0;
                    this.m_clobval = xmlclob;
                }
            }
        }
    }

    public XMLType extract(String xpath, String nsmap) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long retcstate = this.extractNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, xpath, nsmap);
        if (retcstate != 0L) {
            return new XMLType((Connection)this.m_local_conn, retcstate);
        }
        return null;
    }

    public boolean existsNode(String xpath, String nsmap) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean retval = this.existsNodeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, xpath, nsmap);
        return retval;
    }

    public XMLType transform(XMLType xsldoc, String parammap) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0 || xsldoc == null) {
            throw new SQLException();
        }
        long retcstate = this.transformNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, xsldoc.m_cstate, parammap);
        if (retcstate != 0L) {
            return new XMLType((Connection)this.m_local_conn, retcstate);
        }
        return null;
    }

    public boolean isFragment() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean retval = this.isFragmentNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        return retval;
    }

    public XDBDocFragment getDocumentFragment() throws SQLException {
        XDBDocFragment fragment = null;
        switch (this.m_conntype) {
            case 1: 
            case 2: {
                if (this.isFragment()) {
                    XDBDocument d = (XDBDocument)this.getDOM();
                    fragment = new XDBDocFragment(d, this.m_cstate);
                    break;
                }
                throw new SQLException();
            }
            default: {
                throw new SQLException();
            }
        }
        return fragment;
    }

    public boolean isSchemaValid(String schurl, String elname) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean retval = this.isSchemaValidNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, schurl, elname);
        return retval;
    }

    public XMLType createSchemaBasedXML(String schemaURL) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return new XMLType((Connection)this.m_local_conn, this.getClobVal(), schemaURL, false, false);
    }

    public String getRootElement() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getRootElementNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    public String getSchemaURL() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getSchemaURLNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    public boolean isSchemaBased() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaBasedNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    public String getNamespace() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getNamespaceNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    public void schemaValidate() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.schemaValidateNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    public boolean isSchemaValidated() throws SQLException {
        boolean validated = false;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaValidatedNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    public void setSchemaValidated(boolean validateFlag) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.setSchemaValidatedNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, validateFlag);
    }

    public NUMBER getNumberVal() throws SQLException {
        NUMBER result = null;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        String strValue = this.getStringVal();
        result = NUMBER.formattedTextToNumber((String)strValue, null, null);
        return result;
    }

    public Document getDOM() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        switch (this.m_conntype) {
            case 0: {
                if (this.m_scalable && this.m_isCSX && (this.m_blobval != null || this.m_bytesval != null)) {
                    try {
                        BinXMLStream bxmlstr = this.getBinXMLStreamInt();
                        BinXMLDecoder dec = bxmlstr.getDecoder();
                        InfosetReader reader = dec.getReader();
                        XMLDOMImplementation domimpl = new XMLDOMImplementation();
                        domimpl.setAttribute("oracle.xml.parser.XMLDocument.SCALABLE_DOM", (Object)Boolean.TRUE);
                        this.m_dom = domimpl.createDocument(reader);
                        return this.m_dom;
                    }
                    catch (Exception e) {
                        throw new SQLException(e.getMessage());
                    }
                }
                DOMParser p = new DOMParser();
                if (this.m_blobval != null && this.m_clobval == null) {
                    this.m_clobval = this.getClobVal();
                }
                if (this.m_stringval != null) {
                    try {
                        p.parse((Reader)new StringReader(this.m_stringval));
                    }
                    catch (XMLParseException e) {
                        throw new SQLException(e.getMessage());
                    }
                    catch (IOException e) {
                        throw new SQLException();
                    }
                    catch (SAXException e) {
                        throw new SQLException();
                    }
                    this.m_dom = p.getDocument();
                    break;
                }
                if (this.m_clobval != null) {
                    try {
                        p.parse(this.m_clobval.getCharacterStream());
                    }
                    catch (XMLParseException e) {
                        throw new SQLException(e.getMessage());
                    }
                    catch (IOException e) {
                        throw new SQLException(e.getMessage());
                    }
                    catch (SAXException e) {
                        throw new SQLException(e.getMessage());
                    }
                    this.m_dom = p.getDocument();
                    break;
                }
                if (this.m_bytesval == null) break;
                try {
                    p.parse((Reader)new StringReader(this.getStringFromBinaryStream()));
                }
                catch (XMLParseException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (IOException e) {
                    throw new SQLException();
                }
                catch (SAXException e) {
                    throw new SQLException();
                }
                this.m_dom = p.getDocument();
                break;
            }
            case 1: 
            case 2: {
                long xobdcstate = this.getXobdFromXMLType(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                this.m_dom = new XDBDocument(this, (Connection)this.m_local_conn, xobdcstate);
            }
        }
        return this.m_dom;
    }

    public Document getDocument() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            if (this.m_scalable && this.m_isCSX && (this.m_blobval != null || this.m_bytesval != null)) {
                try {
                    BinXMLStream bxmlstr = this.getBinXMLStreamInt();
                    BinXMLDecoder dec = bxmlstr.getDecoder();
                    InfosetReader reader = dec.getReader();
                    XMLDOMImplementation domimpl = new XMLDOMImplementation();
                    domimpl.setAttribute("oracle.xml.parser.XMLDocument.SCALABLE_DOM", (Object)Boolean.TRUE);
                    this.m_dom = domimpl.createDocument(reader);
                    return this.m_dom;
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
            }
            DOMParser p = new DOMParser();
            if (this.m_blobval != null && this.m_clobval == null) {
                this.m_clobval = this.getClobVal();
            }
            if (this.m_stringval != null) {
                try {
                    p.parse((Reader)new StringReader(this.m_stringval));
                }
                catch (XMLParseException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (IOException e) {
                    throw new SQLException();
                }
                catch (SAXException e) {
                    throw new SQLException();
                }
                this.m_dom = p.getDocument();
            } else if (this.m_clobval != null) {
                try {
                    p.parse(this.m_clobval.getCharacterStream());
                }
                catch (XMLParseException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (IOException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (SAXException e) {
                    throw new SQLException(e.getMessage());
                }
                this.m_dom = p.getDocument();
            } else if (this.m_bytesval != null) {
                try {
                    p.parse((Reader)new StringReader(this.getStringFromBinaryStream()));
                }
                catch (XMLParseException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (IOException e) {
                    throw new SQLException();
                }
                catch (SAXException e) {
                    throw new SQLException();
                }
                this.m_dom = p.getDocument();
            }
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            long xobdcstate = this.getXobdFromXMLType(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
            this.m_dom = new XMLDocument((Connection)this.m_local_conn, xobdcstate);
        }
        return this.m_dom;
    }

    public XMLType() throws SQLException {
        super(null, null, (Object)new byte[1]);
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private static int bytesToInt(byte[] val, int pos) {
        int i = 0;
        i += XMLType.unsignedByteToInt(val[pos++]) << 24;
        i += XMLType.unsignedByteToInt(val[pos++]) << 16;
        i += XMLType.unsignedByteToInt(val[pos++]) << 8;
        return i += XMLType.unsignedByteToInt(val[pos++]) << 0;
    }

    private static int twoBytesToInt(byte[] val, int pos) {
        int i = 0;
        i += XMLType.unsignedByteToInt(val[pos++]) << 8;
        return i += XMLType.unsignedByteToInt(val[pos++]);
    }

    public XMLType(Connection conn, long cstate) throws SQLException {
        this(conn, cstate, null);
    }

    private XMLType(Connection conn, long cstate, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        this.m_cstate = cstate;
    }

    private void processLob(byte[] byteval, int bytepos) throws SQLException {
        byte[] lobloc = new byte[byteval.length - bytepos];
        System.arraycopy(byteval, bytepos, lobloc, 0, byteval.length - bytepos);
        if (this.m_isCSX) {
            this.m_blobval = new BLOB((oracle.jdbc.OracleConnection)this.m_local_conn, lobloc);
        } else {
            this.m_clobval = new CLOB((oracle.jdbc.OracleConnection)this.m_local_conn, lobloc);
        }
    }

    private void processCSXBytes(byte[] byteval, int bytepos) throws SQLException {
        if (this.m_isCSX) {
            this.m_bytes = new byte[byteval.length - bytepos];
            System.arraycopy(byteval, bytepos, this.m_bytes, 0, byteval.length - bytepos);
        }
    }

    private void processXQDM(byte[] byteval, int bytepos) throws SQLException {
        if (this.m_isXQDM) {
            this.m_bytes = new byte[byteval.length - bytepos];
            System.arraycopy(byteval, bytepos, this.m_bytes, 0, byteval.length - bytepos);
            int flag = XMLType.twoBytesToInt(byteval, bytepos);
            bytepos += 2;
            if ((flag & 2) == 2 || (flag & 8) == 8) {
                short xqType = Util.getUnsignedByte((byte)byteval[bytepos]);
                short sqlType = Util.getUnsignedByte((byte)byteval[++bytepos]);
                int len = XMLType.bytesToInt(byteval, ++bytepos);
                bytepos += 4;
                if (sqlType == 1) {
                    if (xqType == 19) {
                        this.m_qname = this.processQName(this.m_charSet, byteval, bytepos);
                    } else {
                        byte[] value = new byte[len];
                        System.arraycopy(byteval, bytepos, value, 0, len);
                        this.m_stringval = this.m_charSet.toString(value, 0, len);
                    }
                }
                bytepos += len;
                if ((flag & 8) == 8) {
                    this.m_qname = this.processQName(this.m_charSet, byteval, bytepos);
                }
            } else if ((flag & 4) == 4) {
                int len = XMLType.bytesToInt(byteval, bytepos);
                byte[] value = new byte[len];
                System.arraycopy(byteval, bytepos += 4, value, 0, len);
                this.processThin(value, 0);
                if (this.m_stringval == null) {
                    this.m_stringval = this.getStringVal();
                }
            }
        }
    }

    private String processString(CharacterSet byteCS, byte[] byteval, int bytepos) throws SQLException {
        byte[] byt = new byte[byteval.length - bytepos];
        System.arraycopy(byteval, bytepos, byt, 0, byteval.length - bytepos);
        return byteCS.toString(byt, 0, byt.length);
    }

    private QName processQName(CharacterSet byteCS, byte[] byteval, int bytepos) throws SQLException {
        int nslen = XMLType.bytesToInt(byteval, bytepos);
        bytepos += 4;
        String ns = null;
        if (nslen > 0) {
            byte[] value = new byte[nslen];
            System.arraycopy(byteval, bytepos, value, 0, nslen);
            ns = byteCS.toString(value, 0, nslen);
        } else {
            ns = "";
        }
        int namelen = XMLType.bytesToInt(byteval, bytepos += nslen);
        byte[] value2 = new byte[namelen];
        System.arraycopy(byteval, bytepos += 4, value2, 0, namelen);
        String name = byteCS.toString(value2, 0, namelen);
        int prefixlen = XMLType.bytesToInt(byteval, bytepos += namelen);
        bytepos += 4;
        String prefix = null;
        if (prefixlen > 0) {
            byte[] value3 = new byte[prefixlen];
            System.arraycopy(byteval, bytepos, value3, 0, prefixlen);
            prefix = byteCS.toString(value3, 0, prefixlen);
        } else {
            prefix = "";
        }
        QName qname = new QName(ns, name, prefix);
        return qname;
    }

    private void processCState(byte[] byteval, int bytepos) throws SQLException {
        this.m_cstate = this.getXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), byteval, this.m_local_conn.getDbCsId());
    }

    private void processThin(byte[] byteVal, int bytepos) throws SQLException {
        short version = Util.getUnsignedByte((byte)byteVal[bytepos]);
        ++bytepos;
        if (version != 1) {
            throw new SQLException("error occurred in XMLtype conversion" + version);
        }
        this.m_thinflags = XMLType.bytesToInt(byteVal, bytepos);
        bytepos += 4;
        if ((this.m_thinflags & 0x100000) == 0x100000) {
            bytepos += 4;
        }
        if ((this.m_thinflags & 0x1000) == 4096) {
            this.m_thinsnapshot = new byte[24];
            System.arraycopy(byteVal, bytepos, this.m_thinsnapshot, 0, 24);
            bytepos += 24;
        }
        if ((this.m_thinflags & 8) == 8) {
            this.m_thinschoid = new byte[16];
            System.arraycopy(byteVal, bytepos, this.m_thinschoid, 0, 16);
            this.m_thinelemnum = new byte[4];
            System.arraycopy(byteVal, bytepos += 16, this.m_thinelemnum, 0, 4);
            bytepos += 4;
        }
        if ((this.m_thinflags & 0x1000000) == 0x1000000) {
            this.m_isCSX = true;
        }
        if ((this.m_thinflags & 0x20000000) == 0x20000000) {
            this.m_guid = new byte[16];
            System.arraycopy(byteVal, bytepos, this.m_guid, 0, 16);
            bytepos += 16;
        }
        if ((this.m_thinflags & 0x80000) == 524288) {
            this.m_isXQDM = true;
            this.processXQDM(byteVal, bytepos);
        } else if ((this.m_thinflags & 1) == 1) {
            this.processLob(byteVal, bytepos);
        } else if ((this.m_thinflags & 4) == 4) {
            if (this.m_isCSX) {
                this.processCSXBytes(byteVal, bytepos);
            } else {
                this.m_stringval = this.processString(this.m_charSet, byteVal, bytepos);
            }
        } else {
            throw new SQLException("Only LOB or String Storage is supported in Thin XMLType");
        }
    }

    public byte[] getBytesValue() throws SQLException {
        byte[] bval;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_blobval != null) {
            this.m_clobval = this.getClobVal();
        }
        if (this.m_picklepref == 1 && (bval = this.getPickledCSXBytes()) != null) {
            return bval;
        }
        if (this.m_clobval != null) {
            return this.getBytesLob();
        }
        if (this.m_stringval != null) {
            return this.getBytesString();
        }
        if (this.m_bytesval != null) {
            return this.getBytesBytes();
        }
        if (this.m_conntype == 2 || this.m_conntype == 1) {
            return this.getBytesPtr(this.m_local_conn);
        }
        return null;
    }

    private void int2Byte(int val, byte[] byteVal) {
        byteVal[0] = (byte)(val >> 24);
        byteVal[1] = (byte)((val &= 0xFFFFFF) >> 16);
        byteVal[2] = (byte)((val &= 0xFFFF) >> 8);
        byteVal[3] = (byte)(val &= 0xFF);
    }

    private void writePreamble(ByteArrayOutputStream strm, int ver, int flag) throws IOException {
        strm.write(1);
        byte[] flagVal = new byte[4];
        if ((this.m_thinflags & 0x1000) == 4096) {
            flag |= 0x1000;
        }
        if ((this.m_thinflags & 8) == 8) {
            flag |= 8;
        }
        if ((this.m_thinflags & 0x400000) == 0x400000) {
            flag |= 0x400000;
        }
        if ((this.m_thinflags & 0x20) == 32) {
            flag |= 0x20;
        }
        if ((this.m_thinflags & 0x400) == 1024) {
            flag |= 0x400;
        }
        this.int2Byte(flag, flagVal);
        strm.write(flagVal);
        if ((this.m_thinflags & 0x1000) == 4096) {
            strm.write(this.m_thinsnapshot);
        }
        if ((this.m_thinflags & 8) == 8) {
            strm.write(this.m_thinschoid);
            strm.write(this.m_thinelemnum);
        }
    }

    private byte[] getBytesString() throws SQLException {
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            this.writePreamble(strm, 1, 4);
            strm.write(this.m_charSet.convert(this.m_stringval));
            return strm.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private BinXMLProcessor getBinXMLProcessorNoShare(OracleConnection metadataconn) throws BinXMLException, SQLException {
        BinXMLProcessor proc = null;
        if (metadataconn == null) {
            return proc;
        }
        DBBinXMLMetadataProvider dbmeta = BinXMLMetadataProviderFactory.createDBMetadataProvider();
        dbmeta.setConnection((Connection)metadataconn);
        proc = BinXMLProcessorFactory.createProcessor((BinXMLMetadataProvider)dbmeta);
        return proc;
    }

    private synchronized BinXMLProcessor getBinXMLProcessor(OracleConnection conn) throws BinXMLException, SQLException {
        if (!m_sharebinproc) {
            return this.getBinXMLProcessorNoShare(conn);
        }
        if (conn == null) {
            return null;
        }
        BinXMLProcessor proc = null;
        if (m_binxmlprocs != null) {
            proc = (BinXMLProcessor)m_binxmlprocs.get(conn);
        }
        if (proc == null) {
            DBBinXMLMetadataProvider dbmeta = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            dbmeta.setConnection((Connection)conn);
            proc = BinXMLProcessorFactory.createProcessor((BinXMLMetadataProvider)dbmeta);
            if (m_binxmlprocs == null) {
                m_binxmlprocs = new SoftHashMap(10);
            }
            m_binxmlprocs.put(conn, proc);
        }
        return proc;
    }

    private boolean getPickledCSXBytes_int(ByteArrayOutputStream strm, OracleConnection metadataconn, boolean loc_aware) {
        Boolean encoded_ok;
        block11: {
            try {
                BinXMLProcessor proc = this.getBinXMLProcessor(metadataconn);
                ByteArrayOutputStream outstrm = new ByteArrayOutputStream();
                BinXMLStream bxmlstr = proc.createBinXMLStream((OutputStream)outstrm);
                BinXMLEncoder enc = bxmlstr.getEncoder();
                if (this.m_schemaURL != null) {
                    enc.setProperty(1, true);
                    enc.setSchema(this.m_schemaURL);
                } else {
                    enc.setProperty(7, loc_aware);
                    enc.setProperty(1, false);
                }
                enc.setProperty(4, true);
                enc.setProperty(6, true);
                enc.setChunkMode(this.m_chunkmode);
                SAXParser parser = new SAXParser();
                parser.setContentHandler(enc.getContentHandler());
                parser.setErrorHandler(enc.getErrorHandler());
                parser.setLexHandler(enc.getLexicalHandler());
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)enc.getLexicalHandler());
                parser.setDTDHandler(enc.getDTDHandler());
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", (Object)enc.getDeclHandler());
                if (this.m_clobval != null) {
                    parser.parse(this.m_clobval.getCharacterStream());
                } else if (this.m_stringval != null) {
                    parser.parse((Reader)new StringReader(this.m_stringval));
                } else if (this.m_bytesval != null) {
                    parser.parse((Reader)new StringReader(this.m_bytesval.toString()));
                }
                if (loc_aware && outstrm.toByteArray().length == 0) {
                    encoded_ok = false;
                } else {
                    strm.write(outstrm.toByteArray());
                    encoded_ok = true;
                }
            }
            catch (Exception e) {
                encoded_ok = false;
                if (this.m_schemaURL == null && loc_aware) break block11;
                e.printStackTrace();
            }
        }
        return encoded_ok;
    }

    private byte[] getPickledCSXBytes() {
        Object retval = null;
        OracleConnection metadataconn = null;
        if (this.m_isCSX) {
            try {
                ByteArrayOutputStream os;
                ByteArrayOutputStream strm = new ByteArrayOutputStream();
                this.writePreamble(strm, 1, 0x1000000);
                if (this.m_bytesval != null) {
                    strm.write(this.m_bytesval.toByteArray());
                } else if (this.m_bytes != null) {
                    strm.write(this.m_bytes);
                } else if (this.m_blobval != null && (os = this.getBinaryStream(this.m_blobval)) != null) {
                    strm.write(os.toByteArray());
                }
                retval = strm.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                retval = null;
            }
            return retval;
        }
        if (this.m_metadataconn != null) {
            if (this.m_metadataconn instanceof OracleConnection) {
                metadataconn = (OracleConnection)this.m_metadataconn;
            }
        } else {
            return null;
        }
        try {
            Boolean encoded_ok;
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            this.writePreamble(strm, 1, 0x1000000);
            if (this.m_schemaURL != null) {
                encoded_ok = this.getPickledCSXBytes_int(strm, metadataconn, false);
            } else {
                encoded_ok = this.getPickledCSXBytes_int(strm, metadataconn, true);
                if (!encoded_ok.booleanValue()) {
                    encoded_ok = this.getPickledCSXBytes_int(strm, metadataconn, false);
                }
            }
            retval = encoded_ok.booleanValue() ? strm.toByteArray() : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            retval = null;
        }
        return retval;
    }

    private byte[] getBytesBytes() throws SQLException {
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            if (this.m_isCSX) {
                this.writePreamble(strm, 1, 0x1000000);
            } else {
                this.writePreamble(strm, 1, 4);
            }
            strm.write(this.m_bytesval.toByteArray());
            return strm.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] getBytesLob() throws SQLException {
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            this.writePreamble(strm, 1, 1);
            strm.write(this.m_clobval.getLocator());
            return strm.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] getBytesPtr(OracleConnection conn) throws SQLException {
        byte[] b = this.pickleXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, this.m_picklepref);
        return b;
    }

    private long getErrHandle() throws SQLException {
        return XMLType.getErrorHandle((Connection)this.m_local_conn, this.m_conntype);
    }

    private long getSvcHandle() throws SQLException {
        return XMLType.getServiceHandle((Connection)this.m_local_conn, this.m_conntype);
    }

    public static long getErrorHandle(Connection conn, int conntype) throws SQLException {
        long retval;
        switch (conntype) {
            case 1: {
                OracleConnection iconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                Properties prop = iconn.getOCIHandles();
                retval = Long.parseLong(prop.getProperty("OCIErrHandle"));
                break;
            }
            default: {
                retval = 0L;
            }
        }
        return retval;
    }

    public static long getServiceHandle(Connection conn, int conntype) throws SQLException {
        long retval;
        switch (conntype) {
            case 1: {
                OracleConnection iconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                Properties prop = iconn.getOCIHandles();
                retval = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
                break;
            }
            default: {
                retval = 0L;
            }
        }
        return retval;
    }

    public byte[] toBytes() throws SQLException {
        return ((OPAQUE)this.toDatum((Connection)this.m_local_conn)).toBytes();
    }

    protected void freeXMLType() {
        boolean free_doc = true;
        if (this.m_isClosed) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                if (this.m_clobval != null) {
                    try {
                        if (CLOB.isTemporary((CLOB)this.m_clobval)) {
                            this.m_clobval.freeTemporary();
                        } else {
                            this.m_clobval.close();
                        }
                        this.m_clobval = null;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                if (this.m_blobval == null) break;
                try {
                    if (BLOB.isTemporary((BLOB)this.m_blobval)) {
                        this.m_blobval.freeTemporary();
                    } else {
                        this.m_blobval.close();
                    }
                    this.m_blobval = null;
                }
                catch (SQLException e) {}
                break;
            }
            case 1: 
            case 2: {
                if (this.m_dom != null) {
                    if (this.m_dom instanceof XDBDocument) {
                        ((XDBDocument)this.m_dom).close();
                    } else if (this.m_dom instanceof XMLDocument) {
                        ((XMLDocument)this.m_dom).freeNode();
                        free_doc = false;
                    }
                }
                if (!free_doc) break;
                try {
                    this.closeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                    this.m_cstate = 0L;
                    break;
                }
                catch (SQLException e) {
                    this.m_cstate = 0L;
                }
            }
        }
        this.m_isClosed = true;
    }

    public void close() {
        this.freeXMLType();
    }

    public void finalize() {
    }

    private void initConn(Connection conn) throws SQLException {
        this.initConn(conn, null);
    }

    private void initConn(Connection conn, String kind) throws SQLException {
        this.m_local_conn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        this.m_conntype = XMLType.getConnType(conn);
        if (kind == null) {
            switch (this.m_conntype) {
                case 0: {
                    this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                    break;
                }
                case 1: 
                case 2: {
                    this.m_kind = "oracle.xml.parser.XMLDocument.THICK";
                }
            }
        } else {
            this.m_kind = kind;
        }
        if (this.m_conntype == 2) {
            this.m_gpCState = XDBResource.getServerEnv();
        }
    }

    public static int getConnType(Connection conn) throws SQLException {
        int conntype;
        block12: {
            if (conn == null) {
                return 2;
            }
            OracleConnection localconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            if (localconn.getProtocolType().equals("thin")) {
                conntype = 0;
            } else if (localconn.getProtocolType().equals("oci8") || localconn.getProtocolType().equals("oci")) {
                conntype = 1;
                try {
                    if (m_libLoaded) break block12;
                    String osName = System.getProperty("os.name");
                    if (osName.toUpperCase().startsWith("WINDOWS")) {
                        System.loadLibrary("orageneric11");
                        System.loadLibrary("oraxml11");
                        m_libLoaded = true;
                        break block12;
                    }
                    if (osName.equalsIgnoreCase("Mac OS X")) {
                        System.loadLibrary("clntsh");
                        m_libLoaded = true;
                        break block12;
                    }
                    if (osName.equalsIgnoreCase("AIX")) {
                        System.loadLibrary("clntsh");
                        m_libLoaded = true;
                        break block12;
                    }
                    m_libLoaded = true;
                }
                catch (Exception ex) {
                    conntype = 0;
                }
            } else if (localconn.getProtocolType().equals("kprb")) {
                conntype = 2;
            } else {
                throw new SQLException("Unknown connection type.");
            }
        }
        return conntype;
    }

    private String getClobStr(CLOB clob) throws SQLException {
        String tmpstr = null;
        try {
            int nread;
            CharArrayWriter cwriter = new CharArrayWriter();
            char[] buf = new char[1024];
            Reader rdr = clob.getCharacterStream();
            while ((nread = rdr.read(buf)) != -1) {
                cwriter.write(buf, 0, nread);
            }
            rdr.close();
            tmpstr = cwriter.toString();
            cwriter.close();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return tmpstr;
    }

    private ByteArrayOutputStream getBinaryStream(BLOB blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream bytestrm = new ByteArrayOutputStream();
        try {
            int nread;
            byte[] buf = new byte[1024];
            InputStream instrm = blob.getBinaryStream();
            while ((nread = instrm.read(buf)) != -1) {
                bytestrm.write(buf, 0, nread);
            }
            instrm.close();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return bytestrm;
    }

    private BinXMLStream getBinXMLStreamInt() {
        BinXMLStream bxmlstr = null;
        if (!this.m_isCSX) {
            return null;
        }
        try {
            BinXMLProcessor proc = this.getBinXMLProcessor(this.m_local_conn);
            if (this.m_blobval != null) {
                bxmlstr = proc.createBinXMLStream((Blob)this.m_blobval);
            } else if (this.m_bytes != null) {
                bxmlstr = proc.createBinXMLStream(this.m_bytes);
            } else if (this.m_bytesval != null) {
                bxmlstr = proc.createBinXMLStream(this.m_bytesval.toByteArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bxmlstr = null;
        }
        return bxmlstr;
    }

    private String getStringFromBinXMLStream() throws SQLException {
        String tmpstr = null;
        if (this.m_isCSX) {
            try {
                BinXMLStream bxmlstr = this.getBinXMLStreamInt();
                ByteArrayOutputStream byteoutstr = new ByteArrayOutputStream();
                XMLSAXSerializer xmlsaxsz = new XMLSAXSerializer((OutputStream)byteoutstr);
                BinXMLDecoderImpl xmldec = (BinXMLDecoderImpl)bxmlstr.getDecoder();
                xmldec.setLexicalHandler((LexicalHandler)xmlsaxsz);
                xmldec.setDeclHandler((DeclHandler)xmlsaxsz);
                xmldec.setDTDHandler((DTDHandler)xmlsaxsz);
                if (this.m_CSXencoding != null) {
                    xmldec.decode((ContentHandler)xmlsaxsz, (ErrorHandler)xmlsaxsz, this.m_CSXencoding);
                } else {
                    xmldec.decode((ContentHandler)xmlsaxsz, (ErrorHandler)xmlsaxsz);
                }
                tmpstr = byteoutstr.toString();
                return tmpstr;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        return null;
    }

    private String getStringFromBinaryStream() throws SQLException {
        if (this.m_isCSX) {
            return this.getStringFromBinXMLStream();
        }
        if (this.m_bytesval == null) {
            return null;
        }
        if (this.m_csid == 0) {
            return this.m_bytesval.toString();
        }
        return this.processString(this.m_blobCS, this.m_bytesval.toByteArray(), 0);
    }

    public static long createContext(Connection conn) throws SQLException {
        return XDBResource.getServerCtx();
    }

    public static void destroyContext(long xmctx) throws SQLException {
        XDBResource.freeServerCtx(xmctx);
    }

    public static long inputToSegStream(long gp, InputStream istr, long svchdl, long errhdl, long strmHeap) throws SQLException {
        long segstream = 0L;
        byte[] buf = new byte[1024];
        try {
            int nread;
            int off = 0;
            while ((nread = istr.read(buf)) != -1) {
                segstream = XMLType.WriteToSegStreamNative(gp, svchdl, errhdl, segstream, buf, off, nread, strmHeap);
                off += buf.length;
            }
        }
        catch (IOException e) {
            throw new SQLException();
        }
        return segstream;
    }

    public BinXMLStream getBinXMLStream() throws SQLException {
        block4: {
            try {
                if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
                    byte[] bval = this.getBinaryBytes(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                    if (bval != null) {
                        BinXMLProcessor binxmlproc = this.getBinXMLProcessor(this.m_local_conn);
                        BLOB bl = new BLOB((oracle.jdbc.OracleConnection)this.m_local_conn, bval);
                        return binxmlproc.createBinXMLStream((Blob)bl);
                    }
                    break block4;
                }
                return this.getBinXMLStreamInt();
            }
            catch (BinXMLException e) {
                throw new SQLException("Error creating Binary xml stream");
            }
        }
        return null;
    }

    public byte[] getXQDMBytes() {
        if (this.m_isXQDM) {
            return this.m_bytes;
        }
        return null;
    }

    public String getXQDMString() {
        if (this.m_isXQDM) {
            return this.m_stringval;
        }
        return null;
    }

    public int getThinFlag() {
        return this.m_thinflags;
    }

    public QName getXQDMQName() {
        if (this.m_isXQDM) {
            return this.m_qname;
        }
        return null;
    }

    public void setBinaryXMLEncoding(String encoding) {
        this.m_CSXencoding = encoding;
    }

    public static synchronized void cleanupCache(boolean forcemode) {
        boolean doclear = true;
        if (m_binxmlprocs != null) {
            if (m_binxmlprocs.size() > 0 && !forcemode) {
                Set entries = m_binxmlprocs.keySet();
                if (entries != null) {
                    for (Connection iterconn : entries) {
                        BinXMLProcessor proc = (BinXMLProcessor)m_binxmlprocs.get(iterconn);
                        if (proc != null) continue;
                        m_binxmlprocs.remove(iterconn);
                    }
                }
                if (m_binxmlprocs.size() > 0) {
                    doclear = false;
                }
            }
            if (doclear || forcemode) {
                m_binxmlprocs.clear();
                m_binxmlprocs = null;
            }
        }
    }

    public static synchronized void setSharableProcessor(boolean share) {
        if (m_sharebinproc && !share) {
            XMLType.cleanupCache(true);
        }
        m_sharebinproc = share;
    }
}

