/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;

class IntColumnIdentityFilter
extends ColumnFilter {
    IntColumnIdentityFilter() {
    }

    private static final String zeroOneToYesNo(int n) {
        return 0 == n ? "NO" : "YES";
    }

    final Object apply(Object object, JDBCType jDBCType) throws SQLServerException {
        if (object == null) {
            return object;
        }
        switch (jDBCType) {
            case INTEGER: 
            case SMALLINT: {
                assert (object instanceof Number);
                return IntColumnIdentityFilter.zeroOneToYesNo(((Number)object).intValue());
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                assert (object instanceof String);
                return IntColumnIdentityFilter.zeroOneToYesNo(Integer.parseInt((String)object));
            }
        }
        DataTypes.throwConversionError("char", jDBCType.toString());
        return object;
    }
}

