/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.Any2LsRGBRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;

public class GraphicsUtil {
    public static AffineTransform IDENTITY = new AffineTransform();
    public static final boolean WARN_DESTINATION = false;
    public static final ColorModel Linear_sRGB = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel Linear_sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel Linear_sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    public static final ColorModel sRGB = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);

    public static void drawImage(Graphics2D graphics2D, RenderedImage renderedImage) {
        GraphicsUtil.drawImage(graphics2D, GraphicsUtil.wrap(renderedImage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(Graphics2D graphics2D, CachableRed cachableRed) {
        block41: {
            Object object;
            Object object2 = null;
            while (true) {
                if (cachableRed instanceof AffineRed) {
                    object = (AffineRed)cachableRed;
                    if (object2 == null) {
                        object2 = ((AffineRed)object).getTransform();
                    } else {
                        ((AffineTransform)object2).concatenate(((AffineRed)object).getTransform());
                    }
                    cachableRed = ((AffineRed)object).getSource();
                    continue;
                }
                if (!(cachableRed instanceof TranslateRed)) break;
                object = (TranslateRed)cachableRed;
                int n = ((TranslateRed)object).getDeltaX();
                int n2 = ((TranslateRed)object).getDeltaY();
                if (object2 == null) {
                    object2 = AffineTransform.getTranslateInstance(n, n2);
                } else {
                    ((AffineTransform)object2).translate(n, n2);
                }
                cachableRed = ((TranslateRed)object).getSource();
            }
            object = graphics2D.getTransform();
            if (object2 == null || ((AffineTransform)object2).isIdentity()) {
                object2 = object;
            } else {
                ((AffineTransform)object2).preConcatenate((AffineTransform)object);
            }
            ColorModel colorModel = cachableRed.getColorModel();
            ColorModel colorModel2 = GraphicsUtil.getDestinationColorModel(graphics2D);
            ColorSpace colorSpace = null;
            if (colorModel2 != null) {
                colorSpace = colorModel2.getColorSpace();
            }
            if (colorSpace == null) {
                colorSpace = ColorSpace.getInstance(1000);
            }
            ColorModel colorModel3 = colorModel2;
            if (colorModel2 == null || !colorModel2.hasAlpha()) {
                colorModel3 = sRGB_Unpre;
            }
            if (cachableRed instanceof BufferedImageCachableRed && colorSpace.equals(colorModel.getColorSpace()) && colorModel3.equals(colorModel)) {
                graphics2D.setTransform((AffineTransform)object2);
                BufferedImageCachableRed bufferedImageCachableRed = (BufferedImageCachableRed)cachableRed;
                graphics2D.drawImage((Image)bufferedImageCachableRed.getBufferedImage(), bufferedImageCachableRed.getMinX(), bufferedImageCachableRed.getMinY(), null);
                graphics2D.setTransform((AffineTransform)object);
                return;
            }
            double d = ((AffineTransform)object2).getDeterminant();
            if (!((AffineTransform)object2).isIdentity() && d <= 1.0) {
                if (((AffineTransform)object2).getType() != 1) {
                    cachableRed = new AffineRed(cachableRed, (AffineTransform)object2, graphics2D.getRenderingHints());
                } else {
                    int n = cachableRed.getMinX() + (int)((AffineTransform)object2).getTranslateX();
                    int n3 = cachableRed.getMinY() + (int)((AffineTransform)object2).getTranslateY();
                    cachableRed = new TranslateRed(cachableRed, n, n3);
                }
            }
            if (colorSpace != colorModel.getColorSpace()) {
                if (colorSpace == ColorSpace.getInstance(1000)) {
                    cachableRed = GraphicsUtil.convertTosRGB(cachableRed);
                } else if (colorSpace == ColorSpace.getInstance(1004)) {
                    cachableRed = GraphicsUtil.convertToLsRGB(cachableRed);
                }
            }
            if (!colorModel3.equals(colorModel = cachableRed.getColorModel())) {
                cachableRed = FormatRed.construct(cachableRed, colorModel3);
            }
            if (!((AffineTransform)object2).isIdentity() && d > 1.0) {
                cachableRed = new AffineRed(cachableRed, (AffineTransform)object2, graphics2D.getRenderingHints());
            }
            graphics2D.setTransform(IDENTITY);
            Composite composite = graphics2D.getComposite();
            if (graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) == "Printing" && SVGComposite.OVER.equals(composite)) {
                graphics2D.setComposite(SVGComposite.OVER);
            }
            Rectangle rectangle = cachableRed.getBounds();
            Shape shape = graphics2D.getClip();
            try {
                Object object3;
                Rectangle rectangle2;
                if (shape == null) {
                    shape = rectangle;
                    rectangle2 = rectangle;
                } else {
                    rectangle2 = shape.getBounds();
                    if (!rectangle2.intersects(rectangle)) {
                        return;
                    }
                    rectangle2 = rectangle2.intersection(rectangle);
                }
                Rectangle rectangle3 = GraphicsUtil.getDestinationBounds(graphics2D);
                if (rectangle3 != null) {
                    if (!rectangle2.intersects(rectangle3)) {
                        return;
                    }
                    rectangle2 = rectangle2.intersection(rectangle3);
                }
                boolean bl = false;
                colorModel = cachableRed.getColorModel();
                SampleModel sampleModel = cachableRed.getSampleModel();
                if (sampleModel.getWidth() * sampleModel.getHeight() >= rectangle2.width * rectangle2.height) {
                    bl = true;
                }
                if ((object3 = graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING)) == RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON) {
                    bl = true;
                }
                if (object3 == RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_OFF) {
                    bl = false;
                }
                if (bl) {
                    Raster raster = cachableRed.getData(rectangle2);
                    WritableRaster writableRaster = ((WritableRaster)raster).createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 0, null);
                    BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                    graphics2D.drawImage((Image)bufferedImage, rectangle2.x, rectangle2.y, null);
                    break block41;
                }
                WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                int n = cachableRed.getMinTileX();
                int n4 = n + cachableRed.getNumXTiles();
                int n5 = cachableRed.getMinTileY();
                int n6 = n5 + cachableRed.getNumYTiles();
                int n7 = sampleModel.getWidth();
                int n8 = sampleModel.getHeight();
                Rectangle rectangle4 = new Rectangle(0, 0, n7, n8);
                Rectangle rectangle5 = new Rectangle(0, 0, 0, 0);
                int n9 = n5 * n8 + cachableRed.getTileGridYOffset();
                int n10 = (rectangle2.y - n9) / n8;
                if (n10 < 0) {
                    n10 = 0;
                }
                n5 += n10;
                int n11 = n * n7 + cachableRed.getTileGridXOffset();
                n10 = (rectangle2.x - n11) / n7;
                if (n10 < 0) {
                    n10 = 0;
                }
                int n12 = rectangle2.x + rectangle2.width - 1;
                int n13 = rectangle2.y + rectangle2.height - 1;
                n9 = n5 * n8 + cachableRed.getTileGridYOffset();
                int n14 = (n += n10) * n7 + cachableRed.getTileGridXOffset();
                int n15 = n7;
                n11 = n14;
                int n16 = n5;
                while (n16 < n6) {
                    if (n9 > n13) {
                        break;
                    }
                    for (int i = n; i < n4 && n11 >= n14 && n11 <= n12; ++i, n11 += n15) {
                        rectangle4.x = n11;
                        rectangle4.y = n9;
                        Rectangle2D.intersect(rectangle, rectangle4, rectangle5);
                        WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, rectangle5.width, rectangle5.height, rectangle5.x, rectangle5.y, null);
                        cachableRed.copyData(writableRaster2);
                        BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, rectangle5.width, rectangle5.height);
                        graphics2D.drawImage((Image)bufferedImage2, rectangle5.x, rectangle5.y, null);
                    }
                    n15 = -n15;
                    n11 += n15;
                    ++n16;
                    n9 += n8;
                }
            }
            finally {
                graphics2D.setTransform((AffineTransform)object);
                graphics2D.setComposite(composite);
            }
        }
    }

    public static void drawImage(Graphics2D graphics2D, RenderableImage renderableImage, RenderContext renderContext) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Shape shape2 = renderContext.getAreaOfInterest();
        if (shape2 != null) {
            graphics2D.clip(shape2);
        }
        graphics2D.transform(renderContext.getTransform());
        graphics2D.setRenderingHints(renderContext.getRenderingHints());
        GraphicsUtil.drawImage(graphics2D, renderableImage);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHints(renderingHints);
    }

    public static void drawImage(Graphics2D graphics2D, RenderableImage renderableImage) {
        Object object;
        if (renderableImage instanceof PaintRable && (object = (PaintRable)((Object)renderableImage)).paintRable(graphics2D)) {
            return;
        }
        object = graphics2D.getTransform();
        RenderedImage renderedImage = renderableImage.createRendering(new RenderContext((AffineTransform)object, graphics2D.getClip(), graphics2D.getRenderingHints()));
        if (renderedImage == null) {
            return;
        }
        graphics2D.setTransform(IDENTITY);
        GraphicsUtil.drawImage(graphics2D, GraphicsUtil.wrap(renderedImage));
        graphics2D.setTransform((AffineTransform)object);
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage, RenderingHints renderingHints) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (renderingHints != null) {
            graphics2D.addRenderingHints(renderingHints);
        }
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(bufferedImage));
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return graphics2D;
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(bufferedImage));
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return graphics2D;
    }

    public static BufferedImage getDestination(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE);
        if (object != null) {
            return (BufferedImage)((Reference)object).get();
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        return null;
    }

    public static ColorModel getDestinationColorModel(Graphics2D graphics2D) {
        BufferedImage bufferedImage = GraphicsUtil.getDestination(graphics2D);
        if (bufferedImage != null) {
            return bufferedImage.getColorModel();
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        if (graphicsConfiguration.getDevice().getType() == 2) {
            if (graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) == "Printing") {
                return sRGB_Unpre;
            }
            return null;
        }
        return graphicsConfiguration.getColorModel();
    }

    public static ColorSpace getDestinationColorSpace(Graphics2D graphics2D) {
        ColorModel colorModel = GraphicsUtil.getDestinationColorModel(graphics2D);
        if (colorModel != null) {
            return colorModel.getColorSpace();
        }
        return null;
    }

    public static Rectangle getDestinationBounds(Graphics2D graphics2D) {
        BufferedImage bufferedImage = GraphicsUtil.getDestination(graphics2D);
        if (bufferedImage != null) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        if (graphicsConfiguration.getDevice().getType() == 2) {
            return null;
        }
        return null;
    }

    public static ColorModel makeLinear_sRGBCM(boolean bl) {
        return bl ? Linear_sRGB_Pre : Linear_sRGB_Unpre;
    }

    public static BufferedImage makeLinearBufferedImage(int n, int n2, boolean bl) {
        ColorModel colorModel = GraphicsUtil.makeLinear_sRGBCM(bl);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public static CachableRed convertToLsRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1004)) {
            return cachableRed;
        }
        return new Any2LsRGBRed(cachableRed);
    }

    public static CachableRed convertTosRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1000)) {
            return cachableRed;
        }
        return new Any2sRGBRed(cachableRed);
    }

    public static CachableRed wrap(RenderedImage renderedImage) {
        if (renderedImage instanceof CachableRed) {
            return (CachableRed)renderedImage;
        }
        if (renderedImage instanceof BufferedImage) {
            return new BufferedImageCachableRed((BufferedImage)renderedImage);
        }
        return new RenderedImageCachableRed(renderedImage);
    }

    public static void copyData_INT_PACK(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4 = writableRaster.getMinX();
        if (n4 < raster.getMinX()) {
            n4 = raster.getMinX();
        }
        if ((n3 = writableRaster.getMinY()) < raster.getMinY()) {
            n3 = raster.getMinY();
        }
        if ((n2 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n2 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n = raster.getMinY() + raster.getHeight() - 1;
        }
        int n5 = n2 - n4 + 1;
        int n6 = n - n3 + 1;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n8 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n4 - raster.getSampleModelTranslateX(), n3 - raster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n9 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n4 - writableRaster.getSampleModelTranslateX(), n3 - writableRaster.getSampleModelTranslateY());
        if (n7 == n9 && n7 == n5) {
            System.arraycopy(nArray, n8, nArray2, n10, n5 * n6);
        } else if (n5 > 128) {
            int n11 = n8;
            int n12 = n10;
            for (int i = 0; i < n6; ++i) {
                System.arraycopy(nArray, n11, nArray2, n12, n5);
                n11 += n7;
                n12 += n9;
            }
        } else {
            for (int i = 0; i < n6; ++i) {
                int n13 = n8 + i * n7;
                int n14 = n10 + i * n9;
                for (int j = 0; j < n5; ++j) {
                    nArray2[n14++] = nArray[n13++];
                }
            }
        }
    }

    public static void copyData_FALLBACK(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4 = writableRaster.getMinX();
        if (n4 < raster.getMinX()) {
            n4 = raster.getMinX();
        }
        if ((n3 = writableRaster.getMinY()) < raster.getMinY()) {
            n3 = raster.getMinY();
        }
        if ((n2 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n2 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n = raster.getMinY() + raster.getHeight() - 1;
        }
        int n5 = n2 - n4 + 1;
        int[] nArray = null;
        for (int i = n3; i <= n; ++i) {
            nArray = raster.getPixels(n4, i, n5, 1, nArray);
            writableRaster.setPixels(n4, i, n5, 1, nArray);
        }
    }

    public static void copyData(Raster raster, WritableRaster writableRaster) {
        if (GraphicsUtil.is_INT_PACK_Data(raster.getSampleModel(), false) && GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
            GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
            return;
        }
        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
    }

    public static WritableRaster copyRaster(Raster raster) {
        return GraphicsUtil.copyRaster(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster copyRaster(Raster raster, int n, int n2) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n, n2, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster.getDataBuffer();
        if (dataBuffer.getDataType() != dataBuffer2.getDataType()) {
            throw new IllegalArgumentException("New DataBuffer doesn't match original");
        }
        int n3 = dataBuffer.getSize();
        int n4 = dataBuffer.getNumBanks();
        int[] nArray = dataBuffer.getOffsets();
        block6: for (int i = 0; i < n4; ++i) {
            switch (dataBuffer.getDataType()) {
                case 0: {
                    DataBuffer dataBuffer3 = (DataBufferByte)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferByte)dataBuffer2;
                    System.arraycopy(((DataBufferByte)dataBuffer3).getData(i), nArray[i], ((DataBufferByte)dataBuffer4).getData(i), nArray[i], n3);
                    continue block6;
                }
                case 3: {
                    DataBuffer dataBuffer3 = (DataBufferInt)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferInt)dataBuffer2;
                    System.arraycopy(((DataBufferInt)dataBuffer3).getData(i), nArray[i], ((DataBufferInt)dataBuffer4).getData(i), nArray[i], n3);
                    continue block6;
                }
                case 2: {
                    DataBuffer dataBuffer3 = (DataBufferShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferShort)dataBuffer2;
                    System.arraycopy(((DataBufferShort)dataBuffer3).getData(i), nArray[i], ((DataBufferShort)dataBuffer4).getData(i), nArray[i], n3);
                    continue block6;
                }
                case 1: {
                    DataBuffer dataBuffer3 = (DataBufferUShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferUShort)dataBuffer2;
                    System.arraycopy(((DataBufferUShort)dataBuffer3).getData(i), nArray[i], ((DataBufferUShort)dataBuffer4).getData(i), nArray[i], n3);
                }
            }
        }
        return writableRaster;
    }

    public static WritableRaster makeRasterWritable(Raster raster) {
        return GraphicsUtil.makeRasterWritable(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster makeRasterWritable(Raster raster, int n, int n2) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n, n2, null);
        return writableRaster;
    }

    public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl) {
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
        return colorModel.coerceData(writableRaster, bl);
    }

    public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl) {
        if (!colorModel.hasAlpha()) {
            return colorModel;
        }
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        if (bl) {
            GraphicsUtil.multiplyAlpha(writableRaster);
        } else {
            GraphicsUtil.divideAlpha(writableRaster);
        }
        return GraphicsUtil.coerceColorModel(colorModel, bl);
    }

    public static void multiplyAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.mult_INT_PACK_Data(writableRaster);
        } else {
            int[] nArray = null;
            int n = writableRaster.getNumBands();
            float f = 0.003921569f;
            int n2 = writableRaster.getMinX();
            int n3 = n2 + writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            for (int i = n4; i < n5; ++i) {
                for (int j = n2; j < n3; ++j) {
                    int n6 = (nArray = writableRaster.getPixel(j, i, nArray))[n - 1];
                    if (n6 < 0 || n6 >= 255) continue;
                    float f2 = (float)n6 * f;
                    for (int k = 0; k < n - 1; ++k) {
                        nArray[k] = (int)((float)nArray[k] * f2 + 0.5f);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
    }

    public static void divideAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(writableRaster);
        } else {
            int n = writableRaster.getNumBands();
            int[] nArray = null;
            int n2 = writableRaster.getMinX();
            int n3 = n2 + writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            for (int i = n4; i < n5; ++i) {
                for (int j = n2; j < n3; ++j) {
                    int n6 = (nArray = writableRaster.getPixel(j, i, nArray))[n - 1];
                    if (n6 <= 0 || n6 >= 255) continue;
                    float f = 255.0f / (float)n6;
                    for (int k = 0; k < n - 1; ++k) {
                        nArray[k] = (int)((float)nArray[k] * f + 0.5f);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
    }

    public static void copyData(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        GraphicsUtil.copyData(bufferedImage, rectangle, bufferedImage2, new Point(0, 0));
    }

    public static void copyData(BufferedImage bufferedImage, Rectangle rectangle, BufferedImage bufferedImage2, Point point) {
        boolean bl;
        boolean bl2 = bufferedImage.getColorModel().hasAlpha();
        if (!(bl2 != (bl = bufferedImage2.getColorModel().hasAlpha()) || bl2 && bufferedImage.isAlphaPremultiplied() != bufferedImage2.isAlphaPremultiplied())) {
            GraphicsUtil.copyData(bufferedImage.getRaster(), bufferedImage2.getRaster());
            return;
        }
        int[] nArray = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n = writableRaster2.getNumBands();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n6 + rectangle.height - 1;
        if (!bl2) {
            int n8;
            int[] nArray2 = new int[n * n4];
            for (n8 = n4 * n - 1; n8 >= 0; n8 -= n) {
                nArray2[n8] = 255;
            }
            for (int i = n6; i <= n7; ++i) {
                nArray = writableRaster.getPixels(n5, i, n4, 1, nArray);
                int n9 = n4 * (n - 1) - 1;
                n8 = n4 * n - 2;
                switch (n) {
                    case 4: {
                        while (n9 >= 0) {
                            nArray2[n8--] = nArray[n9--];
                            nArray2[n8--] = nArray[n9--];
                            nArray2[n8--] = nArray[n9--];
                            --n8;
                        }
                        break;
                    }
                    default: {
                        while (n9 >= 0) {
                            for (int j = 0; j < n - 1; ++j) {
                                nArray2[n8--] = nArray[n9--];
                            }
                            --n8;
                        }
                        break block0;
                    }
                }
                writableRaster2.setPixels(n5 + n2, i + n3, n4, 1, nArray2);
            }
        } else if (bl && bufferedImage2.isAlphaPremultiplied()) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i = n6; i <= n7; ++i) {
                nArray = writableRaster.getPixels(n5, i, n4, 1, nArray);
                int n12 = n * n4 - 1;
                switch (n) {
                    case 4: {
                        int n13;
                        int n14;
                        while (n12 >= 0) {
                            n14 = nArray[n12];
                            if (n14 == 255) {
                                n12 -= 4;
                                continue;
                            }
                            n13 = n10 * n14;
                            nArray[--n12] = nArray[n12] * n13 + n11 >>> 24;
                            nArray[--n12] = nArray[n12] * n13 + n11 >>> 24;
                            nArray[--n12] = nArray[n12] * n13 + n11 >>> 24;
                            --n12;
                        }
                        break;
                    }
                    default: {
                        int n13;
                        int n14;
                        while (n12 >= 0) {
                            n14 = nArray[n12];
                            if (n14 == 255) {
                                n12 -= n;
                                continue;
                            }
                            --n12;
                            n13 = n10 * n14;
                            for (int j = 0; j < n - 1; ++j) {
                                nArray[n12] = nArray[n12] * n13 + n11 >>> 24;
                                --n12;
                            }
                        }
                        break block3;
                    }
                }
                writableRaster2.setPixels(n5 + n2, i + n3, n4, 1, nArray);
            }
        } else if (bl && !bufferedImage2.isAlphaPremultiplied()) {
            int n15 = 0xFF0000;
            int n16 = 32768;
            for (int i = n6; i <= n7; ++i) {
                nArray = writableRaster.getPixels(n5, i, n4, 1, nArray);
                int n17 = n * n4 - 1;
                switch (n) {
                    case 4: {
                        int n18;
                        int n19;
                        while (n17 >= 0) {
                            n19 = nArray[n17];
                            if (n19 <= 0 || n19 >= 255) {
                                n17 -= 4;
                                continue;
                            }
                            n18 = n15 / n19;
                            nArray[--n17] = nArray[n17] * n18 + n16 >>> 16;
                            nArray[--n17] = nArray[n17] * n18 + n16 >>> 16;
                            nArray[--n17] = nArray[n17] * n18 + n16 >>> 16;
                            --n17;
                        }
                        break;
                    }
                    default: {
                        int n18;
                        int n19;
                        while (n17 >= 0) {
                            n19 = nArray[n17];
                            if (n19 <= 0 || n19 >= 255) {
                                n17 -= n;
                                continue;
                            }
                            --n17;
                            n18 = n15 / n19;
                            for (int j = 0; j < n - 1; ++j) {
                                nArray[n17] = nArray[n17] * n18 + n16 >>> 16;
                                --n17;
                            }
                        }
                        break block6;
                    }
                }
                writableRaster2.setPixels(n5 + n2, i + n3, n4, 1, nArray);
            }
        } else if (bufferedImage.isAlphaPremultiplied()) {
            int[] nArray3 = new int[n * n4];
            int n20 = 0xFF0000;
            int n21 = 32768;
            for (int i = n6; i <= n7; ++i) {
                nArray = writableRaster.getPixels(n5, i, n4, 1, nArray);
                int n22 = (n + 1) * n4 - 1;
                int n23 = n * n4 - 1;
                while (n22 >= 0) {
                    int n24;
                    int n25 = nArray[n22];
                    --n22;
                    if (n25 > 0) {
                        if (n25 < 255) {
                            int n26 = n20 / n25;
                            for (n24 = 0; n24 < n; ++n24) {
                                nArray3[n23--] = nArray[n22--] * n26 + n21 >>> 16;
                            }
                            continue;
                        }
                        for (n24 = 0; n24 < n; ++n24) {
                            nArray3[n23--] = nArray[n22--];
                        }
                        continue;
                    }
                    n22 -= n;
                    for (n24 = 0; n24 < n; ++n24) {
                        nArray3[n23--] = 255;
                    }
                }
                writableRaster2.setPixels(n5 + n2, i + n3, n4, 1, nArray3);
            }
        } else {
            Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            for (int i = 0; i < n; ++i) {
                GraphicsUtil.copyBand(writableRaster, rectangle, i, writableRaster2, rectangle2, i);
            }
        }
    }

    public static void copyBand(Raster raster, int n, WritableRaster writableRaster, int n2) {
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        GraphicsUtil.copyBand(raster, rectangle3, n, writableRaster, rectangle3, n2);
    }

    public static void copyBand(Raster raster, Rectangle rectangle, int n, WritableRaster writableRaster, Rectangle rectangle2, int n2) {
        int n3 = rectangle2.y - rectangle.y;
        int n4 = rectangle2.x - rectangle.x;
        rectangle = rectangle.intersection(raster.getBounds());
        rectangle2 = rectangle2.intersection(writableRaster.getBounds());
        int n5 = rectangle2.width < rectangle.width ? rectangle2.width : rectangle.width;
        int n6 = rectangle2.height < rectangle.height ? rectangle2.height : rectangle.height;
        int n7 = rectangle.x + n4;
        int[] nArray = null;
        for (int i = rectangle.y; i < rectangle.y + n6; ++i) {
            nArray = raster.getSamples(rectangle.x, i, n5, 1, n, nArray);
            writableRaster.setSamples(n7, i + n3, n5, 1, n2, nArray);
        }
    }

    public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length == 3 ? bl : nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n4;
            int n5 = n4 + n;
            for (n4 = n3 + i * n2; n4 < n5; ++n4) {
                int n6 = nArray[n4];
                int n7 = n6 >>> 24;
                if (n7 <= 0) {
                    nArray[n4] = 0xFFFFFF;
                    continue;
                }
                if (n7 >= 255) continue;
                int n8 = 0xFF0000 / n7;
                nArray[n4] = n7 << 24 | ((n6 & 0xFF0000) >> 16) * n8 & 0xFF0000 | (((n6 & 0xFF00) >> 8) * n8 & 0xFF0000) >> 8 | ((n6 & 0xFF) * n8 & 0xFF0000) >> 16;
            }
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n4;
            int n5 = n4 + n;
            for (n4 = n3 + i * n2; n4 < n5; ++n4) {
                int n6 = nArray[n4];
                int n7 = n6 >>> 24;
                if (n7 < 0 || n7 >= 255) continue;
                nArray[n4] = n7 << 24 | (n6 & 0xFF0000) * n7 >> 8 & 0xFF0000 | (n6 & 0xFF00) * n7 >> 8 & 0xFF00 | (n6 & 0xFF) * n7 >> 8 & 0xFF;
            }
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = nArray[nArray.length - 1];
        int n6 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n7;
            int n8 = n7 + n * n3;
            for (n7 = n4 + i * n2; n7 < n8; n7 += n3) {
                int n9;
                int n10 = byArray[n7 + n5] & 0xFF;
                if (n10 == 0) {
                    for (n9 = 0; n9 < n6; ++n9) {
                        byArray[n7 + nArray[n9]] = -1;
                    }
                    continue;
                }
                if (n10 >= 255) continue;
                n9 = 0xFF0000 / n10;
                for (int j = 0; j < n6; ++j) {
                    int n11 = n7 + nArray[j];
                    byArray[n11] = (byte)((byArray[n11] & 0xFF) * n9 >>> 16);
                }
            }
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = nArray[nArray.length - 1];
        int n6 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            int n7;
            int n8 = n7 + n * n3;
            for (n7 = n4 + i * n2; n7 < n8; n7 += n3) {
                int n9 = byArray[n7 + n5] & 0xFF;
                if (n9 == 255) continue;
                for (int j = 0; j < n6; ++j) {
                    int n10 = n7 + nArray[j];
                    byArray[n10] = (byte)((byArray[n10] & 0xFF) * n9 >> 8);
                }
            }
        }
    }
}

