/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;

public class WinUser {
    public static boolean deleteUser(String string) {
        String string2 = Win32UserInfo.getAccountName(string);
        return Win32UserInfo.deleteUser(string2 != null ? string2 : string);
    }

    public static boolean deleteLocalGroup(String string) {
        String string2 = Win32UserInfo.getAccountName(string);
        return Win32UserInfo.deleteLocalGroup(string2 != null ? string2 : string);
    }

    public static AddUserResult addUser(String string, String string2, String string3, GroupCreationMode groupCreationMode, String string4, String string5) {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("name required");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password required");
        }
        if (groupCreationMode == null) {
            throw new IllegalArgumentException("groupCreationMode required");
        }
        if (string4 != null && string4.trim().length() == 0) {
            string4 = null;
        }
        if (string4 == null && groupCreationMode == GroupCreationMode.CREATE_IF_NECESSARY) {
            groupCreationMode = GroupCreationMode.NONE;
        }
        if (groupCreationMode != GroupCreationMode.NONE && string4 == null) {
            throw new IllegalArgumentException("localGroupName required");
        }
        if (groupCreationMode == GroupCreationMode.NONE) {
            string4 = null;
        }
        if (string4 != null && (object = Win32UserInfo.getAccountName(string4)) != null) {
            string4 = object;
        }
        object = Win32UserInfo.addUser(string, string2, string3, string4, string5, groupCreationMode == GroupCreationMode.CREATE_IF_NECESSARY || groupCreationMode == GroupCreationMode.CREATE_OR_FAIL, groupCreationMode == GroupCreationMode.CREATE_OR_FAIL);
        switch (((Win32UserInfo.Result)object).getErrorCode()) {
            case 0: {
                return new AddUserResult(AddUserResultType.SUCCESS, ((Win32UserInfo.Result)object).getUserSid(), ((Win32UserInfo.Result)object).getGroupSid(), ((Win32UserInfo.Result)object).isGroupCreated());
            }
            case 1379: 
            case 2223: {
                return new AddUserResult(AddUserResultType.ERROR_GROUP_EXISTS);
            }
            case 2220: {
                return new AddUserResult(AddUserResultType.ERROR_GROUP_NOT_FOUND);
            }
            case 2224: {
                return new AddUserResult(AddUserResultType.ERROR_USER_EXISTS);
            }
            case 2245: {
                return new AddUserResult(AddUserResultType.ERROR_PASSWORD_REQUIREMENTS);
            }
            case 5: 
            case 2226: {
                return new AddUserResult(AddUserResultType.ERROR_ACCESS_DENIED);
            }
        }
        Logger.getInstance().error(WinUser.class, "Could not create user. Win32 error code is " + ((Win32UserInfo.Result)object).getErrorCode() + ", raw result: " + ((Win32UserInfo.Result)object).getRawResult());
        return new AddUserResult(AddUserResultType.ERROR_OTHER);
    }

    public static String getAccountName(String string) {
        return Win32UserInfo.getAccountName(string);
    }

    public static String getUserName(String string) {
        return Win32UserInfo.getAccountName(string, true);
    }

    public static String getUserSid() {
        return Win32UserInfo.getUserSid();
    }

    public static class AddUserResult {
        private AddUserResultType resultType;
        private String userSid;
        private String groupSid;
        private boolean groupCreated;

        private AddUserResult(AddUserResultType addUserResultType, String string, String string2, boolean bl) {
            this.resultType = addUserResultType;
            this.userSid = string;
            this.groupSid = string2;
            this.groupCreated = bl;
        }

        private AddUserResult(AddUserResultType addUserResultType) {
            this.resultType = addUserResultType;
        }

        public AddUserResultType getType() {
            return this.resultType;
        }

        public String getUserSid() {
            return this.userSid;
        }

        public String getGroupSid() {
            return this.groupSid;
        }

        public boolean isGroupCreated() {
            return this.groupCreated;
        }

        public String toString() {
            return "AddUserResult{resultType=" + this.resultType + ", userSid='" + this.userSid + '\'' + ", groupSid='" + this.groupSid + '\'' + ", groupCreated=" + this.groupCreated + '}';
        }
    }

    public static class AddUserResultType {
        public static final AddUserResultType SUCCESS = new AddUserResultType("");
        public static final AddUserResultType ERROR_ACCESS_DENIED = new AddUserResultType("");
        public static final AddUserResultType ERROR_GROUP_EXISTS = new AddUserResultType("");
        public static final AddUserResultType ERROR_GROUP_NOT_FOUND = new AddUserResultType("");
        public static final AddUserResultType ERROR_USER_EXISTS = new AddUserResultType("");
        public static final AddUserResultType ERROR_PASSWORD_REQUIREMENTS = new AddUserResultType("");
        public static final AddUserResultType ERROR_OTHER = new AddUserResultType("");
        private String verbose;

        private AddUserResultType(String string) {
            this.verbose = string;
        }

        public String toString() {
            return this.verbose;
        }
    }

    public static class GroupCreationMode {
        public static final GroupCreationMode NONE = new GroupCreationMode("none");
        public static final GroupCreationMode USE_EXISTING = new GroupCreationMode("use existing");
        public static final GroupCreationMode CREATE_IF_NECESSARY = new GroupCreationMode("create if necessary");
        public static final GroupCreationMode CREATE_OR_FAIL = new GroupCreationMode("create or fail");
        private String name;

        private GroupCreationMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

