/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class AddToDockAction
extends SystemInstallAction
implements AutoUninstallAction {
    private Properties persistentProperties = new Properties();
    private File executable;
    private static final String PROPNAME_EXECUTABLE = "executable";
    private static final String PLIST_NAME = "com.apple.dock";
    private static final String ARRAY_NAME = "persistent-apps";
    private static final String TILE_DATA_KEY = "tile-data";
    private static final String FILE_DATA_KEY = "file-data";
    private static final String CF_URL_STRING_KEY = "_CFURLString";

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            Object[][] objectArray;
            File file = installerContext.getDestinationFile(this.getExecutable());
            String string = file.getAbsolutePath() + "/";
            this.doRollback(string);
            String string2 = file.getName();
            if (string2.endsWith(".app")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            if (PlistHelper.addToPlist(PLIST_NAME, ARRAY_NAME, objectArray = new Object[][]{{TILE_DATA_KEY, "tile-type"}, {new Object[][]{{"dock-extra", FILE_DATA_KEY, "file-label"}, {Boolean.FALSE, new Object[][]{{CF_URL_STRING_KEY, "_CFURLStringType"}, {string, new Integer(0)}}, string2}}, "file-tile"}})) {
                this.getPersistentProperties().setProperty(PROPNAME_EXECUTABLE, string);
                this.restartDock();
            } else {
                return false;
            }
        }
        return true;
    }

    private void restartDock() {
        try {
            Execution.executeAndWait(new String[]{"killall", "Dock"}, null);
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
    }

    public Properties getPersistentProperties() {
        return this.persistentProperties;
    }

    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }

    public void rollback(InstallerContext installerContext) {
        if (InstallerUtil.isMacOS()) {
            this.doRollback(installerContext.getDestinationFile(this.getExecutable()).getAbsolutePath() + "/");
            this.restartDock();
        }
    }

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            this.doRollback(this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
            this.restartDock();
        }
        return true;
    }

    private void doRollback(String string) {
        if (string != null) {
            try {
                if (!PlistHelper.removeElementWithChild(PLIST_NAME, ARRAY_NAME, new String[]{TILE_DATA_KEY, FILE_DATA_KEY, CF_URL_STRING_KEY}, string, true)) {
                    Logger.getInstance().error(this, "removing not successful");
                }
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
            }
        }
    }

    public File getExecutable() {
        return AddToDockAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }
}

