/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.groups.ActionGroup;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.ActionCallbackCommand;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.LanguageSelector;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.controller.ScreenNavigator;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Controller {
    private ScreenExecutor screenExecutor;
    private ContextImpl context;
    private List startedActionsConfigs = new ArrayList();
    private ScreenNavigator screenNavigator;

    public Controller(ScreenExecutor screenExecutor) {
        this.screenExecutor = screenExecutor;
        this.context = screenExecutor.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LanguageSelector.initSystemAndDefaultLanguage();
        InstallerVariables.initUserVars();
        InstallerUtil.registerStarted(false);
        InstallerVariables.setReplaceI18nVariables(true);
        InstallerVariables.setReplaceInstallerAndCompilerVariables(true);
        InstallerUtil.setConsole(this.screenExecutor.isConsole());
        InstallerUtil.setUnattended(this.screenExecutor.isUnattended());
        InstallerUtil.loadJREDeployLibs();
        LanguageSelector.initLanguage(this.context, this.screenExecutor);
        if (!this.context.checkStart()) {
            this.context.exit(1);
        }
        this.context.registerScreens();
        if (this.getScreenConfigsFlat().size() == 0) {
            return;
        }
        this.screenNavigator = new ScreenNavigator(this.context);
        ScreenBeanConfig screenBeanConfig = this.handleStartup();
        if (screenBeanConfig == null && InstallerUtil.isInProcess()) {
            return;
        }
        ControllerCommand controllerCommand = null;
        while (screenBeanConfig != null) {
            CommandSink commandSink = new CommandSink(this);
            this.execute(screenBeanConfig, commandSink, controllerCommand);
            CommandSink commandSink2 = commandSink;
            synchronized (commandSink2) {
                while (commandSink.getCommand() == null) {
                    try {
                        commandSink.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            controllerCommand = commandSink.getCommand();
            screenBeanConfig = this.handleCommand(commandSink, screenBeanConfig);
            if (commandSink.isFinished()) {
                return;
            }
            if (screenBeanConfig == null) {
                Logger.getImpl().setCurrentScreen(null);
                commandSink.finished();
                continue;
            }
            Logger.getImpl().setCurrentScreen(screenBeanConfig.getOrInstantiateScreen(false));
        }
        this.context.immediateExit(0);
    }

    private ScreenBeanConfig handleStartup() {
        ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)this.getScreenConfigsFlat().get(0);
        CommandSink commandSink = new CommandSink(this);
        commandSink.returnToController(new GoForwardCommand(1, true, true, null));
        return this.handleCommand(commandSink, screenBeanConfig);
    }

    private void execute(final ScreenBeanConfig screenBeanConfig, final CommandSink commandSink, final ControllerCommand controllerCommand) {
        this.screenNavigator.addHistory(screenBeanConfig);
        ArrayList arrayList = new ArrayList();
        ScreenBeanConfig screenBeanConfig2 = this.screenNavigator.findPreviousScreenConfigInHistory(false, arrayList, 1);
        final boolean bl = screenBeanConfig2 != null && screenBeanConfig.getBackButtonType() != 3 && (screenBeanConfig.getBackButtonType() != 2 || !this.hasNonMultiExecActions(screenBeanConfig2.getActionConfigs()) && arrayList.size() == 0);
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        this.context.fireInstallerEvent(new InstallerEvent(screen, this.context, EventType.SHOW_SCREEN));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Controller.this.screenExecutor.execute(screenBeanConfig, commandSink, bl, controllerCommand);
            }
        });
    }

    private boolean hasNonMultiExecActions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof GroupBeanConfig ? this.hasNonMultiExecActions(((GroupBeanConfig)e).getBeanConfigs()) : e instanceof ActionBeanConfig && !((ActionBeanConfig)e).isMultiExec())) continue;
            return true;
        }
        return false;
    }

    private ScreenBeanConfig handleCommand(CommandSink commandSink, ScreenBeanConfig screenBeanConfig) {
        Logger.getImpl().resetOrigin();
        ControllerCommand controllerCommand = commandSink.getCommand();
        ActionCallback actionCallback = null;
        try {
            if (controllerCommand instanceof GoForwardCommand && ((GoForwardCommand)controllerCommand).isExecuteActions() || controllerCommand instanceof FinishCommand) {
                actionCallback = ((ActionCallbackCommand)controllerCommand).getActionCallback();
                commandSink.allowOverride();
                if (actionCallback != null) {
                    actionCallback.actionsStarted();
                }
                try {
                    this.executeActions(screenBeanConfig.getActionConfigs(), "", false);
                    this.checkRollbackBarrier(screenBeanConfig, screenBeanConfig.getOrInstantiateScreen(false));
                }
                catch (UserCanceledException userCanceledException) {
                    this.rollback(commandSink);
                    ScreenBeanConfig screenBeanConfig2 = null;
                    if (actionCallback != null) {
                        actionCallback.actionsFinished();
                    }
                    return screenBeanConfig2;
                }
                controllerCommand = commandSink.getOverriddenCommand();
            }
            Logger.getInstance().info(screenBeanConfig.getOrInstantiateScreen(false), "command: " + controllerCommand);
            if (controllerCommand instanceof GoForwardCommand) {
                GoForwardCommand goForwardCommand = (GoForwardCommand)controllerCommand;
                ScreenBeanConfig screenBeanConfig3 = this.screenNavigator.findNextScreenConfig(screenBeanConfig, goForwardCommand.getNumber(), goForwardCommand.isCheckCondition());
                if (screenBeanConfig3 == null) {
                    this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING));
                    commandSink.finished();
                    this.context.finish(0);
                }
                ScreenBeanConfig screenBeanConfig4 = screenBeanConfig3;
                return screenBeanConfig4;
            }
            if (controllerCommand instanceof GoBackCommand) {
                GoBackCommand goBackCommand = (GoBackCommand)controllerCommand;
                if (goBackCommand.isUseHistory()) {
                    this.screenNavigator.removeLastHistoryItem();
                    if (goBackCommand.getNumber() == 0) {
                        ScreenBeanConfig screenBeanConfig5 = screenBeanConfig;
                        return screenBeanConfig5;
                    }
                    ScreenBeanConfig screenBeanConfig6 = this.screenNavigator.findPreviousScreenConfigInHistory(true, null, goBackCommand.getNumber());
                    if (screenBeanConfig6 == null) {
                        throw new RuntimeException("Could not go back " + goBackCommand.getNumber() + " step in history from " + screenBeanConfig.getOrInstantiateScreen(true));
                    }
                    ScreenBeanConfig screenBeanConfig7 = screenBeanConfig6;
                    return screenBeanConfig7;
                }
                ScreenBeanConfig screenBeanConfig8 = this.screenNavigator.findPreviousScreenConfig(screenBeanConfig, goBackCommand.getNumber());
                return screenBeanConfig8;
            }
            if (controllerCommand instanceof GoBackInHistoryToScreenCommand) {
                ScreenBeanConfig screenBeanConfig9;
                Screen screen = ((GoBackInHistoryToScreenCommand)controllerCommand).getScreen();
                this.screenNavigator.removeLastHistoryItem();
                if (screen == screenBeanConfig.getOrInstantiateScreen(false)) {
                    ScreenBeanConfig screenBeanConfig10 = screenBeanConfig;
                    return screenBeanConfig10;
                }
                do {
                    if ((screenBeanConfig9 = this.screenNavigator.findPreviousScreenConfigInHistory(true, null, 1)) != null) continue;
                    throw new RuntimeException("Could not go back in history to screen " + screen.toString());
                } while (screenBeanConfig9.getOrInstantiateScreen(false) != screen);
                ScreenBeanConfig screenBeanConfig11 = screenBeanConfig9;
                return screenBeanConfig11;
            }
            if (controllerCommand instanceof FinishCommand) {
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING));
                commandSink.finished();
                this.context.finish(0);
                ScreenBeanConfig screenBeanConfig12 = null;
                return screenBeanConfig12;
            }
            if (controllerCommand == ControllerCommand.CANCEL) {
                this.rollback(commandSink);
                ScreenBeanConfig screenBeanConfig13 = null;
                return screenBeanConfig13;
            }
            if (controllerCommand instanceof GotoScreenCommand) {
                ScreenBeanConfig screenBeanConfig14 = this.findScreenConfig(((GotoScreenCommand)controllerCommand).getScreen());
                this.screenNavigator.sync(screenBeanConfig14);
                ScreenBeanConfig screenBeanConfig15 = screenBeanConfig14;
                return screenBeanConfig15;
            }
            throw new RuntimeException("Unknown command " + controllerCommand.toString());
        }
        finally {
            if (actionCallback != null) {
                actionCallback.actionsFinished();
            }
        }
    }

    public void rollback(CommandSink commandSink) {
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELLING));
        FileInstaller fileInstaller = FileInstaller.getInstance();
        boolean bl = fileInstaller.hasRollbackFiles();
        if (this.startedActionsConfigs.size() > 0 || bl) {
            ServiceHandler.resetStopState();
            this.context.setRollback();
            this.context.getProgressInterface().setDetailMessage("");
            if (bl) {
                ServiceHandler.stopServices(this.context, true);
            }
            this.context.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            for (int i = this.startedActionsConfigs.size() - 1; i >= 0; --i) {
                Logger.getImpl().resetOrigin();
                ActionBeanConfig actionBeanConfig = (ActionBeanConfig)this.startedActionsConfigs.get(i);
                if (actionBeanConfig.isRolledBack()) continue;
                if (bl) {
                    fileInstaller.rollback(actionBeanConfig.getRollbackId());
                }
                this.context.rollbackAction(actionBeanConfig);
                actionBeanConfig.setRolledBack(true);
            }
            if (bl) {
                fileInstaller.rollbackAll();
            }
        }
        if (fileInstaller.hasUnrollbackedFiles()) {
            this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED));
            commandSink.finished();
            this.context.finish(1);
        }
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED));
        commandSink.finished();
        this.context.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeActions(List list, String string, boolean bl) throws UserCanceledException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Bean bean;
            AbstractBeanConfig abstractBeanConfig;
            Logger.getImpl().resetOrigin();
            Object e = iterator.next();
            if (e instanceof ActionBeanConfig) {
                abstractBeanConfig = (ActionBeanConfig)e;
                bean = ((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(false);
                boolean bl2 = false;
                do {
                    if (this.context.isCancelling()) {
                        throw new UserCanceledException();
                    }
                    if (!bl2 && (!((ActionBeanConfig)abstractBeanConfig).isMultiExec() && ((ActionBeanConfig)abstractBeanConfig).isExecuted() || !this.context.runBooleanScript(abstractBeanConfig.getConditionClassName(), bean))) continue;
                    if (!(((ActionBeanConfig)abstractBeanConfig).isExecuted() || bean instanceof InstallAction && !this.isRollbackSupported((Action)bean))) {
                        this.startedActionsConfigs.add(abstractBeanConfig);
                    }
                    ((ActionBeanConfig)abstractBeanConfig).setExecuted(true);
                    try {
                        Logger.getImpl().setCurrentAction(((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(false));
                        if (!this.context.performAction((ActionBeanConfig)abstractBeanConfig)) {
                            bl2 = this.handleFailure((ActionBeanConfig)abstractBeanConfig, bean.getClass(), string);
                            if (bl2 || !bl) continue;
                            boolean bl3 = false;
                            return bl3;
                        }
                        bl2 = false;
                    }
                    catch (UndefinedVariableException undefinedVariableException) {
                        Logger.getInstance().error(bean, "undefined variable: " + undefinedVariableException.getMessage());
                        bl2 = this.handleFailure((ActionBeanConfig)abstractBeanConfig, bean.getClass(), string);
                        if (bl2 || !bl) continue;
                        boolean bl4 = false;
                        return bl4;
                    }
                    finally {
                        this.checkRollbackBarrier(abstractBeanConfig, bean);
                        Logger.getImpl().setCurrentAction(null);
                    }
                } while (bl2);
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            if (!this.context.checkGroupCondition((GroupBeanConfig)abstractBeanConfig)) continue;
            bean = (ActionGroup)((GroupBeanConfig)abstractBeanConfig).getOrInstantiateGroup(false);
            ContextImpl.GroupState groupState = new ContextImpl.GroupState();
            this.context.initLoopIndex((GroupBeanConfig)abstractBeanConfig, groupState);
            do {
                String string2;
                if ((string2 = ((ActionGroup)bean).getDefaultErrorMessage().trim()).length() == 0) {
                    string2 = string;
                }
                if (this.executeActions(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs(), string2, ((ActionGroup)bean).isOnErrorBreakGroup()) || !bl) continue;
                return false;
            } while (this.context.isGroupLoop((GroupBeanConfig)abstractBeanConfig, groupState));
        }
        return true;
    }

    private boolean isRollbackSupported(Action action) {
        try {
            return ((InstallAction)action).isRollbackSupported();
        }
        catch (AbstractMethodError abstractMethodError) {
            return false;
        }
    }

    private boolean handleFailure(ActionBeanConfig actionBeanConfig, Class clazz, String string) throws UserCanceledException {
        int n;
        boolean bl;
        this.context.setErrorOccurred(true);
        String string2 = actionBeanConfig.getErrorMessage().trim();
        if (string2.length() == 0) {
            string2 = string.trim();
        }
        boolean bl2 = bl = (n = actionBeanConfig.getFailureStrategy()) == 2;
        if (bl || n == 1) {
            if (string2.length() > 0) {
                Util.showMessage(string2, bl ? 0 : 2);
            }
            if (bl) {
                this.quitAndKeepLogFile();
            }
        } else {
            VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
            if (string2.length() == 0) {
                string2 = MessageFormat.format(variableResourceBundleWrapper.getString("ErrorFunctionFailedNoCode"), clazz.getName()) + "\n";
            }
            if (n == 3) {
                if (Util.showOptionDialog(string2, new String[]{variableResourceBundleWrapper.getString("ButtonIgnore"), variableResourceBundleWrapper.getString("ButtonQuit")}, 0) == 1) {
                    this.quitAndKeepLogFile();
                }
            } else {
                int n2 = Util.showOptionDialog(string2, new String[]{variableResourceBundleWrapper.getString("ButtonIgnore"), variableResourceBundleWrapper.getString("ButtonRetry"), variableResourceBundleWrapper.getString("ButtonQuit")}, 0);
                if (n2 == 2) {
                    this.quitAndKeepLogFile();
                } else if (n2 == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private void quitAndKeepLogFile() throws UserCanceledException {
        System.setProperty("install4j.keepLog", "true");
        throw new UserCanceledException();
    }

    private void checkRollbackBarrier(AbstractBeanConfig abstractBeanConfig, Bean bean) {
        if (abstractBeanConfig.isRollbackBarrier()) {
            this.startedActionsConfigs.clear();
            FileInstaller.getInstance().setRollbackBarrier();
            Logger.getInstance().info(bean, "Rollback barrier reached");
        }
    }

    private ScreenBeanConfig findScreenConfig(Screen screen) {
        ListIterator listIterator = this.getScreenConfigsFlat().listIterator();
        while (listIterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)listIterator.next();
            if (screenBeanConfig.getOrInstantiateScreen(false) != screen) continue;
            return screenBeanConfig;
        }
        throw new RuntimeException("not in screen sequence; " + screen);
    }

    private List getScreenConfigsFlat() {
        return this.context.getScreenConfigsFlat();
    }
}

