/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.WizardContext;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.screens.ProgressScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.LanguageSelectionDialog;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.RollbackProgressInterface;
import com.install4j.runtime.installer.frontend.ScreenEnvelope;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class WizardScreenExecutor
extends WizardBase
implements ScreenExecutor,
WizardContext {
    private GUIProgressInterface defaultProgressInterface;
    private RollbackProgressInterface rollbackProgressInterface;
    private ScreenEnvelope screenEnvelope;
    private CommandSink commandSink;
    private WizardIndex wizardIndex;
    private String wizardIndexKey;
    private Map cachedWizardIndexKeys = new HashMap();
    private boolean dialog;
    private Window parentWindow;

    public WizardScreenExecutor(boolean bl, Window window) {
        super("");
        this.dialog = bl;
        this.parentWindow = window;
        this.initAWT();
        this.defaultProgressInterface = new GUIProgressInterface();
        FileInstaller.getInstance().setDefaultProgressInterface(this.defaultProgressInterface);
        if (Util.isMacOS() && !InstallerUtil.isInProcess()) {
            try {
                Class.forName("com.install4j.runtime.installer.platform.macos.MacEventHandler").getMethod("init", WizardScreenExecutor.class).invoke(null, this);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    public abstract String getWindowTitle();

    protected abstract Icon getDefaultHeaderIcon();

    protected String getCustomHeaderIconFileName() {
        ExternalFile externalFile = InstallerConfig.getCurrentApplication().getCustomHeaderImage();
        if (externalFile == null || externalFile.getPath().length() == 0) {
            return null;
        }
        return externalFile.getPath();
    }

    protected boolean isHeaderIconOverlap() {
        return InstallerConfig.getCurrentApplication().isHeaderIconOverlap() && this.getCustomHeaderIconFileName() != null;
    }

    protected Anchor getHeaderIconAnchor() {
        return InstallerConfig.getCurrentApplication().getHeaderIconAnchor();
    }

    public void setNextButtonEnabled(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonEnabled(bl);
        }
    }

    public void setBackButtonEnabled(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonEnabled(bl);
        }
    }

    public void setCancelButtonEnabled(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonEnabled(bl);
        }
    }

    public void setNextButtonVisible(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonVisible(bl);
        }
    }

    public void setBackButtonVisible(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonVisible(bl);
        }
    }

    public void setCancelButtonVisible(boolean bl) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonVisible(bl);
        }
    }

    public void pressNextButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doNext();
        }
    }

    public void pressPreviousButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doPrevious();
        }
    }

    public void pressCancelButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doCancel();
        }
    }

    public void focusNextButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.focusNextButton();
        }
    }

    public void setNextButtonText(String string) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonText(string);
        }
    }

    public void setPreviousButtonText(String string) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonText(string);
        }
    }

    public void setCancelButtonText(String string) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonText(string);
        }
    }

    public WizardIndex getWizardIndex() {
        return this.wizardIndex;
    }

    public void setWizardIndex(WizardIndex wizardIndex) {
        this.wizardIndex = wizardIndex;
        this.wizardIndexKey = wizardIndex == null ? null : wizardIndex.getInitialKey();
    }

    public void setWizardIndexKey(String string) {
        this.wizardIndexKey = string;
    }

    public String getWizardIndexKey() {
        return this.wizardIndexKey;
    }

    public void register(final Screen screen, final ScreenBeanConfig screenBeanConfig) {
        this.getContext().applyToScreen(screen, screenBeanConfig);
        GUIHelper.invokeOnEDT(new Runnable(){

            public void run() {
                WizardScreenExecutor.this.registerScreen(new ScreenEnvelope(WizardScreenExecutor.this, screen, screenBeanConfig));
            }
        });
    }

    public void execute(ScreenBeanConfig screenBeanConfig, CommandSink commandSink, boolean bl, ControllerCommand controllerCommand) {
        Object object;
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        if ((controllerCommand instanceof GoBackCommand || controllerCommand instanceof GoBackInHistoryToScreenCommand) && this.cachedWizardIndexKeys.containsKey(screen)) {
            object = (WizardIndexAndKey)this.cachedWizardIndexKeys.get(screen);
            this.wizardIndex = ((WizardIndexAndKey)object).wizardIndex;
            this.wizardIndexKey = ((WizardIndexAndKey)object).key;
        }
        this.commandSink = commandSink;
        object = this.getScreens().iterator();
        while (object.hasNext()) {
            ScreenEnvelope screenEnvelope = (ScreenEnvelope)object.next();
            if (screenEnvelope.getScreen() != screen) continue;
            if (this.screenEnvelope != null) {
                this.screenEnvelope.getScreen().deactivated();
            }
            this.screenEnvelope = screenEnvelope;
            if (!bl) {
                screenEnvelope.setPreviousButtonVisible(false);
            }
            this.setScreen(screenEnvelope);
            if (!this.isShowing()) {
                if (this.dialog) {
                    this.showDialog(this.parentWindow);
                } else {
                    this.showFrame(null);
                }
            }
            return;
        }
        throw new RuntimeException("screen not registered " + screen.toString());
    }

    public void cacheWizardIndexAndKey(Screen screen) {
        this.cachedWizardIndexKeys.put(screen, new WizardIndexAndKey(this.wizardIndex, this.wizardIndexKey));
    }

    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    public ProgressInterface getProgressInterface() {
        if (this.rollbackProgressInterface != null) {
            return this.rollbackProgressInterface;
        }
        if (this.screenEnvelope != null) {
            ProgressInterface progressInterface;
            FormPanel formPanel = this.screenEnvelope.getFormPanel();
            if (formPanel != null && (progressInterface = formPanel.findProgressInterface()) != null) {
                return progressInterface;
            }
            return this.screenEnvelope.getScreen().getProgressInterface(this.defaultProgressInterface);
        }
        return this.defaultProgressInterface;
    }

    public ProgressInterface getDefaultProgressInterface() {
        return this.defaultProgressInterface;
    }

    public WizardContext getWizardContext() {
        return this;
    }

    public void selectLanguage(ReturnToken returnToken) {
        new LanguageSelectionDialog(returnToken).setVisible(true);
    }

    public boolean isUnattended() {
        return false;
    }

    public boolean isConsole() {
        return false;
    }

    protected int getFrameWidth() {
        String string = this.getContext().getCompilerVariable("__internal.app." + InstallerConfig.getCurrentApplicationId() + ".width");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return InstallerConfig.getCurrentApplication().getFrameWidth();
    }

    protected int getFrameHeight() {
        String string = this.getContext().getCompilerVariable("__internal.app." + InstallerConfig.getCurrentApplicationId() + ".height");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return InstallerConfig.getCurrentApplication().getFrameHeight();
    }

    protected boolean needsNextScreenOnVisible() {
        return false;
    }

    protected void beforeShow(Window window) {
        super.beforeShow(window);
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.setTitle(this.getWindowTitle());
            jFrame.setResizable(InstallerConfig.getCurrentApplication().isResizable());
        } else {
            JDialog jDialog = (JDialog)window;
            jDialog.setTitle(this.getWindowTitle());
            jDialog.setResizable(InstallerConfig.getCurrentApplication().isResizable());
        }
    }

    protected void beforeHide(Window window) {
        super.beforeHide(window);
        if (this.rollbackProgressInterface != null && this.rollbackProgressInterface.isVisible()) {
            this.rollbackProgressInterface.setVisible(false);
        }
    }

    public boolean isSizeClientArea() {
        return InstallerConfig.getCurrentApplication().isFrameSizeClientArea();
    }

    protected boolean isQuitOnWindowClose() {
        if (this.screenEnvelope == null) {
            return true;
        }
        return this.screenEnvelope.isCancelVisible() && this.screenEnvelope.isCancelButtonEnabled();
    }

    public boolean isFinishOnWindowClose() {
        if (this.screenEnvelope == null) {
            return false;
        }
        return this.screenEnvelope.isFinishScreen();
    }

    public void finishFromCloseButton() {
        this.screenEnvelope.doNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ContextImpl.setAskingForCancel(true);
        try {
            if (GUIHelper.confirmCancel(this)) {
                this.screenEnvelope.setCancelButtonEnabled(false);
                ContextImpl.setCancelling();
                this.commandSink.returnToController(ControllerCommand.CANCEL);
            }
        }
        finally {
            ContextImpl.setAskingForCancel(false);
        }
    }

    protected void setupComponent() {
        super.setupComponent();
        this.setMinimumSize(new Dimension(500, 300));
    }

    public void setRollback() {
        if (this.screenEnvelope != null && this.screenEnvelope.getScreen() instanceof ProgressScreen) {
            ProgressInterface progressInterface = this.getProgressInterface();
            progressInterface.setIndeterminateProgress(false);
            progressInterface.setDetailMessage("");
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            progressInterface.setPercentCompleted(0);
        } else if (this.rollbackProgressInterface == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    WizardScreenExecutor.this.rollbackProgressInterface = RollbackProgressInterface.create(WizardScreenExecutor.this.getWizardWindow());
                    WizardScreenExecutor.this.rollbackProgressInterface.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void closeWindows() {
        this.finish();
    }

    public ActionCallback getActionCallback() {
        return this.screenEnvelope;
    }

    public void initializeLazilyLoadedScreens() {
        Iterator iterator = this.getScreens().iterator();
        while (iterator.hasNext()) {
            ((ScreenEnvelope)iterator.next()).initializeLazilyLoaded();
        }
    }

    public Color getHeaderBackgroundColor() {
        Color color = InstallerConfig.getCurrentApplication().getHeaderBackground();
        return color == null ? Color.WHITE : color;
    }

    public Color getHeaderForegroundColor() {
        return InstallerConfig.getCurrentApplication().getHeaderForeground();
    }

    public Icon getHeaderIcon() {
        try {
            ImageIcon imageIcon;
            String string = this.getCustomHeaderIconFileName();
            if (string != null && (imageIcon = new ImageIcon(InstallerUtil.getInstallerFile(string).getPath())).getIconWidth() > 0) {
                return imageIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDefaultHeaderIcon();
    }

    private void initAWT() {
        if (SwingUtilities.isEventDispatchThread()) {
            new Button();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        new Button();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void disarmButtons() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.disarmButtons();
        }
    }

    private static class WizardIndexAndKey {
        private WizardIndex wizardIndex;
        private String key;

        private WizardIndexAndKey(WizardIndex wizardIndex, String string) {
            this.wizardIndex = wizardIndex;
            this.key = string;
        }
    }
}

