/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.api.context.WizardContext;
import com.install4j.runtime.dirchooser.DirectoryChooser;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.AbstractTextAndButtonPanel;
import com.install4j.runtime.util.FileDrop;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DirectorySelector
extends AbstractTextAndButtonPanel
implements AbstractFileSelector {
    public static final String PROPERTY_SELECTED_PATH = "selectedPath";
    private static final String BAD_CHARS = ":*?\"<>|%" + (InstallerUtil.isWindows() ? "/" : "\\");
    private static File lastDirectory = null;
    private String standardDirectoryName;
    public boolean noStandardDirectoryNameForUpdate;
    private InternalValidator internalValidator;
    private WizardContext wizardContext;
    private JTextField txtDirectory;
    private JButton btnBrowse;
    private DirectoryChooser directoryChooser;
    private String directoryDescription;
    private boolean allowSpacesOnUnix = false;
    private boolean allowNewFolderCreation = false;
    private boolean allowEmpty = false;
    private boolean designTime;
    private String focusInText = "";
    private FileValidator validator;
    private boolean alreadyValidated;
    private String initialBrowserDirectory;

    public DirectorySelector(String string, boolean bl) {
        this.directoryDescription = string;
        this.designTime = bl;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setInternalValidator(InternalValidator internalValidator) {
        this.internalValidator = internalValidator;
    }

    public void setAllowSpacesOnUnix(boolean bl) {
        this.allowSpacesOnUnix = bl;
    }

    public void setAllowNewFolderCreation(boolean bl) {
        this.allowNewFolderCreation = bl;
    }

    public void activateNextScreenOnEnter(WizardContext wizardContext) {
        this.wizardContext = wizardContext;
    }

    public void setEnabled(boolean bl) {
        this.txtDirectory.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }

    public void initDirectory(File file, String string) {
        this.standardDirectoryName = string;
        this.txtDirectory.setText(this.getSuggestedPath(file));
    }

    public void setDirectory(File file) {
        if (!this.txtDirectory.getText().equals(file.getPath())) {
            this.txtDirectory.setText(file.getPath());
        }
    }

    public void setNoStandardDirectoryNameForUpdate(boolean bl) {
        this.noStandardDirectoryNameForUpdate = bl;
    }

    public void setSelectedFile(File file) {
        this.initDirectory(file, "");
    }

    public File getSelectedFile() {
        return new File(StringUtil.replaceHomeDir(this.getSelectedDirectoryName()));
    }

    public JTextField getTextField() {
        return this.txtDirectory;
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    public void setManualEntryAllowed(boolean bl) {
        this.txtDirectory.setEditable(bl);
    }

    public void setAllowEmpty(boolean bl) {
        this.allowEmpty = bl;
    }

    public void setValidator(FileValidator fileValidator) {
        this.validator = fileValidator;
    }

    public boolean checkSelectedFile() {
        return this.alreadyValidated || this.checkDirectory(this.getSelectedDirectoryName());
    }

    public void setInitialBrowserDirectory(String string) {
        this.initialBrowserDirectory = string;
    }

    public boolean checkDirectory(String string) {
        File file;
        int n;
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        if (string.length() == 0) {
            if (this.allowEmpty) {
                return true;
            }
            GUIHelper.showMessage(window, variableResourceBundleWrapper.getString("MustEnterDirectory"), 2);
            return false;
        }
        if (!new File(string).isAbsolute()) {
            GUIHelper.showMessage(window, MessageFormat.format(variableResourceBundleWrapper.getString("InvalidDirectory"), string), 2);
            return false;
        }
        if (!(InstallerUtil.isWindows() || InstallerUtil.isMacOS() || string.indexOf(32) <= -1 || this.allowSpacesOnUnix)) {
            GUIHelper.showMessage(window, variableResourceBundleWrapper.getString("NoDirNameWithSpace"), 2);
            return false;
        }
        char[] cArray = BAD_CHARS.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            int n2 = string.indexOf(cArray[n]);
            if (n2 < 0 || cArray[n] == ':' && n2 == 1 && string.lastIndexOf(58) == n2 && InstallerUtil.isWindows()) continue;
            GUIHelper.showMessage(window, MessageFormat.format(variableResourceBundleWrapper.getString("BadDirName32"), BAD_CHARS), 2);
            return false;
        }
        if (InstallerUtil.isWindows() && string.lastIndexOf(58) == 1 && !new File(string.substring(0, 2)).exists()) {
            GUIHelper.showMessage(window, variableResourceBundleWrapper.getString("InvalidDrive"), 2);
            return false;
        }
        if (InstallerUtil.isWindows() && string.startsWith("\\\\")) {
            n = string.indexOf(92, 2);
            if (n > 0) {
                n = string.indexOf(92, n + 1);
            }
            if (n < 0) {
                n = string.length();
            }
            if (!new File(string.substring(0, n)).exists()) {
                GUIHelper.showMessage(window, variableResourceBundleWrapper.getString("InvalidDrive"), 2);
                return false;
            }
        }
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            GUIHelper.showMessage(window, MessageFormat.format(variableResourceBundleWrapper.getString("InvalidDirectory"), string), 2);
            return false;
        }
        if (this.internalValidator != null) {
            File file2 = this.internalValidator.validateInternally(file);
            if (file2 == null) {
                return false;
            }
            if (!file2.equals(file)) {
                this.setSelectedFile(file2);
            }
        }
        return this.validator == null || this.validator.isValidFile(file);
    }

    public void focusTextField() {
        if (this.txtDirectory.isEditable()) {
            this.txtDirectory.requestFocus();
            this.txtDirectory.setSelectionStart(0);
            this.txtDirectory.setSelectionEnd(this.txtDirectory.getDocument().getLength());
        } else {
            this.btnBrowse.requestFocus();
        }
    }

    private void setupControls() {
        this.txtDirectory = new JTextField(" ");
        FileDrop.addTo(this.txtDirectory, null);
        this.btnBrowse = new JButton(Messages.getMessages().getString("ButtonBrowse"));
    }

    private void setupComponent() {
        this.setOpaque(false);
        if (this.directoryDescription != null) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.directoryDescription), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtDirectory, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        this.add((Component)this.btnBrowse, gridBagConstraints);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectorySelector.this.doBrowse();
            }
        });
        KeyboardUtil.addAccelerator(0, this.txtDirectory, this.txtDirectory, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectorySelector.this.wizardContext.pressNextButton();
            }
        }, 10, 0);
        this.txtDirectory.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DirectorySelector.this.focusInText = DirectorySelector.this.txtDirectory.getText();
            }

            public void focusLost(FocusEvent focusEvent) {
                DirectorySelector.this.firePropertyChange(DirectorySelector.PROPERTY_SELECTED_PATH, DirectorySelector.this.focusInText, DirectorySelector.this.txtDirectory.getText());
            }
        });
        this.txtDirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                DirectorySelector.this.alreadyValidated = false;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DirectorySelector.this.alreadyValidated = false;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DirectorySelector.this.alreadyValidated = false;
            }
        });
    }

    private void doBrowse() {
        File file;
        File file2;
        String string;
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        if (this.directoryChooser == null) {
            this.directoryChooser = new DirectoryChooser();
            this.directoryChooser.setTitle(variableResourceBundleWrapper.getString("SelectDirectory"));
            this.directoryChooser.setMultiSelectionEnabled(false);
            this.directoryChooser.setAllowFolderCreation(this.allowNewFolderCreation);
        }
        if ((string = this.txtDirectory.getText().trim()).length() > 0) {
            file2 = new File(string);
        } else if (this.initialBrowserDirectory != null && this.initialBrowserDirectory.length() > 0) {
            file2 = new File(this.initialBrowserDirectory);
        } else {
            if (lastDirectory == null) {
                lastDirectory = new File(Util.getUserHome());
            }
            file2 = lastDirectory;
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(file2.exists() && file2.isDirectory() || (file = this.directoryChooser.getFileSystemView().getParentDirectory(file2)) == null || file2.equals(file))) {
            file2 = file;
        }
        if (file2.exists() && file2.isDirectory()) {
            this.directoryChooser.setCurrentDirectory(file2);
        }
        if (this.directoryChooser.showDialog(this, variableResourceBundleWrapper.getString("ButtonOK"), variableResourceBundleWrapper.getString("ButtonCancel")) == 0) {
            file = this.directoryChooser.getSelectedFile();
            String string2 = this.getSuggestedPath(file);
            String string3 = this.txtDirectory.getText();
            lastDirectory = file;
            if (this.checkDirectory(string2)) {
                this.txtDirectory.setText(string2);
                this.firePropertyChange(PROPERTY_SELECTED_PATH, string3, string2);
                this.alreadyValidated = true;
            } else {
                this.alreadyValidated = false;
            }
        }
    }

    private String getSelectedDirectoryName() {
        String string = this.txtDirectory.getText().trim();
        if (new File(string).getParent() != null) {
            while (string.endsWith("\\") || string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private String getSuggestedPath(File file) {
        if (file.getPath().trim().length() == 0) {
            return "";
        }
        if (this.standardDirectoryName == null || this.standardDirectoryName.trim().length() == 0 || this.noStandardDirectoryNameForUpdate && ApplicationRegistry.isUpdateDirectory(file)) {
            return file.getPath();
        }
        return new File(file, this.standardDirectoryName).getPath();
    }

    public static interface InternalValidator {
        public File validateInternally(File var1);
    }
}

