/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm.impl;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchIntAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

class HelperProgressInterface
implements ProgressInterface,
Serializable {
    private transient HelperCommunication helperCommunication = HelperCommunication.getInstance();
    private transient int lastPercentCompleted = -1;
    private transient int lastSecondaryPercentCompleted = -1;
    private transient String lastStatusMessage;
    private transient String lastDetailMessage;

    HelperProgressInterface() {
    }

    public void setStatusMessage(final String string) {
        if (!string.equals(this.lastStatusMessage)) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                protected void run(Context context) {
                    context.getProgressInterface().setStatusMessage(string);
                }
            });
            this.lastStatusMessage = string;
        }
    }

    public void setDetailMessage(final String string) {
        if (!string.equals(this.lastDetailMessage)) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                protected void run(Context context) {
                    context.getProgressInterface().setDetailMessage(string);
                }
            });
            this.lastDetailMessage = string;
        }
    }

    public void setPercentCompleted(final int n) {
        if (this.lastPercentCompleted != n) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                protected void run(Context context) {
                    context.getProgressInterface().setPercentCompleted(n);
                }
            });
            this.lastPercentCompleted = n;
        }
    }

    public void setSecondaryPercentCompleted(final int n) {
        if (this.lastSecondaryPercentCompleted != n) {
            this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                protected void run(Context context) {
                    context.getProgressInterface().setSecondaryPercentCompleted(n);
                }
            });
            this.lastSecondaryPercentCompleted = n;
        }
    }

    public int getPercentCompleted() {
        return this.helperCommunication.fetchInt(ExecutionContext.UNELEVATED, new FetchLongAction(){

            protected long fetchValue(Context context) {
                return context.getProgressInterface().getPercentCompleted();
            }
        });
    }

    public void setIndeterminateProgress(final boolean bl) {
        this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                context.getProgressInterface().setIndeterminateProgress(bl);
            }
        });
    }

    public void showFailure(final String string) {
        this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                context.getProgressInterface().showFailure(string);
            }
        });
    }

    public int askOverwrite(final File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchIntChecked(ExecutionContext.UNELEVATED, new FetchIntAction(){

                protected int fetchValue(Context context) throws UserCanceledException {
                    return context.getProgressInterface().askOverwrite(file);
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public int askRetry(final File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchIntChecked(ExecutionContext.UNELEVATED, new FetchIntAction(){

                protected int fetchValue(Context context) throws UserCanceledException {
                    return context.getProgressInterface().askRetry(file);
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean askContinue(final File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchBooleanChecked(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                protected boolean fetchValue(Context context) throws UserCanceledException {
                    return context.getProgressInterface().askContinue(file);
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

