/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import LZMA.LzmaInputStream;
import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.ApplicationRegistry;
import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileInfo;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerFileInstallationEvent;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.AbstractInstallFilesAction;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentCollector;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.JreInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ContentInstaller {
    private static ExecutionContext executionContext = ExecutionContext.UNELEVATED;
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private JreInstaller jreInstaller = new JreInstaller();
    private Set installedUserJars = new HashSet();
    private static ContentInstaller instance = new ContentInstaller();
    public static final long FILE_WEIGHT = 153600L;
    static /* synthetic */ Class class$com$install4j$runtime$beans$actions$InstallFilesAction;

    public static ContentInstaller getInstance() {
        return instance;
    }

    private ContentInstaller() {
    }

    public static ExecutionContext getExecutionContext() {
        return executionContext;
    }

    public static void setExecutionContext(final ExecutionContext executionContext) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            protected void run(Context context) {
                ContentInstaller.executionContext = executionContext;
            }
        });
    }

    public void doStandardInstallation(InstallerContext installerContext, ProgressInterface progressInterface, InstallFilesAction installFilesAction) throws IOException, UserCanceledException {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        if (installerContext.isCancelling()) {
            return;
        }
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            ContentInstaller.setExecutionContext(ExecutionContext.MAXIMUM);
        }
        boolean bl3 = bl2 = installFilesAction.isInstallRuntime() && !InstallerConfig.getCurrentInstance().isAddOnInstaller();
        if (bl2) {
            this.fileInstaller.createDirectory(installerContext.getInstallationDirectory());
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContentStats contentStats = ContentStats.getInstance();
        long l = contentStats.getSelectedContentSize();
        long l2 = contentStats.getSelectedContentCount();
        boolean bl4 = bl = !Boolean.getBoolean("install4j.noJreInstallation") && this.jreInstaller.checkJreInstallation(installerContext.getInstallationDirectory(), installFilesAction.isUpdateBundledJre());
        if (bl && bl2) {
            l += this.jreInstaller.getJreSize();
            l2 += (long)this.jreInstaller.getJreCount();
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContextInt contextInt = ContextImpl.getContextInt(installerContext);
        contextInt.fireInstallerEvent(new InstallerFileInstallationEvent(contextInt.getEventSource(), installerContext, EventType.FILE_INSTALLATION_STARTED, l, l2));
        l += 153600L * l2;
        long l3 = 0L;
        Map map = new ContentCollector(progressInterface, installerContext, installFilesAction.isSaveDownloadedFiles()).collectContentStreams(null);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        if (Util.isMacosInstaller() && ((InstallerConfig)(object2 = InstallerConfig.getCurrentInstance())).getMacSpecificConfig().isSingleBundle()) {
            object = new File(installerContext.getInstallationDirectory(), ((InstallerConfig)object2).getMacSpecificConfig().getRuntimeDirParent());
            File file = new File(((File)object).getParentFile().getParentFile(), "java/app");
            file.getParentFile().mkdirs();
            if (((File)object).exists() && !file.exists() && !UnixFileSystem.getFileInformation((File)object).isLink()) {
                ((File)object).renameTo(file);
            }
            file.mkdirs();
            ((File)object).getParentFile().mkdirs();
            UnixFileSystem.createLink("../java/app", (File)object);
        }
        if (bl && bl2) {
            l3 = this.jreInstaller.installJre(installerContext, progressInterface, installFilesAction, l, l3);
        }
        object2 = map.values().iterator();
        while (object2.hasNext()) {
            object = (InputStream)object2.next();
            l3 = this.installContent(installerContext, (InputStream)object, progressInterface, installFilesAction, l, l3);
        }
        progressInterface.setDetailMessage("");
        if (bl2) {
            this.jreInstaller.writePreferredJre(installerContext.getDestinationFile(".install4j"));
            this.createRuntimeDirectory(installerContext, installFilesAction);
        }
        if (!installerContext.isCancelling()) {
            progressInterface.setPercentCompleted(100);
        }
    }

    private long installContent(InstallerContext installerContext, InputStream inputStream, ProgressInterface progressInterface, AbstractInstallFilesAction abstractInstallFilesAction, long l, long l2) throws IOException, UserCanceledException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream;
        try {
            inputStream = new BufferedInputStream(inputStream);
            if (InstallerConfig.getCurrentInstance().isLzmaCompression()) {
                inputStream = new LzmaInputStream(inputStream);
            }
            zipInputStream = new ZipInputStream(inputStream);
            zipEntry = zipInputStream.getNextEntry();
        }
        catch (Exception exception) {
            throw new ReadIOException(exception);
        }
        while (zipEntry != null) {
            Serializable serializable;
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
            String string = zipEntry.getName();
            string = InstallerUtil.isWindows() ? string.replace('/', '\\') : string.replace('\\', '/');
            boolean bl = string.endsWith(".i4jlnk");
            if (bl) {
                string = string.substring(0, string.length() - ".i4jlnk".length());
            }
            FileInfo fileInfo = installerContext.getDestinationFileInfo(string);
            progressInterface.setDetailMessage(InstallerUtil.cleanupName(fileInfo.getRelativeFilePath()));
            File file = fileInfo.getRootResolved();
            boolean bl2 = true;
            String string2 = fileInfo.getFilesetId();
            if (string2.length() > 0 && !installerContext.getFileSetById(string2).isSelected()) {
                bl2 = false;
            } else if (file != null) {
                if (fileInfo.getRootUnresolved() != null && fileInfo.getRelativeFilePath().equals("\\") || fileInfo.getRelativeFilePath().equals("/") || fileInfo.getRelativeFilePath().equals("")) {
                    bl2 = false;
                } else {
                    Serializable serializable2;
                    serializable = abstractInstallFilesAction.getFileFilterScript();
                    if (serializable != null) {
                        try {
                            serializable2 = (Boolean)installerContext.runScript((ScriptProperty)serializable, abstractInstallFilesAction, new Object[]{fileInfo});
                            bl2 = serializable2 == null || ((Boolean)serializable2).booleanValue();
                        }
                        catch (Exception exception) {
                            Util.printAnnotatedStackTrace(exception);
                            Logger.getInstance().log(exception);
                            bl2 = false;
                        }
                    }
                    serializable2 = abstractInstallFilesAction.getDirectoryResolverScript();
                    if (bl2 && serializable2 != null) {
                        try {
                            File file2 = (File)installerContext.runScript((ScriptProperty)serializable2, abstractInstallFilesAction, new Object[]{fileInfo});
                            if (file2 != null) {
                                file = file2;
                            }
                        }
                        catch (Exception exception) {
                            Util.printAnnotatedStackTrace(exception);
                            Logger.getInstance().log(exception);
                            bl2 = false;
                        }
                    }
                }
            }
            if (file == null) {
                bl2 = false;
            }
            serializable = InstallerConfig.getCurrentInstance();
            long l3 = l2 + 153600L;
            File file3 = this.getDestFile(file, fileInfo.getRelativeFilePath());
            if (zipEntry.isDirectory()) {
                if (bl2) {
                    FileOptions fileOptions = ((InstallerConfig)serializable).getOptions(string);
                    UninstallMode uninstallMode = UninstallMode.IF_CREATED;
                    if (fileOptions != null) {
                        uninstallMode = fileOptions.getUninstallMode();
                    }
                    this.fileInstaller.createDirectory(file3, uninstallMode);
                    file3.setLastModified(zipEntry.getTime());
                    if (fileOptions != null && !InstallerUtil.isWindows()) {
                        VersionSpecificHelper.setPosixFilePermissions(file3, fileOptions.getMode());
                    }
                }
            } else {
                long l4 = zipEntry.getSize();
                l3 += l4;
                if (bl2) {
                    Object object;
                    FilterInputStream filterInputStream = zipInputStream;
                    if (bl) {
                        object = new File(string).getName();
                        this.installedUserJars.add(object);
                        File file4 = ContextImpl.getContextInt(installerContext).getAdditionalUserJarsDir();
                        File file5 = file4 != null ? new File(file4, (String)object) : InstallerUtil.getInstallerFile("user/" + (String)object);
                        l4 = file5.length();
                        filterInputStream = new BufferedInputStream(new FileInputStream(file5));
                    }
                    if ((object = ((InstallerConfig)serializable).getOptions(string)) == null) {
                        object = new FileOptions();
                    }
                    ((FileOptions)object).setFileTime(zipEntry.getTime());
                    ((FileOptions)object).setDelayIfNecessary(abstractInstallFilesAction.isDelay());
                    this.fileInstaller.install(filterInputStream, file3, (FileOptions)object, new ProgressAdapter(progressInterface, (int)(l2 * 100L / l), (int)(l3 * 100L / l)), l4, ((InstallerConfig)serializable).isPack200Compression());
                    if (bl) {
                        ((InputStream)filterInputStream).close();
                    }
                }
            }
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
            l2 = l3;
            progressInterface.setPercentCompleted((int)(l2 * 100L / l));
            try {
                zipEntry = zipInputStream.getNextEntry();
            }
            catch (Exception exception) {
                throw new ReadIOException(exception);
            }
        }
        try {
            zipInputStream.close();
        }
        catch (Exception exception) {
            throw new ReadIOException(exception);
        }
        return l2;
    }

    private File getDestFile(File file, String string) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string2 = installerConfig.getUninstallerPath();
        if (Util.isMacosInstaller() && string.startsWith(string2 + ".app") && installerConfig.getUninstallerDirectory().equals(".")) {
            string = this.getUninstallerName() + string.substring(string2.length());
        }
        return new File(file, string);
    }

    private String getUninstallerName() {
        String string = ContentInstaller.replaceSlashes(InstallerConfig.getCurrentInstance().getApplicationName());
        return MessageFormat.format(Messages.getMessages().getString("UninstallerMenuEntry"), string);
    }

    public static String replaceSlashes(String string) {
        return string.replace('/', ' ').replace('\\', ' ').replace(':', ' ').replace(';', ' ');
    }

    private void createRuntimeDirectory(Context context, InstallFilesAction installFilesAction) throws IOException, UserCanceledException {
        FileOptions fileOptions = new FileOptions(OverwriteMode.ALWAYS, UninstallMode.ALWAYS);
        fileOptions.setDelayIfNecessary(installFilesAction.isDelay());
        File file = new File(System.getProperty("user.dir"));
        File file2 = Util.isMacosInstaller() && !InstallerUtil.DEBUG ? new File(".install4j") : file;
        File file3 = new File(file2, "i4jruntime.jar");
        File file4 = context.getDestinationFile(".install4j");
        File file5 = new File(file4, "i4jruntime.jar");
        this.fileInstaller.createDirectory(file4, UninstallMode.ALWAYS);
        this.fileInstaller.install(file3, file5, fileOptions);
        String string = "";
        if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
            string = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
        }
        this.fileInstaller.install(new File(file, "MessagesDefault"), new File(file4, "MessagesDefault"), fileOptions);
        this.fileInstaller.install(new File(file, "i4jparams.conf"), new File(file4, "i4jparams.conf" + string), fileOptions);
        this.fileInstaller.install(new File(file, "stats.properties"), new File(file4, "stats.properties" + string), fileOptions);
        this.installIfExists("uninstallPrevious.log", string, file, file4, fileOptions, null);
        this.installIfExists("launchers.xml", string, file, file4, fileOptions, null);
        this.installIfExists("user.jar", string, file, file4, fileOptions, null);
        this.installIfExists("user", string, file, file4, fileOptions, this.installedUserJars);
        ContextInt contextInt = ContextImpl.getContextInt(context);
        File file6 = contextInt.getAdditionalUserJarsDir();
        if (file6 != null) {
            this.installIfExists(file6.getName(), string, file6.getParentFile(), file4, fileOptions, this.installedUserJars, "user");
        }
        fileOptions.setMode("755");
        this.installIfExists("install4j", string, file, file4, fileOptions, null);
        fileOptions.setMode("644");
        File[] fileArray = new File(System.getProperty("user.dir")).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file7 = fileArray[i];
            String string2 = file7.getName().toLowerCase();
            if (!string2.endsWith(".dll") && !string2.endsWith(".exe") && !string2.startsWith("i4j_extf_")) continue;
            this.fileInstaller.install(file7, new File(file4, file7.getName()), fileOptions);
        }
    }

    private void installIfExists(String string, String string2, File file, File file2, FileOptions fileOptions, Set set) throws UserCanceledException, IOException {
        this.installIfExists(string, string2, file, file2, fileOptions, set, string);
    }

    private void installIfExists(String string, String string2, File file, File file2, FileOptions fileOptions, Set set, String string3) throws UserCanceledException, IOException {
        File file3 = new File(file, string);
        if (file3.exists()) {
            File file4 = new File(file2, string3 + string2);
            if (file3.isDirectory()) {
                this.fileInstaller.createDirectory(file4);
                File[] fileArray = file3.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string4 = fileArray[i].getName();
                        if (set != null && (set.contains(string4) || string4.endsWith(".pack"))) continue;
                        this.installIfExists(string4, "", file3, file4, fileOptions, set);
                    }
                }
            } else {
                this.fileInstaller.install(file3, file4, fileOptions);
            }
        }
    }

    public void setPreferredJre(String string) {
        this.jreInstaller.setPreferredJre(string);
    }

    public long getMinSize() {
        try {
            return this.jreInstaller.getJreSize() + ContentInstaller.getMinContentSize();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
    }

    private static long getMinContentSize() {
        return HelperCommunication.getInstance().fetchLong(ExecutionContext.UNELEVATED, new FetchLongAction(){

            protected long fetchValue(Context context) throws UserCanceledException {
                Comparable<File> comparable;
                long l;
                InstallFilesAction installFilesAction = (InstallFilesAction)context.getFirstAction(class$com$install4j$runtime$beans$actions$InstallFilesAction == null ? (class$com$install4j$runtime$beans$actions$InstallFilesAction = ContentInstaller.class$("com.install4j.runtime.beans.actions.InstallFilesAction")) : class$com$install4j$runtime$beans$actions$InstallFilesAction, null);
                try {
                    int n;
                    File[] fileArray;
                    l = ContentStats.getInstance().getSelectedContentSize();
                    comparable = InstallerUtil.getInstallerFile("user");
                    if (((File)comparable).isDirectory() && (fileArray = ((File)comparable).listFiles()) != null) {
                        for (n = 0; n < fileArray.length; ++n) {
                            if (!fileArray[n].isFile()) continue;
                            l += fileArray[n].length();
                        }
                    }
                    if ((fileArray = ((File)comparable).getParentFile().listFiles()) != null) {
                        for (n = 0; n < fileArray.length; ++n) {
                            if (!fileArray[n].isFile() || fileArray[n].getName().equals("jre.tar.gz") || fileArray[n].getName().equals("platform.zip")) continue;
                            l += fileArray[n].length();
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return 0L;
                }
                if (installFilesAction != null) {
                    try {
                        comparable = (Long)context.runScript(installFilesAction.getSizeCalculatorScript(), installFilesAction, new Object[]{new Long(l)});
                        if (comparable != null) {
                            l = (Long)comparable;
                        }
                    }
                    catch (Exception exception) {
                        Util.printAnnotatedStackTrace(exception);
                        Logger.getInstance().log(exception);
                    }
                }
                return l;
            }
        });
    }

    public static File validateInstallationDir(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6;
        boolean bl7;
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        boolean bl8 = bl7 = !Util.isMacosInstaller() || !installerConfig.getMacSpecificConfig().isSingleBundle();
        if (bl7 && !ApplicationRegistry.checkApplicationId(file)) {
            File file2;
            if (bl) {
                if (!installerConfig.isAddOnInstaller()) {
                    Util.showMessage(variableResourceBundleWrapper.getString(bl5 ? "DifferentApplication2" : "DifferentApplication"), 1);
                } else {
                    File file3;
                    if (Util.isMacosInstaller() && ApplicationRegistry.checkApplicationId(file3 = new File(file, "Contents/Resources/app"))) {
                        return file3;
                    }
                    Util.showMessage(variableResourceBundleWrapper.getString(bl5 ? "NoTargetApplication2" : "NoTargetApplication"), 1);
                }
                return null;
            }
            if (Util.isMacosInstaller() && installerConfig.isAddOnInstaller() && ApplicationRegistry.checkApplicationId(file2 = new File(file, "Contents/Resources/app"))) {
                return file2;
            }
        }
        if (!(bl6 = ApplicationRegistry.isUpdateDirectory(file)) && bl2) {
            long l = (long)((double)ContentInstaller.getInstance().getMinSize() * 1.1);
            long l2 = SystemInfo.getFreeDiskSpace(file);
            if (l2 != -1L && l > l2) {
                try {
                    if (InstallerUtil.isUnattended()) {
                        System.err.println("Not enough disk space for target directory: " + file.getAbsolutePath());
                        return null;
                    }
                    int n = Util.showOptionDialog(MessageFormat.format(variableResourceBundleWrapper.getString("DiskSpaceWarning"), String.valueOf(l / 1024L), String.valueOf(l2 / 1024L)), new String[]{variableResourceBundleWrapper.getString("ButtonYes"), variableResourceBundleWrapper.getString("ButtonNo")}, 3);
                    if (n == 1) {
                        return null;
                    }
                }
                catch (UserCanceledException userCanceledException) {
                    return null;
                }
            }
        }
        if (!installerConfig.isAddOnInstaller() && bl3 && file.exists() && !bl6 && !bl4 && bl7) {
            try {
                int n = Util.showOptionDialog(MessageFormat.format(variableResourceBundleWrapper.getString("DirExists"), file.getAbsolutePath()), new String[]{variableResourceBundleWrapper.getString("ButtonYes"), variableResourceBundleWrapper.getString("ButtonNo")}, 3);
                if (n != 0) {
                    return null;
                }
            }
            catch (UserCanceledException userCanceledException) {
                return null;
            }
        }
        return file;
    }

    public void cleanup() {
        ContentInstaller.cleanupInt();
    }

    private static void cleanupInt() {
        HelperCommunication.getInstance().executeAction(executionContext, new RunAction(){

            protected void run(Context context) {
                ContentInstaller.getInstance().jreInstaller.cleanup();
            }
        });
    }

    public void rollback() {
        ContentInstaller.rollbackInt();
    }

    private static void rollbackInt() {
        HelperCommunication.getInstance().executeAction(executionContext, new RunAction(){

            protected void run(Context context) {
                ContentInstaller.getInstance().jreInstaller.rollback();
            }
        });
    }

    public void doComponentInstallation(InstallerContext installerContext, ProgressInterface progressInterface, String string, AbstractInstallFilesAction abstractInstallFilesAction) throws IOException, UserCanceledException {
        if (installerContext.isCancelling()) {
            return;
        }
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            ContentInstaller.setExecutionContext(ExecutionContext.MAXIMUM);
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContentStats contentStats = ContentStats.getInstance();
        long l = contentStats.getSelectedContentSize(string);
        long l2 = contentStats.getSelectedContentCount(string);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        l += 153600L * l2;
        long l3 = 0L;
        Map map = new ContentCollector(progressInterface, installerContext, false).collectContentStreams(string);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            InputStream inputStream = (InputStream)iterator.next();
            l3 = this.installContent(installerContext, inputStream, progressInterface, abstractInstallFilesAction, l, l3);
        }
        progressInterface.setDetailMessage("");
        if (!installerContext.isCancelling()) {
            progressInterface.setPercentCompleted(100);
        }
    }
}

