/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.ProxyDialog;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import java.net.URLConnection;
import java.util.Properties;
import sun.misc.BASE64Encoder;

class ProxyConfig {
    private ProxyDialog proxyDialog;
    private boolean proxySet = false;
    private boolean auth = false;
    private String host = "";
    private String port = "";
    private String authPassword = "";
    private String authUser = "";
    public static final String PROXY_SET = "proxySet";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_AUTH = "proxyAuth";
    public static final String PROXY_AUTH_USER = "proxyAuthUser";
    public static final String PROXY_AUTH_PASSWORD = "proxyAuthPassword";
    public static final String PASSWORD_REQUIRED_VALUE = "i4j_pw_required";
    private static final String SYSPROP_CLEAR_PROXY_CACHE = "install4j.clearProxyCache";
    private static final String EXTERNAL_PROXY_SET = System.getProperty("proxySet");
    private boolean passwordRequired = false;

    public ProxyConfig() {
        if (Boolean.getBoolean(SYSPROP_CLEAR_PROXY_CACHE)) {
            this.setProperties();
            this.saveConfig();
            return;
        }
        String string = EXTERNAL_PROXY_SET;
        if (string == null) {
            string = InstallRegistry.getValue(PROXY_SET);
        }
        if (string != null) {
            this.proxySet = Boolean.valueOf(string);
        }
        if ((string = System.getProperty(PROXY_HOST)) == null) {
            string = InstallRegistry.getValue(PROXY_HOST);
        }
        if (string != null) {
            this.host = string;
        }
        if ((string = System.getProperty(PROXY_PORT)) == null) {
            string = InstallRegistry.getValue(PROXY_PORT);
        }
        if (string != null) {
            this.port = string;
        }
        if ((string = System.getProperty(PROXY_AUTH)) == null) {
            string = InstallRegistry.getValue(PROXY_AUTH);
        }
        if (string != null) {
            this.auth = Boolean.valueOf(string);
        }
        if ((string = System.getProperty(PROXY_AUTH_USER)) == null) {
            string = InstallRegistry.getValue(PROXY_AUTH_USER);
        }
        if (string != null) {
            this.authUser = string;
        }
        if ((string = System.getProperty(PROXY_AUTH_PASSWORD)) == null) {
            if (PASSWORD_REQUIRED_VALUE.equals(InstallRegistry.getValue(PROXY_AUTH_PASSWORD))) {
                this.passwordRequired = true;
            }
        } else {
            this.authPassword = string;
        }
        this.setProperties();
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public boolean isProxySet() {
        return this.proxySet;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void setProxySet(boolean bl) {
        this.proxySet = bl;
    }

    public void setAuth(boolean bl) {
        this.auth = bl;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setAuthPassword(String string) {
        this.authPassword = string;
    }

    public void setAuthUser(String string) {
        this.authUser = string;
    }

    public boolean isCanceled() {
        return this.proxyDialog != null ? this.proxyDialog.isCanceled() : false;
    }

    public void show(boolean bl, boolean bl2) throws UserCanceledException {
        if (bl) {
            ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
            VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
            if (bl2) {
                consoleImpl.println(variableResourceBundleWrapper.getString("ProxyAuthentication"));
                this.authPassword = consoleImpl.askPassword(variableResourceBundleWrapper.getString("Password"), "");
            } else {
                consoleImpl.println(variableResourceBundleWrapper.getString("DownloadError"));
                consoleImpl.println(variableResourceBundleWrapper.getString("ConnectionParametersRequest"));
                this.proxySet = consoleImpl.askYesNo(variableResourceBundleWrapper.getString("ProxyConnection"), this.proxySet);
                if (this.proxySet) {
                    this.host = consoleImpl.askString(variableResourceBundleWrapper.getString("ProxyHost"), this.host);
                    this.port = consoleImpl.askString(variableResourceBundleWrapper.getString("ProxyPort"), this.port);
                    this.auth = consoleImpl.askYesNo(variableResourceBundleWrapper.getString("ProxyAuthentication"), this.auth);
                    if (this.auth) {
                        this.authUser = consoleImpl.askString(variableResourceBundleWrapper.getString("UserName"), this.authUser);
                        this.authPassword = consoleImpl.askPassword(variableResourceBundleWrapper.getString("Password"), "");
                    }
                }
            }
        } else {
            if (this.proxyDialog == null) {
                this.proxyDialog = ProxyDialog.create(this, Util.getParentWindow());
            }
            this.proxyDialog.setPasswordOnly(bl2);
            this.proxyDialog.setVisible(true);
        }
        this.passwordRequired = false;
        this.setProperties();
        this.saveConfig();
    }

    public void setProperties() {
        System.setProperty(PROXY_SET, String.valueOf(this.isProxySet()));
        if (this.isProxySet()) {
            System.setProperty(PROXY_HOST, this.getHost());
            System.setProperty(PROXY_PORT, this.getPort());
        } else {
            Properties properties = System.getProperties();
            properties.remove(PROXY_HOST);
            properties.remove(PROXY_PORT);
        }
    }

    private void saveConfig() {
        InstallRegistry.setValue(PROXY_SET, String.valueOf(this.proxySet));
        InstallRegistry.setValue(PROXY_HOST, this.host);
        InstallRegistry.setValue(PROXY_PORT, this.port);
        InstallRegistry.setValue(PROXY_AUTH, String.valueOf(this.auth));
        InstallRegistry.setValue(PROXY_AUTH_USER, this.authUser);
        if (this.auth && this.authPassword.length() > 0) {
            InstallRegistry.setValue(PROXY_AUTH_PASSWORD, PASSWORD_REQUIRED_VALUE);
        } else {
            InstallRegistry.setValue(PROXY_AUTH_PASSWORD, "");
        }
    }

    public void updateConnection(URLConnection uRLConnection) {
        if (this.isProxySet() && this.isAuth()) {
            String string = this.getAuthUser() + ":" + this.getAuthPassword();
            String string2 = new BASE64Encoder().encode(string.getBytes());
            uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string2);
        }
    }

    public void update(ProxyHostInfo proxyHostInfo) {
        if (EXTERNAL_PROXY_SET != null && EXTERNAL_PROXY_SET.toLowerCase().equals("true")) {
            return;
        }
        if (proxyHostInfo != null) {
            this.host = proxyHostInfo.getHost();
            this.port = String.valueOf(proxyHostInfo.getPort());
            this.proxySet = true;
            this.auth = false;
        } else {
            this.proxySet = false;
        }
        this.setProperties();
    }
}

