/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.versionspecific.Java16Helper;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Set;

public class Java17Helper
extends Java16Helper {
    @Override
    public boolean isSymbolicLink(File file) {
        try {
            return Files.isSymbolicLink(file.toPath());
        }
        catch (InvalidPathException invalidPathException) {
            return super.isSymbolicLink(file);
        }
    }

    @Override
    public File getSymbolicLinkTargetFile(File file) throws IOException {
        try {
            return Files.readSymbolicLink(file.toPath()).toFile();
        }
        catch (InvalidPathException invalidPathException) {
            return super.getSymbolicLinkTargetFile(file);
        }
    }

    @Override
    public void createSymbolicLink(File file, File file2) throws IOException {
        try {
            Files.createSymbolicLink(file.toPath(), file2.toPath(), new FileAttribute[0]);
        }
        catch (InvalidPathException invalidPathException) {
            super.createSymbolicLink(file, file2);
        }
    }

    @Override
    public String getPosixFilePermissions(File file) throws IOException {
        try {
            return PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), LinkOption.NOFOLLOW_LINKS));
        }
        catch (InvalidPathException invalidPathException) {
            return super.getPosixFilePermissions(file);
        }
    }

    @Override
    public void setPosixFilePermissions(File file, String string) throws IOException {
        block6: {
            try {
                if (string == null || string.length() <= 0) break block6;
                if (Character.isDigit(string.charAt(0))) {
                    string = LegacyUnixFileSystem.toJavaTypeMode(string);
                }
                Path path = file.toPath();
                try {
                    Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(string));
                }
                catch (IOException iOException) {
                    if (!Files.isSymbolicLink(path)) {
                        throw iOException;
                    }
                }
            }
            catch (InvalidPathException invalidPathException) {
                super.setPosixFilePermissions(file, string);
            }
        }
    }

    @Override
    public void setOwner(File file, String string) throws IOException {
        try {
            UserPrincipal userPrincipal;
            String string2;
            int n = string.indexOf(58);
            String string3 = "";
            if (n > -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            } else {
                string2 = string;
            }
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            UserPrincipalLookupService userPrincipalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            if (string2.length() > 0) {
                userPrincipal = userPrincipalLookupService.lookupPrincipalByName(string2);
                posixFileAttributeView.setOwner(userPrincipal);
            }
            if (string3.length() > 0) {
                userPrincipal = userPrincipalLookupService.lookupPrincipalByGroupName(string3);
                posixFileAttributeView.setGroup((GroupPrincipal)userPrincipal);
            }
        }
        catch (InvalidPathException invalidPathException) {
            super.setOwner(file, string);
        }
    }

    @Override
    public UnixFileSystem.FileInformation getFileInformation(File file) throws IOException {
        try {
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            int n = LegacyUnixFileSystem.fromJavaTypeMode(PosixFilePermissions.toString(posixFileAttributes.permissions()));
            String string = posixFileAttributes.owner().getName() + ":" + posixFileAttributes.group().getName();
            String string2 = null;
            if (posixFileAttributes.isSymbolicLink()) {
                string2 = this.getSymbolicLinkTargetFile(file).getPath();
            }
            return new LegacyUnixFileSystem.FileInformationImpl(n, string, posixFileAttributes.isSymbolicLink(), string2);
        }
        catch (InvalidPathException invalidPathException) {
            return super.getFileInformation(file);
        }
    }

    @Override
    public void setPosixFilePermissionsRecursive(File file, String string) throws IOException {
        try {
            if (string != null && string.length() > 0) {
                if (Character.isDigit(string.charAt(0))) {
                    string = LegacyUnixFileSystem.toJavaTypeMode(string);
                }
                final Set<PosixFilePermission> set = PosixFilePermissions.fromString(string);
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        Files.setPosixFilePermissions(path, set);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                        Files.setPosixFilePermissions(path, set);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (InvalidPathException invalidPathException) {
            super.setPosixFilePermissionsRecursive(file, string);
        }
    }
}

