/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.Util;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class LegacyUnixFileSystem {
    private static final String LINK_ARROW = " -> ";

    public static boolean setMode(int n, File file) {
        return LegacyUnixFileSystem.setMode(StringUtil.padLeft(Integer.toOctalString(n & 0x1FF), '0', 3), file, false);
    }

    public static boolean setMode(String string, File file) {
        return LegacyUnixFileSystem.setMode(string, file, false);
    }

    public static boolean setMode(String string, File file, boolean bl) {
        return LegacyUnixFileSystem.setMode(string, file, bl, null);
    }

    public static boolean setMode(String string, File file, boolean bl, StringBuffer stringBuffer) {
        if (Util.isWindows()) {
            return false;
        }
        if (Boolean.getBoolean("install4j.noDefaultChmod") && string.equals("644")) {
            return true;
        }
        try {
            String string2 = LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath());
            if (bl) {
                return Execution.executeAndWait(new String[]{"chmod", "-R", string, string2}, stringBuffer);
            }
            return Execution.executeAndWait(new String[]{"chmod", string, string2}, stringBuffer);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean setMode(String string, Collection collection) {
        if (Util.isWindows()) {
            return false;
        }
        try {
            String[] stringArray = new String[collection.size() + 2];
            stringArray[0] = "chmod";
            stringArray[1] = string;
            int n = 2;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                stringArray[n++] = LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath());
            }
            return Execution.executeAndWait(stringArray, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean createLink(String string, File file) throws IOException {
        if (Util.isWindows()) {
            return false;
        }
        file.delete();
        return Execution.executeAndWait(new String[]{"ln", "-s", LegacyUnixFileSystem.quoteDollarSign(string), LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath())}, null);
    }

    public static boolean setOwner(String string, File file) {
        if (Util.isWindows()) {
            return false;
        }
        try {
            return Execution.executeAndWait(new String[]{"chown", string, LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath())}, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static FileInformationImpl getFileInformation(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath());
            if (!Execution.executeAndWait(new String[]{"ls", "-lad", string}, stringBuffer) || stringBuffer.length() == 0) {
                return null;
            }
            FileInformationImpl fileInformationImpl = new FileInformationImpl();
            fileInformationImpl.mode = LegacyUnixFileSystem.fromJavaTypeMode(stringBuffer.substring(1));
            fileInformationImpl.ownerInfo = LegacyUnixFileSystem.getOwnerInfo(stringBuffer);
            fileInformationImpl.link = stringBuffer.charAt(0) == 'l';
            if (fileInformationImpl.link) {
                fileInformationImpl.linkTarget = LegacyUnixFileSystem.getLinkTarget(stringBuffer.toString());
            }
            return fileInformationImpl;
        }
        catch (Exception exception) {
            System.err.println("Could not get file information for " + file.getAbsolutePath() + ", exception: " + exception.getMessage());
            return null;
        }
    }

    private static String quoteDollarSign(String string) {
        return string.replaceAll("\\$", "\\\\\\$");
    }

    public static int getMode(File file) {
        FileInformationImpl fileInformationImpl = LegacyUnixFileSystem.getFileInformation(file);
        if (fileInformationImpl != null) {
            return fileInformationImpl.getMode();
        }
        return -1;
    }

    public static String getOwnerInfo(File file) {
        FileInformationImpl fileInformationImpl = LegacyUnixFileSystem.getFileInformation(file);
        if (fileInformationImpl != null) {
            return fileInformationImpl.getOwnerInfo();
        }
        return null;
    }

    private static String getLinkTarget(String string) {
        int n = string.lastIndexOf(LINK_ARROW);
        if (n > -1) {
            return string.substring(n + LINK_ARROW.length()).trim();
        }
        return null;
    }

    private static String getOwnerInfo(StringBuffer stringBuffer) {
        int n;
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " ");
        for (n = 0; stringTokenizer.hasMoreTokens() && n < 4; ++n) {
            String string2 = stringTokenizer.nextToken();
            if (n == 2) {
                string = string2.trim();
                continue;
            }
            if (n != 3) continue;
            string = string + ":" + string2.trim();
        }
        if (n == 4 && string.length() > 0) {
            return string;
        }
        return null;
    }

    public static int fromJavaTypeMode(String string) {
        if (string.length() < 9) {
            return -1;
        }
        int n = LegacyUnixFileSystem.getGroupMode(string, 0);
        n += LegacyUnixFileSystem.getGroupMode(string, 1);
        return n += LegacyUnixFileSystem.getGroupMode(string, 2);
    }

    private static int getGroupMode(String string, int n) {
        int n2 = (int)Math.pow(8.0, 2 - n);
        int n3 = 0;
        if (string.charAt(0 + n * 3) == 'r') {
            n3 += n2 * 4;
        }
        if (string.charAt(1 + n * 3) == 'w') {
            n3 += n2 * 2;
        }
        if (string.charAt(2 + n * 3) == 'x') {
            n3 += n2;
        }
        return n3;
    }

    public static String toJavaTypeMode(String string) {
        int n = Integer.parseInt(string, 8);
        StringBuffer stringBuffer = new StringBuffer();
        LegacyUnixFileSystem.appendSingleJavaTypeMode((n & 0x1C0) >> 6, stringBuffer);
        LegacyUnixFileSystem.appendSingleJavaTypeMode((n & 0x38) >> 3, stringBuffer);
        LegacyUnixFileSystem.appendSingleJavaTypeMode(n & 7, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendSingleJavaTypeMode(int n, StringBuffer stringBuffer) {
        if ((n & 4) > 0) {
            stringBuffer.append("r");
        } else {
            stringBuffer.append("-");
        }
        if ((n & 2) > 0) {
            stringBuffer.append("w");
        } else {
            stringBuffer.append("-");
        }
        if ((n & 1) > 0) {
            stringBuffer.append("x");
        } else {
            stringBuffer.append("-");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(Integer.toOctalString(LegacyUnixFileSystem.fromJavaTypeMode(LegacyUnixFileSystem.toJavaTypeMode("664"))));
    }

    public static class FileInformationImpl
    implements UnixFileSystem.FileInformation {
        private int mode = -1;
        private String ownerInfo;
        private boolean link;
        private String linkTarget;

        private FileInformationImpl() {
        }

        public FileInformationImpl(int n, String string, boolean bl, String string2) {
            this.mode = n;
            this.ownerInfo = string;
            this.link = bl;
            this.linkTarget = string2;
        }

        public int getMode() {
            return this.mode;
        }

        public String getOwnerInfo() {
            return this.ownerInfo;
        }

        public boolean isLink() {
            return this.link;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public String toString() {
            return Integer.toOctalString(this.mode) + ", " + this.ownerInfo + ", link: " + this.link + (this.link ? ", target: " + this.linkTarget : "");
        }
    }
}

