/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.db2;

import com.onseven.dbvis.J.A.B;
import com.onseven.dbvis.J.B.J;
import com.onseven.dbvis.J.B.O;
import com.onseven.dbvis.db.A.G;
import com.onseven.dbvis.db.DatabaseFacade;
import com.onseven.dbvis.db.ExplainPlanHandler;
import com.onseven.dbvis.db.db2.DB2Util;
import com.onseven.dbvis.sql.H;
import com.onseven.dbvis.sql.M;
import com.onseven.dbvis.sql.PropsManagerWrapper;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.table.TableModel;
import se.pureit.A.B.A;

public class DB2ExplainPlanHandler
implements ExplainPlanHandler {
    private static final String[] DISPLAY_COLUMNS_AND_ORDER = new String[]{"TOTAL_COST", "CPU_COST", "IO_COST", "FIRST_ROW_COST", "RE_TOTAL_COST", "RE_CPU_COST", "RE_IO_COST", "COMM_COST", "FIRST_COMM_COST", "BUFFERS", "REMOTE_TOTAL_COST", "REMOTE_COMM_COST", "STREAM_COUNT", "COLUMN_COUNT"};
    private G dbConnection;
    private String schemaName;
    private int majorVersion;
    private String queryTag;

    private void init(H h2) throws M {
        boolean bl;
        String string;
        this.dbConnection = h2.\u0104();
        PropsManagerWrapper propsManagerWrapper = this.dbConnection.\u0135();
        boolean bl2 = propsManagerWrapper.getBool("UseUserDefinedExplainTable");
        if (bl2) {
            this.schemaName = propsManagerWrapper.getProperty("ExplainSchema");
            if (this.schemaName.length() == 0) {
                this.schemaName = this.dbConnection.\u0137().\u0128();
            }
        } else {
            this.schemaName = "SYSTOOLS";
        }
        this.majorVersion = this.dbConnection.\u0137().\u0108();
        this.queryTag = "dbvis-" + System.currentTimeMillis();
        J j2 = new J(false);
        DatabaseFacade databaseFacade = this.dbConnection.\u0106();
        boolean bl3 = databaseFacade.doesTableExist(null, this.schemaName, string = "EXPLAIN_INSTANCE");
        if (!bl3) {
            bl3 = databaseFacade.doesTableExist(null, this.schemaName.toUpperCase(Locale.ENGLISH), string);
        }
        if ((bl = propsManagerWrapper.getBool("CreateExplainTable")) && !bl3) {
            String string2;
            try {
                string2 = DB2Util.getCreateExplainInstanceTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o2) {
                // empty catch block
            }
            try {
                string2 = DB2Util.getCreateExplainStatementTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o3) {
                // empty catch block
            }
            try {
                string2 = DB2Util.getCreateExplainArgumentTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o4) {
                // empty catch block
            }
            try {
                string2 = DB2Util.getCreateExplainObjectTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o5) {
                // empty catch block
            }
            try {
                string2 = DB2Util.getCreateExplainOperatorTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o6) {
                // empty catch block
            }
            try {
                string2 = DB2Util.getCreateExplainPredicateTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o7) {
                // empty catch block
            }
            try {
                string2 = DB2Util.getCreateExplainStreamTable(this.schemaName, this.majorVersion);
                h2.\u0105(string2);
                j2.execute(h2);
                j2.run();
            }
            catch (O o8) {}
        } else if (!bl3) {
            throw new M(DB2ExplainPlanHandler.getText("NoPlanTable"));
        }
    }

    @Override
    public com.onseven.dbvis.sql.A.A fetchExplainPlan(H h2) throws O, SQLException {
        H h3 = (H)h2.clone();
        this.init(h3);
        B b2 = this.queryExplainPlan(h3, h2);
        com.onseven.dbvis.sql.A.A a2 = this.createExplainPlanResult(b2);
        this.cleanUp(h3);
        return a2;
    }

    private B queryExplainPlan(H h2, H h3) throws O {
        String string = DB2Util.getExplainPlanStmt(this.queryTag, h3.\u010e());
        h2.\u0105(string);
        J j2 = new J();
        j2.setSchemaAutomatically(true);
        j2.execute(h2);
        j2.run();
        String string2 = DB2Util.getSelectExplainPlanStmt(this.schemaName, this.queryTag);
        h2.\u0105(string2);
        j2.execute(h2);
        j2.run();
        return j2.getFirstDataSet();
    }

    private com.onseven.dbvis.sql.A.A createExplainPlanResult(B b2) {
        Object object;
        int[] nArray = this.getDisplayColumns((TableModel)((Object)b2));
        Class[] classArray = new Class[nArray.length];
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string;
            object = com.onseven.dbvis.sql.A.A.getFixedColumnName(i2);
            if (object == null) {
                object = b2.getColumnName(nArray[i2]);
            }
            stringArray[i2] = (string = DB2ExplainPlanHandler.getText((String)object)) != null && string.length() > 0 ? string : object;
            String string2 = DB2ExplainPlanHandler.getText("descr." + (String)object);
            stringArray2[i2] = string2 != null ? string2 : DB2ExplainPlanHandler.getText("NoDescription");
            Class clazz = com.onseven.dbvis.sql.A.A.getFixedColumnClass(i2);
            if (clazz == null) {
                clazz = b2.getColumnClass(nArray[i2]);
            }
            classArray[i2] = clazz;
        }
        com.onseven.dbvis.sql.A.A a2 = new com.onseven.dbvis.sql.A.A(stringArray, classArray, stringArray2);
        a2.setExecutionResult(b2.getExecutionResult());
        object = b2.getSortedDataSet(1, true);
        int n2 = object.getRowCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            this.addExplainPlanEntry(a2, (TableModel)object, i3);
        }
        a2.calcNodeCost();
        PropsManagerWrapper propsManagerWrapper = this.dbConnection.\u0135();
        boolean bl = propsManagerWrapper.getBool("ColorCriticalNodes");
        if (bl) {
            int n3 = propsManagerWrapper.getInt("CriticalThreshold");
            int n4 = propsManagerWrapper.getInt("WarningThreshold");
            a2.calcCostLevel(n3, n4);
        }
        return a2;
    }

    private void cleanUp(H h2) {
        PropsManagerWrapper propsManagerWrapper = this.dbConnection.\u0135();
        boolean bl = propsManagerWrapper.getBool("DropExplainTable");
        if (bl) {
            this.dropExplainPlanTables(h2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropExplainPlanTables(H h2) {
        J j2 = new J(false);
        try {
            this.dbConnection.\u0133();
            try {
                h2.\u0105(DB2Util.getDropExplainStreamTableStmt(this.schemaName));
                j2.execute(h2);
                j2.run();
            }
            catch (O o2) {
                // empty catch block
            }
            try {
                h2.\u0105(DB2Util.getDropExplainArgumentTableStmt(this.schemaName));
                j2.execute(h2);
                j2.run();
            }
            catch (O o3) {
                // empty catch block
            }
            try {
                h2.\u0105(DB2Util.getDropExplainPredicateTableStmt(this.schemaName));
                j2.run();
                j2.execute(h2);
            }
            catch (O o4) {
                // empty catch block
            }
            try {
                h2.\u0105(DB2Util.getDropExplainObjectTableStmt(this.schemaName));
                j2.execute(h2);
                j2.run();
            }
            catch (O o5) {
                // empty catch block
            }
            try {
                h2.\u0105(DB2Util.getDropExplainOperatorTableStmt(this.schemaName));
                j2.execute(h2);
                j2.run();
            }
            catch (O o6) {
                // empty catch block
            }
            try {
                h2.\u0105(DB2Util.getDropExplainStatementTableStmt(this.schemaName));
                j2.execute(h2);
                j2.run();
            }
            catch (O o7) {
                // empty catch block
            }
            try {
                h2.\u0105(DB2Util.getDropExplainInstanceTableStmt(this.schemaName));
                j2.execute(h2);
                j2.run();
            }
            catch (O o8) {
                // empty catch block
            }
        }
        finally {
            this.dbConnection.\u010b();
        }
    }

    private void addExplainPlanEntry(com.onseven.dbvis.sql.A.A a2, TableModel tableModel, int n2) {
        Object object;
        Object object2;
        Object object3;
        String string;
        int[] nArray = this.getDisplayColumns(tableModel);
        Object[] objectArray = new Object[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 == 0) {
                string = (String)tableModel.getValueAt(n2, 0);
                object3 = (String)tableModel.getValueAt(n2, 3);
                object2 = (String)tableModel.getValueAt(n2, 4);
                object = (object3 != null ? ((String)object3).trim() + "." : "") + (object2 != null ? ((String)object2).trim() : "");
                objectArray[i2] = (((String)object).length() > 0 ? (String)object + "  " : "") + string;
                continue;
            }
            objectArray[i2] = i2 == 1 ? "" : tableModel.getValueAt(n2, nArray[i2]);
        }
        Object object4 = tableModel.getValueAt(n2, 1);
        string = object4 != null ? object4.toString() : "1";
        object3 = new com.onseven.dbvis.sql.A.B(string);
        ((com.onseven.dbvis.sql.A.B)object3).\u0101(objectArray);
        object2 = (Double)tableModel.getValueAt(n2, 5);
        ((com.onseven.dbvis.sql.A.B)object3).\u0104(object2 != null ? (Double)object2 : 0.0);
        object = tableModel.getValueAt(n2, 2);
        String string2 = object != null ? object.toString() : null;
        a2.addEntry((com.onseven.dbvis.sql.A.B)object3, string2);
    }

    private int getColumnIndex(TableModel tableModel, String string) {
        if (tableModel != null) {
            int n2 = tableModel.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = tableModel.getColumnName(i2);
                if (!string2.equals(string)) continue;
                return i2;
            }
        }
        return -1;
    }

    private int[] getDisplayColumns(TableModel tableModel) {
        int n2;
        int n3 = 0;
        for (int i2 = 0; i2 < DISPLAY_COLUMNS_AND_ORDER.length; ++i2) {
            n2 = this.getColumnIndex(tableModel, DISPLAY_COLUMNS_AND_ORDER[i2]);
            n3 += n2 > -1 ? 1 : 0;
        }
        int[] nArray = new int[n3 + com.onseven.dbvis.sql.A.A.FIXED_COLUMN_NAMES.length];
        n2 = com.onseven.dbvis.sql.A.A.FIXED_COLUMN_NAMES.length;
        for (int i3 = 0; i3 < DISPLAY_COLUMNS_AND_ORDER.length; ++i3) {
            int n4 = this.getColumnIndex(tableModel, DISPLAY_COLUMNS_AND_ORDER[i3]);
            if (n4 <= -1) continue;
            nArray[n2++] = n4;
        }
        return nArray;
    }

    private static String getText(String string) {
        return A.\u0101(DB2ExplainPlanHandler.class, "DB2ExplainPlanHandler." + string);
    }
}

