/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.db2;

public class DB2Util {
    public static final int OPERATOR_TYPE_COL = 0;
    public static final int SOURCE_ID_COL = 1;
    public static final int TARGET_ID_COL = 2;
    public static final int OBJECT_OWNER_COL = 3;
    public static final int OBJECT_NAME_COL = 4;
    public static final int TOTAL_COST_COL = 5;
    private static String SCHEMA_TAG = "<schema>";
    private static String CREATE_EXPLAIN_INSTANCE_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_INSTANCE (EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, EXPLAIN_OPTION    CHAR(1)      NOT NULL, SNAPSHOT_TAKEN    CHAR(1)      NOT NULL, DB2_VERSION       CHAR(7)      NOT NULL, SQL_TYPE          CHAR(1)      NOT NULL, QUERYOPT          INTEGER      NOT NULL, BLOCK             CHAR(1)      NOT NULL, ISOLATION         CHAR(2)      NOT NULL, BUFFPAGE          INTEGER      NOT NULL, AVG_APPLS         INTEGER      NOT NULL, SORTHEAP          INTEGER      NOT NULL, LOCKLIST          INTEGER      NOT NULL, MAXLOCKS          SMALLINT     NOT NULL, LOCKS_AVAIL       INTEGER      NOT NULL, CPU_SPEED         DOUBLE       NOT NULL, REMARKS           VARCHAR(254),DBHEAP            INTEGER      NOT NULL, COMM_SPEED        DOUBLE       NOT NULL, PARALLELISM       CHAR(2)      NOT NULL, DATAJOINER        CHAR(1)      NOT NULL, PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA))";
    private static String CREATE_EXPLAIN_INSTANCE_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_INSTANCE ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,EXPLAIN_TIME      TIMESTAMP    NOT NULL,SOURCE_NAME       VARCHAR(128) NOT NULL,SOURCE_SCHEMA     VARCHAR(128) NOT NULL,SOURCE_VERSION    VARCHAR(64)  NOT NULL,EXPLAIN_OPTION    CHAR(1)      NOT NULL,SNAPSHOT_TAKEN    CHAR(1)      NOT NULL,DB2_VERSION       CHAR(7)      NOT NULL,SQL_TYPE          CHAR(1)      NOT NULL,QUERYOPT          INTEGER      NOT NULL,BLOCK             CHAR(1)      NOT NULL,ISOLATION         CHAR(2)      NOT NULL,BUFFPAGE          INTEGER      NOT NULL,AVG_APPLS         INTEGER      NOT NULL,SORTHEAP          INTEGER      NOT NULL,LOCKLIST          INTEGER      NOT NULL,MAXLOCKS          SMALLINT     NOT NULL,LOCKS_AVAIL       INTEGER      NOT NULL,CPU_SPEED         DOUBLE       NOT NULL,REMARKS           VARCHAR(254),DBHEAP            INTEGER      NOT NULL,COMM_SPEED        DOUBLE       NOT NULL,PARALLELISM       CHAR(2)      NOT NULL,DATAJOINER        CHAR(1)      NOT NULL,PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION))";
    private static String CREATE_EXPLAIN_INSTANCE_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_INSTANCE     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_OPTION CHAR(1) NOT NULL,         SNAPSHOT_TAKEN CHAR(1) NOT NULL,         DB2_VERSION CHAR(7) NOT NULL,         SQL_TYPE CHAR(1) NOT NULL,         QUERYOPT INTEGER NOT NULL,         BLOCK CHAR(1) NOT NULL,         ISOLATION CHAR(2) NOT NULL,         BUFFPAGE INTEGER NOT NULL,         AVG_APPLS INTEGER NOT NULL,         SORTHEAP INTEGER NOT NULL,         LOCKLIST INTEGER NOT NULL,         MAXLOCKS SMALLINT NOT NULL,         LOCKS_AVAIL INTEGER NOT NULL,         CPU_SPEED DOUBLE NOT NULL,         REMARKS VARCHAR(254),         DBHEAP INTEGER NOT NULL,         COMM_SPEED DOUBLE NOT NULL,         PARALLELISM CHAR(2) NOT NULL,         DATAJOINER CHAR(1) NOT NULL,         PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION)    )";
    private static String CREATE_EXPLAIN_INSTANCE_TABLE_10_STMT = "CREATE     TABLE <schema>.EXPLAIN_INSTANCE     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_OPTION CHAR(1) NOT NULL,         SNAPSHOT_TAKEN CHAR(1) NOT NULL,         DB2_VERSION CHAR(7) NOT NULL,         SQL_TYPE CHAR(1) NOT NULL,         QUERYOPT INTEGER NOT NULL,         BLOCK CHAR(1) NOT NULL,         ISOLATION CHAR(2) NOT NULL,         BUFFPAGE INTEGER NOT NULL,         AVG_APPLS INTEGER NOT NULL,         SORTHEAP INTEGER NOT NULL,         LOCKLIST INTEGER NOT NULL,         MAXLOCKS SMALLINT NOT NULL,         LOCKS_AVAIL INTEGER NOT NULL,         CPU_SPEED DOUBLE NOT NULL,         REMARKS VARCHAR(254),         DBHEAP INTEGER NOT NULL,         COMM_SPEED DOUBLE NOT NULL,         PARALLELISM CHAR(2) NOT NULL,         DATAJOINER CHAR(1) NOT NULL,         EXECUTABLE_ID VARCHAR(32),         EXECUTION_TIME TIMESTAMP,         PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION)    )";
    private static String CREATE_EXPLAIN_STATEMENT_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_STATEMENT ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, QUERYNO           INTEGER      NOT NULL, QUERYTAG          CHAR(20)     NOT NULL, STATEMENT_TYPE    CHAR(2)      NOT NULL, UPDATABLE         CHAR(1)      NOT NULL, DELETABLE         CHAR(1)      NOT NULL, TOTAL_COST        DOUBLE       NOT NULL, STATEMENT_TEXT    CLOB(1M)     NOT NULL NOT LOGGED, SNAPSHOT          BLOB(10M)    NOT LOGGED, QUERY_DEGREE      INTEGER      NOT NULL, PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, EXPLAIN_LEVEL, STMTNO, SECTNO), FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA) REFERENCES <schema>.EXPLAIN_INSTANCE ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_STATEMENT_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_STATEMENT ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, SOURCE_VERSION    VARCHAR(64)  NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, QUERYNO           INTEGER      NOT NULL, QUERYTAG          CHAR(20)     NOT NULL, STATEMENT_TYPE    CHAR(2)      NOT NULL, UPDATABLE         CHAR(1)      NOT NULL, DELETABLE         CHAR(1)      NOT NULL, TOTAL_COST        DOUBLE       NOT NULL, STATEMENT_TEXT    CLOB(2M)     NOT NULL NOT LOGGED, SNAPSHOT          BLOB(10M)    NOT LOGGED, QUERY_DEGREE      INTEGER      NOT NULL, PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO), FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION) REFERENCES <schema>.EXPLAIN_INSTANCE ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_STATEMENT_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_STATEMENT     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         QUERYNO INTEGER NOT NULL,         QUERYTAG CHAR(20) NOT NULL,         STATEMENT_TYPE CHAR(2) NOT NULL,         UPDATABLE CHAR(1) NOT NULL,         DELETABLE CHAR(1) NOT NULL,         TOTAL_COST DOUBLE NOT NULL,         STATEMENT_TEXT CLOB(2M) NOT NULL NOT LOGGED,         SNAPSHOT BLOB(10M) NOT LOGGED,         QUERY_DEGREE INTEGER NOT NULL,         PRIMARY KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO),         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION) REFERENCES <schema>.EXPLAIN_INSTANCE         ON     DELETE         CASCADE    )";
    private static String CREATE_EXPLAIN_ARGUMENT_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_ARGUMENT ( EXPLAIN_REQUESTER   VARCHAR(128)  NOT NULL, EXPLAIN_TIME        TIMESTAMP     NOT NULL, SOURCE_NAME         VARCHAR(128)  NOT NULL, SOURCE_SCHEMA       VARCHAR(128)  NOT NULL, EXPLAIN_LEVEL       CHAR(1)       NOT NULL, STMTNO              INTEGER       NOT NULL, SECTNO              INTEGER       NOT NULL, OPERATOR_ID         INTEGER       NOT NULL, ARGUMENT_TYPE       CHAR(8)       NOT NULL, ARGUMENT_VALUE      VARCHAR(1024), LONG_ARGUMENT_VALUE CLOB(1M)      NOT LOGGED, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_ARGUMENT_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_ARGUMENT ( EXPLAIN_REQUESTER   VARCHAR(128)  NOT NULL, EXPLAIN_TIME        TIMESTAMP     NOT NULL, SOURCE_NAME         VARCHAR(128)  NOT NULL, SOURCE_SCHEMA       VARCHAR(128)  NOT NULL, SOURCE_VERSION      VARCHAR(64)   NOT NULL, EXPLAIN_LEVEL       CHAR(1)       NOT NULL, STMTNO              INTEGER       NOT NULL, SECTNO              INTEGER       NOT NULL, OPERATOR_ID         INTEGER       NOT NULL, ARGUMENT_TYPE       CHAR(8)       NOT NULL, ARGUMENT_VALUE      VARCHAR(1024), LONG_ARGUMENT_VALUE CLOB(2M)      NOT LOGGED,FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_ARGUMENT_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_ARGUMENT     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         OPERATOR_ID INTEGER NOT NULL,         ARGUMENT_TYPE CHAR(8) NOT NULL,         ARGUMENT_VALUE VARCHAR(1024),         LONG_ARGUMENT_VALUE CLOB(2M) NOT LOGGED,         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT         ON     DELETE         CASCADE    )";
    private static String CREATE_EXPLAIN_OBJECT_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_OBJECT ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, OBJECT_SCHEMA     VARCHAR(128) NOT NULL, OBJECT_NAME       VARCHAR(128) NOT NULL, OBJECT_TYPE       CHAR(2)      NOT NULL, CREATE_TIME       TIMESTAMP, STATISTICS_TIME   TIMESTAMP, COLUMN_COUNT      SMALLINT     NOT NULL, ROW_COUNT         BIGINT       NOT NULL, WIDTH             INTEGER      NOT NULL, PAGES             INTEGER      NOT NULL, DISTINCT          CHAR(1)      NOT NULL, TABLESPACE_NAME   VARCHAR(128), OVERHEAD          DOUBLE       NOT NULL, TRANSFER_RATE     DOUBLE       NOT NULL, PREFETCHSIZE      INTEGER      NOT NULL, EXTENTSIZE        INTEGER      NOT NULL, CLUSTER           DOUBLE       NOT NULL, NLEAF             INTEGER      NOT NULL, NLEVELS           INTEGER      NOT NULL, FULLKEYCARD       BIGINT       NOT NULL, OVERFLOW          INTEGER      NOT NULL, FIRSTKEYCARD      BIGINT       NOT NULL, FIRST2KEYCARD     BIGINT       NOT NULL, FIRST3KEYCARD     BIGINT       NOT NULL, FIRST4KEYCARD     BIGINT       NOT NULL, SEQUENTIAL_PAGES  INTEGER      NOT NULL, DENSITY           INTEGER      NOT NULL, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_OBJECT_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_OBJECT ( EXPLAIN_REQUESTER    VARCHAR(128) NOT NULL, EXPLAIN_TIME         TIMESTAMP    NOT NULL, SOURCE_NAME          VARCHAR(128) NOT NULL, SOURCE_SCHEMA        VARCHAR(128) NOT NULL, SOURCE_VERSION       VARCHAR(64)  NOT NULL, EXPLAIN_LEVEL        CHAR(1)      NOT NULL, STMTNO               INTEGER      NOT NULL, SECTNO               INTEGER      NOT NULL, OBJECT_SCHEMA        VARCHAR(128) NOT NULL, OBJECT_NAME          VARCHAR(128) NOT NULL, OBJECT_TYPE          CHAR(2)      NOT NULL, CREATE_TIME          TIMESTAMP, STATISTICS_TIME      TIMESTAMP, COLUMN_COUNT         SMALLINT     NOT NULL, ROW_COUNT            BIGINT       NOT NULL, WIDTH                INTEGER      NOT NULL, PAGES                INTEGER      NOT NULL, DISTINCT             CHAR(1)      NOT NULL, TABLESPACE_NAME      VARCHAR(128), OVERHEAD             DOUBLE       NOT NULL, TRANSFER_RATE        DOUBLE       NOT NULL, PREFETCHSIZE         INTEGER      NOT NULL, EXTENTSIZE           INTEGER      NOT NULL, CLUSTER              DOUBLE       NOT NULL, NLEAF                INTEGER      NOT NULL, NLEVELS              INTEGER      NOT NULL, FULLKEYCARD          BIGINT       NOT NULL, OVERFLOW             INTEGER      NOT NULL, FIRSTKEYCARD         BIGINT       NOT NULL, FIRST2KEYCARD        BIGINT       NOT NULL, FIRST3KEYCARD        BIGINT       NOT NULL, FIRST4KEYCARD        BIGINT       NOT NULL, SEQUENTIAL_PAGES     INTEGER      NOT NULL, DENSITY              INTEGER      NOT NULL, STATS_SRC            CHAR(1)      NOT NULL, AVERAGE_SEQUENCE_GAP          DOUBLE  NOT NULL, AVERAGE_SEQUENCE_FETCH_GAP    DOUBLE  NOT NULL, AVERAGE_SEQUENCE_PAGES        DOUBLE  NOT NULL, AVERAGE_SEQUENCE_FETCH_PAGES  DOUBLE  NOT NULL, AVERAGE_RANDOM_PAGES          DOUBLE  NOT NULL, AVERAGE_RANDOM_FETCH_PAGES    DOUBLE  NOT NULL, NUMRIDS                       BIGINT  NOT NULL, NUMRIDS_DELETED               BIGINT  NOT NULL, NUM_EMPTY_LEAFS               BIGINT  NOT NULL, ACTIVE_BLOCKS                 BIGINT  NOT NULL, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_OBJECT_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_OBJECT     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         OBJECT_SCHEMA VARCHAR(128) NOT NULL,         OBJECT_NAME VARCHAR(128) NOT NULL,         OBJECT_TYPE CHAR(2) NOT NULL,         CREATE_TIME TIMESTAMP,         STATISTICS_TIME TIMESTAMP,         COLUMN_COUNT SMALLINT NOT NULL,         ROW_COUNT BIGINT NOT NULL,         WIDTH INTEGER NOT NULL,         PAGES BIGINT NOT NULL,         DISTINCT CHAR(1) NOT NULL,         TABLESPACE_NAME VARCHAR(128),         OVERHEAD DOUBLE NOT NULL,         TRANSFER_RATE DOUBLE NOT NULL,         PREFETCHSIZE INTEGER NOT NULL,         EXTENTSIZE INTEGER NOT NULL,         CLUSTER DOUBLE NOT NULL,         NLEAF BIGINT NOT NULL,         NLEVELS INTEGER NOT NULL,         FULLKEYCARD BIGINT NOT NULL,         OVERFLOW BIGINT NOT NULL,         FIRSTKEYCARD BIGINT NOT NULL,         FIRST2KEYCARD BIGINT NOT NULL,         FIRST3KEYCARD BIGINT NOT NULL,         FIRST4KEYCARD BIGINT NOT NULL,         SEQUENTIAL_PAGES BIGINT NOT NULL,         DENSITY INTEGER NOT NULL,         STATS_SRC CHAR(1) NOT NULL,         AVERAGE_SEQUENCE_GAP DOUBLE NOT NULL,         AVERAGE_SEQUENCE_FETCH_GAP DOUBLE NOT NULL,         AVERAGE_SEQUENCE_PAGES DOUBLE NOT NULL,         AVERAGE_SEQUENCE_FETCH_PAGES DOUBLE NOT NULL,         AVERAGE_RANDOM_PAGES DOUBLE NOT NULL,         AVERAGE_RANDOM_FETCH_PAGES DOUBLE NOT NULL,         NUMRIDS BIGINT NOT NULL,         NUMRIDS_DELETED BIGINT NOT NULL,         NUM_EMPTY_LEAFS BIGINT NOT NULL,         ACTIVE_BLOCKS BIGINT NOT NULL,         NUM_DATA_PARTS INTEGER NOT NULL,         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT         ON     DELETE         CASCADE    )";
    private static String CREATE_EXPLAIN_OPERATOR_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_OPERATOR ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, OPERATOR_ID       INTEGER      NOT NULL, OPERATOR_TYPE     CHAR(6)      NOT NULL, TOTAL_COST        DOUBLE       NOT NULL, IO_COST           DOUBLE       NOT NULL, CPU_COST          DOUBLE       NOT NULL, FIRST_ROW_COST    DOUBLE       NOT NULL, RE_TOTAL_COST     DOUBLE       NOT NULL, RE_IO_COST        DOUBLE       NOT NULL, RE_CPU_COST       DOUBLE       NOT NULL, COMM_COST         DOUBLE       NOT NULL, FIRST_COMM_COST   DOUBLE       NOT NULL, BUFFERS           DOUBLE       NOT NULL, REMOTE_TOTAL_COST DOUBLE       NOT NULL, REMOTE_COMM_COST  DOUBLE       NOT NULL, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_OPERATOR_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_OPERATOR ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, SOURCE_VERSION    VARCHAR(64)  NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, OPERATOR_ID       INTEGER      NOT NULL, OPERATOR_TYPE     CHAR(6)      NOT NULL, TOTAL_COST        DOUBLE       NOT NULL, IO_COST           DOUBLE       NOT NULL, CPU_COST          DOUBLE       NOT NULL, FIRST_ROW_COST    DOUBLE       NOT NULL, RE_TOTAL_COST     DOUBLE       NOT NULL, RE_IO_COST        DOUBLE       NOT NULL, RE_CPU_COST       DOUBLE       NOT NULL, COMM_COST         DOUBLE       NOT NULL, FIRST_COMM_COST   DOUBLE       NOT NULL, BUFFERS           DOUBLE       NOT NULL, REMOTE_TOTAL_COST DOUBLE       NOT NULL, REMOTE_COMM_COST  DOUBLE       NOT NULL, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_OPERATOR_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_OPERATOR     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         OPERATOR_ID INTEGER NOT NULL,         OPERATOR_TYPE CHAR(6) NOT NULL,         TOTAL_COST DOUBLE NOT NULL,         IO_COST DOUBLE NOT NULL,         CPU_COST DOUBLE NOT NULL,         FIRST_ROW_COST DOUBLE NOT NULL,         RE_TOTAL_COST DOUBLE NOT NULL,         RE_IO_COST DOUBLE NOT NULL,         RE_CPU_COST DOUBLE NOT NULL,         COMM_COST DOUBLE NOT NULL,         FIRST_COMM_COST DOUBLE NOT NULL,         BUFFERS DOUBLE NOT NULL,         REMOTE_TOTAL_COST DOUBLE NOT NULL,         REMOTE_COMM_COST DOUBLE NOT NULL,         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT         ON     DELETE         CASCADE    )";
    private static String CREATE_EXPLAIN_PREDICATE_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_PREDICATE ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, OPERATOR_ID       INTEGER      NOT NULL, PREDICATE_ID      INTEGER      NOT NULL, HOW_APPLIED       CHAR(5)      NOT NULL, WHEN_EVALUATED    CHAR(3)      NOT NULL, RELOP_TYPE        CHAR(2)      NOT NULL, SUBQUERY          CHAR(1)      NOT NULL, FILTER_FACTOR     DOUBLE       NOT NULL, PREDICATE_TEXT    CLOB(1M)     NOT LOGGED, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_PREDICATE_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_PREDICATE ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, SOURCE_VERSION    VARCHAR(64)  NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, OPERATOR_ID       INTEGER      NOT NULL, PREDICATE_ID      INTEGER      NOT NULL, HOW_APPLIED       CHAR(5)      NOT NULL, WHEN_EVALUATED    CHAR(3)      NOT NULL, RELOP_TYPE        CHAR(2)      NOT NULL, SUBQUERY          CHAR(1)      NOT NULL, FILTER_FACTOR     DOUBLE       NOT NULL, PREDICATE_TEXT    CLOB(2M)     NOT LOGGED, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_PREDICATE_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_PREDICATE     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         OPERATOR_ID INTEGER NOT NULL,         PREDICATE_ID INTEGER NOT NULL,         HOW_APPLIED CHAR(10) NOT NULL,         WHEN_EVALUATED CHAR(3) NOT NULL,         RELOP_TYPE CHAR(2) NOT NULL,         SUBQUERY CHAR(1) NOT NULL,         FILTER_FACTOR DOUBLE NOT NULL,         PREDICATE_TEXT CLOB(2M) NOT LOGGED,         RANGE_NUM INTEGER,         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT         ON     DELETE         CASCADE    )";
    private static String CREATE_EXPLAIN_PREDICATE_TABLE_10_STMT = "CREATE     TABLE <schema>.EXPLAIN_PREDICATE     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         OPERATOR_ID INTEGER NOT NULL,         PREDICATE_ID INTEGER NOT NULL,         HOW_APPLIED CHAR(10) NOT NULL,         WHEN_EVALUATED CHAR(3) NOT NULL,         RELOP_TYPE CHAR(2) NOT NULL,         SUBQUERY CHAR(1) NOT NULL,         FILTER_FACTOR DOUBLE NOT NULL,         PREDICATE_TEXT CLOB(2M) NOT LOGGED,         RANGE_NUM INTEGER,         INDEX_CLOSEQ INTEGER NOT NULL,         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT         ON     DELETE         CASCADE    )";
    private static String CREATE_EXPLAIN_STREAM_TABLE_7_STMT = "CREATE TABLE <schema>.EXPLAIN_STREAM ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, STREAM_ID         INTEGER      NOT NULL, SOURCE_TYPE       CHAR(1)      NOT NULL, SOURCE_ID         INTEGER      NOT NULL, TARGET_TYPE       CHAR(1)      NOT NULL, TARGET_ID         INTEGER      NOT NULL, OBJECT_SCHEMA     VARCHAR(128), OBJECT_NAME       VARCHAR(128), STREAM_COUNT      DOUBLE       NOT NULL, COLUMN_COUNT      SMALLINT     NOT NULL, PREDICATE_ID      INTEGER      NOT NULL, COLUMN_NAMES      CLOB(1M)     NOT LOGGED, PMID              SMALLINT     NOT NULL, SINGLE_NODE       CHAR(5), PARTITION_COLUMNS CLOB(1M)     NOT LOGGED, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_STREAM_TABLE_8_STMT = "CREATE TABLE <schema>.EXPLAIN_STREAM ( EXPLAIN_REQUESTER VARCHAR(128) NOT NULL, EXPLAIN_TIME      TIMESTAMP    NOT NULL, SOURCE_NAME       VARCHAR(128) NOT NULL, SOURCE_SCHEMA     VARCHAR(128) NOT NULL, SOURCE_VERSION    VARCHAR(64)  NOT NULL, EXPLAIN_LEVEL     CHAR(1)      NOT NULL, STMTNO            INTEGER      NOT NULL, SECTNO            INTEGER      NOT NULL, STREAM_ID         INTEGER      NOT NULL, SOURCE_TYPE       CHAR(1)      NOT NULL, SOURCE_ID         INTEGER      NOT NULL, TARGET_TYPE       CHAR(1)      NOT NULL, TARGET_ID         INTEGER      NOT NULL, OBJECT_SCHEMA     VARCHAR(128), OBJECT_NAME       VARCHAR(128), STREAM_COUNT      DOUBLE       NOT NULL, COLUMN_COUNT      SMALLINT     NOT NULL, PREDICATE_ID      INTEGER      NOT NULL, COLUMN_NAMES      CLOB(2M)     NOT LOGGED, PMID              SMALLINT     NOT NULL, SINGLE_NODE       CHAR(5), PARTITION_COLUMNS CLOB(2M)     NOT LOGGED, FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT ON DELETE CASCADE)";
    private static String CREATE_EXPLAIN_STREAM_TABLE_9_STMT = "CREATE     TABLE <schema>.EXPLAIN_STREAM     (         EXPLAIN_REQUESTER VARCHAR(128) NOT NULL,         EXPLAIN_TIME TIMESTAMP NOT NULL,         SOURCE_NAME VARCHAR(128) NOT NULL,         SOURCE_SCHEMA VARCHAR(128) NOT NULL,         SOURCE_VERSION VARCHAR(64) NOT NULL,         EXPLAIN_LEVEL CHAR(1) NOT NULL,         STMTNO INTEGER NOT NULL,         SECTNO INTEGER NOT NULL,         STREAM_ID INTEGER NOT NULL,         SOURCE_TYPE CHAR(1) NOT NULL,         SOURCE_ID INTEGER NOT NULL,         TARGET_TYPE CHAR(1) NOT NULL,         TARGET_ID INTEGER NOT NULL,         OBJECT_SCHEMA VARCHAR(128),         OBJECT_NAME VARCHAR(128),         STREAM_COUNT DOUBLE NOT NULL,         COLUMN_COUNT SMALLINT NOT NULL,         PREDICATE_ID INTEGER NOT NULL,         COLUMN_NAMES CLOB(2M) NOT LOGGED,         PMID SMALLINT NOT NULL,         SINGLE_NODE CHAR(5),         PARTITION_COLUMNS CLOB(2M) NOT LOGGED,         SEQUENCE_SIZES CLOB(2M) NOT LOGGED,         FOREIGN KEY (EXPLAIN_REQUESTER, EXPLAIN_TIME, SOURCE_NAME, SOURCE_SCHEMA, SOURCE_VERSION, EXPLAIN_LEVEL, STMTNO, SECTNO) REFERENCES <schema>.EXPLAIN_STATEMENT         ON     DELETE         CASCADE    )";
    private static String DROP_EXPLAIN_STREAM_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_STREAM";
    private static String DROP_EXPLAIN_ARGUMENT_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_ARGUMENT";
    private static String DROP_EXPLAIN_PREDICATE_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_PREDICATE";
    private static String DROP_EXPLAIN_OBJECT_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_OBJECT";
    private static String DROP_EXPLAIN_OPERATOR_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_OPERATOR";
    private static String DROP_EXPLAIN_STATEMENT_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_STATEMENT";
    private static String DROP_EXPLAIN_INSTANCE_TABLE_STMT = "DROP TABLE <schema>.EXPLAIN_INSTANCE";

    private DB2Util() {
    }

    public static String getCreateExplainInstanceTable(String string, int n2) {
        if (n2 >= 10) {
            return CREATE_EXPLAIN_INSTANCE_TABLE_10_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 >= 9) {
            return CREATE_EXPLAIN_INSTANCE_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_INSTANCE_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_INSTANCE_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getCreateExplainStatementTable(String string, int n2) {
        if (n2 >= 9) {
            return CREATE_EXPLAIN_STATEMENT_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_STATEMENT_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_STATEMENT_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getCreateExplainArgumentTable(String string, int n2) {
        if (n2 >= 9) {
            return CREATE_EXPLAIN_ARGUMENT_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_ARGUMENT_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_ARGUMENT_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getCreateExplainObjectTable(String string, int n2) {
        if (n2 >= 9) {
            return CREATE_EXPLAIN_OBJECT_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_OBJECT_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_OBJECT_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getCreateExplainOperatorTable(String string, int n2) {
        if (n2 >= 9) {
            return CREATE_EXPLAIN_OPERATOR_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_OPERATOR_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_OPERATOR_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getCreateExplainPredicateTable(String string, int n2) {
        if (n2 >= 10) {
            return CREATE_EXPLAIN_PREDICATE_TABLE_10_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 >= 9) {
            return CREATE_EXPLAIN_PREDICATE_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_PREDICATE_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_PREDICATE_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getCreateExplainStreamTable(String string, int n2) {
        if (n2 >= 9) {
            return CREATE_EXPLAIN_STREAM_TABLE_9_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 8) {
            return CREATE_EXPLAIN_STREAM_TABLE_8_STMT.replaceAll(SCHEMA_TAG, string);
        }
        if (n2 == 7) {
            return CREATE_EXPLAIN_STREAM_TABLE_7_STMT.replaceAll(SCHEMA_TAG, string);
        }
        return null;
    }

    public static String getExplainPlanStmt(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("explain plan set querytag = '");
        stringBuffer.append(string);
        stringBuffer.append("' for ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String getSelectExplainPlanStmt(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append("OPERATOR_TYPE, STR.SOURCE_ID, STR.TARGET_ID, OBJ.OBJECT_SCHEMA, ");
        stringBuffer.append("OBJ.OBJECT_NAME, OPER.TOTAL_COST, QUERYTAG, ");
        stringBuffer.append("CPU_COST, IO_COST, FIRST_ROW_COST, ");
        stringBuffer.append("RE_TOTAL_COST, RE_CPU_COST, RE_IO_COST, COMM_COST, ");
        stringBuffer.append("FIRST_COMM_COST, BUFFERS, REMOTE_TOTAL_COST, REMOTE_COMM_COST, ");
        stringBuffer.append("STR.STREAM_COUNT, STR.COLUMN_COUNT ");
        stringBuffer.append("FROM (((" + string + ".EXPLAIN_OPERATOR OPER JOIN " + string + ".EXPLAIN_STATEMENT STMT ON ");
        stringBuffer.append("STMT.QUERYTAG = '" + string2 + "' AND ");
        stringBuffer.append("OPER.EXPLAIN_REQUESTER = STMT.EXPLAIN_REQUESTER AND ");
        stringBuffer.append("OPER.EXPLAIN_TIME = STMT.EXPLAIN_TIME AND ");
        stringBuffer.append("OPER.SOURCE_NAME = STMT.SOURCE_NAME AND ");
        stringBuffer.append("OPER.SOURCE_SCHEMA = STMT.SOURCE_SCHEMA AND ");
        stringBuffer.append("OPER.EXPLAIN_LEVEL = STMT.EXPLAIN_LEVEL AND ");
        stringBuffer.append("OPER.STMTNO = STMT.STMTNO AND ");
        stringBuffer.append("OPER.SECTNO = STMT.SECTNO AND ");
        stringBuffer.append("STMT.EXPLAIN_LEVEL = 'P') ");
        stringBuffer.append("LEFT JOIN " + string + ".EXPLAIN_STREAM STR ON ");
        stringBuffer.append("OPER.OPERATOR_ID = STR.SOURCE_ID AND ");
        stringBuffer.append("OPER.EXPLAIN_REQUESTER = STR.EXPLAIN_REQUESTER AND ");
        stringBuffer.append("OPER.EXPLAIN_TIME = STR.EXPLAIN_TIME AND ");
        stringBuffer.append("OPER.SOURCE_NAME = STR.SOURCE_NAME AND ");
        stringBuffer.append("OPER.SOURCE_SCHEMA = STR.SOURCE_SCHEMA AND ");
        stringBuffer.append("OPER.EXPLAIN_LEVEL = STR.EXPLAIN_LEVEL AND ");
        stringBuffer.append("OPER.STMTNO = STR.STMTNO AND ");
        stringBuffer.append("OPER.SECTNO = STR.SECTNO ) ");
        stringBuffer.append("LEFT JOIN " + string + ".EXPLAIN_STREAM OBJ ON ");
        stringBuffer.append("STR.SOURCE_ID = OBJ.TARGET_ID AND ");
        stringBuffer.append("OBJ.SOURCE_ID = -1 AND ");
        stringBuffer.append("STR.EXPLAIN_REQUESTER = OBJ.EXPLAIN_REQUESTER AND ");
        stringBuffer.append("STR.EXPLAIN_TIME = OBJ.EXPLAIN_TIME AND ");
        stringBuffer.append("STR.SOURCE_NAME = OBJ.SOURCE_NAME AND ");
        stringBuffer.append("STR.SOURCE_SCHEMA = OBJ.SOURCE_SCHEMA AND ");
        stringBuffer.append("STR.EXPLAIN_LEVEL = OBJ.EXPLAIN_LEVEL AND ");
        stringBuffer.append("STR.STMTNO = OBJ.STMTNO AND ");
        stringBuffer.append("STR.SECTNO = OBJ.SECTNO ) ");
        return stringBuffer.toString();
    }

    public static String getDropExplainStreamTableStmt(String string) {
        return DROP_EXPLAIN_STREAM_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }

    public static String getDropExplainArgumentTableStmt(String string) {
        return DROP_EXPLAIN_ARGUMENT_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }

    public static String getDropExplainPredicateTableStmt(String string) {
        return DROP_EXPLAIN_PREDICATE_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }

    public static String getDropExplainObjectTableStmt(String string) {
        return DROP_EXPLAIN_OBJECT_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }

    public static String getDropExplainOperatorTableStmt(String string) {
        return DROP_EXPLAIN_OPERATOR_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }

    public static String getDropExplainStatementTableStmt(String string) {
        return DROP_EXPLAIN_STATEMENT_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }

    public static String getDropExplainInstanceTableStmt(String string) {
        return DROP_EXPLAIN_INSTANCE_TABLE_STMT.replaceAll(SCHEMA_TAG, string);
    }
}

