/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.oracle;

import com.onseven.dbvis.db.A.G;

public class OraUtil {
    public static final String ID_COLUMN = "id";
    public static final String PARENT_ID_COLUMN = "parent_id";
    public static final String OPERATION_COLUMN = "operation";
    public static final String OPTIONS_COLUMN = "options";
    public static final String COST_COLUMN = "cost";
    public static final String OBJECT_OWNER_COLUMN = "object_owner";
    public static final String OBJECT_NAME_COLUMN = "object_name";
    private static final String[][] ORA8_PLAN_TABLE_COLUMNS = new String[][]{{"statement_id", "varchar2(30)"}, {"timestamp", "date"}, {"remarks", "varchar2(80)"}, {"operation", "varchar2(30)"}, {"options", "varchar2(30)"}, {"object_node", "varchar2(128)"}, {"object_owner", "varchar2(30)"}, {"object_name", "varchar2(30)"}, {"object_instance", "numeric"}, {"object_type", "varchar2(30)"}, {"optimizer", "varchar2(255)"}, {"search_columns", "number"}, {"id", "numeric"}, {"parent_id", "numeric"}, {"position", "numeric"}, {"cost", "numeric"}, {"cardinality", "numeric"}, {"bytes", "numeric"}, {"other_tag", "varchar2(255)"}, {"partition_start", "varchar2(255)"}, {"partition_stop", "varchar2(255)"}, {"partition_id", "numeric"}, {"other", "long"}, {"distribution", "varchar2(30)"}};
    private static final String[][] ORA9_PLAN_TABLE_COLUMNS = new String[][]{{"statement_id", "varchar2(30)"}, {"timestamp", "date"}, {"remarks", "varchar2(80)"}, {"operation", "varchar2(30)"}, {"options", "varchar2(255)"}, {"object_node", "varchar2(128)"}, {"object_owner", "varchar2(30)"}, {"object_name", "varchar2(30)"}, {"object_instance", "numeric"}, {"object_type", "varchar2(30)"}, {"optimizer", "varchar2(255)"}, {"search_columns", "number"}, {"id", "numeric"}, {"parent_id", "numeric"}, {"position", "numeric"}, {"cost", "numeric"}, {"cardinality", "numeric"}, {"bytes", "numeric"}, {"other_tag", "varchar2(255)"}, {"partition_start", "varchar2(255)"}, {"partition_stop", "varchar2(255)"}, {"partition_id", "numeric"}, {"other", "long"}, {"distribution", "varchar2(30)"}, {"cpu_cost", "numeric"}, {"io_cost", "numeric"}, {"temp_space", "numeric"}, {"access_predicates", "varchar2(4000)"}, {"filter_predicates", "varchar2(4000)"}};
    private static final String[][] ORA10_PLAN_TABLE_COLUMNS = new String[][]{{"statement_id", "varchar2(30)"}, {"plan_id", "number"}, {"timestamp", "date"}, {"remarks", "varchar2(4000)"}, {"operation", "varchar2(30)"}, {"options", "varchar2(255)"}, {"object_node", "varchar2(128)"}, {"object_owner", "varchar2(30)"}, {"object_name", "varchar2(30)"}, {"object_alias", "varchar2(65)"}, {"object_instance", "numeric"}, {"object_type", "varchar2(30)"}, {"optimizer", "varchar2(255)"}, {"search_columns", "number"}, {"id", "numeric"}, {"parent_id", "numeric"}, {"position", "numeric"}, {"cost", "numeric"}, {"cardinality", "numeric"}, {"bytes", "numeric"}, {"other_tag", "varchar2(255)"}, {"partition_start", "varchar2(255)"}, {"partition_stop", "varchar2(255)"}, {"partition_id", "numeric"}, {"other", "long"}, {"other_xml", "clob"}, {"distribution", "varchar2(30)"}, {"cpu_cost", "numeric"}, {"io_cost", "numeric"}, {"temp_space", "numeric"}, {"access_predicates", "varchar2(4000)"}, {"filter_predicates", "varchar2(4000)"}, {"depth", "numeric"}, {"projection", "varchar2(4000)"}, {"time", "numeric"}, {"qblock_name", "varchar2(30)"}};

    private OraUtil() {
    }

    public static String getCreatePlanTableStmt(G g2, String string, String string2, int n2) {
        return OraUtil.getCreateTableStmt(g2, string, string2, OraUtil.getColumnList(n2));
    }

    private static String[][] getColumnList(int n2) {
        if (n2 >= 10) {
            return ORA10_PLAN_TABLE_COLUMNS;
        }
        if (n2 == 9) {
            return ORA9_PLAN_TABLE_COLUMNS;
        }
        return ORA8_PLAN_TABLE_COLUMNS;
    }

    public static String getCreateTableStmt(G g2, String string, String string2, String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create table ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string));
            stringBuffer.append(".");
        }
        stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string2));
        stringBuffer.append(" (");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2][0]);
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i2][1]);
            stringBuffer.append(i2 < stringArray.length - 1 ? ", " : ") ");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("DECLARE objExists NUMBER; ");
        stringBuffer2.append("BEGIN ");
        if (string != null && string.length() > 0) {
            stringBuffer2.append("SELECT count(0) INTO objExists FROM all_all_tables WHERE table_name = '");
            stringBuffer2.append(string2);
            stringBuffer2.append("' ");
            stringBuffer2.append("AND owner = '");
            stringBuffer2.append(string);
            stringBuffer2.append("'; ");
        } else {
            stringBuffer2.append("SELECT count(0) INTO objExists FROM user_all_tables WHERE table_name = '");
            stringBuffer2.append(string2);
            stringBuffer2.append("'; ");
        }
        stringBuffer2.append("IF objExists = 0 THEN EXECUTE IMMEDIATE '");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("'; END IF; ");
        stringBuffer2.append("END;");
        return stringBuffer2.toString();
    }

    public static String getDropTableStmt(G g2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("drop table ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string));
            stringBuffer.append(".");
        }
        stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string2));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("DECLARE objExists NUMBER; ");
        stringBuffer2.append("BEGIN ");
        if (string != null && string.length() > 0) {
            stringBuffer2.append("SELECT count(0) INTO objExists FROM all_tables WHERE table_name = '");
            stringBuffer2.append(string2);
            stringBuffer2.append("' ");
            stringBuffer2.append("AND owner = '");
            stringBuffer2.append(string);
            stringBuffer2.append("'; ");
        } else {
            stringBuffer2.append("SELECT count(0) INTO objExists FROM user_tables WHERE table_name = '");
            stringBuffer2.append(string2);
            stringBuffer2.append("'; ");
        }
        stringBuffer2.append("IF objExists = 1 THEN EXECUTE IMMEDIATE '");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("'; END IF; ");
        stringBuffer2.append("END;");
        return stringBuffer2.toString();
    }

    public static String getDeleteTableStmt(G g2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string));
            stringBuffer.append(".");
        }
        stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string2));
        return stringBuffer.toString();
    }

    public static String getDeleteExplainPlanStmt(G g2, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string));
            stringBuffer.append(".");
        }
        stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string2));
        stringBuffer.append(" where statement_id='");
        stringBuffer.append(string3);
        stringBuffer.append("' ");
        return stringBuffer.toString();
    }

    public static String getExplainPlanStmt(G g2, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("explain plan set statement_id='");
        stringBuffer.append(string3);
        stringBuffer.append("' into ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string));
            stringBuffer.append(".");
        }
        stringBuffer.append(OraUtil.getDelimitedIdentifier(g2, string2));
        stringBuffer.append(" for ");
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static String getSelectExplainPlanStmt(G g2, String string, String string2, String string3) {
        int n2 = g2.\u0137().\u0108();
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = OraUtil.getColumnList(n2);
        for (String[] stringArray2 : stringArray) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray2[0]);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("select ");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append(" from ");
        if (string != null && string.length() > 0) {
            stringBuffer2.append(OraUtil.getDelimitedIdentifier(g2, string));
            stringBuffer2.append(".");
        }
        stringBuffer2.append(OraUtil.getDelimitedIdentifier(g2, string2));
        stringBuffer2.append(" start with id=0 and statement_id='");
        stringBuffer2.append(string3);
        stringBuffer2.append("' ");
        stringBuffer2.append("connect by prior id=parent_id and prior statement_id=statement_id");
        return stringBuffer2.toString();
    }

    private static String getDelimitedIdentifier(G g2, String string) {
        if (g2 != null && g2.\u0135().getBool("DelimitedIdentifiersBehindTheScene")) {
            String string2 = g2.\u0135().getProperty("DelimitedIdentifierBegin");
            String string3 = g2.\u0135().getProperty("DelimitedIdentifierEnd");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2).append(string).append(string3);
            return stringBuffer.toString();
        }
        return string;
    }
}

