/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.oracle;

import com.onseven.dbvis.db.A.G;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class OracleDbmsOutput {
    private CallableStatement enable_stmt;
    private CallableStatement disable_stmt;
    private CallableStatement show_stmt;

    public OracleDbmsOutput(G g2) throws SQLException {
        int n2 = 255;
        if (g2.\u0137().\u0108() >= 10 && g2.\u0137().\u0117() >= 2) {
            n2 = Short.MAX_VALUE;
        }
        Connection connection = g2.\u0124();
        this.enable_stmt = connection.prepareCall("begin dbms_output.enable(:1); end;");
        this.disable_stmt = connection.prepareCall("begin dbms_output.disable; end;");
        this.show_stmt = connection.prepareCall("declare     l_line varchar2(" + n2 + "); " + "    l_done number; " + "    l_buffer long; " + "begin " + "  loop " + "    exit when length(l_buffer)+255 > :maxbytes OR l_done = 1; " + "    dbms_output.get_line( l_line, l_done ); " + "    l_buffer := l_buffer || l_line || chr(10); " + "  end loop; " + " :done := l_done; " + " :buffer := l_buffer; " + "end;");
    }

    public void enable(int n2) throws SQLException {
        this.enable_stmt.setInt(1, n2);
        this.enable_stmt.executeUpdate();
    }

    public void disable() throws SQLException {
        this.disable_stmt.executeUpdate();
    }

    public String get() throws SQLException {
        String string;
        this.show_stmt.registerOutParameter(2, 4);
        this.show_stmt.registerOutParameter(3, 12);
        StringBuffer stringBuffer = new StringBuffer();
        do {
            this.show_stmt.setInt(1, 32000);
            this.show_stmt.executeUpdate();
            string = this.show_stmt.getString(3);
            if (string == null) continue;
            stringBuffer.append(string.trim()).append("\n");
        } while (this.show_stmt.getInt(2) != 1);
        string = stringBuffer.toString().trim();
        return string.length() == 0 ? null : string + "\n";
    }

    public void close() throws SQLException {
        this.enable_stmt.close();
        this.disable_stmt.close();
        this.show_stmt.close();
    }
}

