/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.oracle;

import com.onseven.dbvis.J.A.B;
import com.onseven.dbvis.J.A.G;
import com.onseven.dbvis.J.B.J;
import com.onseven.dbvis.J.B.O;
import com.onseven.dbvis.db.DatabaseFacade;
import com.onseven.dbvis.db.ExplainPlanHandler;
import com.onseven.dbvis.db.oracle.OraUtil;
import com.onseven.dbvis.k.p;
import com.onseven.dbvis.sql.H;
import com.onseven.dbvis.sql.M;
import com.onseven.dbvis.sql.PropsManagerWrapper;
import java.math.BigDecimal;
import java.util.Locale;
import javax.swing.table.TableModel;
import se.pureit.A.B.A;

public class OracleExplainPlanHandler
implements ExplainPlanHandler {
    private static final String[] DISPLAY_COLUMNS_AND_ORDER = new String[]{"COST", "CPU_COST", "IO_COST", "OPTIMIZER", "CARDINALITY", "BYTES", "POSITION", "PARTITION_START", "PARTITION_STOP", "PARTITION_ID"};
    private com.onseven.dbvis.db.A.G dbConnection;
    private int majorVersion;
    private String schemaName;
    private String tableName;
    private String statementId;

    private void init(H h2) throws O {
        this.dbConnection = h2.\u0104();
        this.majorVersion = this.dbConnection.\u0137().\u0108();
        this.statementId = "dbvis-" + System.currentTimeMillis();
        h2.\u0104(1);
        PropsManagerWrapper propsManagerWrapper = this.dbConnection.\u0135();
        boolean bl = propsManagerWrapper.getBool("UseUserDefinedExplainTable");
        if (bl) {
            this.schemaName = propsManagerWrapper.getProperty("ExplainSchema");
            if (this.schemaName.length() == 0) {
                this.schemaName = this.dbConnection.\u012b();
            }
            this.tableName = propsManagerWrapper.getProperty("ExplainTable");
        } else {
            this.schemaName = propsManagerWrapper.getPropsDefault("ExplainSchema");
            if (this.schemaName.length() == 0) {
                this.schemaName = this.dbConnection.\u012b();
            }
            this.tableName = propsManagerWrapper.getPropsDefault("ExplainTable");
        }
        J j2 = new J();
        DatabaseFacade databaseFacade = this.dbConnection.\u0106();
        boolean bl2 = false;
        try {
            bl2 = databaseFacade.doesTableExist(null, this.schemaName.toUpperCase(Locale.ENGLISH), this.tableName.toUpperCase(Locale.ENGLISH));
        }
        catch (M m2) {
            // empty catch block
        }
        boolean bl3 = propsManagerWrapper.getBool("CreateExplainTable");
        if (bl3 && !bl2) {
            String string = null;
            string = OraUtil.getCreatePlanTableStmt(this.dbConnection, this.schemaName, this.tableName, this.majorVersion);
            h2.\u0105(string);
            j2.execute(h2);
            j2.run();
        } else if (!bl2) {
            throw new O(OracleExplainPlanHandler.getText("NoPlanTable", this.schemaName + "." + this.tableName));
        }
    }

    @Override
    public com.onseven.dbvis.sql.A.A fetchExplainPlan(H h2) throws O {
        H h3 = (H)h2.clone();
        this.init(h3);
        B b2 = this.queryExplainPlan(h3, h2);
        com.onseven.dbvis.sql.A.A a2 = this.createExplainPlanResult(b2);
        this.clearExplainPlanTable(h3);
        return a2;
    }

    private B queryExplainPlan(H h2, H h3) throws O {
        String string = OraUtil.getExplainPlanStmt(this.dbConnection, this.schemaName, this.tableName, this.statementId, h3.\u010e());
        h2.\u0105(string);
        J j2 = new J();
        j2.setSchemaAutomatically(true);
        j2.execute(h2);
        j2.run();
        String string2 = OraUtil.getSelectExplainPlanStmt(this.dbConnection, this.schemaName, this.tableName, this.statementId);
        h2.\u0105(string2);
        j2.execute(h2);
        j2.run();
        return j2.getFirstDataSet();
    }

    private com.onseven.dbvis.sql.A.A createExplainPlanResult(B b2) {
        Object object;
        int[] nArray = this.getDisplayColumns((TableModel)((Object)b2));
        Class[] classArray = new Class[nArray.length];
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string;
            object = com.onseven.dbvis.sql.A.A.getFixedColumnName(i2);
            if (object == null) {
                object = b2.getColumnName(nArray[i2]);
            }
            stringArray[i2] = (string = OracleExplainPlanHandler.getText((String)object, new Object[0])) != null && string.length() > 0 ? string : object;
            String string2 = OracleExplainPlanHandler.getText("descr." + (String)object, new Object[0]);
            stringArray2[i2] = string2 != null ? string2 : OracleExplainPlanHandler.getText("NoDescription", new Object[0]);
            Class clazz = com.onseven.dbvis.sql.A.A.getFixedColumnClass(i2);
            if (clazz == null) {
                clazz = b2.getColumnClass(nArray[i2]);
            }
            classArray[i2] = clazz;
        }
        com.onseven.dbvis.sql.A.A a2 = new com.onseven.dbvis.sql.A.A(stringArray, classArray, stringArray2);
        a2.setExecutionResult(b2.getExecutionResult());
        a2.setDataSetProducer(b2.getDataSetProducer());
        object = b2.getSortedDataSet(b2.getColumnSet().\u0101("id"), true);
        int n2 = object.getRowCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            this.addExplainPlanEntry(a2, (G)object, i3);
        }
        a2.calcNodeCost();
        PropsManagerWrapper propsManagerWrapper = this.dbConnection.\u0135();
        boolean bl = propsManagerWrapper.getBool("ColorCriticalNodes");
        if (bl) {
            int n3 = propsManagerWrapper.getInt("CriticalThreshold");
            int n4 = propsManagerWrapper.getInt("WarningThreshold");
            a2.calcCostLevel(n3, n4);
        }
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExplainPlanTable(H h2) {
        String string = OraUtil.getDeleteExplainPlanStmt(this.dbConnection, this.schemaName, this.tableName, this.statementId);
        h2.\u0105(string);
        try {
            this.dbConnection.\u0133();
            J j2 = new J();
            j2.execute(h2);
            j2.run();
        }
        catch (O o2) {
        }
        finally {
            this.dbConnection.\u010b();
        }
    }

    private void addExplainPlanEntry(com.onseven.dbvis.sql.A.A a2, G g2, int n2) {
        String string;
        Object object;
        Object object2;
        Object object3;
        String string2;
        int[] nArray = this.getDisplayColumns((TableModel)((Object)g2));
        Object[] objectArray = new Object[nArray.length];
        B b2 = p.\u0104((TableModel)((Object)g2));
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 == 0) {
                string2 = (String)g2.getValueAt(n2, b2.getColumnIndex("operation"));
                object3 = (String)g2.getValueAt(n2, b2.getColumnIndex("options"));
                object2 = (String)g2.getValueAt(n2, b2.getColumnIndex("object_owner"));
                object = (String)g2.getValueAt(n2, b2.getColumnIndex("object_name"));
                string = (object2 != null ? (String)object2 + "." : "") + (String)(object != null ? object : "");
                objectArray[i2] = (string.length() > 0 ? string + "  " : "") + string2 + (object3 != null ? " (" + (String)object3 + ")" : "");
                continue;
            }
            objectArray[i2] = i2 == 1 ? "" : g2.getValueAt(n2, nArray[i2]);
        }
        BigDecimal bigDecimal = (BigDecimal)g2.getValueAt(n2, b2.getColumnIndex("id"));
        string2 = bigDecimal != null ? bigDecimal.toString() : null;
        object3 = new com.onseven.dbvis.sql.A.B(string2);
        ((com.onseven.dbvis.sql.A.B)object3).\u0101(objectArray);
        object2 = (BigDecimal)g2.getValueAt(n2, b2.getColumnIndex("cost"));
        ((com.onseven.dbvis.sql.A.B)object3).\u0104(object2 != null ? ((BigDecimal)object2).doubleValue() : 0.0);
        object = (BigDecimal)g2.getValueAt(n2, b2.getColumnIndex("parent_id"));
        string = object != null ? ((BigDecimal)object).toString() : null;
        a2.addEntry((com.onseven.dbvis.sql.A.B)object3, string);
    }

    private int getColumnIndex(TableModel tableModel, String string) {
        if (tableModel != null) {
            int n2 = tableModel.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = tableModel.getColumnName(i2);
                if (!string2.equals(string)) continue;
                return i2;
            }
        }
        return -1;
    }

    private int[] getDisplayColumns(TableModel tableModel) {
        int n2;
        int n3 = 0;
        for (int i2 = 0; i2 < DISPLAY_COLUMNS_AND_ORDER.length; ++i2) {
            n2 = this.getColumnIndex(tableModel, DISPLAY_COLUMNS_AND_ORDER[i2]);
            n3 += n2 > -1 ? 1 : 0;
        }
        int[] nArray = new int[n3 + com.onseven.dbvis.sql.A.A.FIXED_COLUMN_NAMES.length];
        n2 = com.onseven.dbvis.sql.A.A.FIXED_COLUMN_NAMES.length;
        for (int i3 = 0; i3 < DISPLAY_COLUMNS_AND_ORDER.length; ++i3) {
            int n4 = this.getColumnIndex(tableModel, DISPLAY_COLUMNS_AND_ORDER[i3]);
            if (n4 <= -1) continue;
            nArray[n2++] = n4;
        }
        return nArray;
    }

    private static String getText(String string, Object ... objectArray) {
        return A.\u0102(OracleExplainPlanHandler.class, "OracleExplainPlanHandler." + string, objectArray);
    }
}

