/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.oracle.gui;

import com.jidesoft.action.CommandBar;
import com.onseven.dbvis.B.C;
import com.onseven.dbvis.N.A.i;
import com.onseven.dbvis.N.E;
import com.onseven.dbvis.N.F;
import com.onseven.dbvis.R.D;
import com.onseven.dbvis.db.A.G;
import com.onseven.dbvis.db.oracle.OracleDbmsOutput;
import java.awt.Component;
import java.sql.SQLException;
import java.util.EnumSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import se.pureit.A.B.A;
import se.pureit.swing.A.S;
import se.pureit.swing.icons.StdIconFactory;

public class OracleDbmsOutputPanel
extends D {
    private C editor;
    private OracleDbmsOutput oracleDbms = null;
    private boolean showToolBar;
    private S dbmsOutputEnableCommand;
    private S dbmsOutputDisableCommand;
    private S dbmsOutputClearCommand;
    private S dbmsOutputSaveAsCommand;
    private JLabel bufferSizeLabel;
    private se.pureit.swing.F.G bufferSizeField;
    private boolean wasDbmsOutput = false;
    private i fileChooser;
    private static Logger log = Logger.getLogger(OracleDbmsOutputPanel.class);

    public OracleDbmsOutputPanel(boolean bl) {
        this.showToolBar = bl;
        this.init();
    }

    private void init() {
        this.initActions();
        this.editor = new C();
        this.bufferSizeField = new se.pureit.swing.F.G(5);
        this.bufferSizeField.setText("100000");
        CommandBar commandBar = this.createToolBar("dbms-output-toolbar");
        this.bufferSizeField.putClientProperty("CommandBar.expandable", "false");
        commandBar.add(Box.createHorizontalStrut(20));
        this.bufferSizeLabel = new JLabel("Buffer Size:");
        commandBar.add((Component)this.bufferSizeLabel);
        commandBar.add(Box.createHorizontalStrut(3));
        commandBar.add((Component)this.bufferSizeField);
        if (this.showToolBar) {
            this.add((Component)commandBar, "North");
        }
        this.add((Component)this.editor, "Center");
        this.realizeActionManagerIcons();
        this.getActionManager().\u010d(this);
    }

    private void initActions() {
        this.dbmsOutputEnableCommand = new S(this, "dbms-output-enable-command"){

            @Override
            public void execute() {
                OracleDbmsOutputPanel.this.enableDbmsOutput(true);
            }
        };
        this.dbmsOutputDisableCommand = new S(this, "dbms-output-disable-command"){

            @Override
            public void execute() {
                OracleDbmsOutputPanel.this.enableDbmsOutput(false);
            }
        };
        this.dbmsOutputDisableCommand.setEnabled(false);
        this.dbmsOutputSaveAsCommand = new S(this, "dbms-output-save-as-command"){

            @Override
            public void execute() {
                OracleDbmsOutputPanel.this.getFileChooser().\u0102((Component)OracleDbmsOutputPanel.this, OracleDbmsOutputPanel.this.editor.\u012e());
            }
        };
        this.dbmsOutputClearCommand = new S(this, "dbms-output-clear-command"){

            @Override
            public void execute() {
                OracleDbmsOutputPanel.this.clearBuffer();
            }
        };
        this.getActionManager().\u0102(this.dbmsOutputDisableCommand);
        this.getActionManager().\u0102(this.dbmsOutputEnableCommand);
        this.getActionManager().\u0102(this.dbmsOutputSaveAsCommand);
        this.getActionManager().\u0102(this.dbmsOutputClearCommand);
    }

    private i getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new i(true, false, false);
        }
        return this.fileChooser;
    }

    public void enableDbmsOutput(boolean bl) {
        this.dbmsOutputEnableCommand.setEnabled(!bl);
        this.dbmsOutputDisableCommand.setEnabled(bl);
        this.getEventManager().\u0102(this);
        if (!bl) {
            this.wasDbmsOutput = false;
        }
    }

    public boolean isDbmsOutputEnabled() {
        return !this.dbmsOutputEnableCommand.isEnabled();
    }

    public String getBuffer() {
        return this.editor.\u012e();
    }

    public void clearBuffer() {
        this.editor.\u0102("");
    }

    public void executeBegin(G g2) throws SQLException {
        if (this.isDbmsOutputEnabled() && this.oracleDbms == null && g2 != null && g2.\u0106().isOracle()) {
            log.debug((Object)("Enabling DBMS_OUTPUT with buffer size " + this.bufferSizeField.\u010a()));
            this.oracleDbms = new OracleDbmsOutput(g2);
            this.oracleDbms.enable(this.bufferSizeField.\u010a());
        } else if (!this.isDbmsOutputEnabled() && this.oracleDbms != null) {
            log.debug((Object)"Disabling DBMS_OUTPUT");
            this.oracleDbms.disable();
            this.oracleDbms.close();
            this.oracleDbms = null;
        }
    }

    public boolean stop() throws SQLException {
        this.wasDbmsOutput = false;
        if (this.oracleDbms != null) {
            log.debug((Object)"Getting buffer and disabling DBMS_OUTPUT");
            final String string = this.oracleDbms.get();
            this.wasDbmsOutput = string != null && string.length() > 0;
            this.oracleDbms.disable();
            this.oracleDbms.close();
            this.oracleDbms = null;
            if (string != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!OracleDbmsOutputPanel.this.editor.\u0145()) {
                            OracleDbmsOutputPanel.this.editor.\u0107("\n");
                        }
                        OracleDbmsOutputPanel.this.editor.\u0107("--- " + F.\u0103() + " ---\n");
                        OracleDbmsOutputPanel.this.editor.\u0107(string);
                        OracleDbmsOutputPanel.this.editor.\u0134();
                    }
                });
            }
        }
        return this.wasDbmsOutput;
    }

    public boolean wasAnyDbmsOutput() {
        return this.wasDbmsOutput;
    }

    public Icon getViewerIcon() {
        if (this.isDbmsOutputEnabled()) {
            return StdIconFactory.getIconFromCollection("dbmsOutputEnabled");
        }
        return StdIconFactory.getIconFromCollection("dbmsOutputDisabled");
    }

    public void reloadViewer() {
    }

    @Override
    public void reset(EnumSet<E.A> enumSet) {
        this.editor.\u0101(enumSet);
        if (enumSet.contains((Object)E.A.\u0104) && this.oracleDbms != null) {
            try {
                this.oracleDbms.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected String getText(String string) {
        return A.\u0101(this.getClass(), "OracleDbmsOutputPanel." + string);
    }

    public void requestFocusInWindowForEditor() {
        this.editor.\u0123().\u0455();
    }
}

