/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.postgresql;

import com.onseven.dbvis.J.B.J;
import com.onseven.dbvis.J.B.O;
import com.onseven.dbvis.db.ExplainPlanHandler;
import com.onseven.dbvis.sql.A.A;
import com.onseven.dbvis.sql.A.B;
import com.onseven.dbvis.sql.H;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PostgreSQLExplainPlanHandler
implements ExplainPlanHandler {
    private DecimalFormat millisFormatter = new DecimalFormat("0.000");
    public static final String QUERY = "Query";
    public static final String PLAN = "Plan";
    public static final String PLANS = "Plans";
    public static final String EXCLUSIVE = "Exclusive";
    public static final String INCLUSIVE = "Inclusive";
    public static final String NODE_TYPE = "Node-Type";
    public static final String STRATEGY = "Strategy";
    public static final String PARENT_RELATIONSHIP = "Parent-Relationship";
    public static final String RELATION_NAME = "Relation-Name";
    public static final String ALIAS = "Alias";
    public static final String JOIN_TYPE = "Join-Type";
    public static final String STARTUP_COST = "Startup-Cost";
    public static final String TOTAL_COST = "Total-Cost";
    public static final String PLAN_ROWS = "Plan-Rows";
    public static final String PLAN_WIDTH = "Plan-Width";
    public static final String ACTUAL_STARTUP_TIME = "Actual-Startup-Time";
    public static final String ACTUAL_TOTAL_TIME = "Actual-Total-Time";
    public static final String ACTUAL_ROWS = "Actual-Rows";
    public static final String ACTUAL_LOOPS = "Actual-Loops";
    public static final String SORT_METHOD = "Sort-Method";
    public static final String SORT_SPACE_USED = "Sort-Space-Used";
    public static final String SORT_SPACE_TYPE = "Sort-Space-Type";
    public static final String SORT_KEY = "Sort-Key";
    public static final String ITEM = "Item";
    public static final String HASH_COND = "Hash-Cond";
    public static final String FILTER = "Filter";
    public static final String TOTAL_RUNTIME = "Total-Runtime";
    private static final String[] DISPLAY_COLUMNS_AND_ORDER = new String[]{"Inclusive", "Actual-Startup-Time", "Actual-Total-Time", "Actual-Rows", "Actual-Loops", "Startup-Cost", "Total-Cost", "Plan-Rows", "Plan-Width", "Strategy", "Sort-Method", "Sort-Space-Used", "Sort-Space-Type", "Parent-Relationship", "Relation-Name", "Alias", "Join-Type", "Sort-Key", "Hash-Cond", "Filter"};
    private static final Class[] DISPLAY_COLUMN_CLASSES_AND_ORDER = new Class[]{Float.class, Float.class, Float.class, Integer.class, Integer.class, Float.class, Float.class, Integer.class, Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private int nodeId;
    private Class[] columnClasses = (Class[])ArrayUtils.addAll((Object[])A.FIXED_COLUMN_CLASSES, (Object[])DISPLAY_COLUMN_CLASSES_AND_ORDER);
    private String[] columnNames = (String[])ArrayUtils.addAll((Object[])A.FIXED_COLUMN_NAMES, (Object[])DISPLAY_COLUMNS_AND_ORDER);
    protected static Logger log = Logger.getLogger(PostgreSQLExplainPlanHandler.class);

    @Override
    public A fetchExplainPlan(H h2) throws O {
        H h3 = (H)h2.clone();
        if (h3.\u0104().\u0137().\u0108() < 9) {
            throw new O("Explain plan is supported only for PostgreSQL version 9 and later");
        }
        try {
            com.onseven.dbvis.J.A.B b2 = this.queryExplainPlan(h3, h2);
            A a2 = this.createExplainPlanResultFromXML(b2.getValueAt(0, 0).toString());
            a2.calcNodeCost();
            if (h3.\u0104().\u0135().getBool("ColorCriticalNodes")) {
                int n2 = h3.\u0104().\u0135().getInt("CriticalThreshold");
                int n3 = h3.\u0104().\u0135().getInt("WarningThreshold");
                a2.calcCostLevel(n2, n3);
            }
            return a2;
        }
        catch (Exception exception) {
            throw new O(h3.\u0104(), PostgreSQLExplainPlanHandler.getText("FetchExplainFailed", exception.getMessage()), h3.\u010e());
        }
    }

    private com.onseven.dbvis.J.A.B queryExplainPlan(H h2, H h3) throws O {
        boolean bl = false;
        if (h3.\u0104() != null && h3.\u0104().\u0137() != null) {
            bl = h3.\u0104().\u0135().getBool("RunAnalyzeWhenExplain");
        }
        String string = "EXPLAIN (format xml" + (bl ? ",  analyze" : "") + ") ";
        h2.\u0105(string + h3.\u010e());
        J j2 = new J();
        j2.setShouldApplyMaxRowsForStatement(false);
        j2.execute(h2);
        j2.run();
        return j2.getFirstDataSet();
    }

    private A createExplainPlanResultFromXML(String string) throws DocumentException {
        Object object;
        String string2;
        String[] stringArray = Arrays.copyOf(this.columnNames, this.columnNames.length);
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = PostgreSQLExplainPlanHandler.getText("descr." + stringArray[i2], new Object[0]);
            stringArray2[i2] = string2 != null ? string2 : PostgreSQLExplainPlanHandler.getText("NoDescription", new Object[0]);
            object = PostgreSQLExplainPlanHandler.getText(stringArray[i2], new Object[0]);
            stringArray[i2] = object != null && ((String)object).length() > 0 ? object : stringArray[i2];
        }
        A a2 = new A(stringArray, this.columnClasses, stringArray2);
        a2.setHaveExplainPlanToolProperties(true);
        string2 = DocumentHelper.parseText((String)string);
        object = string2.getRootElement().element(QUERY);
        try {
            this.processElement(a2, object.element(PLAN), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a2;
    }

    private void processElement(A a2, Element element, String string) {
        Object object;
        Object[] objectArray;
        Object object2;
        String string2;
        String string3;
        String string4 = Integer.toString(this.nodeId++);
        String string5 = element.elementText(NODE_TYPE);
        String string6 = element.elementText(STRATEGY);
        String string7 = element.elementText(STARTUP_COST);
        if (string7.equals("0.00")) {
            string7 = "0.0";
        }
        if ((string3 = element.elementText(TOTAL_COST)).equals("0.00")) {
            string3 = "0.0";
        }
        String string8 = element.elementText(PLAN_ROWS);
        String string9 = element.elementText(PLAN_WIDTH);
        String string10 = element.elementText(ACTUAL_STARTUP_TIME);
        if (string10 != null && string10.equals("0.000")) {
            string10 = "0.0";
        }
        if ((string2 = element.elementText(ACTUAL_TOTAL_TIME)) != null && string2.equals("0.000")) {
            string2 = "0.0";
        }
        String string11 = element.elementText(ACTUAL_ROWS);
        String string12 = element.elementText(ACTUAL_LOOPS);
        String string13 = element.elementText(SORT_METHOD);
        String string14 = element.elementText(SORT_SPACE_USED);
        String string15 = element.elementText(SORT_SPACE_TYPE);
        String string16 = element.elementText(PARENT_RELATIONSHIP);
        String string17 = element.elementText(RELATION_NAME);
        String string18 = element.elementText(ALIAS);
        String string19 = element.elementText(JOIN_TYPE);
        String string20 = element.elementText(HASH_COND);
        String string21 = element.elementText(FILTER);
        StringBuilder stringBuilder = new StringBuilder();
        Element element2 = element.element(SORT_KEY);
        if (element2 != null) {
            object2 = element2.elements(ITEM);
            objectArray = object2.iterator();
            while (objectArray.hasNext()) {
                object = (Element)objectArray.next();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object.getText());
            }
        }
        object2 = null;
        if (string12 != null && string2 != null) {
            try {
                object2 = (double)Integer.parseInt(string12) * Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        objectArray = new Object[]{string5, "", object2 != null ? this.millisFormatter.format(object2) : "", string10, string2, string11, string12, string7, string3, string8, string9, string6, string13, string14, string15, string16, string17, string18, string19, stringBuilder.length() > 0 ? stringBuilder.toString() : null, string20, string21};
        object = new B(string4);
        ((B)object).\u0104(object2 != null ? (Double)object2 : 0.0);
        ((B)object).\u0101(objectArray);
        a2.addEntry((B)object, string);
        Element element3 = element.element(PLANS);
        if (element3 != null) {
            List list = element3.elements(PLAN);
            for (Object e2 : list) {
                this.processElement(a2, (Element)e2, string4);
            }
        }
    }

    private static String getText(String string, Object ... objectArray) {
        return se.pureit.A.B.A.\u0102(PostgreSQLExplainPlanHandler.class, "PostgreSQLExplainPlanHandler." + string, objectArray);
    }
}

