/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.sqlserver;

import com.onseven.dbvis.J.A.B;
import com.onseven.dbvis.J.A.G;
import com.onseven.dbvis.J.B.J;
import com.onseven.dbvis.J.B.O;
import com.onseven.dbvis.db.ExplainPlanHandler;
import com.onseven.dbvis.k.p;
import com.onseven.dbvis.sql.H;
import com.onseven.dbvis.sql.PropsManagerWrapper;
import javax.swing.table.TableModel;
import se.pureit.A.B.A;

public class SQLServerExplainPlanHandler
implements ExplainPlanHandler {
    private static final String[] DISPLAY_COLUMNS_AND_ORDER = new String[]{"TotalSubtreeCost", "EstimateCPU", "EstimateIO", "EstimateRows", "AvgRowSize", "EstimateExecutions", "Argument", "Type", "DefinedValues", "OutputList", "Warnings", "Parallel", "StmtText"};
    private static final String NODE_ID_COL = "NodeId";
    private static final String PARENT_COL = "Parent";
    private static final String PHYSICAL_OP_COL = "PhysicalOp";
    private static final String LOGICAL_OP_COL = "LogicalOp";
    private static final String TOTAL_SUBTREE_COST_COL = "TotalSubtreeCost";
    private static final String TYPE_COL = "Type";
    protected static String SET_SHOWPLAN_ALL_ON_STMT = "SET SHOWPLAN_ALL ON";
    protected static String SET_SHOWPLAN_ALL_OFF_STMT = "SET SHOWPLAN_ALL OFF";
    protected static String SET_STATISTICS_PROFILE_ON_STMT = "SET STATISTICS PROFILE ON";
    protected static String SET_STATISTICS_PROFILE_OFF_STMT = "SET STATISTICS PROFILE OFF";
    private com.onseven.dbvis.db.A.G dbConnection;
    private int majorVersion;

    private void init(H h2) throws O {
        this.dbConnection = h2.\u0104();
        this.majorVersion = this.dbConnection.\u0137().\u0108();
        h2.\u0104(1);
        h2.\u0105(SET_SHOWPLAN_ALL_ON_STMT);
        J j2 = new J();
        j2.setShouldApplyMaxRowsForStatement(false);
        try {
            j2.execute(h2);
            j2.run();
        }
        catch (O o2) {
            throw new O(this.dbConnection, SQLServerExplainPlanHandler.getText("ExplainModeFailed", o2.getMessage()), j2.getExecutorCommandString());
        }
    }

    @Override
    public com.onseven.dbvis.sql.A.A fetchExplainPlan(H h2) throws O {
        H h3 = (H)h2.clone();
        this.init(h3);
        try {
            com.onseven.dbvis.sql.A.A a2;
            B b2 = this.queryExplainPlan(h3, h2);
            com.onseven.dbvis.sql.A.A a3 = a2 = this.createExplainPlanResult(b2);
            return a3;
        }
        catch (O o2) {
            throw new O(h3.\u0104(), SQLServerExplainPlanHandler.getText("FetchExplainFailed", o2.getMessage()), h3.\u010e());
        }
        finally {
            this.cleanUp(h3);
        }
    }

    private B queryExplainPlan(H h2, H h3) throws O {
        h2.\u0105(h3.\u010e());
        J j2 = new J();
        j2.setShouldApplyMaxRowsForStatement(false);
        j2.execute(h2);
        j2.run();
        return j2.getFirstDataSet();
    }

    private com.onseven.dbvis.sql.A.A createExplainPlanResult(B b2) throws O {
        Object object;
        boolean bl = this.isValidExplainResult((TableModel)((Object)b2));
        if (!bl) {
            throw new O(SQLServerExplainPlanHandler.getText("ExplainNotValid", new Object[0]));
        }
        int[] nArray = this.getDisplayColumns((TableModel)((Object)b2));
        Class[] classArray = new Class[nArray.length];
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string;
            object = com.onseven.dbvis.sql.A.A.getFixedColumnName(i2);
            if (object == null) {
                object = b2.getColumnName(nArray[i2]);
            }
            stringArray[i2] = (string = SQLServerExplainPlanHandler.getText((String)object, new Object[0])) != null && string.length() > 0 ? string : object;
            String string2 = SQLServerExplainPlanHandler.getText("descr." + (String)object, new Object[0]);
            stringArray2[i2] = string2 != null ? string2 : SQLServerExplainPlanHandler.getText("NoDescription", new Object[0]);
            Class clazz = com.onseven.dbvis.sql.A.A.getFixedColumnClass(i2);
            if (clazz == null) {
                clazz = b2.getColumnClass(nArray[i2]);
            }
            classArray[i2] = clazz;
        }
        com.onseven.dbvis.sql.A.A a2 = new com.onseven.dbvis.sql.A.A(stringArray, classArray, stringArray2);
        a2.setExecutionResult(b2.getExecutionResult());
        object = b2.getSortedDataSet(this.getColumnIndex((TableModel)((Object)b2), NODE_ID_COL), true);
        int n2 = object.getRowCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            this.addExplainPlanEntry(a2, (G)object, i3);
        }
        a2.calcNodeCost();
        PropsManagerWrapper propsManagerWrapper = this.dbConnection.\u0135();
        boolean bl2 = propsManagerWrapper.getBool("ColorCriticalNodes");
        if (bl2) {
            int n3 = propsManagerWrapper.getInt("CriticalThreshold");
            int n4 = propsManagerWrapper.getInt("WarningThreshold");
            a2.calcCostLevel(n3, n4);
        }
        return a2;
    }

    private void addExplainPlanEntry(com.onseven.dbvis.sql.A.A a2, G g2, int n2) {
        Object object;
        String string;
        int[] nArray = this.getDisplayColumns((TableModel)((Object)g2));
        Object[] objectArray = new Object[nArray.length];
        B b2 = p.\u0104((TableModel)((Object)g2));
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 == 0) {
                string = (String)g2.getValueAt(n2, b2.getColumnIndex(PHYSICAL_OP_COL));
                object = (String)g2.getValueAt(n2, b2.getColumnIndex(LOGICAL_OP_COL));
                if (string == null && object == null) {
                    objectArray[i2] = g2.getValueAt(n2, b2.getColumnIndex(TYPE_COL));
                    continue;
                }
                objectArray[i2] = string + (string.equals(object) ? "" : " (" + (String)object + ")");
                continue;
            }
            objectArray[i2] = i2 == 1 ? "" : g2.getValueAt(n2, nArray[i2]);
        }
        Number number = (Number)g2.getValueAt(n2, this.getColumnIndex((TableModel)((Object)g2), NODE_ID_COL));
        string = number != null ? number.toString() : "1";
        object = new com.onseven.dbvis.sql.A.B(string);
        ((com.onseven.dbvis.sql.A.B)object).\u0101(objectArray);
        Float f2 = (Float)g2.getValueAt(n2, this.getColumnIndex((TableModel)((Object)g2), TOTAL_SUBTREE_COST_COL));
        ((com.onseven.dbvis.sql.A.B)object).\u0104(f2 != null ? f2.doubleValue() : 0.0);
        Number number2 = (Number)g2.getValueAt(n2, this.getColumnIndex((TableModel)((Object)g2), PARENT_COL));
        String string2 = number2 != null ? number2.toString() : null;
        a2.addEntry((com.onseven.dbvis.sql.A.B)object, string2);
    }

    private boolean isValidExplainResult(TableModel tableModel) {
        if (this.getColumnIndex(tableModel, NODE_ID_COL) == -1) {
            return false;
        }
        if (this.getColumnIndex(tableModel, PARENT_COL) == -1) {
            return false;
        }
        if (this.getColumnIndex(tableModel, PHYSICAL_OP_COL) == -1) {
            return false;
        }
        if (this.getColumnIndex(tableModel, LOGICAL_OP_COL) == -1) {
            return false;
        }
        if (this.getColumnIndex(tableModel, TOTAL_SUBTREE_COST_COL) == -1) {
            return false;
        }
        return this.getColumnIndex(tableModel, TYPE_COL) != -1;
    }

    private void cleanUp(H h2) {
        try {
            h2.\u0104(1);
            h2.\u0105(SET_SHOWPLAN_ALL_OFF_STMT);
            J j2 = new J();
            j2.setShouldApplyMaxRowsForStatement(false);
            j2.execute(h2);
            j2.run();
        }
        catch (O o2) {
            // empty catch block
        }
    }

    private int getColumnIndex(TableModel tableModel, String string) {
        if (tableModel != null) {
            int n2 = tableModel.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = tableModel.getColumnName(i2);
                if (string2 == null || !string2.equals(string)) continue;
                return i2;
            }
        }
        return -1;
    }

    private int[] getDisplayColumns(TableModel tableModel) {
        int n2;
        int n3 = 0;
        for (int i2 = 0; i2 < DISPLAY_COLUMNS_AND_ORDER.length; ++i2) {
            n2 = this.getColumnIndex(tableModel, DISPLAY_COLUMNS_AND_ORDER[i2]);
            n3 += n2 > -1 ? 1 : 0;
        }
        int[] nArray = new int[n3 + com.onseven.dbvis.sql.A.A.FIXED_COLUMN_NAMES.length];
        n2 = com.onseven.dbvis.sql.A.A.FIXED_COLUMN_NAMES.length;
        for (int i3 = 0; i3 < DISPLAY_COLUMNS_AND_ORDER.length; ++i3) {
            int n4 = this.getColumnIndex(tableModel, DISPLAY_COLUMNS_AND_ORDER[i3]);
            if (n4 <= -1) continue;
            nArray[n2++] = n4;
        }
        return nArray;
    }

    private static String getText(String string, Object ... objectArray) {
        return A.\u0102(SQLServerExplainPlanHandler.class, "SQLServerExplainPlanHandler." + string, objectArray);
    }
}

