/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.sql;

import com.A.F.M;
import com.onseven.dbvis.sql.C;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BinaryData
implements C {
    private byte[] data = new byte[0];
    private long length = 0L;
    private Blob blob;
    private String cachedStr;
    private String cachedHex;
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Logger log = Logger.getLogger(BinaryData.class);

    public BinaryData() {
    }

    public BinaryData(Blob blob) {
        this.blob = blob;
        this.data = null;
        this.length = -1L;
    }

    public BinaryData(byte[] byArray) {
        this.data = byArray;
        this.length = this.data.length;
    }

    public BinaryData(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[1024];
        while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        this.data = byteArrayOutputStream.toByteArray();
        this.length = this.data.length;
    }

    public long getLength() {
        if (this.length < 0L && this.blob != null) {
            try {
                this.length = this.blob.length();
            }
            catch (SQLException sQLException) {
                log.error((Object)"Error getting blob data: ");
                log.error((Object)sQLException);
                this.length = 0L;
            }
        }
        return this.length;
    }

    public byte[] getBytes() {
        if (this.data == null && this.blob != null) {
            try {
                this.data = this.blob.getBytes(1L, (int)this.getLength());
            }
            catch (Exception exception) {
                log.error((Object)"Error getting blob data: ");
                log.error((Object)exception);
                this.data = new byte[0];
            }
        }
        return this.data;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n2) {
        if (this.cachedStr != null) {
            return this.cachedStr;
        }
        byte[] byArray = this.getBytes();
        int n3 = (int)this.getLength();
        if (n3 == 0 || byArray.length == 0) {
            return "";
        }
        if (n2 <= 0) {
            n2 = n3;
        }
        n3 = Math.min(n3, n2);
        this.cachedStr = new String(byArray, 0, n3);
        return this.cachedStr;
    }

    public String toHexString() {
        return this.toHexString(-1);
    }

    public String toHexString(int n2) {
        if (this.cachedHex != null) {
            return this.cachedHex;
        }
        byte[] byArray = this.getBytes();
        int n3 = (int)this.getLength();
        if (n3 == 0 || byArray.length == 0) {
            return "";
        }
        if (n2 <= 0) {
            n2 = n3;
        }
        n3 = Math.min(n3, n2);
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(hexChar[(byArray[i2] & 0xF0) >>> 4]);
            stringBuffer.append(hexChar[byArray[i2] & 0xF]);
        }
        this.cachedHex = stringBuffer.toString();
        return this.cachedHex;
    }

    public static String byteToBase64String(byte[] byArray) {
        return new String(M.\u0102(byArray));
    }

    public static byte[] Base64StringTobyte(String string) {
        return M.\u0101(string.getBytes());
    }
}

