/*
 * Decompiled with CFR 0.152.
 */
package se.pureit.swing.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.Timer;
import se.pureit.swing.icons.AnimatedIcon;

public abstract class AbstractAnimatedIcon
extends AnimatedIcon {
    private static final int DEFAULT_INTERVAL = 41;
    private Timer timer;
    private int repaintInterval;
    private int frame;
    private int frameCount;

    protected AbstractAnimatedIcon() {
        this(0);
    }

    protected AbstractAnimatedIcon(int n2) {
        this(n2, 41);
    }

    protected AbstractAnimatedIcon(int n2, int n3) {
        this.frameCount = n2;
        this.setFrameInterval(n3);
    }

    protected void finalize() {
        this.timer.stop();
    }

    public void setFrameInterval(int n2) {
        this.repaintInterval = n2;
        if (n2 != 0) {
            if (this.timer == null) {
                this.timer = new Timer(n2, new AnimationUpdater(this));
                this.timer.setRepeats(true);
            } else {
                this.timer.setDelay(n2);
            }
        } else if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public int getFrameInterval() {
        return this.repaintInterval;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void nextFrame() {
        this.setFrame(this.getFrame() + 1);
    }

    public void setFrame(int n2) {
        this.frame = n2;
        if (this.frameCount != 0) {
            this.frame %= this.frameCount;
        }
        this.repaint();
    }

    public int getFrame() {
        return this.frame;
    }

    @Override
    protected abstract void paintFrame(Component var1, Graphics var2, int var3, int var4);

    @Override
    public abstract int getIconWidth();

    @Override
    public abstract int getIconHeight();

    @Override
    protected synchronized void registerRepaintArea(Component component, int n2, int n3, int n4, int n5) {
        if (this.timer != null && !this.timer.isRunning()) {
            this.timer.start();
        }
        super.registerRepaintArea(component, n2, n3, n4, n5);
    }

    private static class AnimationUpdater
    implements ActionListener {
        private WeakReference ref;

        public AnimationUpdater(AbstractAnimatedIcon abstractAnimatedIcon) {
            this.ref = new WeakReference<AbstractAnimatedIcon>(abstractAnimatedIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractAnimatedIcon abstractAnimatedIcon = (AbstractAnimatedIcon)this.ref.get();
            if (abstractAnimatedIcon != null) {
                abstractAnimatedIcon.nextFrame();
            }
        }
    }
}

