/*
 * Decompiled with CFR 0.152.
 */
package se.pureit.swing.icons;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class AnimatedIcon
implements Icon {
    private ImageIcon original;
    private Set<RepaintArea> repaints = new HashSet<RepaintArea>();

    protected AnimatedIcon() {
    }

    public AnimatedIcon(ImageIcon imageIcon) {
        this.original = imageIcon;
        new AnimationObserver(this, imageIcon);
    }

    protected synchronized void repaint() {
        Iterator<RepaintArea> iterator = this.repaints.iterator();
        while (iterator.hasNext()) {
            iterator.next().repaint();
        }
        this.repaints.clear();
    }

    @Override
    public int getIconHeight() {
        return this.original.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.original.getIconWidth();
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        this.paintFrame(component, graphics, n2, n3);
        if (component != null) {
            int n4 = this.getIconWidth();
            int n5 = this.getIconHeight();
            AffineTransform affineTransform = ((Graphics2D)graphics).getTransform();
            n4 = (int)((double)n4 * affineTransform.getScaleX());
            n5 = (int)((double)n4 * affineTransform.getScaleY());
            this.registerRepaintArea(component, n2, n3, n4, n5);
        }
    }

    protected void paintFrame(Component component, Graphics graphics, int n2, int n3) {
        this.original.paintIcon(component, graphics, n2, n3);
    }

    protected void registerRepaintArea(Component component, int n2, int n3, int n4, int n5) {
        RepaintArea repaintArea = new RepaintArea(component, n2, n3, n4, n5);
        this.repaints.add(repaintArea);
    }

    private static class AnimationObserver
    implements ImageObserver {
        private WeakReference<AnimatedIcon> ref;
        private ImageIcon original;

        public AnimationObserver(AnimatedIcon animatedIcon, ImageIcon imageIcon) {
            this.original = imageIcon;
            this.original.setImageObserver(this);
            this.ref = new WeakReference<AnimatedIcon>(animatedIcon);
        }

        @Override
        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            if ((n2 & 0x30) != 0) {
                AnimatedIcon animatedIcon = (AnimatedIcon)this.ref.get();
                if (animatedIcon != null) {
                    animatedIcon.repaint();
                } else {
                    this.original.setImageObserver(null);
                }
            }
            return (n2 & 0xA0) == 0;
        }
    }

    private class RepaintArea {
        public int x;
        public int y;
        public int w;
        public int h;
        public Component component;
        private int hashCode;

        public RepaintArea(Component component, int n2, int n3, int n4, int n5) {
            Object object;
            Component component2 = this.findNonRendererAncestor(component);
            if (component2 != component) {
                object = SwingUtilities.convertPoint(component, n2, n3, component2);
                component = component2;
                n2 = ((Point)object).x;
                n3 = ((Point)object).y;
            }
            this.component = component;
            this.x = n2;
            this.y = n3;
            this.w = n4;
            this.h = n5;
            object = String.valueOf(n2) + "," + n3 + ":" + component.hashCode();
            this.hashCode = ((String)object).hashCode();
        }

        private Component findNonRendererAncestor(Component component) {
            Container container = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component);
            if (container != null && container != component && container.getParent() != null) {
                component = this.findNonRendererAncestor(container.getParent());
            }
            return component;
        }

        public void repaint() {
            this.component.repaint(this.x, this.y, this.w, this.h);
        }

        public boolean equals(Object object) {
            if (object instanceof RepaintArea) {
                RepaintArea repaintArea = (RepaintArea)object;
                return repaintArea.component == this.component && repaintArea.x == this.x && repaintArea.y == this.y && repaintArea.w == this.w && repaintArea.h == this.h;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Repaint(" + this.component.getClass().getName() + "@" + this.x + "," + this.y + ")";
        }
    }
}

