/*
 * Decompiled with CFR 0.152.
 */
package se.pureit.swing.icons;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import se.pureit.A.B.A;
import se.pureit.swing.icons.StdIconFactory;

public class IconCacheBuilder
extends StdIconFactory {
    File smallDir;
    File largeDir;

    public IconCacheBuilder() {
        String string = System.getProperty("iconsFile");
        String string2 = System.getProperty("collections");
        System.out.println("IconCacheBuilder - rootPath = " + System.getProperty("rootPath"));
        System.out.println("IconCacheBuilder - iconsFile = " + string);
        System.out.println("IconCacheBuilder - collections = " + string2);
        if (string != null) {
            IconCacheBuilder.setIconFile(string);
        }
        if (string2 == null || string2.indexOf("ix1") > -1) {
            this.buildIconCache("ix");
        }
        if (string2 == null || string2.indexOf("ix2") > -1) {
            this.buildIconCache("ix2");
        }
    }

    private void buildIconCache(String string) {
        IconCacheBuilder.setIconCollection(string);
        this.prepareOutputDirectory(string);
        this.copyFiles();
    }

    private void copyFiles() {
        if (iconMap == null) {
            ResourceBundle resourceBundle = A.\u0102(this.getClass());
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (string.startsWith("icons.")) continue;
                this.copyFile(string, 1, this.smallDir);
                this.copyFile(string, 2, this.largeDir);
            }
        } else {
            for (String string : iconMap.keySet()) {
                if (string.startsWith("icons.")) continue;
                this.copyFile(string, 1, this.smallDir);
                this.copyFile(string, 2, this.largeDir);
            }
        }
    }

    private void copyFile(String string, int n2, File file) {
        String string2 = IconCacheBuilder.getFileName(string);
        if (string2 != null) {
            try {
                InputStream inputStream = IconCacheBuilder.getIconStreamFromCollection(string, n2);
                if (inputStream != null) {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    File file2 = new File(file, string2);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    fileOutputStream.write(byArray);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    inputStream.close();
                } else {
                    System.out.println(file.getPath() + "/" + string2 + " is mapped in icons file do not exist for key " + string);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    private void prepareOutputDirectory(String string) {
        String string2 = System.getProperty("rootPath");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string.equals("ix")) {
            string3 = ixIconRootDirectory;
            string4 = ixSmallIconsDirectory;
            string5 = ixLargeIconsDirectory;
        } else if (string.equals("ix2")) {
            string3 = ix2IconRootDirectory;
            string4 = ix2SmallIconsDirectory;
            string5 = ix2LargeIconsDirectory;
        }
        File file = new File(string2 + "/" + string3);
        file.mkdir();
        this.smallDir = new File(file, string4);
        this.smallDir.mkdir();
        this.largeDir = new File(file, string5);
        this.largeDir.mkdir();
    }

    public static void main(String[] stringArray) {
        new IconCacheBuilder();
    }
}

